/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.Place;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.utilities.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class HolmesWindowTemplateEx
extends JFrame {
    private JFrame ego;
    private GUIManager overlord;
    private ArrayList<Double> multisetK = new ArrayList();
    private Place place = null;
    private boolean mainSimulatorActive;
    private boolean listenerAllowed = true;
    private JPanel mainPanel;
    private JComboBox tokensComboBox;

    public HolmesWindowTemplateEx(Place placeObj) {
        this.overlord = GUIManager.getDefaultGUIManager();
        this.place = placeObj;
        this.ego = this;
        this.ego.setTitle("XPTN place tokens manager");
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (533315487) | Exception:  " + ex.getMessage(), "error", true);
        }
        if (GUIManager.getDefaultGUIManager().getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
            this.mainSimulatorActive = true;
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesWindowTemplateEx.this.overlord.getFrame().setEnabled(true);
            }
        });
        if (this.mainSimulatorActive) {
            JOptionPane.showMessageDialog(null, "Window unavailable when simulator is working.", "Error: simulation in progress", 0);
            this.dispatchEvent(new WindowEvent(this, 201));
        } else {
            this.overlord.getFrame().setEnabled(false);
            this.setResizable(false);
            this.initializeComponents();
            this.setVisible(true);
        }
    }

    private void initializeComponents() {
        this.setLocation(20, 20);
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(640, 450));
        this.setLocation(50, 50);
        this.setResizable(false);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        this.mainPanel.setBounds(0, 0, 640, 450);
        this.mainPanel.setLocation(0, 0);
        this.mainPanel.add(this.getComboTopPanel());
        this.mainPanel.add(this.getDockPanel());
        this.add((Component)this.mainPanel, "Center");
    }

    private JPanel getComboTopPanel() {
        JPanel comboPanel = new JPanel();
        comboPanel.setLayout(null);
        comboPanel.setBounds(0, 0, 640, 150);
        comboPanel.setLocation(0, 0);
        comboPanel.setBorder(BorderFactory.createTitledBorder("Token selected:"));
        int comboPanelX = 0;
        int comboPanelY = 0;
        String[] dataP = new String[]{"---"};
        this.tokensComboBox = new JComboBox<String>(dataP);
        this.tokensComboBox.setLocation(comboPanelX += 15, comboPanelY += 15);
        this.tokensComboBox.setSize(400, 20);
        this.tokensComboBox.setSelectedIndex(0);
        this.tokensComboBox.setMaximumRowCount(10);
        this.tokensComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!HolmesWindowTemplateEx.this.listenerAllowed) {
                    return;
                }
                int selected = HolmesWindowTemplateEx.this.tokensComboBox.getSelectedIndex();
                if (selected > 0) {
                    // empty if block
                }
            }
        });
        comboPanelX += 25;
        comboPanel.add(this.tokensComboBox);
        this.tokensComboBox.removeAllItems();
        this.tokensComboBox.addItem("---");
        for (int p = 0; p < this.multisetK.size(); ++p) {
            this.tokensComboBox.addItem("\u03ba" + p + "." + this.multisetK.get(p));
        }
        return comboPanel;
    }

    private JPanel getDockPanel() {
        JPanel dockPanel = new JPanel(new BorderLayout());
        dockPanel.setLayout(null);
        dockPanel.setBounds(0, 0, 640, 300);
        dockPanel.setLocation(0, 150);
        dockPanel.setBorder(BorderFactory.createTitledBorder("Options:"));
        return dockPanel;
    }
}

