/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.Tools;
import holmes.workspace.WorkspaceSheet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.DefaultFormatter;

public class HolmesSearch
extends JFrame {
    private static final long serialVersionUID = 8885161841467059860L;
    private JFrame ego;
    private ArrayList<Place> places = new ArrayList();
    private ArrayList<Transition> transitions = new ArrayList();
    private ArrayList<Integer> foundNodes = new ArrayList();
    private ArrayList<Integer> foundType = new ArrayList();
    private int selectedFound = -1;
    private JComboBox<String> placesCombo = null;
    private JComboBox<String> transitionsCombo = null;
    private ButtonGroup group = new ButtonGroup();
    private JFormattedTextField searchField;
    private JFormattedTextField idField;
    private JRadioButton transitionMode;
    private JLabel nodeName;
    private JLabel nodeType;
    private JLabel nodeInArcs;
    private JLabel nodeOutArcs;
    private JLabel nodeIsPortal;
    private boolean listenerAllowed = true;

    public HolmesSearch() {
        this.ego = this;
        this.ego.setTitle("Net nodes search window");
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (375431746) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(518, 260));
        this.setLocation(50, 50);
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        JPanel main = this.createMainPanel();
        this.add((Component)main, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        this.setVisible(false);
        this.initiateListeners();
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        JPanel choicePanel = new JPanel();
        choicePanel.setLayout(null);
        choicePanel.setBorder(BorderFactory.createTitledBorder("Search options"));
        choicePanel.setBounds(0, 0, 500, 150);
        int choiceColPx = 10;
        int choiceRowPx = 15;
        JLabel label1 = new JLabel("Places:");
        label1.setBounds(choiceColPx, choiceRowPx, 70, 20);
        choicePanel.add(label1);
        String[] dataP = new String[]{"---"};
        this.placesCombo = new JComboBox<String>(dataP);
        this.placesCombo.setLocation(choiceColPx + 75, choiceRowPx + 2);
        this.placesCombo.setSize(400, 20);
        this.placesCombo.setSelectedIndex(0);
        this.placesCombo.setMaximumRowCount(6);
        this.placesCombo.addActionListener(actionEvent -> {
            if (!this.listenerAllowed) {
                return;
            }
            int selected = this.placesCombo.getSelectedIndex();
            if (selected > 0) {
                this.listenerAllowed = false;
                this.transitionsCombo.setSelectedIndex(0);
                this.listenerAllowed = true;
                this.centerOnElement("place", selected - 1, null);
            } else {
                this.clearSubPanel();
            }
        });
        choicePanel.add(this.placesCombo);
        JLabel label2 = new JLabel("Transitions:");
        label2.setBounds(choiceColPx, choiceRowPx += 25, 70, 20);
        choicePanel.add(label2);
        String[] dataT = new String[]{"---"};
        this.transitionsCombo = new JComboBox<String>(dataT);
        this.transitionsCombo.setLocation(choiceColPx + 75, choiceRowPx + 2);
        this.transitionsCombo.setSize(400, 20);
        this.transitionsCombo.setSelectedIndex(0);
        this.transitionsCombo.setMaximumRowCount(6);
        this.transitionsCombo.addActionListener(actionEvent -> {
            if (!this.listenerAllowed) {
                return;
            }
            int selected = this.transitionsCombo.getSelectedIndex();
            if (selected > 0) {
                this.listenerAllowed = false;
                this.placesCombo.setSelectedIndex(0);
                this.listenerAllowed = true;
                this.centerOnElement("transition", selected - 1, null);
            } else {
                this.clearSubPanel();
            }
        });
        choicePanel.add(this.transitionsCombo);
        JLabel label3 = new JLabel("Search for:");
        label3.setBounds(choiceColPx, choiceRowPx += 25, 80, 20);
        choicePanel.add(label3);
        DefaultFormatter format = new DefaultFormatter();
        format.setOverwriteMode(false);
        this.searchField = new JFormattedTextField(format);
        this.searchField.setLocation(choiceColPx + 75, choiceRowPx);
        this.searchField.setSize(270, 20);
        this.searchField.setValue("");
        this.searchField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
                String newName = field.getText();
                if (newName.length() > 0) {
                    this.searchForString(newName);
                }
            }
            catch (ParseException ex) {
                GUIManager.getDefaultGUIManager().log("Error (762682665) | Exception:  " + ex.getMessage(), "error", true);
            }
        });
        choicePanel.add(this.searchField);
        JLabel label4 = new JLabel("Search ID:");
        label4.setBounds(choiceColPx + 350, choiceRowPx, 80, 20);
        choicePanel.add(label4);
        DefaultFormatter formatID = new DefaultFormatter();
        formatID.setOverwriteMode(false);
        this.idField = new JFormattedTextField(format);
        this.idField.setLocation(choiceColPx + 415, choiceRowPx);
        this.idField.setSize(60, 20);
        this.idField.setValue("");
        this.idField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
                String IDstr = field.getText();
                if (IDstr.length() == 0) {
                    return;
                }
                int id = Integer.parseInt(IDstr);
                this.selectByID(id);
            }
            catch (Exception ex) {
                GUIManager.getDefaultGUIManager().log("Error (554893398) | Exception:  " + ex.getMessage(), "error", true);
            }
        });
        choicePanel.add(this.idField);
        JRadioButton placesMode = new JRadioButton("Search places");
        placesMode.setBounds(choiceColPx, choiceRowPx += 20, 120, 20);
        placesMode.setLocation(choiceColPx, choiceRowPx);
        placesMode.setActionCommand("0");
        ActionListener placesModeActionListener = actionEvent -> {
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                String newName = this.searchField.getText();
                this.idField.setText("");
                if (newName.length() > 0) {
                    this.searchForString(newName);
                }
            }
        };
        placesMode.addActionListener(placesModeActionListener);
        choicePanel.add(placesMode);
        this.group.add(placesMode);
        this.transitionMode = new JRadioButton("Search transitions");
        this.transitionMode.setBounds(choiceColPx + 140, choiceRowPx, 140, 20);
        this.transitionMode.setLocation(choiceColPx + 140, choiceRowPx);
        this.transitionMode.setActionCommand("1");
        ActionListener transitionModeActionListener = actionEvent -> {
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                String newName = this.searchField.getText();
                this.idField.setText("");
                if (newName.length() > 0) {
                    this.searchForString(newName);
                }
            }
        };
        this.transitionMode.addActionListener(transitionModeActionListener);
        choicePanel.add(this.transitionMode);
        this.group.add(this.transitionMode);
        JRadioButton bothMode = new JRadioButton("Search places and transitions");
        bothMode.setBounds(choiceColPx + 280, choiceRowPx, 200, 20);
        bothMode.setLocation(choiceColPx + 280, choiceRowPx);
        bothMode.setActionCommand("2");
        bothMode.setVisible(false);
        choicePanel.add(bothMode);
        this.group.add(bothMode);
        this.group.setSelected(this.transitionMode.getModel(), true);
        JButton prevButton = new JButton("Previous");
        prevButton.setBounds(choiceColPx, choiceRowPx += 20, 120, 32);
        prevButton.setIcon(Tools.getResIcon32("/icons/searchWindow/prev.png"));
        prevButton.addActionListener(actionEvent -> this.showFound("prev"));
        choicePanel.add(prevButton);
        JButton nextButton = new JButton("Next");
        nextButton.setBounds(choiceColPx + 130, choiceRowPx, 120, 32);
        nextButton.setIcon(Tools.getResIcon32("/icons/searchWindow/next.png"));
        nextButton.addActionListener(actionEvent -> this.showFound("next"));
        choicePanel.add(nextButton);
        panel.add(choicePanel);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(null);
        infoPanel.setBorder(BorderFactory.createTitledBorder("Selected node info"));
        infoPanel.setBounds(0, 150, 500, 70);
        int infoCol = 10;
        int infoRow = 20;
        JLabel label11 = new JLabel("Type:");
        label11.setBounds(infoCol, infoRow, 50, 20);
        infoPanel.add(label11);
        this.nodeType = new JLabel("---");
        this.nodeType.setBounds(infoCol + 60, infoRow, 70, 20);
        infoPanel.add(this.nodeType);
        this.nodeName = new JLabel("---");
        this.nodeName.setBounds(infoCol + 130, infoRow, 355, 20);
        infoPanel.add(this.nodeName);
        JLabel label12 = new JLabel("Portal:");
        label12.setBounds(infoCol, infoRow += 20, 50, 20);
        infoPanel.add(label12);
        this.nodeIsPortal = new JLabel("---");
        this.nodeIsPortal.setBounds(infoCol + 60, infoRow, 30, 20);
        infoPanel.add(this.nodeIsPortal);
        JLabel label13 = new JLabel("In-arcs:");
        label13.setBounds(infoCol + 130, infoRow, 50, 20);
        infoPanel.add(label13);
        this.nodeInArcs = new JLabel("0");
        this.nodeInArcs.setBounds(infoCol + 180, infoRow, 30, 20);
        infoPanel.add(this.nodeInArcs);
        JLabel label14 = new JLabel("Out-arcs:");
        label14.setBounds(infoCol + 210, infoRow, 60, 20);
        infoPanel.add(label14);
        this.nodeOutArcs = new JLabel("0");
        this.nodeOutArcs.setBounds(infoCol + 280, infoRow, 30, 20);
        infoPanel.add(this.nodeOutArcs);
        panel.add(infoPanel);
        panel.repaint();
        return panel;
    }

    protected void clearSubPanel() {
        this.nodeName.setText("---");
        this.nodeType.setText("---");
        this.nodeInArcs.setText("---");
        this.nodeOutArcs.setText("---");
        this.nodeIsPortal.setText("---");
    }

    public void fillComboBoxesData() {
        this.places = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces();
        this.transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
        this.placesCombo.removeAllItems();
        this.placesCombo.addItem("---");
        for (int p = 0; p < this.places.size(); ++p) {
            this.placesCombo.addItem("p" + p + "." + this.places.get(p).getName());
        }
        this.transitionsCombo.removeAllItems();
        this.transitionsCombo.addItem("---");
        for (int t = 0; t < this.transitions.size(); ++t) {
            this.transitionsCombo.addItem("t" + t + "." + this.transitions.get(t).getName());
        }
        this.nodeName.setText("---");
        this.nodeType.setText("---");
        this.nodeInArcs.setText("---");
        this.nodeOutArcs.setText("---");
        this.nodeIsPortal.setText("---");
    }

    protected void centerOnElement(String type, int index, ElementLocation portalLoc) {
        if (portalLoc == null) {
            int sheetID;
            ElementLocation loc1st;
            Node x;
            if (type.equals("place")) {
                x = this.places.get(index);
                loc1st = x.getElementLocations().get(0);
                sheetID = loc1st.getSheetID();
                this.nodeName.setText(x.getName());
                this.nodeType.setText("place");
                this.nodeInArcs.setText("" + x.getInArcs().size());
                this.nodeOutArcs.setText("" + x.getOutArcs().size());
                if (x.isPortal()) {
                    this.nodeIsPortal.setText("yes");
                } else {
                    this.nodeIsPortal.setText("no");
                }
            } else {
                x = this.transitions.get(index);
                loc1st = x.getElementLocations().get(0);
                sheetID = loc1st.getSheetID();
                this.nodeName.setText(x.getName());
                this.nodeType.setText("place");
                this.nodeInArcs.setText("" + x.getInArcs().size());
                this.nodeOutArcs.setText("" + x.getOutArcs().size());
                if (x.isPortal()) {
                    this.nodeIsPortal.setText("yes");
                } else {
                    this.nodeIsPortal.setText("no");
                }
            }
            WorkspaceSheet ws = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get(sheetID);
            ws.getGraphPanel().setZoom(100, ws.getGraphPanel().getZoom());
            ws.getGraphPanel().getSelectionManager().selectOneElementLocation(loc1st);
            int visibleX = ws.getWidth();
            int visibleY = ws.getHeight();
            int barHorX = ws.getHorizontalScrollBar().getValue();
            int barVerY = ws.getVerticalScrollBar().getValue();
            ws.scrollHorizontal(-barHorX);
            ws.scrollVertical(-barVerY);
            int locX = loc1st.getPosition().x;
            int locY = loc1st.getPosition().y;
            if (locX > visibleX - 100) {
                int pushX = locX - (visibleX - 100) + visibleX / 2;
                ws.scrollHorizontal(pushX);
            }
            if (locY > visibleY - 160) {
                int pushY = locY - (visibleY - 160) + visibleY / 2;
                ws.scrollVertical(pushY);
            }
        }
    }

    private void selectByID(int id) {
        int mode = Integer.parseInt(this.group.getSelection().getActionCommand());
        if (mode == 0) {
            int maxPlaces = this.places.size();
            if (id < maxPlaces) {
                this.placesCombo.setSelectedIndex(id + 1);
            }
        } else if (mode == 1) {
            int maxTransitions = this.transitions.size();
            if (id < maxTransitions) {
                this.transitionsCombo.setSelectedIndex(id + 1);
            }
        } else {
            this.group.setSelected(this.transitionMode.getModel(), true);
            this.selectByID(id);
        }
    }

    private void searchForString(String searchString) {
        int mode = Integer.parseInt(this.group.getSelection().getActionCommand());
        searchString = searchString.toLowerCase();
        this.selectedFound = -1;
        this.foundNodes.clear();
        this.foundType.clear();
        if (mode == 0) {
            int id = 99999;
            int maxPlaces = this.places.size();
            this.foundNodes.clear();
            for (int i = 0; i < maxPlaces; ++i) {
                if (!this.places.get(i).getName().toLowerCase().contains(searchString)) continue;
                if (id == 99999) {
                    id = i;
                }
                this.foundNodes.add(i);
                this.foundType.add(mode);
                this.selectedFound = 0;
            }
            if (id < maxPlaces) {
                this.placesCombo.setSelectedIndex(id + 1);
            }
        } else if (mode == 1) {
            int maxTransitions = this.transitions.size();
            int id = 99999;
            this.foundNodes.clear();
            for (int i = 0; i < maxTransitions; ++i) {
                if (!this.transitions.get(i).getName().toLowerCase().contains(searchString)) continue;
                if (id == 99999) {
                    id = i;
                }
                this.foundNodes.add(i);
                this.foundType.add(mode);
                this.selectedFound = 0;
            }
            if (id < maxTransitions) {
                this.transitionsCombo.setSelectedIndex(id + 1);
            }
        } else {
            this.group.setSelected(this.transitionMode.getModel(), true);
            this.searchForString(searchString);
        }
    }

    private void showFound(String mode) {
        try {
            if (mode.equals("prev")) {
                if (this.foundNodes.size() > 0 && this.selectedFound > 0) {
                    --this.selectedFound;
                    int id = this.foundNodes.get(this.selectedFound);
                    if (this.foundType.get(this.selectedFound) == 0) {
                        this.placesCombo.setSelectedIndex(id + 1);
                    } else {
                        this.transitionsCombo.setSelectedIndex(id + 1);
                    }
                }
            } else if (mode.equals("next") && this.foundNodes.size() > 0 && this.selectedFound + 1 < this.foundNodes.size()) {
                ++this.selectedFound;
                int id = this.foundNodes.get(this.selectedFound);
                if (this.foundType.get(this.selectedFound) == 0) {
                    this.placesCombo.setSelectedIndex(id + 1);
                } else {
                    this.transitionsCombo.setSelectedIndex(id + 1);
                }
            }
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (145588510) | Exception:  " + ex.getMessage(), "error", true);
        }
    }

    public void selectedManually(boolean place, int index) {
        try {
            if (place) {
                this.placesCombo.setSelectedIndex(index + 1);
            } else {
                this.transitionsCombo.setSelectedIndex(index + 1);
            }
        }
        catch (Exception e) {
            boolean bl = true;
        }
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                HolmesSearch.this.fillComboBoxesData();
                HolmesSearch.this.searchField.requestFocusInWindow();
            }
        });
    }
}

