/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.darkgui.GUIManager;
import holmes.darkgui.settings.SettingsManager;
import holmes.utilities.Tools;
import holmes.workspace.ExtensionFileFilter;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class HolmesProgramPropertiesActions {
    SettingsManager sm;

    public HolmesProgramPropertiesActions(SettingsManager sm) {
        this.sm = sm;
    }

    public void setRPath() {
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Rscript.exe (.exe)", new String[]{"EXE"})};
        String selectedFile = Tools.selectFileDialog("", filters, "Select Rscript.exe", "Please select Rscript exe, usually located in R/Rx.x.x/bin directory.", "");
        if (selectedFile.equals("")) {
            return;
        }
        if (!selectedFile.contains("x64")) {
            Object dest = selectedFile.substring(0, selectedFile.lastIndexOf(File.separator));
            if (Tools.ifExist((String)(dest = (String)dest + "\\x64\\Rscript.exe"))) {
                this.sm.setValue("r_path64", (String)dest, true);
            } else {
                this.sm.setValue("r_path64", "", true);
            }
        } else {
            this.sm.setValue("r_path64", selectedFile, true);
        }
        if (Tools.ifExist(selectedFile)) {
            this.sm.setValue("r_path", selectedFile, true);
            GUIManager.getDefaultGUIManager().setRStatus(true);
            GUIManager.getDefaultGUIManager().log("Rscript.exe manually located in " + selectedFile + ". Settings file updated.", "text", true);
        } else {
            this.sm.setValue("r_path", "", true);
            GUIManager.getDefaultGUIManager().setRStatus(false);
            GUIManager.getDefaultGUIManager().log("Rscript.exe location unknown. Clustering procedures will not work.", "warning", true);
        }
    }
}

