/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.darkgui.GUIManager;
import holmes.darkgui.settings.SettingsManager;
import holmes.utilities.Tools;
import holmes.windows.HolmesProgramPropertiesActions;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HolmesProgramProperties
extends JFrame {
    private static final long serialVersionUID = 2831478312283009975L;
    private JFrame parentFrame;
    private SettingsManager sm;
    private HolmesProgramPropertiesActions action;
    private boolean noAction = false;

    public HolmesProgramProperties(JFrame parent) {
        this.parentFrame = parent;
        this.sm = GUIManager.getDefaultGUIManager().getSettingsManager();
        this.action = new HolmesProgramPropertiesActions(this.sm);
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (688341781) | Exception:  " + ex.getMessage(), "error", true);
        }
        try {
            this.initialize_components();
        }
        catch (Exception e) {
            String msg = e.getMessage();
            GUIManager.getDefaultGUIManager().log("Critical error, cannot create Holmes properties window:", "error", true);
            GUIManager.getDefaultGUIManager().log(msg, "error", true);
        }
    }

    private void initialize_components() {
        this.setLocation(20, 20);
        this.setTitle("Settings");
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(600, 500));
        this.setResizable(false);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBounds(0, 0, 600, 500);
        tabbedPane.addTab("System", Tools.getResIcon32("/icons/propertiesWindow/systemIcon.png"), this.makeSysPanel(), "Holmes main options.");
        tabbedPane.setMnemonicAt(0, 49);
        tabbedPane.addTab("Editor", Tools.getResIcon32("/icons/propertiesWindow/editorIcon.png"), this.makeEditorPanel(), "Editor options");
        tabbedPane.setMnemonicAt(1, 50);
        tabbedPane.addTab("Simulator", Tools.getResIcon32("/icons/propertiesWindow/simulationIcon.png"), this.makeSimulatorPanel(), "Simulator options");
        tabbedPane.setMnemonicAt(1, 51);
        tabbedPane.addTab("Analyzer", Tools.getResIcon32("/icons/propertiesWindow/analysisIcon.png"), this.makeAnalysisPanel(), "Does twice as much nothing");
        tabbedPane.setMnemonicAt(2, 52);
        JComponent panel5 = this.makeTextPanel("Other options.");
        tabbedPane.addTab("Other", Tools.getResIcon32("/icons/propertiesWindow/otherIcon.png"), panel5, "Does nothing at all");
        tabbedPane.setMnemonicAt(3, 53);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBounds(0, 0, 800, 600);
        mainPanel.add(tabbedPane);
        this.add(mainPanel);
        this.repaint();
    }

    private JPanel makeSysPanel() {
        JPanel panel = new JPanel(null);
        panel.setBounds(0, 0, 600, 500);
        panel.add(this.createRoptionsSystemPanel(0, 0, 590, 90));
        panel.add(this.createSnoopyReadSystemPanel(0, 90, 590, 150));
        panel.add(this.createOtherOptionsPanel(0, 240, 590, 200));
        panel.repaint();
        return panel;
    }

    private JPanel createSnoopyReadSystemPanel(int x, int y, int w, int h) {
        String netExtFactorValue;
        JPanel ioPanel = new JPanel(null);
        ioPanel.setBorder(BorderFactory.createTitledBorder("I/O operations"));
        ioPanel.setBounds(x, y, w, h);
        int posX = 10;
        int posY = 15;
        this.noAction = true;
        JLabel labelIO1 = new JLabel("(Snoopy) Resize net when loaded:");
        labelIO1.setBounds(posX, posY, 200, 20);
        ioPanel.add(labelIO1);
        ButtonGroup group = new ButtonGroup();
        JRadioButton resize80Button = new JRadioButton("80%");
        resize80Button.setBounds(posX, posY += 20, 60, 20);
        resize80Button.setActionCommand("0");
        resize80Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            GUIManager.getDefaultGUIManager().getSettingsManager().setValue("programSnoopyLoaderNetExtFactor", "80", false);
        });
        group.add(resize80Button);
        ioPanel.add(resize80Button);
        JRadioButton resize100Button = new JRadioButton("100%");
        resize100Button.setBounds(posX + 60, posY, 60, 20);
        resize100Button.setActionCommand("1");
        resize100Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            GUIManager.getDefaultGUIManager().getSettingsManager().setValue("programSnoopyLoaderNetExtFactor", "100", true);
        });
        group.add(resize100Button);
        ioPanel.add(resize100Button);
        JRadioButton resize120Button = new JRadioButton("120%");
        resize120Button.setBounds(posX + 120, posY, 60, 20);
        resize120Button.setActionCommand("2");
        resize120Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            GUIManager.getDefaultGUIManager().getSettingsManager().setValue("programSnoopyLoaderNetExtFactor", "120", false);
        });
        group.add(resize120Button);
        ioPanel.add(resize120Button);
        JRadioButton resize140Button = new JRadioButton("140%");
        resize140Button.setBounds(posX, posY += 20, 60, 20);
        resize140Button.setActionCommand("3");
        resize140Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            GUIManager.getDefaultGUIManager().getSettingsManager().setValue("programSnoopyLoaderNetExtFactor", "140", false);
        });
        group.add(resize140Button);
        ioPanel.add(resize140Button);
        JRadioButton resize160Button = new JRadioButton("160%");
        resize160Button.setBounds(posX + 60, posY, 60, 20);
        resize160Button.setActionCommand("4");
        resize160Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            GUIManager.getDefaultGUIManager().getSettingsManager().setValue("programSnoopyLoaderNetExtFactor", "160", false);
        });
        group.add(resize160Button);
        ioPanel.add(resize160Button);
        JRadioButton resize180Button = new JRadioButton("180%");
        resize180Button.setBounds(posX + 120, posY, 60, 20);
        resize180Button.setActionCommand("5");
        resize180Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            GUIManager.getDefaultGUIManager().getSettingsManager().setValue("programSnoopyLoaderNetExtFactor", "180", false);
        });
        group.add(resize180Button);
        ioPanel.add(resize180Button);
        switch (netExtFactorValue = GUIManager.getDefaultGUIManager().getSettingsManager().getValue("programSnoopyLoaderNetExtFactor")) {
            case "80": {
                group.setSelected(resize80Button.getModel(), true);
                break;
            }
            case "120": {
                group.setSelected(resize120Button.getModel(), true);
                break;
            }
            case "140": {
                group.setSelected(resize140Button.getModel(), true);
                break;
            }
            case "160": {
                group.setSelected(resize160Button.getModel(), true);
                break;
            }
            case "180": {
                group.setSelected(resize180Button.getModel(), true);
                break;
            }
            default: {
                group.setSelected(resize100Button.getModel(), true);
            }
        }
        JCheckBox alignGridWhenSavedCheckBox = this.checkboxWizard("(Snoopy) Align to grid when saved", posX + 200, posY - 20, 240, 20, "editorGridAlignWhenSaved", true);
        ioPanel.add(alignGridWhenSavedCheckBox);
        JCheckBox useOffsetsCheckBox = this.checkboxWizard("(Snoopy) Use Snoopy offsets for names", posX + 200, posY, 260, 20, "editorUseSnoopyOffsets", true);
        ioPanel.add(useOffsetsCheckBox);
        JCheckBox useOldLoaderCheckBox = this.checkboxWizard("(UNSAFE) Use old Snoopy loader (PN, extPN, TPN/DPN *ONLY*)", posX, posY += 20, 400, 20, "programUseOldSnoopyLoaders", true);
        ioPanel.add(useOldLoaderCheckBox);
        JCheckBox checkSaveCheckBox = this.checkboxWizard("Warnings concerning wrong save format", posX, posY += 20, 300, 20, "editorExportCheckAndWarning", true);
        ioPanel.add(checkSaveCheckBox);
        JCheckBox simpleEditorCheckBox = this.checkboxWizard("Use simple notepad (restart required)", posX, posY += 20, 300, 20, "programUseSimpleEditor", true);
        ioPanel.add(simpleEditorCheckBox);
        this.noAction = false;
        return ioPanel;
    }

    private JPanel createOtherOptionsPanel(int x, int y, int w, int h) {
        JPanel ioPanel = new JPanel(null);
        ioPanel.setBorder(BorderFactory.createTitledBorder("Other options"));
        ioPanel.setBounds(x, y, w, h);
        int posX = 10;
        int posY = 20;
        this.noAction = true;
        JCheckBox alignGridWhenSavedCheckBox = this.checkboxWizard("Debug mode", posX, posY, 240, 20, "programDebugMode", true);
        ioPanel.add(alignGridWhenSavedCheckBox);
        this.noAction = false;
        return ioPanel;
    }

    private JPanel createRoptionsSystemPanel(int x, int y, int w, int h) {
        JPanel rOptionsPanel = new JPanel(null);
        rOptionsPanel.setBorder(BorderFactory.createTitledBorder("R settings"));
        rOptionsPanel.setBounds(x, y, w, h);
        JLabel labelR_1 = new JLabel("R path:");
        labelR_1.setBounds(10, 16, 60, 20);
        rOptionsPanel.add(labelR_1);
        JTextArea textR_1 = new JTextArea(this.sm.getValue("r_path"));
        textR_1.setBounds(75, 18, 300, 20);
        textR_1.setOpaque(false);
        textR_1.setEditable(false);
        rOptionsPanel.add(textR_1);
        JLabel labelR_2 = new JLabel("Rx64 path:");
        labelR_2.setBounds(10, 36, 60, 20);
        rOptionsPanel.add(labelR_2);
        JTextArea textR_2 = new JTextArea(this.sm.getValue("r_path64"));
        textR_2.setBounds(75, 38, 300, 20);
        textR_2.setOpaque(false);
        textR_2.setEditable(false);
        rOptionsPanel.add(textR_2);
        JButton rSetPath = new JButton("Set R path");
        rSetPath.setName("setRpath");
        rSetPath.setBounds(10, 60, 120, 20);
        rSetPath.setToolTipText("Manually set path to Rscript.exe");
        rSetPath.addActionListener(actionEvent -> {
            this.action.setRPath();
            textR_1.setText(this.sm.getValue("r_path"));
            textR_2.setText(this.sm.getValue("r_path64"));
        });
        rOptionsPanel.add(rSetPath);
        JCheckBox forceRcheckBox = this.checkboxWizard("Force R localization on startup", 140, 60, 210, 20, "programAskForRonStartup", true);
        rOptionsPanel.add(forceRcheckBox);
        return rOptionsPanel;
    }

    private JPanel makeEditorPanel() {
        JPanel panel = new JPanel(null);
        panel.setBounds(0, 0, 600, 500);
        panel.add(this.createGraphicalEditorPanel(0, 0, 590, 150));
        panel.add(this.createGeneralEditorPanel(0, 150, 590, 150));
        panel.repaint();
        return panel;
    }

    private JPanel createGraphicalEditorPanel(int x, int y, int w, int h) {
        String thickValue;
        JPanel panel = new JPanel(null);
        panel.setBorder(BorderFactory.createTitledBorder("Graphical settings"));
        panel.setBounds(x, y, w, h);
        int posX = 10;
        int posY = 15;
        this.noAction = true;
        JLabel labelIO1 = new JLabel("Default arc thickness:");
        labelIO1.setBounds(posX, posY, 200, 20);
        panel.add(labelIO1);
        ButtonGroup group = new ButtonGroup();
        JRadioButton size1Button = new JRadioButton("1");
        size1Button.setBounds(posX, posY + 20, 40, 20);
        size1Button.setActionCommand("0");
        size1Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            GUIManager.getDefaultGUIManager().getSettingsManager().setValue("editorGraphArcLineSize", "1", true);
            GUIManager.getDefaultGUIManager().getWorkspace().repaintAllGraphPanels();
        });
        group.add(size1Button);
        panel.add(size1Button);
        JRadioButton size2Button = new JRadioButton("2");
        size2Button.setBounds(posX + 40, posY + 20, 40, 20);
        size2Button.setActionCommand("1");
        size2Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            GUIManager.getDefaultGUIManager().getSettingsManager().setValue("editorGraphArcLineSize", "2", true);
            GUIManager.getDefaultGUIManager().getWorkspace().repaintAllGraphPanels();
        });
        group.add(size2Button);
        panel.add(size2Button);
        JRadioButton size3Button = new JRadioButton("3");
        size3Button.setBounds(posX + 80, posY + 20, 40, 20);
        size3Button.setActionCommand("2");
        size3Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            GUIManager.getDefaultGUIManager().getSettingsManager().setValue("editorGraphArcLineSize", "3", true);
            GUIManager.getDefaultGUIManager().getWorkspace().repaintAllGraphPanels();
        });
        group.add(size3Button);
        panel.add(size3Button);
        switch (thickValue = GUIManager.getDefaultGUIManager().getSettingsManager().getValue("editorGraphArcLineSize")) {
            case "1": {
                group.setSelected(size1Button.getModel(), true);
                break;
            }
            case "2": {
                group.setSelected(size2Button.getModel(), true);
                break;
            }
            case "3": {
                group.setSelected(size3Button.getModel(), true);
            }
        }
        JLabel labelFontSize = new JLabel("Font size:");
        labelFontSize.setBounds(posX + 150, posY, 200, 20);
        panel.add(labelFontSize);
        JCheckBox boldCheckBox = this.checkboxWizard("Bold", posX + 210, posY, 60, 20, "editorGraphFontBold", true);
        panel.add(boldCheckBox);
        JCheckBox mctNameCheckBox = this.checkboxWizard("MCT names", posX + 270, posY, 110, 20, "mctNameShow", true);
        panel.add(mctNameCheckBox);
        SpinnerNumberModel fontSizeSpinnerModel = new SpinnerNumberModel(Integer.parseInt(GUIManager.getDefaultGUIManager().getSettingsManager().getValue("editorGraphFontSize")), 7, 30, 1);
        JSpinner fontSizeSpinner = new JSpinner(fontSizeSpinnerModel);
        fontSizeSpinner.setBounds(posX + 150, posY += 20, 80, 20);
        fontSizeSpinner.addChangeListener(e -> {
            if (this.noAction) {
                return;
            }
            JSpinner spinner = (JSpinner)e.getSource();
            int val = (Integer)spinner.getValue();
            GUIManager.getDefaultGUIManager().getSettingsManager().setValue("editorGraphFontSize", "" + val, true);
            GUIManager.getDefaultGUIManager().getWorkspace().repaintAllGraphPanels();
        });
        panel.add(fontSizeSpinner);
        JCheckBox useShortNamesCheckBox = this.checkboxWizard("(Editor) Show short default names only", posX, posY += 20, 260, 20, "editorShowShortNames", true);
        panel.add(useShortNamesCheckBox);
        JCheckBox useShortNamesLowerIndexCheckBox = this.checkboxWizard("(Editor) Show short names with lower index", posX, posY += 20, 300, 20, "editorShortNameLowerIndex", true);
        panel.add(useShortNamesLowerIndexCheckBox);
        JCheckBox view3dCheckBox = this.checkboxWizard("(Editor) Petri net elements 3d view", posX, posY += 20, 260, 20, "editor3Dview", true);
        panel.add(view3dCheckBox);
        JCheckBox snoopyStyleCheckBox = this.checkboxWizard("(Editor) Show Snoopy-styled graphics", posX, posY += 20, 260, 20, "editorSnoopyStyleGraphic", true);
        panel.add(snoopyStyleCheckBox);
        JCheckBox snoopyColorsBox = this.checkboxWizard("(Editor) Show non default T/P colors", posX + 270, posY, 260, 20, "editorSnoopyColors", true);
        panel.add(snoopyColorsBox);
        this.noAction = false;
        return panel;
    }

    private JPanel createGeneralEditorPanel(int x, int y, int w, int h) {
        JPanel panel = new JPanel(null);
        panel.setBorder(BorderFactory.createTitledBorder("General settings"));
        panel.setBounds(x, y, w, h);
        int posX = 10;
        int posY = 15;
        this.noAction = true;
        JCheckBox snoopyCompatibilityCheckBox = new JCheckBox("(Snoopy/Holmes) Allow only Snoopy-compatible options", true);
        snoopyCompatibilityCheckBox.setBounds(posX, posY, 400, 20);
        snoopyCompatibilityCheckBox.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                GUIManager.getDefaultGUIManager().getSettingsManager().setValue("editorSnoopyCompatibleMode", "1", true);
            } else {
                GUIManager.getDefaultGUIManager().getSettingsManager().setValue("editorSnoopyCompatibleMode", "0", true);
            }
            GUIManager.getDefaultGUIManager().getWorkspace().repaintAllGraphPanels();
        });
        snoopyCompatibilityCheckBox.setSelected(GUIManager.getDefaultGUIManager().getSettingsManager().getValue("editorSnoopyCompatibleMode").equals("1"));
        panel.add(snoopyCompatibilityCheckBox);
        JCheckBox subnetCompressionCheckBox = this.checkboxWizard("Use meta-arcs compression for metanodes", posX, posY += 20, 350, 20, "editorSubnetCompressMode", true);
        panel.add(subnetCompressionCheckBox);
        this.noAction = false;
        return panel;
    }

    public JPanel makeSimulatorPanel() {
        JPanel panel = new JPanel(null);
        panel.setBounds(0, 0, 600, 500);
        panel.add(this.createSimPanel(0, 0, 590, 190));
        panel.add(this.createSimGraphic(0, 190, 590, 150));
        panel.repaint();
        return panel;
    }

    private JPanel createSimPanel(int x, int y, int w, int h) {
        JPanel panel = new JPanel(null);
        panel.setBorder(BorderFactory.createTitledBorder("Simulator engine options"));
        panel.setBounds(x, y, w, h);
        int posX = 10;
        int posY = 15;
        this.noAction = true;
        JCheckBox readArcReservCheckBox = this.checkboxWizard("Transitions reserve tokens in place via read-arcs", posX, posY, 360, 20, "simTransReadArcTokenReserv", true);
        panel.add(readArcReservCheckBox);
        JCheckBox singleMaxModeCheckBox = this.checkboxWizard("Single-maximum mode (single-50/50 when unchecked)", posX, posY += 20, 360, 20, "simSingleMode", true);
        panel.add(singleMaxModeCheckBox);
        JCheckBox simTDPNrunTimeCheckBox = this.checkboxWizard("TDPN transition acts like DPN when TPN internal clock = EFT", posX, posY += 20, 380, 20, "simTDPNrunWhenEft", true);
        panel.add(simTDPNrunTimeCheckBox);
        JCheckBox placesColorsCheckBox = this.checkboxWizard("Places change colors during simulation", posX, posY += 20, 360, 20, "simPlacesColors", true);
        panel.add(placesColorsCheckBox);
        JCheckBox XTPNsimMassActionCheckBox = this.checkboxWizard("(XTPN) Globally use mass-action kinetics law for simulation", posX, posY += 20, 400, 20, "simXTPNmassAction", true);
        panel.add(XTPNsimMassActionCheckBox);
        JCheckBox XTPNsimReadArcTokenCheckBox = this.checkboxWizard("(XTPN) Read arcs preserve tokens lifetime", posX, posY += 20, 360, 20, "simXTPNreadArcTokens", true);
        panel.add(XTPNsimReadArcTokenCheckBox);
        this.noAction = false;
        return panel;
    }

    private JPanel createSimGraphic(int x, int y, int w, int h) {
        JPanel panel = new JPanel(null);
        panel.setBorder(BorderFactory.createTitledBorder("Simulator graphical options"));
        panel.setBounds(x, y, w, h);
        int io_x = 10;
        int io_y = 15;
        this.noAction = true;
        JLabel transDelayLabel = new JLabel("Transition firing delay:");
        transDelayLabel.setBounds(io_x, io_y, 200, 20);
        panel.add(transDelayLabel);
        JLabel arcDelayLabel = new JLabel("Arc token delay:");
        arcDelayLabel.setBounds(io_x + 280, io_y, 200, 20);
        panel.add(arcDelayLabel);
        JSlider arcDelaySlider = new JSlider(0, 5, 85, 25);
        arcDelaySlider.setBounds(io_x + 280, io_y += 20, 250, 50);
        arcDelaySlider.setMinorTickSpacing(2);
        arcDelaySlider.setMajorTickSpacing(10);
        arcDelaySlider.setPaintTicks(true);
        arcDelaySlider.setPaintLabels(true);
        arcDelaySlider.setLabelTable(arcDelaySlider.createStandardLabels(10));
        arcDelaySlider.addChangeListener(e -> {
            int reference;
            JSlider s = (JSlider)e.getSource();
            int val = s.getValue();
            if (val <= (reference = GUIManager.getDefaultGUIManager().simSettings.getTransitionGraphicDelay())) {
                arcDelaySlider.setValue(val);
                GUIManager.getDefaultGUIManager().simSettings.setArcGraphicDelay(val);
            } else {
                s.setValue(reference);
            }
        });
        panel.add(arcDelaySlider);
        final JSlider transDelaySlider = new JSlider(0, 5, 85, 25);
        transDelaySlider.setBounds(io_x, io_y, 250, 50);
        transDelaySlider.setMinorTickSpacing(2);
        transDelaySlider.setMajorTickSpacing(10);
        transDelaySlider.setPaintTicks(true);
        transDelaySlider.setPaintLabels(true);
        transDelaySlider.setLabelTable(transDelaySlider.createStandardLabels(10));
        transDelaySlider.addChangeListener(new ChangeListener(){
            private JSlider anotherSlider = null;

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider s = (JSlider)e.getSource();
                int value = s.getValue();
                transDelaySlider.setValue(value);
                GUIManager.getDefaultGUIManager().simSettings.setTransitionGraphicDelay(value);
                if (value < GUIManager.getDefaultGUIManager().simSettings.getArcGraphicDelay()) {
                    this.anotherSlider.setValue(value);
                }
            }

            private ChangeListener yesWeCan(JSlider slider) {
                this.anotherSlider = slider;
                return this;
            }
        }.yesWeCan(arcDelaySlider));
        panel.add(transDelaySlider);
        this.noAction = false;
        return panel;
    }

    public JPanel makeAnalysisPanel() {
        JPanel panel = new JPanel(null);
        panel.setBounds(0, 0, 600, 500);
        panel.add(this.createClustersOptionsPanel(0, 0, 590, 60));
        panel.add(this.createMCSPanel(0, 60, 590, 60));
        panel.repaint();
        return panel;
    }

    private JPanel createClustersOptionsPanel(int x, int y, int w, int h) {
        JPanel panel = new JPanel(null);
        panel.setBorder(BorderFactory.createTitledBorder("Clusters options"));
        panel.setBounds(x, y, w, h);
        int io_x = 10;
        int io_y = 15;
        this.noAction = true;
        JCheckBox binaryTinvCheckBox = this.checkboxWizard("Save t-invariants in CSV as binary vectors.", io_x, io_y, 360, 20, "analysisBinaryCSVInvariants", false);
        panel.add(binaryTinvCheckBox);
        JCheckBox feasInvSelfPropCheckBox = this.checkboxWizard("Allow presence of self-propelled readarc regions", io_x, io_y += 20, 360, 20, "analysisFeasibleSelfPropAccepted", true);
        panel.add(feasInvSelfPropCheckBox);
        this.noAction = false;
        return panel;
    }

    private JPanel createClusteringPanel(int x, int y, int w, int h) {
        JPanel panel = new JPanel(null);
        panel.setBorder(BorderFactory.createTitledBorder("Cluster algorithms options"));
        panel.setBounds(x, y, w, h);
        this.noAction = true;
        this.noAction = false;
        return panel;
    }

    private JPanel createMCSPanel(int x, int y, int w, int h) {
        JPanel panel = new JPanel(null);
        panel.setBorder(BorderFactory.createTitledBorder("MCS generator"));
        panel.setBounds(x, y, w, h);
        int io_x = 10;
        int io_y = 15;
        this.noAction = true;
        JCheckBox cleanMCSusingStructureCheckBox = this.checkboxWizard("Eliminate MCS sets non directly connected with objR transition.", io_x, io_y, 400, 20, "analysisMCSReduction", true);
        panel.add(cleanMCSusingStructureCheckBox);
        this.noAction = false;
        return panel;
    }

    protected JComponent makeTextPanel(String text) {
        JPanel panel = new JPanel(false);
        JLabel filler = new JLabel(text);
        filler.setHorizontalAlignment(0);
        panel.add(filler);
        panel.setBounds(0, 0, 640, 480);
        return panel;
    }

    private JCheckBox checkboxWizard(String checkBName, int xPos, int yPos, int width, int height, String propName, boolean autosave) {
        JCheckBox view3dCheckBox = new JCheckBox(checkBName, true);
        view3dCheckBox.setBounds(xPos, yPos, width, height);
        view3dCheckBox.addActionListener(new ActionListener(){
            private String propName = "";
            private boolean autoSave;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HolmesProgramProperties.this.noAction) {
                    return;
                }
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                if (abstractButton.getModel().isSelected()) {
                    GUIManager.getDefaultGUIManager().getSettingsManager().setValue(this.propName, "1", this.autoSave);
                } else {
                    GUIManager.getDefaultGUIManager().getSettingsManager().setValue(this.propName, "0", this.autoSave);
                }
                GUIManager.getDefaultGUIManager().getWorkspace().repaintAllGraphPanels();
            }

            private ActionListener yesWeCan(String name, boolean autosave) {
                this.propName = name;
                this.autoSave = autosave;
                return this;
            }
        }.yesWeCan(propName, autosave));
        view3dCheckBox.setSelected(GUIManager.getDefaultGUIManager().getSettingsManager().getValue(propName).equals("1"));
        return view3dCheckBox;
    }
}

