/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.darkgui.GUIManager;
import holmes.utilities.Tools;
import holmes.workspace.ExtensionFileFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class HolmesNotepad
extends JFrame {
    private static final long serialVersionUID = 1694133455242675169L;
    private String newline = "\r\n";
    private StyledDocument doc;
    private JTextPane textPane;
    private JTextArea textArea;
    private boolean simpleMode = false;
    private String[] initStyles = new String[]{"regular", "italic", "bold", "small", "large", "warning", "error", "time", "node"};

    private HolmesNotepad() {
        this.setTitle("Holmes Notepad");
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (694653943) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.setDefaultCloseOperation(2);
    }

    public HolmesNotepad(int width, int height) {
        this();
        try {
            if (GUIManager.getDefaultGUIManager().getSettingsManager().getValue("programUseSimpleEditor").equals("1")) {
                this.simpleMode = true;
            }
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (330239517) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.setPreferredSize(new Dimension(width, height));
        this.setLocation(50, 50);
        JPanel mainPanel = this.createEditor(width, height);
        this.setContentPane(mainPanel);
        this.pack();
        this.setVisible(false);
    }

    public HolmesNotepad(int width, int height, boolean simpleToken) {
        this();
        this.simpleMode = simpleToken;
        this.setPreferredSize(new Dimension(width, height));
        this.setLocation(50, 50);
        JPanel mainPanel = this.createEditor(width, height);
        this.setContentPane(mainPanel);
        this.pack();
        this.setVisible(false);
    }

    private JPanel createEditor(int width, int height) {
        JScrollPane paneScrollPane;
        JPanel main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        main.add(this.createButtonsPanel(width, height));
        if (this.simpleMode) {
            this.textArea = new JTextArea();
            this.textArea.setFont(new Font("monospaced", 0, 12));
            paneScrollPane = new JScrollPane(this.textArea);
            paneScrollPane.setVerticalScrollBarPolicy(22);
        } else {
            this.textPane = this.createTextPane();
            paneScrollPane = new JScrollPane(this.textPane);
            paneScrollPane.setVerticalScrollBarPolicy(22);
        }
        main.add(paneScrollPane);
        return main;
    }

    private Component createButtonsPanel(int width, int height) {
        JPanel buttonPanel = new JPanel(null);
        buttonPanel.setMinimumSize(new Dimension(width, 50));
        buttonPanel.setPreferredSize(new Dimension(width, 50));
        buttonPanel.setMaximumSize(new Dimension(3000, 50));
        buttonPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JButton savedButton = new JButton();
        savedButton.setBounds(10, 7, 35, 35);
        savedButton.setMargin(new Insets(0, 0, 0, 0));
        savedButton.setIcon(Tools.getResIcon16("/icons/notepad/saveFile.png"));
        savedButton.setToolTipText("Saves the content of notepad.");
        savedButton.setFocusPainted(false);
        savedButton.addActionListener(actionEvent -> this.saveContent());
        buttonPanel.add(savedButton);
        JButton loadButton = new JButton();
        loadButton.setBounds(50, 7, 35, 35);
        loadButton.setMargin(new Insets(0, 0, 0, 0));
        loadButton.setIcon(Tools.getResIcon16("/icons/notepad/loadFile.png"));
        loadButton.setToolTipText("Load txt files.");
        loadButton.setFocusPainted(false);
        loadButton.addActionListener(actionEvent -> this.loadContent());
        buttonPanel.add(loadButton);
        JButton clearButton = new JButton();
        clearButton.setBounds(90, 7, 35, 35);
        clearButton.setMargin(new Insets(0, 0, 0, 0));
        clearButton.setIcon(Tools.getResIcon16("/icons/notepad/eraserIcon.png"));
        clearButton.setToolTipText("Clear content");
        clearButton.setFocusPainted(false);
        clearButton.addActionListener(actionEvent -> this.clearContent());
        buttonPanel.add(clearButton);
        return buttonPanel;
    }

    protected void clearContent() {
        if (this.simpleMode) {
            this.textArea.setText("");
        } else {
            int len = this.textPane.getDocument().getLength();
            try {
                this.doc.remove(0, len);
            }
            catch (BadLocationException ex) {
                GUIManager.getDefaultGUIManager().log("Error (359758146) | Exception:  " + ex.getMessage(), "error", true);
            }
        }
    }

    protected void loadContent() {
        String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Holmes notepad text file (.txt)", new String[]{"TXT"})};
        String selectedFile = Tools.selectFileDialog(lastPath, filters, "Load", "Select text file", "");
        if (!selectedFile.equals("")) {
            try {
                String line;
                this.clearContent();
                DataInputStream dis = new DataInputStream(new FileInputStream(selectedFile));
                BufferedReader buffer = new BufferedReader(new InputStreamReader(dis));
                while ((line = buffer.readLine()) != null) {
                    this.addTextLineNL(line, "text");
                }
                buffer.close();
                this.setCaretFirstLine();
            }
            catch (Exception e) {
                GUIManager.getDefaultGUIManager().log("Reading text file into the notepad failed.", "error", true);
            }
        }
    }

    protected void saveContent() {
        String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Holmes notepad text file (.txt)", new String[]{"TXT"})};
        Object selectedFile = Tools.selectFileDialog(lastPath, filters, "Save", "Select new filename", "");
        if (!((String)selectedFile).equals("")) {
            String extension = ".txt";
            if (!((String)selectedFile).contains(extension)) {
                selectedFile = (String)selectedFile + extension;
            }
            try {
                PrintWriter pw = new PrintWriter((String)selectedFile);
                if (this.simpleMode) {
                    pw.write(this.textArea.getText());
                } else {
                    int len = this.textPane.getDocument().getLength();
                    pw.write(this.doc.getText(0, len));
                }
                pw.close();
            }
            catch (Exception e) {
                GUIManager.getDefaultGUIManager().log("Notepad saving operation for file " + (String)selectedFile + " failed.", "error", true);
            }
        }
    }

    private JTextPane createTextPane() {
        JTextPane txtPane = new JTextPane();
        this.doc = txtPane.getStyledDocument();
        this.addStylesToDocument(this.doc);
        return txtPane;
    }

    public void addText(String text, String mode, boolean time, boolean enter) {
        if (this.simpleMode) {
            String nL = "";
            if (enter) {
                nL = this.newline;
            }
            if (time) {
                String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
                this.textArea.append("[" + timeStamp + "]   ");
            }
            this.textArea.append(text + nL);
        } else {
            int style = this.setWritingStyle(mode);
            String nL = "";
            if (enter) {
                nL = this.newline;
            }
            try {
                if (time) {
                    String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
                    this.doc.insertString(this.doc.getLength(), "[" + timeStamp + "]   ", this.doc.getStyle("time"));
                }
                this.doc.insertString(this.doc.getLength(), text + nL, this.doc.getStyle(this.initStyles[style]));
            }
            catch (Exception ble) {
                GUIManager.getDefaultGUIManager().log("Couldn't insert initial text into text pane.", "error", true);
            }
            int len = this.textPane.getDocument().getLength();
            this.textPane.setCaretPosition(len);
        }
    }

    public void addTextLine(String text, String mode) {
        if (this.simpleMode) {
            this.textArea.append(text);
        } else {
            int style = this.setWritingStyle(mode);
            try {
                this.doc.insertString(this.doc.getLength(), text, this.doc.getStyle(this.initStyles[style]));
            }
            catch (Exception ble) {
                GUIManager.getDefaultGUIManager().log("Couldn't insert initial text into text pane.", "error", true);
            }
            int len = this.textPane.getDocument().getLength();
            this.textPane.setCaretPosition(len);
        }
    }

    public void addTextLineNL(String text, String mode) {
        if (this.simpleMode) {
            this.textArea.append(text + this.newline);
        } else {
            int style = this.setWritingStyle(mode);
            try {
                this.doc.insertString(this.doc.getLength(), text + this.newline, this.doc.getStyle(this.initStyles[style]));
            }
            catch (Exception ble) {
                GUIManager.getDefaultGUIManager().log("Couldn't insert initial text into text pane.", "error", true);
            }
            int len = this.textPane.getDocument().getLength();
            this.textPane.setCaretPosition(len);
        }
    }

    public void addLine(String text, String mode) {
        if (this.simpleMode) {
            this.textArea.append(text);
        } else {
            int style = this.setWritingStyle(mode);
            try {
                this.doc.insertString(this.doc.getLength(), text, this.doc.getStyle(this.initStyles[style]));
            }
            catch (Exception ble) {
                GUIManager.getDefaultGUIManager().log("Couldn't insert initial text into text pane.", "error", true);
            }
            int len = this.textPane.getDocument().getLength();
            this.textPane.setCaretPosition(len);
        }
    }

    public void setCaretFirstLine() {
        if (this.simpleMode) {
            this.textArea.setCaretPosition(0);
        } else {
            this.textPane.setCaretPosition(0);
        }
    }

    private int setWritingStyle(String mode) {
        return switch (mode) {
            case "text", "t" -> 0;
            case "italic", "i" -> 1;
            case "bold", "b" -> 2;
            case "small" -> 3;
            case "large" -> 4;
            case "warning" -> 5;
            case "error" -> 6;
            case "time" -> 7;
            case "nodeName" -> 8;
            default -> 0;
        };
    }

    private void addStylesToDocument(StyledDocument styledDoc) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setFontFamily(def, "Consolas");
        StyleConstants.setFontSize(def, 14);
        Style regular = styledDoc.addStyle("regular", def);
        StyleConstants.setFontFamily(regular, "Consolas");
        StyleConstants.setFontSize(regular, 14);
        Style s = styledDoc.addStyle("italic", regular);
        StyleConstants.setItalic(s, true);
        s = styledDoc.addStyle("bold", regular);
        StyleConstants.setBold(s, true);
        s = styledDoc.addStyle("small", regular);
        StyleConstants.setFontSize(s, 10);
        s = styledDoc.addStyle("large", regular);
        StyleConstants.setFontSize(s, 18);
        s = styledDoc.addStyle("warning", regular);
        StyleConstants.setForeground(s, Color.orange);
        s = styledDoc.addStyle("error", regular);
        StyleConstants.setForeground(s, Color.red);
        s = styledDoc.addStyle("time", regular);
        StyleConstants.setForeground(s, Color.darkGray);
        StyleConstants.setBold(s, true);
        s = styledDoc.addStyle("node", regular);
        StyleConstants.setForeground(s, Color.darkGray);
        StyleConstants.setBold(s, true);
    }
}

