/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.analyse.InvariantsTools;
import holmes.analyse.TimeComputations;
import holmes.darkgui.GUIManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.StateSimulator;
import holmes.tables.InvariantContainer;
import holmes.tables.InvariantsSimulatorTableModel;
import holmes.tables.InvariantsTableModel;
import holmes.tables.PlacesTableModel;
import holmes.tables.TransitionsTableModel;
import holmes.utilities.Tools;
import holmes.windows.HolmesNetTables;
import holmes.windows.HolmesNodeInfo;
import holmes.windows.HolmesNotepad;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class HolmesNetTablesActions {
    private HolmesNetTables antWindow;
    public ArrayList<InvariantContainer> dataMatrix;

    public HolmesNetTablesActions(HolmesNetTables overlord) {
        this.antWindow = overlord;
        this.dataMatrix = null;
    }

    public void cellClickAction(JTable table) {
        try {
            String name = table.getName();
            if (name.equals("PlacesTable")) {
                int row;
                this.antWindow.currentClickedRow = row = table.getSelectedRow();
                int index = Integer.parseInt(table.getValueAt(row, 0).toString());
                HolmesNodeInfo window = new HolmesNodeInfo(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces().get(index), (JFrame)this.antWindow);
                window.setVisible(true);
            } else if (name.equals("TransitionTable")) {
                int row;
                this.antWindow.currentClickedRow = row = table.getSelectedRow();
                int index = Integer.parseInt(table.getValueAt(row, 0).toString());
                HolmesNodeInfo window = new HolmesNodeInfo(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().get(index), (JFrame)this.antWindow);
                window.setVisible(true);
            }
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (437771981) | Exception:  " + ex.getMessage(), "error", true);
        }
    }

    public void addPlacesToModel(PlacesTableModel modelPlaces) {
        ArrayList<Place> places = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces();
        if (places.size() == 0) {
            return;
        }
        StateSimulator ss = new StateSimulator();
        SimulatorGlobals ownSettings = new SimulatorGlobals();
        ownSettings.setNetType(SimulatorGlobals.SimNetType.BASIC, false);
        ownSettings.setMaxMode(false);
        ownSettings.setSingleMode(false);
        ss.initiateSim(false, ownSettings);
        ss.simulateNetSimple(10000, true, false);
        ArrayList<Double> resVector = ss.getPlacesAvgData();
        int iterIndex = -1;
        for (Place p : places) {
            int index = places.indexOf(p);
            if (++iterIndex != index) {
                GUIManager.getDefaultGUIManager().log("Problem with position", "warning", true);
            }
            String name = p.getName();
            int tokens = p.getTokensNumber();
            int inTrans = 0;
            int outTrans = 0;
            for (ElementLocation el : p.getElementLocations()) {
                inTrans += el.getInArcs().size();
                outTrans += el.getOutArcs().size();
            }
            double avgTokens = 0.0;
            if (resVector != null && resVector.size() > 0) {
                avgTokens = resVector.get(iterIndex);
            }
            modelPlaces.addNew(index, name, tokens, inTrans, outTrans, (float)avgTokens);
        }
    }

    public void addTransitionsToModel(TransitionsTableModel modelTransitions) {
        ArrayList<Transition> transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
        if (transitions.size() == 0) {
            return;
        }
        StateSimulator ss = new StateSimulator();
        SimulatorGlobals ownSettings = new SimulatorGlobals();
        ownSettings.setNetType(SimulatorGlobals.SimNetType.BASIC, false);
        ownSettings.setMaxMode(false);
        ownSettings.setSingleMode(false);
        ss.initiateSim(false, ownSettings);
        ss.simulateNetSimple(10000, false, false);
        ArrayList<Double> resVector = ss.getTransitionsAvgData();
        int iterIndex = -1;
        for (Transition t : transitions) {
            int index = transitions.indexOf(t);
            if (++iterIndex != index) {
                GUIManager.getDefaultGUIManager().log("Problem with position", "warning", true);
            }
            String name = t.getName();
            int preP = 0;
            int postP = 0;
            for (ElementLocation el : t.getElementLocations()) {
                preP += el.getInArcs().size();
                postP += el.getOutArcs().size();
            }
            double avgFired = 0.0;
            if (resVector.size() > 0) {
                avgFired = resVector.get(iterIndex);
            }
            int inInv = 0;
            modelTransitions.addNew(index, name, preP, postP, (float)(avgFired *= 100.0), inInv);
        }
    }

    public void addBasicInvDataToModel(InvariantsTableModel modelInvariants) {
        PetriNet pn = GUIManager.getDefaultGUIManager().getWorkspace().getProject();
        ArrayList<Transition> transitions = pn.getTransitions();
        if (transitions.size() == 0) {
            return;
        }
        ArrayList<Arc> arcs = pn.getArcs();
        if (arcs.size() == 0) {
            return;
        }
        ArrayList<ArrayList<Integer>> invMatrix = pn.getT_InvMatrix();
        if (invMatrix == null || invMatrix.size() == 0) {
            return;
        }
        int invMatrixSize = invMatrix.size();
        if (this.dataMatrix == null || this.dataMatrix.size() == 0) {
            this.dataMatrix = new ArrayList();
            ArrayList<ArrayList<Integer>> nonMinimalInvariants = InvariantsTools.checkSupportMinimalityThorough(invMatrix);
            ArrayList<ArrayList<Integer>> arcsInfoMatrix = InvariantsTools.getExtendedT_invariantsInfo(invMatrix, true);
            ArrayList<ArrayList<Integer>> inOutInfoMatrix = InvariantsTools.getT_invInOutTransInfo(invMatrix);
            ArrayList<Integer> invariantsClassVector = InvariantsTools.getT_invariantsClassVector(invMatrix);
            ArrayList<Integer> feasibleVector = InvariantsTools.getT_invFeasibilityClassesStatic(invMatrix);
            ArrayList<Integer> canonicalVector = InvariantsTools.getCanonicalInfo(invMatrix);
            for (int i = 0; i < invMatrixSize; ++i) {
                ArrayList<Integer> invariant = invMatrix.get(i);
                ArrayList<Integer> support = InvariantsTools.getSupport(invariant);
                InvariantContainer ic = new InvariantContainer();
                ic.ID = i;
                ic.name = pn.accessT_InvDescriptions().get(i);
                ic.transNumber = support.size();
                ic.minimal = nonMinimalInvariants.get(i).size() == 0;
                ic.feasible = feasibleVector.get(i) != -1;
                ic.pureInTransitions = inOutInfoMatrix.get(i).get(0);
                ic.inTransitions = inOutInfoMatrix.get(i).get(1);
                ic.outTransitions = inOutInfoMatrix.get(i).get(2);
                ic.readArcs = arcsInfoMatrix.get(i).get(0);
                ic.inhibitors = arcsInfoMatrix.get(i).get(1);
                if (invariantsClassVector.get(i) == 0) {
                    ic.normalInv = true;
                    ic.sub = false;
                    ic.sur = false;
                } else if (invariantsClassVector.get(i) == 1) {
                    ic.normalInv = false;
                    ic.sub = false;
                    ic.sur = true;
                } else if (invariantsClassVector.get(i) == -1) {
                    ic.normalInv = false;
                    ic.sub = true;
                    ic.sur = false;
                } else {
                    ic.normalInv = false;
                    ic.sub = false;
                    ic.sur = false;
                }
                ic.canonical = canonicalVector.get(i) == 0;
                this.dataMatrix.add(ic);
            }
        }
        for (InvariantContainer ic : this.dataMatrix) {
            modelInvariants.addNew(ic.ID, ic.transNumber, ic.minimal, ic.feasible, ic.pureInTransitions, ic.inTransitions, ic.outTransitions, ic.readArcs, ic.inhibitors, ic.sur, ic.sub, ic.normalInv, ic.canonical, ic.name);
        }
    }

    public void addInvariantsToModel(InvariantsSimulatorTableModel modelInvariants, ArrayList<ArrayList<Integer>> invariantsMatrix, int simSteps, boolean maximumMode, boolean singleMode, SimulatorGlobals.SimNetType invSimNetType) {
        StateSimulator ss = new StateSimulator();
        SimulatorGlobals ownSettings = new SimulatorGlobals();
        ownSettings.setNetType(invSimNetType, false);
        ownSettings.setMaxMode(maximumMode);
        ownSettings.setSingleMode(singleMode);
        ss.initiateSim(false, ownSettings);
        ss.simulateNetSimple(simSteps, false, false);
        ArrayList<Double> resVector = ss.getTransitionsAvgData();
        ArrayList<Integer> rowsWithZero = new ArrayList<Integer>();
        ArrayList<Integer> zeroDeadTrans = new ArrayList<Integer>();
        int transNo = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().size();
        for (int i = 0; i < transNo; ++i) {
            zeroDeadTrans.add(0);
        }
        for (int row = 0; row < invariantsMatrix.size(); ++row) {
            ArrayList<Integer> dataV = invariantsMatrix.get(row);
            ArrayList<String> newRow = new ArrayList<String>();
            ArrayList<Integer> invSupport = InvariantsTools.getSupport(dataV);
            newRow.add("" + row);
            newRow.add("" + invSupport.size());
            for (int t = 0; t < dataV.size(); ++t) {
                int value = dataV.get(t);
                if (value > 0) {
                    zeroDeadTrans.set(t, 1);
                    double avg = resVector.get(t);
                    if (avg == 0.0) {
                        if (!rowsWithZero.contains(row)) {
                            rowsWithZero.add(row);
                        }
                        zeroDeadTrans.set(t, -1);
                    }
                    String cell = value + "(" + Tools.cutValue(avg *= 100.0) + "%)";
                    newRow.add(cell);
                    continue;
                }
                newRow.add("");
            }
            modelInvariants.addNew(newRow);
        }
        modelInvariants.setInfeasibleInvariants(rowsWithZero);
        modelInvariants.setZeroDeadTransitions(zeroDeadTrans);
    }

    public boolean switchSelected(JTable table) {
        try {
            String name = table.getName();
            if (!name.equals("PlacesTable") && !name.equals("TransitionsTable")) {
                JOptionPane.showMessageDialog(null, "Swap operation allowed only for places or transitions.", "Invalid table", 2);
                return false;
            }
            int[] selRows = table.getSelectedRows();
            if (selRows.length != 2) {
                JOptionPane.showMessageDialog(null, "Please select two rows (SHIFT key + mouse click).", "Invalid number of rows selected", 2);
                return false;
            }
            GUIManager.getDefaultGUIManager().reset.reset2ndOrderData(true);
            if (name.equals("PlacesTable")) {
                ArrayList<Place> places = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces();
                int pos1 = selRows[0];
                int pos2 = selRows[1];
                Place p1 = places.get(pos1);
                Place p2 = places.get(pos2);
                pos1 = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes().indexOf(p1);
                pos2 = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes().indexOf(p2);
                Collections.swap(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes(), pos1, pos2);
                GUIManager.getDefaultGUIManager().log("Swapping places " + p1.getName() + " and " + p2.getName() + " successfull.", "text", true);
            } else if (name.equals("TransitionTable")) {
                ArrayList<Transition> transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
                int pos1 = selRows[0];
                int pos2 = selRows[1];
                Transition t1 = transitions.get(pos1);
                Transition t2 = transitions.get(pos2);
                pos1 = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes().indexOf(t1);
                pos2 = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes().indexOf(t2);
                Collections.swap(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes(), pos1, pos2);
                GUIManager.getDefaultGUIManager().log("Swapping transitions " + t1.getName() + " and " + t2.getName() + " successfull.", "text", true);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void showTimeDataNotepad() {
        PetriNet pn = GUIManager.getDefaultGUIManager().getWorkspace().getProject();
        ArrayList<Transition> transitions = pn.getTransitions();
        ArrayList<ArrayList<Integer>> invMatrix = pn.getT_InvMatrix();
        if (invMatrix == null || invMatrix.size() == 0) {
            return;
        }
        int invMatrixSize = invMatrix.size();
        HolmesNotepad note = new HolmesNotepad(800, 600);
        note.addTextLineNL(" No.           Min.         Avg.          Max.    PN   TPN  DPN TDPN", "text");
        for (int i = 0; i < invMatrixSize; ++i) {
            ArrayList<Integer> invariant = invMatrix.get(i);
            ArrayList<Double> timeVector = TimeComputations.getT_InvTimeValues(invariant, transitions);
            Object line = "";
            String eftStr = String.format("%.2f", timeVector.get(0) + timeVector.get(3));
            String lftStr = String.format("%.2f", timeVector.get(1) + timeVector.get(3));
            String avgStr = String.format("%.2f", timeVector.get(2) + timeVector.get(3));
            String normal = "" + timeVector.get(4).intValue();
            String tpn = "" + timeVector.get(5).intValue();
            String dpn = "" + timeVector.get(6).intValue();
            String tdpn = "" + timeVector.get(7).intValue();
            line = (String)line + Tools.setToSize("i_" + i, 5, false);
            line = (String)line + Tools.setToSize(eftStr, 14, true);
            line = (String)line + Tools.setToSize(avgStr, 14, true);
            line = (String)line + Tools.setToSize(lftStr, 14, true);
            line = (String)line + "    ";
            line = (String)line + Tools.setToSize(normal, 5, false);
            line = (String)line + Tools.setToSize(tpn, 5, false);
            line = (String)line + Tools.setToSize(dpn, 5, false);
            line = (String)line + Tools.setToSize(tdpn, 5, false);
            note.addTextLineNL((String)line, "text");
        }
        note.setCaretFirstLine();
        note.setVisible(true);
    }
}

