/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.tables.InvariantsSimulatorTableModel;
import holmes.tables.InvariantsTableModel;
import holmes.tables.PTITableRenderer;
import holmes.tables.PlacesTableModel;
import holmes.tables.TransitionsTableModel;
import holmes.utilities.Tools;
import holmes.windows.HolmesNetTablesActions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class HolmesNetTables
extends JFrame {
    private static final long serialVersionUID = 8429744762731301629L;
    private JComboBox<String> invSimNetModeCombo;
    private SimulatorGlobals.SimNetType invSimNetType = SimulatorGlobals.SimNetType.BASIC;
    private boolean doNotUpdate = false;
    private JTable table;
    private PTITableRenderer tableRenderer;
    public int currentClickedRow;
    private int simStepsForInv = 10000;
    private boolean maxModeForSSInv = false;
    private boolean singleModeForSSInv = false;
    private final HolmesNetTablesActions action = new HolmesNetTablesActions(this);

    public HolmesNetTables(JFrame parent) {
        try {
            this.initialize_components();
            this.setVisible(false);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            GUIManager.getDefaultGUIManager().log("Critical error, cannot create Holmes Net Tables window:", "error", true);
            GUIManager.getDefaultGUIManager().log(msg, "error", true);
        }
    }

    public void resetT_invData() {
        this.action.dataMatrix = null;
    }

    private void initialize_components() {
        this.setTitle("Net data tables");
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (475821524) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.setDefaultCloseOperation(1);
        this.setLocation(20, 20);
        this.setSize(new Dimension(900, 700));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.createTablePanel(), "Center");
        mainPanel.add((Component)this.createButtonsPanel(), "East");
        this.add(mainPanel);
    }

    private void createTableConstruct() {
        DefaultTableModel model = new DefaultTableModel();
        this.table = new JTable(model);
        this.tableRenderer = new PTITableRenderer(this.table);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isControlDown()) {
                    HolmesNetTables.this.action.cellClickAction(HolmesNetTables.this.table);
                }
            }
        });
    }

    private JPanel createTablePanel() {
        JPanel tablesSubPanel = new JPanel(new BorderLayout());
        tablesSubPanel.setPreferredSize(new Dimension(670, 560));
        tablesSubPanel.setLocation(0, 0);
        tablesSubPanel.setBorder(BorderFactory.createTitledBorder("Tables:"));
        this.createTableConstruct();
        this.table.setAutoResizeMode(0);
        JScrollPane tableScrollPane = new JScrollPane(this.table, 20, 30);
        tablesSubPanel.add((Component)tableScrollPane, "Center");
        return tablesSubPanel;
    }

    private JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel(null);
        buttonsPanel.setPreferredSize(new Dimension(130, 560));
        buttonsPanel.setLocation(670, 0);
        JPanel upperButtonsPanel = new JPanel(null);
        upperButtonsPanel.setBounds(0, 0, 130, 160);
        upperButtonsPanel.setBorder(BorderFactory.createTitledBorder("P / T / Inv. data"));
        int yPos = 20;
        int xPos = 10;
        int bWidth = 110;
        int bHeight = 30;
        JButton placesButton = new JButton("<html>&nbsp;&nbsp;&nbsp;&nbsp;Places&nbsp;&nbsp;&nbsp;&nbsp;</html>");
        placesButton.setFocusPainted(false);
        placesButton.setMargin(new Insets(0, 0, 0, 0));
        placesButton.setIcon(Tools.getResIcon16("/icons/netTables/placeIcon.png"));
        placesButton.setToolTipText("Shows places table");
        placesButton.setBounds(xPos, yPos, bWidth, bHeight);
        placesButton.addActionListener(actionEvent -> this.createPlacesTable());
        placesButton.setAlignmentX(0.5f);
        upperButtonsPanel.add(placesButton);
        yPos = yPos + bHeight + 5;
        JButton transitionsButton = new JButton("Transitions");
        transitionsButton.setFocusPainted(false);
        transitionsButton.setMargin(new Insets(0, 0, 0, 0));
        transitionsButton.setIcon(Tools.getResIcon16("/icons/netTables/transIcon.png"));
        transitionsButton.setToolTipText("Shows transitions table");
        transitionsButton.setBounds(xPos, yPos, bWidth, bHeight);
        transitionsButton.addActionListener(actionEvent -> this.createTransitionTable());
        transitionsButton.setAlignmentX(0.5f);
        upperButtonsPanel.add(transitionsButton);
        yPos = yPos + bHeight + 5;
        JButton switchButton = new JButton("Switch P / T");
        switchButton.setFocusPainted(false);
        switchButton.setMargin(new Insets(0, 0, 0, 0));
        switchButton.setIcon(Tools.getResIcon16("/icons/netTables/switchIcon.png"));
        switchButton.setToolTipText("Switch internal localization of two places or two transitions.");
        switchButton.setBounds(xPos, yPos, bWidth, 20);
        switchButton.addActionListener(actionEvent -> {
            boolean status = this.action.switchSelected(this.table);
            if (status) {
                if (this.table.getName().equals("PlacesTable")) {
                    this.createPlacesTable();
                } else if (this.table.getName().equals("TransitionTable")) {
                    this.createTransitionTable();
                }
            }
        });
        switchButton.setAlignmentX(0.5f);
        upperButtonsPanel.add(switchButton);
        yPos = yPos + bHeight - 5;
        JButton invButton = new JButton("t-invariants");
        invButton.setFocusPainted(false);
        invButton.setMargin(new Insets(0, 0, 0, 0));
        invButton.setIcon(Tools.getResIcon16("/icons/netTables/invIcon.png"));
        invButton.setToolTipText("Shows invariants information table");
        invButton.setBounds(xPos, yPos, bWidth, bHeight);
        invButton.addActionListener(actionEvent -> this.createSimpleInvTable());
        invButton.setAlignmentX(0.5f);
        upperButtonsPanel.add(invButton);
        yPos = yPos + bHeight + 5;
        buttonsPanel.add(upperButtonsPanel);
        JPanel buttonsInvariantsPanel = new JPanel(null);
        buttonsInvariantsPanel.setBounds(0, upperButtonsPanel.getHeight(), 130, 220);
        buttonsInvariantsPanel.setBorder(BorderFactory.createTitledBorder("Invariants sim."));
        yPos = 20;
        xPos = 10;
        JButton invariantsButton = new JButton("Show data");
        invariantsButton.setFocusPainted(false);
        invariantsButton.setMargin(new Insets(0, 0, 0, 0));
        invariantsButton.setIcon(Tools.getResIcon16("/icons/netTables/invIcon.png"));
        invariantsButton.setToolTipText("Show invariants table with transition firing rates.");
        invariantsButton.setBounds(xPos, yPos, bWidth, bHeight);
        invariantsButton.addActionListener(actionEvent -> this.createInvariantsTable());
        invariantsButton.setAlignmentX(0.5f);
        buttonsInvariantsPanel.add(invariantsButton);
        JLabel ssLabel = new JLabel("State simulator");
        ssLabel.setBounds(xPos, yPos += 30, 110, 20);
        buttonsInvariantsPanel.add(ssLabel);
        JButton acqDataButton = new JButton("SimStart");
        acqDataButton.setFocusPainted(false);
        acqDataButton.setBounds(xPos, yPos += 20, 110, 25);
        acqDataButton.setMargin(new Insets(0, 0, 0, 0));
        acqDataButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        acqDataButton.setToolTipText("Compute new transitions firing statistics.");
        acqDataButton.addActionListener(actionEvent -> {
            String name = this.table.getName();
            if (name == null) {
                return;
            }
            if (name.equals("InvariantsTable")) {
                this.createInvariantsTable();
            }
        });
        buttonsInvariantsPanel.add(acqDataButton);
        SpinnerNumberModel simStepsSpinnerModel = new SpinnerNumberModel(this.simStepsForInv, 0, 1000000, 10000);
        JSpinner simStepsSpinner = new JSpinner(simStepsSpinnerModel);
        simStepsSpinner.setBounds(xPos, yPos += 30, 110, 25);
        simStepsSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.simStepsForInv = (Integer)spinner.getValue();
        });
        buttonsInvariantsPanel.add(simStepsSpinner);
        JLabel label0 = new JLabel("Net type:");
        label0.setBounds(xPos, yPos += 25, 80, 15);
        buttonsInvariantsPanel.add(label0);
        String[] simModeName = new String[]{"Petri Net", "Timed Petri Net", "Hybrid mode"};
        this.invSimNetModeCombo = new JComboBox<String>(simModeName);
        this.invSimNetModeCombo.setBounds(xPos, yPos += 15, 110, 25);
        this.invSimNetModeCombo.setSelectedIndex(0);
        this.invSimNetModeCombo.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            int selectedModeIndex = this.invSimNetModeCombo.getSelectedIndex();
            selectedModeIndex = GUIManager.getDefaultGUIManager().simSettings.checkSimulatorNetType(selectedModeIndex);
            this.doNotUpdate = true;
            switch (selectedModeIndex) {
                case 0: {
                    this.invSimNetType = SimulatorGlobals.SimNetType.BASIC;
                    this.invSimNetModeCombo.setSelectedIndex(0);
                    break;
                }
                case 1: {
                    this.invSimNetType = SimulatorGlobals.SimNetType.TIME;
                    this.invSimNetModeCombo.setSelectedIndex(1);
                    break;
                }
                case 2: {
                    this.invSimNetType = SimulatorGlobals.SimNetType.HYBRID;
                    this.invSimNetModeCombo.setSelectedIndex(2);
                    break;
                }
                case -1: {
                    this.invSimNetType = SimulatorGlobals.SimNetType.BASIC;
                    this.invSimNetModeCombo.setSelectedIndex(1);
                    GUIManager.getDefaultGUIManager().log("Error while changing simulator mode. Set for BASIC.", "error", true);
                }
            }
            this.doNotUpdate = false;
        });
        buttonsInvariantsPanel.add(this.invSimNetModeCombo);
        JLabel label1 = new JLabel("Submode:");
        label1.setBounds(xPos, yPos += 25, 80, 15);
        buttonsInvariantsPanel.add(label1);
        JComboBox<String> simMode = new JComboBox<String>(new String[]{"50/50 mode", "Maximum mode", "Single mode"});
        simMode.setToolTipText("In maximum mode each active transition fire at once, 50/50 means 50% chance for firing,\nin single mode only one transition will fire.");
        simMode.setBounds(xPos, yPos += 15, 110, 25);
        simMode.setSelectedIndex(0);
        simMode.setMaximumRowCount(6);
        simMode.addActionListener(actionEvent -> {
            int selected = simMode.getSelectedIndex();
            if (selected == 0) {
                this.maxModeForSSInv = false;
            } else if (selected == 1) {
                this.maxModeForSSInv = true;
            } else {
                this.singleModeForSSInv = true;
            }
        });
        buttonsInvariantsPanel.add(simMode);
        JButton timeDataButton = new JButton("Time & Inv.");
        timeDataButton.setFocusPainted(false);
        timeDataButton.setBounds(xPos, yPos += 210, 110, 30);
        timeDataButton.setMargin(new Insets(0, 0, 0, 0));
        timeDataButton.setIcon(Tools.getResIcon22("/icons/stateSim/aaa.png"));
        timeDataButton.setToolTipText("Show time data for t-invariants");
        timeDataButton.addActionListener(actionEvent -> this.action.showTimeDataNotepad());
        buttonsPanel.add(timeDataButton);
        buttonsPanel.add(buttonsInvariantsPanel);
        yPos = yPos + bHeight + 15;
        return buttonsPanel;
    }

    private void createPlacesTable() {
        PlacesTableModel modelPlaces = new PlacesTableModel();
        this.table.setModel(modelPlaces);
        this.table.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(0).setMinWidth(30);
        this.table.getColumnModel().getColumn(0).setMaxWidth(30);
        this.table.getColumnModel().getColumn(1).setHeaderValue("Place name:");
        this.table.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.table.getColumnModel().getColumn(1).setMinWidth(100);
        this.table.getColumnModel().getColumn(2).setHeaderValue("Tok:");
        this.table.getColumnModel().getColumn(2).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(2).setMinWidth(40);
        this.table.getColumnModel().getColumn(2).setMaxWidth(40);
        this.table.getColumnModel().getColumn(3).setHeaderValue("In-T");
        this.table.getColumnModel().getColumn(3).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(3).setMinWidth(40);
        this.table.getColumnModel().getColumn(3).setMaxWidth(40);
        this.table.getColumnModel().getColumn(4).setHeaderValue("Out-T");
        this.table.getColumnModel().getColumn(4).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(4).setMinWidth(40);
        this.table.getColumnModel().getColumn(4).setMaxWidth(40);
        this.table.getColumnModel().getColumn(5).setHeaderValue("Avg.Tk");
        this.table.getColumnModel().getColumn(5).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(5).setMinWidth(70);
        this.table.getColumnModel().getColumn(5).setMaxWidth(70);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
        this.table.setRowSorter(sorter);
        this.table.setName("PlacesTable");
        this.tableRenderer.setMode(0);
        this.table.setFillsViewportHeight(true);
        this.table.setDefaultRenderer(Object.class, this.tableRenderer);
        this.action.addPlacesToModel(modelPlaces);
        this.table.setAutoResizeMode(4);
        this.table.validate();
    }

    private void createTransitionTable() {
        TransitionsTableModel modelTransition = new TransitionsTableModel();
        this.table.setModel(modelTransition);
        this.table.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(0).setMinWidth(30);
        this.table.getColumnModel().getColumn(0).setMaxWidth(30);
        this.table.getColumnModel().getColumn(1).setHeaderValue("Transition name");
        this.table.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.table.getColumnModel().getColumn(1).setMinWidth(100);
        this.table.getColumnModel().getColumn(2).setHeaderValue("Pre-P");
        this.table.getColumnModel().getColumn(2).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(2).setMinWidth(40);
        this.table.getColumnModel().getColumn(2).setMaxWidth(40);
        this.table.getColumnModel().getColumn(3).setHeaderValue("Post-P");
        this.table.getColumnModel().getColumn(3).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(3).setMinWidth(40);
        this.table.getColumnModel().getColumn(3).setMaxWidth(40);
        this.table.getColumnModel().getColumn(4).setHeaderValue("Fired");
        this.table.getColumnModel().getColumn(4).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(4).setMinWidth(60);
        this.table.getColumnModel().getColumn(4).setMaxWidth(60);
        this.table.getColumnModel().getColumn(5).setHeaderValue("Inv");
        this.table.getColumnModel().getColumn(5).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(5).setMinWidth(40);
        this.table.getColumnModel().getColumn(5).setMaxWidth(40);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
        this.table.setRowSorter(sorter);
        this.table.setName("TransitionTable");
        this.tableRenderer.setMode(1);
        this.table.setFillsViewportHeight(true);
        this.table.setDefaultRenderer(Object.class, this.tableRenderer);
        this.action.addTransitionsToModel(modelTransition);
        this.table.setAutoResizeMode(4);
        this.table.validate();
    }

    private void createSimpleInvTable() {
        InvariantsTableModel modelBasicInvariants = new InvariantsTableModel();
        this.table.setModel(modelBasicInvariants);
        this.table.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(0).setMinWidth(40);
        this.table.getColumnModel().getColumn(0).setMaxWidth(40);
        this.table.getColumnModel().getColumn(1).setHeaderValue("Tr.#");
        this.table.getColumnModel().getColumn(1).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(1).setMinWidth(40);
        this.table.getColumnModel().getColumn(1).setMaxWidth(40);
        this.table.getColumnModel().getColumn(2).setHeaderValue("Min.");
        this.table.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(2).setMinWidth(50);
        this.table.getColumnModel().getColumn(2).setMaxWidth(50);
        this.table.getColumnModel().getColumn(3).setHeaderValue("Feas.");
        this.table.getColumnModel().getColumn(3).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(3).setMinWidth(50);
        this.table.getColumnModel().getColumn(3).setMaxWidth(50);
        this.table.getColumnModel().getColumn(4).setHeaderValue("pInT");
        this.table.getColumnModel().getColumn(4).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(4).setMinWidth(40);
        this.table.getColumnModel().getColumn(4).setMaxWidth(40);
        this.table.getColumnModel().getColumn(5).setHeaderValue("inT");
        this.table.getColumnModel().getColumn(5).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(5).setMinWidth(40);
        this.table.getColumnModel().getColumn(5).setMaxWidth(40);
        this.table.getColumnModel().getColumn(6).setHeaderValue("outT");
        this.table.getColumnModel().getColumn(6).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(6).setMinWidth(40);
        this.table.getColumnModel().getColumn(6).setMaxWidth(40);
        this.table.getColumnModel().getColumn(7).setHeaderValue("r-Arc");
        this.table.getColumnModel().getColumn(7).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(7).setMinWidth(40);
        this.table.getColumnModel().getColumn(7).setMaxWidth(40);
        this.table.getColumnModel().getColumn(8).setHeaderValue("Inh.");
        this.table.getColumnModel().getColumn(8).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(8).setMinWidth(40);
        this.table.getColumnModel().getColumn(8).setMaxWidth(40);
        this.table.getColumnModel().getColumn(9).setHeaderValue("Sur.");
        this.table.getColumnModel().getColumn(9).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(9).setMinWidth(40);
        this.table.getColumnModel().getColumn(9).setMaxWidth(40);
        this.table.getColumnModel().getColumn(10).setHeaderValue("Sub.");
        this.table.getColumnModel().getColumn(10).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(10).setMinWidth(40);
        this.table.getColumnModel().getColumn(10).setMaxWidth(40);
        this.table.getColumnModel().getColumn(11).setHeaderValue("Cx=0");
        this.table.getColumnModel().getColumn(11).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(11).setMinWidth(40);
        this.table.getColumnModel().getColumn(11).setMaxWidth(40);
        this.table.getColumnModel().getColumn(12).setHeaderValue("Canonical");
        this.table.getColumnModel().getColumn(12).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(12).setMinWidth(40);
        this.table.getColumnModel().getColumn(12).setMaxWidth(40);
        this.table.getColumnModel().getColumn(13).setHeaderValue("Name");
        this.table.getColumnModel().getColumn(13).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(13).setMinWidth(100);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
        this.table.setRowSorter(sorter);
        this.table.setName("BasicInvTable");
        this.tableRenderer.setMode(3);
        this.table.setFillsViewportHeight(true);
        this.table.setDefaultRenderer(Object.class, this.tableRenderer);
        this.action.addBasicInvDataToModel(modelBasicInvariants);
        this.table.setAutoResizeMode(4);
        this.table.validate();
    }

    private void createInvariantsTable() {
        ArrayList<ArrayList<Integer>> invariantsMatrix = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix();
        if (invariantsMatrix == null || invariantsMatrix.size() == 0) {
            JOptionPane.showMessageDialog(this, "Please generate T-invariants (Elementary Modes)", "No invariants", 1);
            return;
        }
        int transNumber = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().size();
        InvariantsSimulatorTableModel modelInvariantsSimData = new InvariantsSimulatorTableModel(transNumber);
        this.table.setModel(modelInvariantsSimData);
        this.table.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(0).setMinWidth(40);
        this.table.getColumnModel().getColumn(0).setMaxWidth(40);
        this.table.getColumnModel().getColumn(1).setHeaderValue("Trans. #:");
        this.table.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setMinWidth(50);
        this.table.getColumnModel().getColumn(1).setMaxWidth(50);
        for (int i = 0; i < transNumber; ++i) {
            this.table.getColumnModel().getColumn(i + 2).setHeaderValue("t" + i);
        }
        this.table.setName("InvariantsTable");
        this.tableRenderer.setMode(2);
        this.table.setFillsViewportHeight(true);
        this.table.setDefaultRenderer(Object.class, this.tableRenderer);
        this.table.setRowSorter(null);
        this.table.setAutoResizeMode(0);
        this.action.addInvariantsToModel(modelInvariantsSimData, invariantsMatrix, this.simStepsForInv, this.maxModeForSSInv, this.singleModeForSSInv, this.invSimNetType);
        ColumnHeaderToolTips tips = new ColumnHeaderToolTips();
        JTableHeader header = this.table.getTableHeader();
        ArrayList<Transition> transition = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
        for (int c = 2; c < this.table.getColumnCount(); ++c) {
            TableColumn col = this.table.getColumnModel().getColumn(c);
            tips.setToolTip(col, "t" + (c - 2) + "_" + transition.get(c - 2).getName());
        }
        header.addMouseMotionListener(tips);
        this.resizeColumnWidth(this.table);
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        InvariantsSimulatorTableModel itm = (InvariantsSimulatorTableModel)table.getModel();
        ArrayList<Integer> dTrans = itm.getZeroDeadTransitions();
        for (int column = 2; column < table.getColumnCount(); ++column) {
            if (dTrans.get(column - 2) == 0) {
                columnModel.getColumn(column).setPreferredWidth(35);
                columnModel.getColumn(column).setMinWidth(35);
                columnModel.getColumn(column).setMaxWidth(35);
                continue;
            }
            if (dTrans.get(column - 2) == -1) {
                columnModel.getColumn(column).setPreferredWidth(40);
                columnModel.getColumn(column).setMinWidth(40);
                columnModel.getColumn(column).setMaxWidth(40);
                continue;
            }
            if (dTrans.get(column - 2) != 1) continue;
            columnModel.getColumn(column).setPreferredWidth(50);
            columnModel.getColumn(column).setMinWidth(50);
            columnModel.getColumn(column).setMaxWidth(50);
        }
    }

    private JButton createStandardButton(String text, Icon icon) {
        JButton resultButton = new JButton();
        resultButton.setLayout(new BorderLayout());
        JLabel tmp = new JLabel(text);
        tmp.setFont(new Font("Arial", 0, 12));
        resultButton.add((Component)tmp, "Center");
        resultButton.setPreferredSize(new Dimension(100, 60));
        resultButton.setMinimumSize(new Dimension(100, 60));
        resultButton.setMaximumSize(new Dimension(100, 60));
        resultButton.setIcon(icon);
        return resultButton;
    }

    public void updateRow(String data, int column) {
        this.table.getModel().setValueAt(data, this.currentClickedRow, column);
    }

    static class ColumnHeaderToolTips
    extends MouseMotionAdapter {
        TableColumn curCol;
        Map<TableColumn, String> tips = new HashMap<TableColumn, String>();

        ColumnHeaderToolTips() {
        }

        public void setToolTip(TableColumn col, String tooltip) {
            if (tooltip == null) {
                this.tips.remove(col);
            } else {
                this.tips.put(col, tooltip);
            }
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
            JTableHeader header = (JTableHeader)evt.getSource();
            JTable table = header.getTable();
            TableColumnModel colModel = table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(evt.getX());
            TableColumn col = null;
            if (vColIndex >= 0) {
                col = colModel.getColumn(vColIndex);
            }
            if (col != this.curCol) {
                header.setToolTipText(this.tips.get(col));
                this.curCol = col;
            }
        }
    }
}

