/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.analyse.InvariantsCalculator;
import holmes.analyse.InvariantsTools;
import holmes.analyse.NetPropertiesAnalyzer;
import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.Tools;
import holmes.varia.Check;
import holmes.workspace.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;

public class HolmesNetProperties
extends JFrame {
    private static final long serialVersionUID = -4382182770445745847L;
    private GUIManager overlord;
    private JFrame ego;
    private ArrayList<Arc> arcs = new ArrayList();
    private ArrayList<Place> places = new ArrayList();
    private ArrayList<Transition> transitions = new ArrayList();
    private ArrayList<Node> nodes = new ArrayList();
    private ArrayList<ArrayList<Integer>> invariantsMatrix;
    private ArrayList<ArrayList<Object>> properties = new ArrayList();
    private JFormattedTextField nameField;
    private JLabel label_nodesNumber;
    private JLabel label_transitionsNumber;
    private JLabel label_placesNumber;
    private JLabel label_arcNumber;
    private JLabel label_invNumber;
    private JLabel label_arcNormal;
    private JLabel label_arcReadarc;
    private JLabel label_arcInhibitor;
    private JLabel label_arcReset;
    private JLabel label_arcEqual;
    JPanel staticPropertiesPanel;
    JTextArea textField;

    public HolmesNetProperties() {
        this.ego = this;
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (742898305) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.setTitle("Petri net general information and properties");
        this.overlord = GUIManager.getDefaultGUIManager();
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(650, 550));
        this.setLocation(50, 50);
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        JPanel main = this.createMainPanel();
        this.add((Component)main, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        this.setVisible(false);
        this.initiateListeners();
    }

    private void fillData() {
        this.places = this.overlord.getWorkspace().getProject().getPlaces();
        this.transitions = this.overlord.getWorkspace().getProject().getTransitions();
        this.arcs = this.overlord.getWorkspace().getProject().getArcs();
        this.nodes = this.overlord.getWorkspace().getProject().getNodes();
        this.invariantsMatrix = this.overlord.getWorkspace().getProject().getT_InvMatrix();
        ArrayList<Integer> arcClasses = Check.getArcClassCount();
        this.nameField.setText(this.overlord.getWorkspace().getProject().getName());
        this.label_nodesNumber.setText("" + this.nodes.size());
        this.label_transitionsNumber.setText("" + this.transitions.size());
        this.label_placesNumber.setText("" + this.places.size());
        int readArcs = arcClasses.get(1) / 2;
        this.label_arcNumber.setText("" + (this.arcs.size() - readArcs));
        int inv_number = this.invariantsMatrix == null ? 0 : this.invariantsMatrix.size();
        this.label_invNumber.setText("" + inv_number);
        this.label_arcNormal.setText("" + arcClasses.get(0));
        this.label_arcReadarc.setText("" + arcClasses.get(1) / 2);
        this.label_arcInhibitor.setText("" + arcClasses.get(2));
        this.label_arcReset.setText("" + arcClasses.get(3));
        this.label_arcEqual.setText("" + arcClasses.get(4));
        this.fillStaticProperties();
        ArrayList<Integer> idTransNoInv = new ArrayList<Integer>();
        ArrayList<Integer> transInInv = new ArrayList<Integer>();
        ArrayList<Integer> transFiresInInv = new ArrayList<Integer>();
        for (int trans = 0; trans < this.transitions.size(); ++trans) {
            transInInv.add(0);
            transFiresInInv.add(0);
        }
        int sur = 0;
        int sub = 0;
        int none = 0;
        int normal = 0;
        if (this.invariantsMatrix != null) {
            if (!this.overlord.getWorkspace().getProject().getT_invTypesComputed()) {
                this.textField.append("Computing t-invariants types vector\n");
                InvariantsCalculator ic = new InvariantsCalculator(true);
                InvariantsTools.analyseInvariantTypes(ic.getCMatrix(), this.invariantsMatrix, true);
            }
            ArrayList<Integer> invTypes = this.overlord.getWorkspace().getProject().accessT_InvTypesVector();
            for (Integer invType : invTypes) {
                if (invType == 0) {
                    ++normal;
                    continue;
                }
                if (invType == -1) {
                    ++sub;
                    continue;
                }
                if (invType == 1) {
                    ++sur;
                    continue;
                }
                ++none;
            }
        }
        this.textField.setText("");
        int transInNoInvariant = 0;
        if (inv_number > 0) {
            ArrayList<Integer> invTypes = this.overlord.getWorkspace().getProject().accessT_InvTypesVector();
            for (int inv = 0; inv < this.invariantsMatrix.size(); ++inv) {
                if (invTypes.get(inv) != 0) continue;
                for (int t = 0; t < this.invariantsMatrix.get(0).size(); ++t) {
                    if (this.invariantsMatrix.get(inv).get(t) <= 0) continue;
                    int oldVal = (Integer)transInInv.get(t);
                    transInInv.set(t, ++oldVal);
                    oldVal = (Integer)transFiresInInv.get(t);
                    transFiresInInv.set(t, oldVal += this.invariantsMatrix.get(inv).get(t).intValue());
                }
            }
            for (int trans = 0; trans < this.transitions.size(); ++trans) {
                if ((Integer)transInInv.get(trans) != 0) continue;
                idTransNoInv.add(trans);
                ++transInNoInvariant;
            }
            this.textField.append("t-invariants (Cx = 0): " + normal + "\n");
            this.textField.append("Sur-t-invariants (Cx > 0): " + sur + "\n");
            this.textField.append("Sub-t-invariants (Cx < 0): " + sub + "\n");
            this.textField.append("Non-t-invariants (Cx <=> 0): " + none + "\n");
            if (transInNoInvariant == 0) {
                this.textField.append("\n");
                this.textField.append("The net is covered by t-invariants (only vectors x such as Cx=0 are considered).\n");
                this.textField.append("\n");
            } else {
                this.textField.append("\n");
                this.textField.append("The net is not covered by t-invariants (only vectors x such as Cx=0 are considered).\n");
                this.textField.append("Transitions not covered by the " + normal + " t-invariants:\n");
                this.textField.append("\n");
                Iterator trans = idTransNoInv.iterator();
                while (trans.hasNext()) {
                    int tNumber = (Integer)trans.next();
                    String txt1 = Tools.setToSize("t" + tNumber, 5, false);
                    this.textField.append(txt1 + " " + tNumber + this.transitions.get(tNumber).getName() + "\n");
                }
                this.textField.append("\n");
            }
            this.textField.append("Transitions within " + normal + " t-invariants:\n");
            for (int i = 0; i < this.transitions.size(); ++i) {
                if ((Integer)transInInv.get(i) <= 0) continue;
                int transInv = (Integer)transInInv.get(i);
                int transFire = (Integer)transFiresInInv.get(i);
                String transName = this.transitions.get(i).getName();
                String txt1 = Tools.setToSize("t" + i, 5, false);
                String txt2 = Tools.setToSize("Inv:" + transInv, 10, false);
                String txt3 = Tools.setToSize("Fired:" + transFire, 12, false);
                this.textField.append(txt1 + txt2 + txt3 + "  t" + i + "_" + transName + "\n");
            }
            this.textField.setCaretPosition(0);
        }
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder("General Petri net informations:"));
        int xPos = 10;
        int yPosA = 15;
        int yPosB = 15;
        int spacing = 20;
        int numberLabelWidth = 70;
        JLabel label1 = new JLabel("Project name:");
        label1.setBounds(xPos, yPosA, 100, 20);
        panel.add(label1);
        this.nameField = new JFormattedTextField();
        this.nameField.setBounds(xPos + 110, yPosA + 2, 500, 20);
        this.nameField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                GUIManager.getDefaultGUIManager().log("Error (544610188) | Exception:  " + ex.getMessage(), "error", true);
            }
            String newName = field.getText();
            this.overlord.getWorkspace().getProject().setName(newName);
        });
        panel.add(this.nameField);
        JLabel label2 = new JLabel("Nodes:");
        label2.setBounds(xPos, yPosA += spacing, 100, 20);
        panel.add(label2);
        this.label_nodesNumber = new JLabel("N/A");
        this.label_nodesNumber.setBounds(xPos + label2.getWidth() + 10, label2.getLocation().y, numberLabelWidth, 20);
        panel.add(this.label_nodesNumber);
        JLabel label3 = new JLabel("Transitions:");
        label3.setBounds(xPos, yPosA += spacing, 100, 20);
        panel.add(label3);
        this.label_transitionsNumber = new JLabel("N/A");
        this.label_transitionsNumber.setBounds(xPos + label3.getWidth() + 10, label3.getLocation().y, numberLabelWidth, 20);
        panel.add(this.label_transitionsNumber);
        JLabel label4 = new JLabel("Places:");
        label4.setBounds(xPos, yPosA += spacing, 100, 20);
        panel.add(label4);
        this.label_placesNumber = new JLabel("N/A");
        this.label_placesNumber.setBounds(xPos + label4.getWidth() + 10, label4.getLocation().y, numberLabelWidth, 20);
        panel.add(this.label_placesNumber);
        JLabel label5 = new JLabel("Arcs:");
        label5.setBounds(xPos, yPosA += spacing, 100, 20);
        panel.add(label5);
        this.label_arcNumber = new JLabel("N/A");
        this.label_arcNumber.setBounds(xPos + label5.getWidth() + 10, label5.getLocation().y, numberLabelWidth, 20);
        panel.add(this.label_arcNumber);
        JLabel label6 = new JLabel("t-invariants:");
        label6.setBounds(xPos, yPosA += spacing, 100, 20);
        panel.add(label6);
        this.label_invNumber = new JLabel("N/A");
        this.label_invNumber.setBounds(xPos + label6.getWidth() + 10, label6.getLocation().y, numberLabelWidth, 20);
        panel.add(this.label_invNumber);
        JLabel label11 = new JLabel("Normal arc:");
        label11.setBounds(xPos + 150, yPosB += spacing, 80, 20);
        panel.add(label11);
        this.label_arcNormal = new JLabel("0");
        this.label_arcNormal.setBounds(xPos + 240, yPosB, 60, 20);
        panel.add(this.label_arcNormal);
        JLabel label12 = new JLabel("Read-arc:");
        label12.setBounds(xPos + 150, yPosB += spacing, 80, 20);
        panel.add(label12);
        this.label_arcReadarc = new JLabel("0");
        this.label_arcReadarc.setBounds(xPos + 240, yPosB, 60, 20);
        panel.add(this.label_arcReadarc);
        JLabel label13 = new JLabel("Inhibitor arc:");
        label13.setBounds(xPos + 150, yPosB += spacing, 80, 20);
        panel.add(label13);
        this.label_arcInhibitor = new JLabel("0");
        this.label_arcInhibitor.setBounds(xPos + 240, yPosB, 60, 20);
        panel.add(this.label_arcInhibitor);
        JLabel label14 = new JLabel("Reset arc:");
        label14.setBounds(xPos + 150, yPosB += spacing, 80, 20);
        panel.add(label14);
        this.label_arcReset = new JLabel("0");
        this.label_arcReset.setBounds(xPos + 240, yPosB, 60, 20);
        panel.add(this.label_arcReset);
        JLabel label15 = new JLabel("Equal arc:");
        label15.setBounds(xPos + 150, yPosB += spacing, 80, 20);
        panel.add(label15);
        this.label_arcEqual = new JLabel("0");
        this.label_arcEqual.setBounds(xPos + 240, yPosB, 60, 20);
        panel.add(this.label_arcEqual);
        this.staticPropertiesPanel = new JPanel(new FlowLayout());
        this.staticPropertiesPanel.setBorder(BorderFactory.createTitledBorder("Net static properties:"));
        this.staticPropertiesPanel.setBounds(330, 35, 300, 100);
        panel.add(this.staticPropertiesPanel);
        JButton saveButton = new JButton("Save to file");
        saveButton.setMargin(new Insets(0, 0, 0, 0));
        saveButton.setIcon(Tools.getResIcon22("/icons/quickSave.png"));
        saveButton.setBounds(xPos, yPosA += 25, 130, 30);
        saveButton.addActionListener(actionEvent -> this.saveToFile());
        panel.add(saveButton);
        yPosA += 10;
        JPanel invInfoPanel = new JPanel(new BorderLayout());
        invInfoPanel.setBorder(BorderFactory.createTitledBorder("Invariants details:"));
        invInfoPanel.setBounds(xPos - 5, yPosA += spacing, 635, 345);
        this.textField = new JTextArea();
        this.textField.setEditable(false);
        this.textField.setFont(new Font("Monospaced", 0, 12));
        JScrollPane areaScrollPane = new JScrollPane(this.textField);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        invInfoPanel.add(areaScrollPane);
        panel.add(invInfoPanel);
        panel.repaint();
        return panel;
    }

    private void fillStaticProperties() {
        this.staticPropertiesPanel.removeAll();
        this.staticPropertiesPanel.revalidate();
        NetPropertiesAnalyzer analyzer = new NetPropertiesAnalyzer();
        this.properties = analyzer.propAnalyze();
        for (ArrayList<Object> pr : this.properties) {
            JButton pButton = new JButton();
            pButton.setPreferredSize(new Dimension(66, 20));
            if (pr.size() < 2) {
                pButton.setBackground(Color.GRAY);
            } else {
                if (((Boolean)pr.get(1)).booleanValue()) {
                    pButton.setBackground(Color.green);
                    pButton.setForeground(Color.WHITE);
                } else {
                    pButton.setBackground(Color.red);
                }
                String[] dataTxt = (String[])pr.get(2);
                pButton.setToolTipText(dataTxt[0]);
                pButton.addActionListener(new ActionListener(){
                    private String[] yesWeCan;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JOptionPane.showMessageDialog(HolmesNetProperties.this.ego, "Petri net meaning:\n" + this.yesWeCan[1] + "\n\nBiological interpretation:\n" + this.yesWeCan[2], this.yesWeCan[0], 1);
                    }

                    private ActionListener goForthMyMinion(String[] codeInjection) {
                        this.yesWeCan = codeInjection;
                        return this;
                    }
                }.goForthMyMinion(dataTxt));
            }
            pButton.setText(pr.get(0).toString());
            pButton.setVisible(true);
            this.staticPropertiesPanel.add(pButton);
        }
    }

    private void saveToFile() {
        FileFilter[] filters = new FileFilter[1];
        String lastPath = this.overlord.getLastPath();
        filters[0] = new ExtensionFileFilter("Normal text file (.txt)", new String[]{"TXT"});
        Object selectedFile = Tools.selectFileDialog(lastPath, filters, "Save", "", "");
        if (!((String)selectedFile).equals("")) {
            String fileName = ((String)selectedFile).substring(((String)selectedFile).lastIndexOf(File.separator) + 1);
            if (!fileName.contains(".txt")) {
                selectedFile = (String)selectedFile + ".txt";
            }
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter((String)selectedFile));
                bw.write("Petri net name: " + this.nameField.getText() + "\n");
                bw.write("Number of nodes: " + this.label_nodesNumber.getText() + "\n");
                bw.write("Number of transitions: " + this.label_transitionsNumber.getText() + "\n");
                bw.write("Number of places: " + this.label_placesNumber.getText() + "\n");
                bw.write("Number of arcs: " + this.label_arcNumber.getText() + "\n");
                bw.write("\n");
                bw.write("Net static properties: \n");
                int count = 1;
                for (ArrayList<Object> property : this.properties) {
                    boolean isNet = (Boolean)property.get(1);
                    if (!isNet) continue;
                    String[] data = (String[])property.get(2);
                    bw.write("Property " + count + ": " + data[0] + "\n");
                    String txt = data[1];
                    txt = txt.replace("\n", "");
                    bw.write("Meaning: " + txt + "\n");
                    txt = data[2];
                    txt = txt.replace("\n", "");
                    bw.write("Biological: " + data[2] + "\n\n");
                    ++count;
                }
                bw.write("\n");
                if (this.invariantsMatrix != null) {
                    int inv_number = this.invariantsMatrix.size();
                    bw.write("Number of invariants: " + inv_number + "\n");
                    bw.write(this.textField.getText());
                }
                bw.close();
            }
            catch (Exception ex) {
                GUIManager.getDefaultGUIManager().log("Error (378650758) | Exception:  " + ex.getMessage(), "error", true);
            }
        }
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                HolmesNetProperties.this.fillData();
            }
        });
    }
}

