/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.analyse.MCSCalculator;
import holmes.darkgui.GUIManager;
import holmes.files.io.MCSoperations;
import holmes.petrinet.data.MCSDataMatrix;
import holmes.petrinet.elements.Transition;
import holmes.utilities.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultCaret;

public class HolmesMCS
extends JFrame {
    private static final long serialVersionUID = -5765964470006303431L;
    private MCSCalculator mcsGenerator = null;
    private ArrayList<Transition> transitions;
    private int maxCutSize;
    private int maximumMCS;
    private int maxSetsNumber = 300;
    private boolean generateAll = true;
    private boolean isMCSGeneratorWorking = false;
    private boolean showFullInfo = true;
    private boolean listenerAllowed = true;
    private JComboBox<String> transitionsCombo;
    private JComboBox<String> transitionsResultsCombo;
    private JSpinner mcsSpinner;
    private JTextArea logField;
    private JTextArea reactionSetsTextField;

    public HolmesMCS() {
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
            this.transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (995194569) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.setVisible(false);
        this.setTitle("Minimal Cutting Sets generator");
        if (this.transitions != null && this.transitions.size() > 1) {
            this.maxCutSize = 2;
            this.maximumMCS = this.transitions.size();
        } else {
            this.maxCutSize = 0;
            this.maximumMCS = 0;
        }
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(860, 754));
        this.setLocation(50, 50);
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        JPanel mainPanel = this.createMainPanel();
        this.add((Component)mainPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                HolmesMCS.this.fillComboBoxData();
            }
        });
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        JPanel buttonPanel = this.createUpperButtonPanel(0, 0, 844, 110);
        JPanel logMainPanel = this.createMainPanel(0, 110, 844, 610);
        panel.add(buttonPanel);
        panel.add(logMainPanel);
        panel.repaint();
        return panel;
    }

    private JPanel createUpperButtonPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createLineBorder(Color.black));
        panel.setBounds(x, y, width, height);
        int posX = 10;
        int posY = 10;
        JLabel mcsLabel1 = new JLabel("Obj. reaction:");
        mcsLabel1.setBounds(posX, posY, 80, 20);
        panel.add(mcsLabel1);
        String[] dataT = new String[]{"---"};
        this.transitionsCombo = new JComboBox<String>(dataT);
        this.transitionsCombo.setBounds(posX + 90, posY, 400, 20);
        this.transitionsCombo.setSelectedIndex(0);
        this.transitionsCombo.setMaximumRowCount(6);
        this.transitionsCombo.removeAllItems();
        this.transitionsCombo.addItem("---");
        if (this.transitions != null && this.transitions.size() > 0) {
            for (int t = 0; t < this.transitions.size(); ++t) {
                this.transitionsCombo.addItem("t" + t + "." + this.transitions.get(t).getName());
            }
        }
        panel.add(this.transitionsCombo);
        JLabel mcsLabel2 = new JLabel("Max. |CutSet|:");
        mcsLabel2.setBounds(posX, posY + 25, 80, 20);
        panel.add(mcsLabel2);
        SpinnerNumberModel mcsSpinnerModel = new SpinnerNumberModel(this.maxCutSize, 0, this.maximumMCS, 1);
        this.mcsSpinner = new JSpinner(mcsSpinnerModel);
        this.mcsSpinner.setBounds(posX + 90, posY + 25, 60, 20);
        this.mcsSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.maxCutSize = (Integer)spinner.getValue();
        });
        panel.add(this.mcsSpinner);
        JLabel mcsLabel3 = new JLabel("Max. set number:");
        mcsLabel3.setBounds(posX + 160, posY + 25, 120, 20);
        panel.add(mcsLabel3);
        SpinnerNumberModel maxSizeSpinnerModel = new SpinnerNumberModel(300, 50, 5000, 100);
        JSpinner maxSizeStepsSpinner = new JSpinner(maxSizeSpinnerModel);
        maxSizeStepsSpinner.setBounds(posX + 270, posY + 25, 60, 20);
        maxSizeStepsSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.maxSetsNumber = (Integer)spinner.getValue();
        });
        panel.add(maxSizeStepsSpinner);
        JCheckBox cleanMCSusingStructureCheckBox = new JCheckBox("Reduce MCSs", true);
        cleanMCSusingStructureCheckBox.setBounds(posX + 340, posY + 25, 140, 20);
        cleanMCSusingStructureCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                GUIManager.getDefaultGUIManager().getSettingsManager().setValue("analysisMCSReduction", "1", true);
            } else {
                GUIManager.getDefaultGUIManager().getSettingsManager().setValue("analysisMCSReduction", "0", true);
            }
        });
        cleanMCSusingStructureCheckBox.setSelected(GUIManager.getDefaultGUIManager().getSettingsManager().getValue("analysisMCSReduction").equals("1"));
        panel.add(cleanMCSusingStructureCheckBox);
        JButton generateButton = new JButton();
        generateButton.setText("<html>Generate<br />MCS</html>");
        generateButton.setBounds(posX, posY + 55, 110, 32);
        generateButton.setMargin(new Insets(0, 0, 0, 0));
        generateButton.setIcon(Tools.getResIcon32("/icons/mcsWindow/computeData.png"));
        generateButton.addActionListener(actionEvent -> {
            this.launchMCSanalysis();
            GUIManager.getDefaultGUIManager().showMCS();
        });
        generateButton.setFocusPainted(false);
        panel.add(generateButton);
        JButton cancelButton = new JButton();
        cancelButton.setText("STOP");
        cancelButton.setBounds(posX + 110, posY + 55, 50, 32);
        cancelButton.setMargin(new Insets(0, 0, 0, 0));
        cancelButton.addActionListener(actionEvent -> {
            if (this.mcsGenerator != null) {
                this.mcsGenerator.emergencyStop();
            }
        });
        cancelButton.setFocusPainted(false);
        panel.add(cancelButton);
        JButton loadButton = new JButton();
        loadButton.setText("<html>Load one<br />objR MCS</html>");
        loadButton.setBounds(posX + 170, posY + 55, 110, 32);
        loadButton.setMargin(new Insets(0, 0, 0, 0));
        loadButton.setIcon(Tools.getResIcon22("/icons/mcsWindow/loadMCS.png"));
        loadButton.addActionListener(actionEvent -> {
            MCSoperations.loadSingleMCS();
            GUIManager.getDefaultGUIManager().showMCS();
        });
        loadButton.setFocusPainted(false);
        panel.add(loadButton);
        JButton loadAllButton = new JButton();
        loadAllButton.setText("<html>Load all<br />MCS</html>");
        loadAllButton.setBounds(posX + 290, posY + 55, 110, 32);
        loadAllButton.setMargin(new Insets(0, 0, 0, 0));
        loadAllButton.setIcon(Tools.getResIcon22("/icons/mcsWindow/loadAllMCS.png"));
        loadAllButton.addActionListener(actionEvent -> {
            MCSoperations.loadAllMCS();
            GUIManager.getDefaultGUIManager().showMCS();
        });
        loadAllButton.setFocusPainted(false);
        panel.add(loadAllButton);
        JButton saveAllButton = new JButton();
        saveAllButton.setText("<html>Save all<br />MCS</html>");
        saveAllButton.setBounds(posX + 410, posY + 55, 110, 32);
        saveAllButton.setMargin(new Insets(0, 0, 0, 0));
        saveAllButton.setIcon(Tools.getResIcon22("/icons/mcsWindow/saveAllMCS.png"));
        saveAllButton.addActionListener(actionEvent -> MCSoperations.saveAllMCS(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMCSdataCore()));
        saveAllButton.setFocusPainted(false);
        panel.add(saveAllButton);
        JButton addToButton = new JButton();
        addToButton.setText("Add");
        addToButton.setBounds(posX + 500, posY, 65, 20);
        addToButton.setMargin(new Insets(0, 0, 0, 0));
        addToButton.setIcon(Tools.getResIcon16("/icons/mcsWindow/add.png"));
        addToButton.addActionListener(actionEvent -> {
            int selected = this.transitionsCombo.getSelectedIndex();
            if (selected == 0) {
                return;
            }
            String msg = "t" + --selected + ",";
            if (!this.reactionSetsTextField.getText().contains(msg)) {
                this.reactionSetsTextField.append(msg);
            }
        });
        addToButton.setFocusPainted(false);
        panel.add(addToButton);
        JButton removeButton = new JButton();
        removeButton.setText("Rem.");
        removeButton.setBounds(posX + 575, posY, 65, 20);
        removeButton.setMargin(new Insets(0, 0, 0, 0));
        removeButton.setIcon(Tools.getResIcon16("/icons/mcsWindow/remove.png"));
        removeButton.addActionListener(actionEvent -> {
            int selected = this.transitionsCombo.getSelectedIndex();
            if (selected == 0) {
                return;
            }
            String msg = "t" + --selected + ",";
            String text = this.reactionSetsTextField.getText();
            text = text.replace(msg, "");
            this.reactionSetsTextField.setText(text);
        });
        removeButton.setFocusPainted(false);
        panel.add(removeButton);
        JButton clearButton = new JButton();
        clearButton.setText("Clear");
        clearButton.setBounds(posX + 650, posY, 65, 20);
        clearButton.setMargin(new Insets(0, 0, 0, 0));
        clearButton.setIcon(Tools.getResIcon16("/icons/mcsWindow/clear.png"));
        clearButton.addActionListener(actionEvent -> this.reactionSetsTextField.setText(""));
        clearButton.setFocusPainted(false);
        panel.add(clearButton);
        this.reactionSetsTextField = new JTextArea();
        this.reactionSetsTextField.setLineWrap(true);
        this.reactionSetsTextField.setEditable(false);
        JPanel logFieldPanel = new JPanel();
        logFieldPanel.setLayout(new BorderLayout());
        logFieldPanel.add((Component)new JScrollPane(this.reactionSetsTextField), "Center");
        logFieldPanel.setBounds(posX + 500, posY + 22, 215, 30);
        panel.add(logFieldPanel);
        JCheckBox allCheckBox = new JCheckBox("Compute all MCS", true);
        allCheckBox.setBounds(posX + 690, posY + 55, 140, 20);
        allCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.generateAll = abstractButton.getModel().isSelected();
        });
        panel.add(allCheckBox);
        JButton calcAllButton = new JButton();
        calcAllButton.setText("<html>Comp.<br />select.<br />MCSs</html>");
        calcAllButton.setBounds(posX + 725, posY, 100, 50);
        calcAllButton.setMargin(new Insets(0, 0, 0, 0));
        calcAllButton.setIcon(Tools.getResIcon22("/icons/mcsWindow/computeSet.png"));
        calcAllButton.addActionListener(actionEvent -> this.calculateAllAction());
        calcAllButton.setFocusPainted(false);
        panel.add(calcAllButton);
        return panel;
    }

    private JPanel createMainPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createLineBorder(Color.black));
        panel.setBounds(x, y, width, height - 5);
        JPanel upperButtons = this.createSubButtonPanel(2, 2, 840, 90);
        panel.add(upperButtons);
        this.logField = new JTextArea();
        this.logField.setLineWrap(true);
        this.logField.setEditable(false);
        DefaultCaret caret = (DefaultCaret)this.logField.getCaret();
        caret.setUpdatePolicy(2);
        JPanel logFieldPanel = new JPanel();
        logFieldPanel.setBorder(BorderFactory.createTitledBorder("Log"));
        logFieldPanel.setLayout(new BorderLayout());
        logFieldPanel.add((Component)new JScrollPane(this.logField), "Center");
        logFieldPanel.setBounds(2, 90, 840, height - 98);
        panel.add(logFieldPanel);
        return panel;
    }

    private JPanel createSubButtonPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder("Computed MCS options"));
        panel.setBounds(x, y, width, height);
        int posX = 10;
        int posY = 20;
        JLabel mcsLabel1 = new JLabel("ObjR MCSs:");
        mcsLabel1.setBounds(posX, posY, 80, 20);
        panel.add(mcsLabel1);
        String[] dataT = new String[]{"---"};
        this.transitionsResultsCombo = new JComboBox<String>(dataT);
        this.transitionsResultsCombo.setBounds(posX + 90, posY, 400, 20);
        this.transitionsResultsCombo.setSelectedIndex(0);
        this.transitionsResultsCombo.setMaximumRowCount(6);
        this.transitionsResultsCombo.removeAllItems();
        this.transitionsResultsCombo.addItem("---");
        if (this.transitions != null && this.transitions.size() > 0) {
            for (int t = 0; t < this.transitions.size(); ++t) {
                this.transitionsResultsCombo.addItem("t" + t + "." + this.transitions.get(t).getName());
            }
        }
        this.transitionsResultsCombo.addActionListener(actionEvent -> {});
        panel.add(this.transitionsResultsCombo);
        JCheckBox showAllCheckBox = new JCheckBox("Show full info", true);
        showAllCheckBox.setBounds(posX + 490, posY, 120, 20);
        showAllCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.showFullInfo = abstractButton.getModel().isSelected();
        });
        panel.add(showAllCheckBox);
        JButton saveButton = new JButton();
        saveButton.setText("<html>Save this<br />objR MCS</html>");
        saveButton.setBounds(posX, posY + 25, 110, 32);
        saveButton.setMargin(new Insets(0, 0, 0, 0));
        saveButton.setIcon(Tools.getResIcon22("/icons/mcsWindow/saveMCS.png"));
        saveButton.addActionListener(actionEvent -> {
            int selected = this.transitionsResultsCombo.getSelectedIndex();
            if (selected == 0) {
                return;
            }
            String name = (String)this.transitionsResultsCombo.getSelectedItem();
            MCSoperations.saveSingleMCS(GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMCSdataCore(), --selected, name);
        });
        saveButton.setFocusPainted(false);
        panel.add(saveButton);
        JButton showMCSButton = new JButton();
        showMCSButton.setText("Show MCS");
        showMCSButton.setBounds(posX + 120, posY + 25, 110, 32);
        showMCSButton.setMargin(new Insets(0, 0, 0, 0));
        showMCSButton.setIcon(Tools.getResIcon22("/icons/mcsWindow/showData.png"));
        showMCSButton.addActionListener(actionEvent -> {
            int selected = this.transitionsResultsCombo.getSelectedIndex();
            if (selected > 0) {
                this.showMCSData(selected - 1);
            }
        });
        showMCSButton.setFocusPainted(false);
        panel.add(showMCSButton);
        JButton calculateFragilityButton = new JButton();
        calculateFragilityButton.setText("Fragility");
        calculateFragilityButton.setBounds(posX + 240, posY + 25, 110, 32);
        calculateFragilityButton.setMargin(new Insets(0, 0, 0, 0));
        calculateFragilityButton.setIcon(Tools.getResIcon22("/icons/mcsWindow/fragility.png"));
        calculateFragilityButton.addActionListener(actionEvent -> {
            int selected = this.transitionsResultsCombo.getSelectedIndex();
            if (selected > 0) {
                this.calculateFragility(selected - 1);
            }
        });
        calculateFragilityButton.setFocusPainted(false);
        panel.add(calculateFragilityButton);
        return panel;
    }

    protected void launchMCSanalysis() {
        if (this.isMCSGeneratorWorking) {
            JOptionPane.showMessageDialog(null, "MCS calculation already in progress.", "MCS generator working", 2);
        } else {
            ArrayList<Transition> transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
            if (transitions == null || transitions.size() < 2) {
                JOptionPane.showMessageDialog(null, "Not enough transitions in net. Operation cannot start.", "Warning", 1);
                return;
            }
            ArrayList<ArrayList<Integer>> invariants = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix();
            if (invariants == null || invariants.size() < 1) {
                JOptionPane.showMessageDialog(null, "Invariants matrix empty! Operation cannot start.", "Warning", 1);
                return;
            }
            int selectionObjR = this.transitionsCombo.getSelectedIndex();
            if (selectionObjR == 0) {
                JOptionPane.showMessageDialog(null, "Please select objective reaction (objR).", "Warning", 1);
                return;
            }
            --selectionObjR;
            int minCutSize = (Integer)this.mcsSpinner.getValue();
            if (minCutSize == 0) {
                JOptionPane.showMessageDialog(null, "MCSs maximal cardinality too low!", "Warning", 1);
                return;
            }
            int MCSdatacoreSize = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMCSdataCore().getSize();
            if (transitions.size() != MCSdatacoreSize) {
                if (MCSdatacoreSize == 0) {
                    GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMCSdataCore().initiateMCS();
                } else {
                    Object[] options = new Object[]{"Yes", "No"};
                    int decision = JOptionPane.showOptionDialog(null, "MCS list detected with different size than current cardinality of the transition set.\nClean old MCS list?", "Net change detected", 0, 2, null, options, options[1]);
                    if (decision == 1) {
                        return;
                    }
                    GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMCSdataCore().initiateMCS();
                }
            }
            this.mcsGenerator = new MCSCalculator(selectionObjR, invariants, transitions, minCutSize, this.maxSetsNumber, this, true);
            Thread myThread = new Thread(this.mcsGenerator);
            this.setGeneratorStatus(true);
            myThread.start();
        }
    }

    protected void calculateAllAction() {
        ArrayList<Integer> objReactions = new ArrayList<Integer>();
        if (this.generateAll) {
            int transSize = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().size();
            for (int t = 0; t < transSize; ++t) {
                objReactions.add(t);
            }
        } else {
            String[] splittedSets;
            String all = this.reactionSetsTextField.getText();
            if (all.length() > 0 && (splittedSets = (all = all.trim()).split(",")).length > 0) {
                for (String s : splittedSets) {
                    try {
                        s = s.replace("t", "");
                        int next = Integer.parseInt(s);
                        objReactions.add(next);
                    }
                    catch (Exception ex) {
                        GUIManager.getDefaultGUIManager().log("Error (457849198) | Exception:  " + ex.getMessage(), "error", true);
                    }
                }
            }
        }
        this.launchMCSanalysis(objReactions);
    }

    protected void launchMCSanalysis(ArrayList<Integer> objReactions) {
        if (objReactions.size() == 0) {
            return;
        }
        if (this.isMCSGeneratorWorking) {
            JOptionPane.showMessageDialog(null, "MCS calculation already in progress.", "MCS generator working", 2);
        } else {
            ArrayList<Transition> transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
            if (transitions == null || transitions.size() < 2) {
                JOptionPane.showMessageDialog(null, "Not enough transitions in net. Operation cannot start.", "Warning", 1);
                return;
            }
            ArrayList<ArrayList<Integer>> invariants = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix();
            if (invariants == null || invariants.size() < 1) {
                JOptionPane.showMessageDialog(null, "Invariants matrix empty! Operation cannot start.", "Warning", 1);
                return;
            }
            int minCutSize = (Integer)this.mcsSpinner.getValue();
            if (minCutSize == 0) {
                JOptionPane.showMessageDialog(null, "MCSs maximal cardinality too low!", "Warning", 1);
                return;
            }
            int MCSdatacoreSize = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMCSdataCore().getSize();
            if (transitions.size() != MCSdatacoreSize) {
                if (MCSdatacoreSize == 0) {
                    GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMCSdataCore().initiateMCS();
                } else {
                    Object[] options = new Object[]{"Yes", "No"};
                    int decision = JOptionPane.showOptionDialog(null, "MCS list detected with different size than current cardinality of the transition set.\nClean old MCS list?", "Net change detected", 0, 2, null, options, options[1]);
                    if (decision == 1) {
                        return;
                    }
                    GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMCSdataCore().initiateMCS();
                }
            }
            for (int el : objReactions) {
                while (this.getGeneratorStatus()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.logField.append("Starting calculations for reaction: " + el + "\n");
                this.mcsGenerator = new MCSCalculator(el, invariants, transitions, minCutSize, this.maxSetsNumber, this, false);
                Thread myThread = new Thread(this.mcsGenerator);
                this.setGeneratorStatus(true);
                myThread.start();
            }
        }
    }

    protected void showMCSData(int selected) {
        MCSDataMatrix mcsd = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMCSdataCore();
        if (mcsd.getSize() == 0) {
            return;
        }
        ArrayList<ArrayList<Integer>> dataVector = mcsd.getMCSlist(selected);
        if (dataVector == null) {
            return;
        }
        Transition objR = this.transitions.get(selected);
        this.logField.append("==========================================================\n");
        this.logField.append("Transition/objR: " + objR.getName() + "\n");
        this.logField.append("Minimal Cuttin Sets list size: " + dataVector.size() + "\n");
        int counter = 0;
        for (ArrayList<Integer> set : dataVector) {
            this.logField.append("MSC#" + counter + " ");
            StringBuilder msg = new StringBuilder("[");
            for (int el : set) {
                msg.append(el).append(", ");
            }
            msg.append("]   : ");
            msg = new StringBuilder(msg.toString().replace(", ]", "]"));
            if (this.showFullInfo) {
                int transSize = this.transitions.size();
                StringBuilder names = new StringBuilder();
                for (int el : set) {
                    if (el >= transSize) continue;
                    names.append("t").append(el).append("_").append(this.transitions.get(el).getName()).append("; ");
                }
                msg.append((CharSequence)names);
            }
            this.logField.append(msg + "\n");
            ++counter;
        }
        this.logField.append("==========================================================\n");
        this.logField.append("\n");
    }

    protected void calculateFragility(int selected) {
        Iterator<Object> iterator;
        MCSDataMatrix mcsd = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMCSdataCore();
        if (mcsd.getSize() == 0) {
            return;
        }
        ArrayList<ArrayList<Integer>> dataVector = mcsd.getMCSlist(selected);
        if (dataVector == null) {
            return;
        }
        ArrayList<Integer> reactions = new ArrayList<Integer>();
        ArrayList<Float> fi = new ArrayList<Float>();
        for (ArrayList<Integer> set : dataVector) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                int el = (Integer)iterator.next();
                if (reactions.contains(el)) continue;
                reactions.add(el);
            }
        }
        Collections.sort(reactions);
        iterator = reactions.iterator();
        while (iterator.hasNext()) {
            int reaction = (Integer)iterator.next();
            float reactSum = 0.0f;
            float setSizeSum = 0.0f;
            for (ArrayList<Integer> set : dataVector) {
                if (!set.contains(reaction)) continue;
                reactSum += 1.0f;
                setSizeSum += (float)set.size();
            }
            fi.add(Float.valueOf(reactSum / setSizeSum));
        }
        for (int i = 0; i < fi.size(); ++i) {
            Object msg = "";
            msg = (String)msg + "t" + reactions.get(i) + "_";
            msg = (String)msg + this.transitions.get((Integer)reactions.get(i)).getName() + "    ";
            msg = (String)msg + "fragility = " + fi.get(i);
            this.logField.append((String)msg + "\n");
        }
    }

    public void setGeneratorStatus(boolean status) {
        this.isMCSGeneratorWorking = status;
    }

    public boolean getGeneratorStatus() {
        return this.isMCSGeneratorWorking;
    }

    protected void fillComboBoxData() {
        this.transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
        int selection = this.transitionsCombo.getSelectedIndex();
        this.transitionsCombo.removeAllItems();
        this.transitionsCombo.addItem("---");
        for (int t = 0; t < this.transitions.size(); ++t) {
            this.transitionsCombo.addItem("t" + t + "." + this.transitions.get(t).getName());
        }
        this.listenerAllowed = false;
        int oldSize = this.transitionsResultsCombo.getItemCount();
        int oldSelected = this.transitionsResultsCombo.getSelectedIndex();
        this.transitionsResultsCombo.removeAllItems();
        this.transitionsResultsCombo.addItem("---");
        for (int t = 0; t < this.transitions.size(); ++t) {
            this.transitionsResultsCombo.addItem("t" + t + "." + this.transitions.get(t).getName());
        }
        if (oldSize == this.transitionsResultsCombo.getItemCount()) {
            this.transitionsResultsCombo.setSelectedIndex(oldSelected);
        }
        this.listenerAllowed = true;
        if (selection < this.transitions.size() + 1) {
            this.transitionsCombo.setSelectedIndex(selection);
        }
        if (this.transitions != null && this.transitions.size() > 1) {
            if (this.maxCutSize >= this.transitions.size()) {
                this.maxCutSize = 2;
            }
            this.maximumMCS = this.transitions.size();
        } else {
            this.maxCutSize = 0;
            this.maximumMCS = 0;
        }
        SpinnerNumberModel mcsSpinnerModel = new SpinnerNumberModel(this.maxCutSize, 0, this.maximumMCS, 1);
        this.mcsSpinner.setModel(mcsSpinnerModel);
    }

    public JTextArea accessLogField() {
        return this.logField;
    }

    public void resetMCSGenerator() {
        this.mcsGenerator = null;
        this.setGeneratorStatus(false);
    }
}

