/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.analyse.InvariantsTools;
import holmes.analyse.MCTCalculator;
import holmes.darkgui.GUIManager;
import holmes.graphpanel.MauritiusMapPanel;
import holmes.petrinet.data.MauritiusMap;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Transition;
import holmes.utilities.HolmesFileView;
import holmes.utilities.Tools;
import holmes.windows.HolmesNotepad;
import holmes.workspace.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileFilter;

public class HolmesKnockout
extends JFrame {
    private static final long serialVersionUID = -9038958824842964847L;
    private JComboBox<String> transitionsCombo;
    private MauritiusMapPanel mmp;
    private int intX = 0;
    private int intY = 0;
    private JPanel mainPanel;
    private JPanel buttonPanel;
    private JPanel logMainPanel;
    private JScrollPane scroller;
    private MauritiusMap mmCurrentObject;
    private ArrayList<Integer> disabledSetByObjR = null;
    private ArrayList<Integer> commonSetToObjR = null;
    private int currentTreshold = 100;
    private boolean contractedMode = true;
    private int globalMode = 0;

    public HolmesKnockout() {
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (629849961) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.setVisible(false);
        this.setTitle("Knockout analysis");
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(900, 750));
        this.setLocation(15, 15);
        this.mainPanel = this.createMainPanel();
        this.add((Component)this.mainPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                HolmesKnockout.this.fillComboBoxData();
            }
        });
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.buttonPanel = this.createUpperButtonPanel(0, 0, 900, 130);
        this.logMainPanel = this.createGraphPanel(0, 130, 900, 600);
        panel.add((Component)this.buttonPanel, "North");
        panel.add((Component)this.logMainPanel, "Center");
        panel.repaint();
        return panel;
    }

    private JPanel createUpperButtonPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder("Search options"));
        panel.setLocation(x, y);
        panel.setPreferredSize(new Dimension(width, height));
        int posX = 10;
        int posY = 20;
        JLabel mcsLabel1 = new JLabel("Obj. reaction:");
        mcsLabel1.setBounds(posX, posY, 80, 20);
        panel.add(mcsLabel1);
        String[] dataT = new String[]{"---"};
        ArrayList<Transition> transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
        this.transitionsCombo = new JComboBox<String>(dataT);
        this.transitionsCombo.setBounds(posX + 90, posY, 400, 20);
        this.transitionsCombo.setSelectedIndex(0);
        this.transitionsCombo.setMaximumRowCount(6);
        this.transitionsCombo.removeAllItems();
        this.transitionsCombo.addItem("---");
        if (transitions != null && transitions.size() > 0) {
            for (int t = 0; t < transitions.size(); ++t) {
                this.transitionsCombo.addItem("t" + t + "." + transitions.get(t).getName());
            }
        }
        panel.add(this.transitionsCombo);
        SpinnerNumberModel tokenSpinnerModel = new SpinnerNumberModel(this.currentTreshold, 0, 100, 1);
        JSpinner tokenSpinner = new JSpinner(tokenSpinnerModel);
        tokenSpinner.setBounds(posX + 620, posY, 70, 20);
        tokenSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.currentTreshold = (Integer)spinner.getValue();
        });
        panel.add(tokenSpinner);
        JComboBox<String> modeCombo = new JComboBox<String>(dataT);
        modeCombo.setBounds(posX + 560, posY + 20, 270, 20);
        modeCombo.setSelectedIndex(0);
        modeCombo.setMaximumRowCount(6);
        modeCombo.removeAllItems();
        modeCombo.addItem("Show tree for ramaining transitions");
        modeCombo.addItem("Show tree for knocked transitions");
        modeCombo.addItem("Show tree for knocked transitions (threshold)");
        modeCombo.addActionListener(actionEvent -> {
            int selected = modeCombo.getSelectedIndex();
            this.globalMode = selected == 0 ? 0 : (selected == 1 ? 1 : (selected == 2 ? 2 : 1));
        });
        panel.add(modeCombo);
        JCheckBox contractedModeBox = new JCheckBox("Contracted");
        contractedModeBox.setBounds(posX + 690, posY, 90, 20);
        contractedModeBox.setSelected(true);
        contractedModeBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.contractedMode = abstractButton.getModel().isSelected();
        });
        panel.add(contractedModeBox);
        JButton generateButton = new JButton("<html>&nbsp;Generate</html>");
        generateButton.setBounds(posX, posY + 25, 120, 36);
        generateButton.setMargin(new Insets(0, 0, 0, 0));
        generateButton.setIcon(Tools.getResIcon32("/icons/knockoutWindow/computeData.png"));
        generateButton.setToolTipText("Generate knockout map for the currently selected transition.");
        generateButton.addActionListener(actionEvent -> {
            this.mmCurrentObject = this.generateMap(this.globalMode);
            if (this.mmCurrentObject != null) {
                this.paintMap();
            }
        });
        generateButton.setFocusPainted(false);
        panel.add(generateButton);
        JButton showKnockoutButton = new JButton("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Show<br>&nbsp;&nbsp;notepad</html>");
        showKnockoutButton.setBounds(posX, posY + 65, 120, 36);
        showKnockoutButton.setMargin(new Insets(0, 0, 0, 0));
        showKnockoutButton.setIcon(Tools.getResIcon32("/icons/knockoutWindow/showNotepad.png"));
        showKnockoutButton.setToolTipText("For the selected transition show knockout detailed data in the notepad.");
        showKnockoutButton.addActionListener(actionEvent -> {
            try {
                MauritiusMap infoMap = this.globalMode == 0 ? this.generateMap(1) : this.generateMap(this.globalMode);
                if (infoMap != null) {
                    HolmesNotepad notePad = new HolmesNotepad(900, 600);
                    notePad.setVisible(true);
                    this.getKnockoutInfo(infoMap, notePad);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Exception in invariants section.\n" + e.getMessage(), "Error", 0);
                GUIManager.getDefaultGUIManager().log("Error" + e.getMessage(), "error", true);
            }
            catch (Error e2) {
                JOptionPane.showMessageDialog(null, "Error in invariants section.\n" + e2.getMessage(), "Error", 0);
                GUIManager.getDefaultGUIManager().log("Error" + e2.getMessage(), "error", true);
            }
        });
        showKnockoutButton.setFocusPainted(false);
        panel.add(showKnockoutButton);
        JButton fullDataKnockoutButton = new JButton("<html>Whole net<br>knockout</html>");
        fullDataKnockoutButton.setBounds(posX + 130, posY + 25, 120, 36);
        fullDataKnockoutButton.setMargin(new Insets(0, 0, 0, 0));
        fullDataKnockoutButton.setIcon(Tools.getResIcon32("/icons/knockoutWindow/fullKnockout.png"));
        fullDataKnockoutButton.addActionListener(actionEvent -> {
            HolmesNotepad notePad = new HolmesNotepad(900, 600);
            notePad.setVisible(true);
            this.getKnockoutFullInfo(notePad);
        });
        fullDataKnockoutButton.setFocusPainted(false);
        panel.add(fullDataKnockoutButton);
        JButton toNetKnockoutButton = new JButton("<html>&nbsp;&nbsp;&nbsp;&nbsp;Color&nbsp;&nbsp;&nbsp;<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;net&nbsp;&nbsp;&nbsp;</html>");
        toNetKnockoutButton.setBounds(posX + 130, posY + 65, 120, 36);
        toNetKnockoutButton.setMargin(new Insets(0, 0, 0, 0));
        toNetKnockoutButton.setIcon(Tools.getResIcon32("/icons/knockoutWindow/sendToNet.png"));
        toNetKnockoutButton.addActionListener(actionEvent -> {
            MauritiusMap infoMap = this.generateMap(this.globalMode);
            if (infoMap != null) {
                this.getKnockoutInfoToNet(infoMap);
            }
        });
        toNetKnockoutButton.setFocusPainted(false);
        panel.add(toNetKnockoutButton);
        JButton monaLisaButton = new JButton("<html>Load Mona<br>Lisa data</html>");
        monaLisaButton.setBounds(posX + 260, posY + 25, 120, 36);
        monaLisaButton.setMargin(new Insets(0, 0, 0, 0));
        monaLisaButton.setIcon(Tools.getResIcon32("/icons/knockoutWindow/monaLisa.png"));
        monaLisaButton.addActionListener(actionEvent -> {
            HolmesNotepad notePad = new HolmesNotepad(900, 600);
            notePad.setVisible(true);
            this.showMonaLisaResults(notePad);
        });
        monaLisaButton.setFocusPainted(false);
        panel.add(monaLisaButton);
        JButton monaLisaToNetButton = new JButton("<html>&nbsp;&nbsp;Mona Lisa<br>-> Color net</html>");
        monaLisaToNetButton.setBounds(posX + 260, posY + 65, 120, 36);
        monaLisaToNetButton.setMargin(new Insets(0, 0, 0, 0));
        monaLisaToNetButton.setIcon(Tools.getResIcon32("/icons/knockoutWindow/monaLisa.png"));
        monaLisaToNetButton.addActionListener(actionEvent -> this.exportMonaLisaToNet());
        monaLisaToNetButton.setFocusPainted(false);
        panel.add(monaLisaToNetButton);
        JButton saveImgButton = new JButton("<html>&nbsp;Save image</html>");
        saveImgButton.setBounds(posX + 390, posY + 25, 120, 36);
        saveImgButton.setMargin(new Insets(0, 0, 0, 0));
        saveImgButton.setIcon(Tools.getResIcon32("/icons/knockoutWindow/saveImage.png"));
        saveImgButton.addActionListener(actionEvent -> this.exportToPicture());
        saveImgButton.setFocusPainted(false);
        panel.add(saveImgButton);
        JButton expInvKnockButton = new JButton("<html>Inv. knockout</html>");
        expInvKnockButton.setBounds(posX + 390, posY + 65, 120, 36);
        expInvKnockButton.setMargin(new Insets(0, 0, 0, 0));
        expInvKnockButton.setIcon(Tools.getResIcon32("/icons/knockoutWindow/saaaamage.png"));
        expInvKnockButton.addActionListener(actionEvent -> this.invData());
        expInvKnockButton.setFocusPainted(false);
        panel.add(expInvKnockButton);
        JCheckBox shortTextCheckBox = new JCheckBox("Show full names");
        shortTextCheckBox.setBounds(posX + 490, posY, 130, 20);
        shortTextCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.mmp.setFullName(abstractButton.getModel().isSelected());
            this.mmp.repaint();
        });
        shortTextCheckBox.setSelected(true);
        panel.add(shortTextCheckBox);
        return panel;
    }

    protected void invData() {
    }

    private JPanel createGraphPanel(int x, int y, int width, int height) {
        JPanel gr_panel = new JPanel(new BorderLayout());
        gr_panel.setLocation(x, y);
        gr_panel.setPreferredSize(new Dimension(width, height));
        this.mmp = new MauritiusMapPanel(this);
        this.intX = width - 10;
        this.intY = height - 25;
        this.scroller = new JScrollPane(this.mmp, 22, 32);
        gr_panel.add((Component)this.scroller, "Center");
        return gr_panel;
    }

    protected void getKnockoutInfo(MauritiusMap infoMap, HolmesNotepad notePad) {
        ArrayList<ArrayList<Integer>> dataMatrix = this.collectMapData(infoMap);
        if (dataMatrix.get(0).contains(-1)) {
            dataMatrix.get(0).remove(dataMatrix.get(0).indexOf(-1));
        }
        if (dataMatrix.get(1).contains(-1)) {
            dataMatrix.get(1).remove(dataMatrix.get(1).indexOf(-1));
        }
        ArrayList<Transition> transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
        try {
            notePad.addTextLineNL("Objective reaction (knock-out reaction): " + infoMap.getRoot().transName, "text");
            notePad.addTextLineNL("", "text");
            if (dataMatrix.get(0).size() == 0) {
                notePad.addTextLine("Reactions knocked out: ", "text");
                notePad.addTextLineNL(" 0  (zero, all transitions present in some unaffected t-invariants).", "text");
            } else {
                notePad.addTextLineNL("Reactions knocked out: ", "text");
                Collections.sort((List)dataMatrix.get(0));
                for (int element : dataMatrix.get(0)) {
                    notePad.addTextLineNL("[t_" + element + "] : " + transitions.get(element).getName(), "text");
                }
            }
            notePad.addTextLineNL("", "text");
            notePad.addTextLineNL("Common-group (e.g., MCT set) reactions: ", "text");
            Collections.sort((List)dataMatrix.get(1));
            for (int element : dataMatrix.get(1)) {
                notePad.addTextLineNL("[t_" + element + "] : " + transitions.get(element).getName(), "text");
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error in transition section.\n" + e.getMessage(), "Error", 0);
            GUIManager.getDefaultGUIManager().log("Error" + e.getMessage(), "error", true);
        }
        try {
            int rootTransition = this.transitionsCombo.getSelectedIndex() - 1;
            ArrayList<ArrayList<Integer>> invariants = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix();
            ArrayList<Integer> invIndices = InvariantsTools.returnInvIndicesWithTransition(invariants, rootTransition);
            notePad.addTextLineNL("", "text");
            notePad.addTextLineNL("t-invariants unaffected by knockout: " + (invariants.size() - invIndices.size()), "text");
            notePad.addTextLineNL("t-invariants disabled: " + invIndices.size(), "text");
            String name = transitions.get(rootTransition).getName();
            notePad.addTextLineNL("t-ivariants (" + invIndices.size() + ") with transition t_" + rootTransition + "_" + name + " (disabled t-inv.):", "text");
            notePad.addTextLineNL("", "text");
            for (int element : invIndices) {
                notePad.addTextLine("i_" + element + " , ", "text");
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error in invariants section.\n" + e.getMessage(), "Error", 0);
            GUIManager.getDefaultGUIManager().log("Error" + e.getMessage(), "error", true);
        }
        notePad.setCaretFirstLine();
    }

    protected void getKnockoutFullInfo(HolmesNotepad notePad) {
        int t;
        ArrayList<ArrayList<Integer>> invariants = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix();
        if (invariants == null || invariants.size() < 1) {
            JOptionPane.showMessageDialog(null, "Invariants matrix empty! Operation cannot start.", "Warning", 1);
            return;
        }
        ArrayList<Transition> transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
        int transNumber = transitions.size();
        ArrayList<Integer> transFailDependency = new ArrayList<Integer>();
        ArrayList<Integer> transCommonSetSize = new ArrayList<Integer>();
        int mode = 1;
        if (this.globalMode != 0) {
            mode = this.globalMode;
        }
        for (t = 0; t < transNumber; ++t) {
            MauritiusMap mm = new MauritiusMap(invariants, t, this.currentTreshold, mode);
            ArrayList<ArrayList<Integer>> dataMatrix = this.collectMapData(mm);
            transFailDependency.add(dataMatrix.get(0).size());
            transCommonSetSize.add(dataMatrix.get(1).size());
        }
        notePad.addTextLineNL("Data collected for " + transNumber + " transitions.", "text");
        notePad.addTextLineNL("", "text");
        for (t = 0; t < transNumber; ++t) {
            notePad.addTextLine("[t_" + t + "]|" + transitions.get(t).getName() + ":", "text");
            int kn = (Integer)transFailDependency.get(t) + (Integer)transCommonSetSize.get(t) - 1;
            notePad.addTextLineNL("| Knocked-out: " + kn + "| Common: " + transCommonSetSize.get(t), "text");
        }
    }

    private void exportMonaLisaToNet() {
        FileFilter[] filters;
        String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
        String selectedFile = Tools.selectFileDialog(lastPath, filters = new FileFilter[]{new ExtensionFileFilter("MonaLisa Knockout transitions (.txt)", new String[]{"TXT"})}, "Load", "", "");
        if (selectedFile.equals("")) {
            JOptionPane.showMessageDialog(null, "Incorrect file location.", "Operation failed.", 0);
            return;
        }
        ArrayList<Transition> transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
        int transSize = transitions.size();
        ArrayList<ArrayList<Integer>> knockoutMatrix = new ArrayList<ArrayList<Integer>>();
        for (int i = 0; i < transSize; ++i) {
            knockoutMatrix.add(new ArrayList());
        }
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(selectedFile));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String line = buffer.readLine();
            line = buffer.readLine();
            while (line != null && line.length() > 4) {
                int tmp = line.indexOf(" ");
                String name = line.substring(0, tmp);
                for (int t = 0; t < transSize; ++t) {
                    if (!transitions.get(t).getName().equals(name)) continue;
                    String next = line.substring(line.indexOf("->") + 2);
                    if (next.length() == 0) break;
                    next = next.trim();
                    String[] elements = next.split(";");
                    ArrayList<Integer> knockoutVector = new ArrayList<Integer>();
                    block5: for (String tr : elements) {
                        for (int t2 = 0; t2 < transSize; ++t2) {
                            if (!transitions.get(t2).getName().equals(tr)) continue;
                            knockoutVector.add(t2);
                            continue block5;
                        }
                    }
                    knockoutMatrix.set(t, knockoutVector);
                    break;
                }
                line = buffer.readLine();
            }
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (526939437) | Exception:  " + ex.getMessage(), "error", true);
        }
        GUIManager.getDefaultGUIManager().showKnockout(knockoutMatrix);
    }

    /*
     * WARNING - void declaration
     */
    private void showMonaLisaResults(HolmesNotepad notePad) {
        void var18_44;
        FileFilter[] filters;
        String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
        String selectedFile = Tools.selectFileDialog(lastPath, filters = new FileFilter[]{new ExtensionFileFilter("MonaLisa Knockout transitions (.txt)", new String[]{"TXT"})}, "Load", "", "");
        if (selectedFile.equals("")) {
            JOptionPane.showMessageDialog(null, "Incorrect file location.", "Operation failed.", 0);
            return;
        }
        MCTCalculator analyzer = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMCTanalyzer();
        ArrayList<ArrayList<Transition>> mct = analyzer.generateMCT();
        mct = MCTCalculator.getSortedMCT(mct, false);
        ArrayList<Transition> transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
        int transSize = transitions.size();
        ArrayList<Object> resultLines = new ArrayList<Object>();
        ArrayList<Object> mctOrNot = new ArrayList<Object>();
        ArrayList<Integer> mctSize = new ArrayList<Integer>();
        for (int i = 0; i < transSize; ++i) {
            resultLines.add("");
            mctOrNot.add("");
            mctSize.add(0);
        }
        int mctNo = 0;
        for (ArrayList<Transition> arr : mct) {
            ++mctNo;
            for (Transition t : arr) {
                int id = transitions.indexOf(t);
                mctOrNot.set(id, "MCT_" + mctNo);
                mctSize.set(id, arr.size());
            }
        }
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(selectedFile));
            BufferedReader buffer = new BufferedReader(new InputStreamReader(in));
            String line = buffer.readLine();
            line = buffer.readLine();
            while (line != null && line.length() > 4) {
                int tmp = line.indexOf(" ");
                String name = line.substring(0, tmp);
                for (int i = 0; i < transSize; ++i) {
                    if (!transitions.get(i).getName().equals(name)) continue;
                    String next = line.substring(line.indexOf("->") + 2);
                    if (next.length() == 0) {
                        String newLine = "t" + i + "_" + name + " | Knockout: 0% (0 / " + transSize + ")  ";
                        newLine = newLine + (String)mctOrNot.get(i);
                        resultLines.set(i, newLine);
                        break;
                    }
                    String[] elements = next.split(";");
                    float knockoutPercent = (float)elements.length / (float)transSize;
                    String newLine = "t" + i + "_" + name + " | Knockout: " + String.format("%.2f", Float.valueOf(knockoutPercent *= 100.0f)) + "% (" + elements.length + "/" + transSize + ")  ";
                    newLine = newLine + (String)mctOrNot.get(i);
                    resultLines.set(i, newLine);
                    break;
                }
                line = buffer.readLine();
            }
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (424094127) | Exception:  " + ex.getMessage(), "error", true);
        }
        notePad.addTextLineNL("", "text");
        for (int t = 0; t < transSize; ++t) {
            notePad.addTextLineNL((String)resultLines.get(t), "text");
        }
        notePad.addTextLineNL("", "text");
        notePad.addTextLineNL("", "text");
        ArrayList<CallSite> mctTmpVector = new ArrayList<CallSite>();
        for (int m = 0; m < mct.size(); ++m) {
            mctTmpVector.add((CallSite)((Object)("MCT_" + (m + 1))));
        }
        ArrayList<Integer> transInInvVector = InvariantsTools.transInT_invariants();
        int invNumber = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix().size();
        ArrayList<Object> secondResultLines = new ArrayList<Object>();
        for (int t = 0; t < transSize; ++t) {
            String transPercent;
            if (((String)resultLines.get(t)).contains(" MCT_")) {
                String string = (String)resultLines.get(t);
                String mctName = string.substring(string.indexOf("MCT_"));
                if (!mctTmpVector.contains(mctName)) continue;
                mctTmpVector.remove(mctName);
                String string2 = string.substring(1);
                float invPercent = -1.0f;
                String id = string2.substring(0, string2.indexOf("_"));
                try {
                    int ident = Integer.parseInt(id);
                    invPercent = (float)transInInvVector.get(ident).intValue() / (float)invNumber;
                    invPercent *= 100.0f;
                }
                catch (Exception ex) {
                    GUIManager.getDefaultGUIManager().log("Error (930795539) | Exception:  " + ex.getMessage(), "error", true);
                }
                String string4 = string2.substring(string2.indexOf("_") + 1);
                string4 = string4.substring(string4.indexOf(":") + 2);
                transPercent = string4.substring(0, string4.indexOf("%") + 1);
                secondResultLines.add(mctName + "   " + transPercent + "  " + String.format("%.2f", Float.valueOf(invPercent)) + "%");
                continue;
            }
            String string5 = (String)resultLines.get(t);
            string5 = string5.substring(1);
            float invPercent = -1.0f;
            String id = string5.substring(0, string5.indexOf("_"));
            try {
                int ident = Integer.parseInt(id);
                invPercent = (float)transInInvVector.get(ident).intValue() / (float)invNumber;
                invPercent *= 100.0f;
            }
            catch (Exception ex) {
                GUIManager.getDefaultGUIManager().log("Error (495583551) | Exception:  " + ex.getMessage(), "error", true);
            }
            String string6 = string5.substring(string5.indexOf("_") + 1);
            String name = string6.substring(0, string6.indexOf("|") - 1);
            String string7 = string6.substring(string6.indexOf(":") + 2);
            transPercent = string7.substring(0, string7.indexOf("%") + 1);
            secondResultLines.add("t" + id + "&_" + name + "   " + transPercent + "  " + String.format("%.2f", Float.valueOf(invPercent)) + "%");
        }
        for (String string : secondResultLines) {
            notePad.addTextLineNL(string, "text");
        }
        int linesNumber = secondResultLines.size();
        boolean bl = false;
        while (var18_44 < linesNumber && var18_44 < linesNumber - 1) {
            String line = (String)secondResultLines.get((int)var18_44);
            line = line.substring(line.indexOf(" "));
            line = line.trim();
            line = line.substring(line.indexOf(" "));
            line = line.trim();
            line = line.substring(0, line.length() - 1);
            line = line.replace(",", ".");
            int nextMax = -1;
            try {
                float value = Float.parseFloat(line);
                for (void j = var18_44 + true; j < linesNumber; ++j) {
                    String line2 = (String)secondResultLines.get((int)j);
                    line2 = line2.substring(line2.indexOf(" "));
                    line2 = line2.trim();
                    line2 = line2.substring(line2.indexOf(" "));
                    line2 = line2.trim();
                    line2 = line2.substring(0, line2.length() - 1);
                    float value2 = Float.parseFloat(line2 = line2.replace(",", "."));
                    if (!(value2 > value)) continue;
                    nextMax = j;
                    value = value2;
                }
                if (nextMax != -1) {
                    String tmpLine = (String)secondResultLines.get((int)var18_44);
                    String maxLine = (String)secondResultLines.get(nextMax);
                    secondResultLines.set((int)var18_44, maxLine);
                    secondResultLines.set(nextMax, tmpLine);
                }
            }
            catch (Exception ex) {
                GUIManager.getDefaultGUIManager().log("Error (269968675) | Exception:  " + ex.getMessage(), "error", true);
            }
            ++var18_44;
        }
        notePad.addTextLineNL("", "text");
        notePad.addTextLineNL("", "text");
        notePad.addTextLineNL("{\\footnotesize", "text");
        notePad.addTextLineNL("\\begin{longtable}{| p{2.1cm} | p{8.2cm} | p{1.9cm} | p{1.9cm} |}", "text");
        notePad.addTextLineNL("\\caption{The impact of knockout of net elements depending on affected transitions} ", "text");
        notePad.addTextLineNL("\\label{tab:knockout} \\\\", "text");
        notePad.addTextLineNL("\\hline ", "text");
        notePad.addTextLineNL("\\bf MCT-set & \\bf \\centering{Biological function}  & \\bf Affected & \\bf Affected\t\\\\", "text");
        notePad.addTextLineNL("\\bf / transition & \\bf  & \\bf transition & \\bf invariants \\\\  \\hline ", "text");
        for (Object line2 : secondResultLines) {
            line2 = ((String)line2).contains("MCT") ? ((String)line2).replace("   ", " & & ") : ((String)line2).replace("   ", " & ");
            line2 = ((String)line2).replace("%  ", "% & ");
            line2 = (String)line2 + "  \\\\ \\hline  ";
            line2 = ((String)line2).replace("%", "\\%");
            line2 = ((String)line2).replace("_", " ");
            notePad.addTextLineNL((String)line2, "text");
        }
        notePad.addTextLineNL("\\end{longtable}", "text");
        notePad.addTextLineNL("}", "text");
    }

    protected void getKnockoutInfoToNet(MauritiusMap infoMap) {
        ArrayList<ArrayList<Integer>> dataMatrix = this.collectMapData(infoMap);
        PetriNet pn = GUIManager.getDefaultGUIManager().getWorkspace().getProject();
        try {
            Transition trans_TMP;
            pn.resetNetColors();
            ArrayList<Transition> transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
            for (int id : dataMatrix.get(0)) {
                trans_TMP = transitions.get(id);
                trans_TMP.drawGraphBoxT.setColorWithNumber(true, Color.black, false, -1.0, false, "");
            }
            for (int id : dataMatrix.get(1)) {
                trans_TMP = transitions.get(id);
                trans_TMP.drawGraphBoxT.setColorWithNumber(true, Color.blue, false, -1.0, false, "");
            }
            int rootID = infoMap.getRoot().transLocation;
            trans_TMP = transitions.get(rootID);
            trans_TMP.drawGraphBoxT.setColorWithNumber(true, Color.red, false, -1.0, false, "");
            GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (187924584) | Exception:  " + ex.getMessage(), "error", true);
        }
    }

    private ArrayList<ArrayList<Integer>> collectMapData(MauritiusMap infoMap) {
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        int noteValue = infoMap.getRoot().transFrequency;
        this.disabledSetByObjR = new ArrayList();
        this.commonSetToObjR = new ArrayList();
        this.collectInfo(infoMap.getRoot(), noteValue);
        result.add(new ArrayList<Integer>(this.disabledSetByObjR));
        result.add(new ArrayList<Integer>(this.commonSetToObjR));
        return result;
    }

    private void collectInfo(MauritiusMap.BTNode node, int startSetValue) {
        int freq = node.transFrequency;
        int transID = node.transLocation;
        if (freq == startSetValue) {
            if (!this.commonSetToObjR.contains(transID)) {
                this.commonSetToObjR.add(transID);
            }
        } else if (!this.disabledSetByObjR.contains(transID)) {
            this.disabledSetByObjR.add(transID);
        }
        if (node.rightChild != null) {
            this.collectInfo(node.rightChild, startSetValue);
        }
        if (node.leftChild != null) {
            this.collectInfo(node.leftChild, startSetValue);
        }
    }

    private MauritiusMap generateMap(int mode) {
        MauritiusMap mm;
        int selection = this.transitionsCombo.getSelectedIndex();
        if (selection == 0) {
            JOptionPane.showMessageDialog(null, "Please choose main reaction for Mauritius Map.", "No selection", 1);
            return null;
        }
        --selection;
        ArrayList<ArrayList<Integer>> invariants = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix();
        if (invariants == null || invariants.size() < 1) {
            JOptionPane.showMessageDialog(null, "Invariants matrix empty! Operation cannot start.", "Warning", 1);
            return null;
        }
        try {
            mm = new MauritiusMap(invariants, selection, this.currentTreshold, mode);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Mauritius Map creation failed.", "Error", 1);
            mm = null;
        }
        return mm;
    }

    private void paintMap() {
        this.mmp.registerNewMap(this.mmCurrentObject, this.contractedMode);
        this.mmp.repaint();
    }

    public BufferedImage getImageFromPanel() {
        MauritiusMap mm = this.generateMap(this.globalMode);
        this.mmp.registerNewMap(mm, this.contractedMode);
        this.mmp.repaint();
        int w = this.mmp.getWidth();
        int h = this.mmp.getHeight();
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D g = bi.createGraphics();
        g.setColor(Color.white);
        this.mmp.paint(g);
        return bi;
    }

    private void exportToPicture() {
        String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
        JFileChooser fc = lastPath == null ? new JFileChooser() : new JFileChooser(lastPath);
        fc.setFileView(new HolmesFileView());
        ExtensionFileFilter pngFilter = new ExtensionFileFilter(".png - Portable Network Graphics", new String[]{"png"});
        ExtensionFileFilter bmpFilter = new ExtensionFileFilter(".bmp -  Bitmap Image File", new String[]{"bmp"});
        ExtensionFileFilter jpegFilter = new ExtensionFileFilter(".jpeg - JPEG Image File", new String[]{"jpeg"});
        ExtensionFileFilter jpgFilter = new ExtensionFileFilter(".jpg - JPEG Image File", new String[]{"jpg"});
        fc.setFileFilter(pngFilter);
        fc.addChoosableFileFilter(pngFilter);
        fc.addChoosableFileFilter(bmpFilter);
        fc.addChoosableFileFilter(jpegFilter);
        fc.addChoosableFileFilter(jpgFilter);
        fc.setAcceptAllFileFilterUsed(false);
        if (fc.showSaveDialog(null) == 0) {
            File file = fc.getSelectedFile();
            String ext = "";
            String extension = fc.getFileFilter().getDescription();
            if (extension.contains(".png")) {
                ext = ".png";
            }
            if (extension.contains(".bmp")) {
                ext = ".bmp";
            }
            if (extension.contains(".jpeg") || extension.contains(".jpg")) {
                ext = ".jpeg";
            }
            BufferedImage image = this.getImageFromPanel();
            try {
                String ext2 = "";
                String path = file.getPath();
                if (ext.equals(".png") && !path.contains(".png")) {
                    ext2 = ".png";
                }
                if (ext.equals(".bmp") && !file.getPath().contains(".bmp")) {
                    ext2 = ".bmp";
                }
                if (ext.equals(".jpeg") && !file.getPath().contains(".jpeg")) {
                    ext2 = ".jpeg";
                }
                if (ext.equals(".jpeg") && !file.getPath().contains(".jpg")) {
                    ext2 = ".jpg";
                }
                ImageIO.write((RenderedImage)image, ext.substring(1), new File(file.getPath() + ext2));
                GUIManager.getDefaultGUIManager().setLastPath(file.getParentFile().getPath());
            }
            catch (IOException ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(null, "Saving net sheet into picture failed.", "Export Picture Error", 0);
            }
        }
    }

    protected void resizeComponents() {
        this.buttonPanel.setBounds(0, 0, this.mainPanel.getWidth(), 90);
        this.logMainPanel.setBounds(0, 90, this.mainPanel.getWidth(), this.mainPanel.getHeight() - 90);
        this.intX = this.logMainPanel.getWidth();
        this.intY = this.logMainPanel.getHeight();
        this.scroller.setPreferredSize(new Dimension(this.intX, this.intY));
    }

    protected void fillComboBoxData() {
        ArrayList<Transition> transitions = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions();
        int selection = this.transitionsCombo.getSelectedIndex();
        this.transitionsCombo.removeAllItems();
        this.transitionsCombo.addItem("---");
        for (int t = 0; t < transitions.size(); ++t) {
            this.transitionsCombo.addItem("t" + t + "." + transitions.get(t).getName());
        }
        if (selection < transitions.size() + 1) {
            this.transitionsCombo.setSelectedIndex(selection);
        }
    }
}

