/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.analyse.InvariantsCalculator;
import holmes.analyse.InvariantsTools;
import holmes.analyse.TimeComputations;
import holmes.darkgui.GUIManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.StateSimulator;
import holmes.tables.InvariantsTableRenderer;
import holmes.tables.InvariantsViewerTableModel;
import holmes.utilities.Tools;
import holmes.windows.HolmesNodeInfo;
import holmes.windows.HolmesNotepad;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class HolmesInvariantsViewer
extends JFrame {
    private static final long serialVersionUID = 7735367902562553555L;
    private GUIManager overlord = GUIManager.getDefaultGUIManager();
    private PetriNet pn = this.overlord.getWorkspace().getProject();
    private static final DecimalFormat formatter = new DecimalFormat("#.##");
    private JComboBox<String> invCombo = null;
    private JLabel labelMinimal;
    private JLabel labelFeasible;
    private JLabel labelSub;
    private JLabel labelSur;
    private JLabel labelCanon;
    private JLabel labelPureInT;
    private JLabel labelInT;
    private JLabel labelOutT;
    private JLabel labelReadArcs;
    private JLabel labelInhibitors;
    private JTextArea descriptionTextArea;
    private JLabel labelEFT;
    private JLabel labelAVG;
    private JLabel labelLFT;
    private JLabel labelTPNtrans;
    private JLabel labelDPNtrans;
    private JLabel labelTDPNtrans;
    private JLabel labelPNtrans;
    private JTable table;
    private InvariantsTableRenderer tableRenderer;
    private JScrollPane tableScrollPane;
    private int currentSelected = 0;
    private ArrayList<ArrayList<Integer>> invariantsMatrix = this.pn.getT_InvMatrix();
    private ArrayList<Transition> transitions;
    private ArrayList<Integer> readArcTransLocations;
    private ArrayList<ArrayList<Integer>> incidenceMatrix;
    private ArrayList<ArrayList<Integer>> supportMatrix;
    private ArrayList<ArrayList<Double>> transStats;
    private boolean problem = false;
    private boolean showTransTable = true;

    public HolmesInvariantsViewer() {
        boolean problem = false;
        if (this.invariantsMatrix == null || this.invariantsMatrix.size() == 0) {
            JOptionPane.showMessageDialog(null, "No invariants found, window cannot be initialized.", "Error: no invariants", 0);
            this.dispatchEvent(new WindowEvent(this, 201));
            problem = true;
        }
        if (!problem) {
            this.currentSelected = 0;
            this.initiateVariables();
            this.initalizeComponents();
            this.initiateListeners();
            this.fillData(this.currentSelected);
            this.setVisible(true);
        }
    }

    public HolmesInvariantsViewer(int invNumber) {
        this.currentSelected = invNumber + 1;
        boolean problem = false;
        if (this.invariantsMatrix == null || this.invariantsMatrix.size() == 0) {
            JOptionPane.showMessageDialog(null, "No invariants found, window cannot initiate itself.", "Error: no ivnariants", 0);
            this.dispatchEvent(new WindowEvent(this, 201));
            problem = true;
        }
        if (!problem) {
            this.initiateVariables();
            this.initalizeComponents();
            this.initiateListeners();
            this.fillData(this.currentSelected);
            this.setVisible(true);
        }
    }

    private void initiateVariables() {
        try {
            this.transitions = this.pn.getTransitions();
            this.readArcTransLocations = InvariantsTools.getReadArcTransitionsStatic();
            InvariantsCalculator ic = new InvariantsCalculator(true);
            this.incidenceMatrix = ic.getCMatrix();
            this.supportMatrix = new ArrayList();
            for (ArrayList<Integer> matrix : this.invariantsMatrix) {
                this.supportMatrix.add(InvariantsTools.getSupport(matrix));
            }
            if (GUIManager.getDefaultGUIManager().getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
                JOptionPane.showMessageDialog(null, "Net simulator working. Unable to retrieve transitions statistics..", "Simulator working", 0);
                this.transStats = null;
                this.problem = true;
            } else {
                StateSimulator ss = new StateSimulator();
                SimulatorGlobals ownSettings = new SimulatorGlobals();
                ownSettings.setNetType(SimulatorGlobals.SimNetType.BASIC, false);
                ownSettings.setMaxMode(false);
                ownSettings.setSingleMode(false);
                ss.initiateSim(false, ownSettings);
                this.transStats = ss.simulateForInvariantTrans(1000, 20, false);
                this.problem = this.transStats == null;
            }
        }
        catch (Exception e) {
            this.overlord.log("Problems encountered while initializing variables for invariant viewer window.", "error", true);
        }
    }

    private void initalizeComponents() {
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (775450119) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(800, 650));
        this.setLocation(50, 50);
        this.setResizable(true);
        this.setTitle("Holmes Invariants Viewer");
        this.setLayout(new BorderLayout());
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)this.getUpperPanel(), "North");
        main.add((Component)this.getBottomPanel(), "Center");
        this.add((Component)main, "Center");
    }

    public JPanel getUpperPanel() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder("General information"));
        result.setPreferredSize(new Dimension(800, 200));
        int posXda = 10;
        int posYda = 25;
        JLabel label0 = new JLabel("Invariant: ");
        label0.setBounds(posXda, posYda, 70, 20);
        result.add(label0);
        this.invCombo = new JComboBox();
        this.invCombo.addItem(" ---------- ");
        for (int i = 0; i < this.invariantsMatrix.size(); ++i) {
            this.invCombo.addItem("Invariant " + (i + 1) + " (ID:" + i + ")");
        }
        this.invCombo.setBounds(posXda + 75, posYda, 160, 20);
        this.invCombo.setSelectedIndex(this.currentSelected);
        this.invCombo.setMaximumRowCount(6);
        this.invCombo.addActionListener(actionEvent -> {
            this.currentSelected = this.invCombo.getSelectedIndex();
            if (this.currentSelected > 0) {
                this.fillData(this.currentSelected);
            } else {
                this.clearSelection();
            }
        });
        result.add(this.invCombo);
        JButton prevButton = new JButton("Previous");
        prevButton.setBounds(posXda + 245, posYda, 80, 20);
        prevButton.setMargin(new Insets(0, 0, 0, 0));
        prevButton.setIcon(Tools.getResIcon16("/icons/invViewer/prevIcon.png"));
        prevButton.setToolTipText("Show previous invariant data.");
        prevButton.addActionListener(actionEvent -> {
            --this.currentSelected;
            if (this.currentSelected <= 0) {
                this.currentSelected = this.invariantsMatrix.size();
            }
            this.invCombo.setSelectedIndex(this.currentSelected);
        });
        result.add(prevButton);
        JButton nextButton = new JButton("<html>&nbsp;&nbsp;&nbsp;Next&nbsp;</html>");
        nextButton.setBounds(posXda + 335, posYda, 80, 20);
        nextButton.setMargin(new Insets(0, 0, 0, 0));
        nextButton.setIcon(Tools.getResIcon16("/icons/invViewer/nextIcon.png"));
        nextButton.setToolTipText("Show next invariant data.");
        nextButton.addActionListener(actionEvent -> {
            ++this.currentSelected;
            if (this.currentSelected > this.invariantsMatrix.size()) {
                this.currentSelected = 1;
            }
            this.invCombo.setSelectedIndex(this.currentSelected);
        });
        result.add(nextButton);
        JLabel label1 = new JLabel("Minimal:");
        label1.setBounds(posXda, posYda += 20, 70, 20);
        result.add(label1);
        this.labelMinimal = new JLabel("---");
        this.labelMinimal.setBounds(posXda + 75, posYda, 40, 20);
        result.add(this.labelMinimal);
        JLabel label2 = new JLabel("Feasible:");
        label2.setBounds(posXda + 110, posYda, 70, 20);
        result.add(label2);
        this.labelFeasible = new JLabel("---");
        this.labelFeasible.setBounds(posXda + 180, posYda, 40, 20);
        result.add(this.labelFeasible);
        JLabel label3 = new JLabel("Sub-inv:");
        label3.setBounds(posXda + 220, posYda, 70, 20);
        result.add(label3);
        this.labelSub = new JLabel("---");
        this.labelSub.setBounds(posXda + 290, posYda, 40, 20);
        result.add(this.labelSub);
        JLabel label4 = new JLabel("Sur-inv:");
        label4.setBounds(posXda + 330, posYda, 70, 20);
        result.add(label4);
        this.labelSur = new JLabel("---");
        this.labelSur.setBounds(posXda + 400, posYda, 40, 20);
        result.add(this.labelSur);
        JLabel label5 = new JLabel("Canonical:");
        label5.setBounds(posXda + 440, posYda, 70, 20);
        result.add(label5);
        this.labelCanon = new JLabel("---");
        this.labelCanon.setBounds(posXda + 510, posYda, 40, 20);
        result.add(this.labelCanon);
        JLabel label6 = new JLabel("pInTrans:");
        label6.setBounds(posXda, posYda += 20, 70, 20);
        result.add(label6);
        this.labelPureInT = new JLabel("---");
        this.labelPureInT.setBounds(posXda + 75, posYda, 40, 20);
        result.add(this.labelPureInT);
        JLabel label7 = new JLabel("inTrans:");
        label7.setBounds(posXda + 110, posYda, 70, 20);
        result.add(label7);
        this.labelInT = new JLabel("---");
        this.labelInT.setBounds(posXda + 180, posYda, 40, 20);
        result.add(this.labelInT);
        JLabel label8 = new JLabel("outTrans:");
        label8.setBounds(posXda + 220, posYda, 70, 20);
        result.add(label8);
        this.labelOutT = new JLabel("---");
        this.labelOutT.setBounds(posXda + 290, posYda, 40, 20);
        result.add(this.labelOutT);
        JLabel label9 = new JLabel("ReadArcs:");
        label9.setBounds(posXda + 330, posYda, 70, 20);
        result.add(label9);
        this.labelReadArcs = new JLabel("---");
        this.labelReadArcs.setBounds(posXda + 400, posYda, 40, 20);
        result.add(this.labelReadArcs);
        JLabel label10 = new JLabel("Inhibitors:");
        label10.setBounds(posXda + 440, posYda, 70, 20);
        result.add(label10);
        this.labelInhibitors = new JLabel("---");
        this.labelInhibitors.setBounds(posXda + 510, posYda, 40, 20);
        result.add(this.labelInhibitors);
        JLabel label11 = new JLabel("Min. time:");
        label11.setBounds(posXda, posYda += 20, 70, 20);
        result.add(label11);
        this.labelEFT = new JLabel("---");
        this.labelEFT.setBounds(posXda + 75, posYda, 40, 20);
        result.add(this.labelEFT);
        JLabel label12 = new JLabel("Avg. time:");
        label12.setBounds(posXda + 140, posYda, 70, 20);
        result.add(label12);
        this.labelAVG = new JLabel("---");
        this.labelAVG.setBounds(posXda + 210, posYda, 40, 20);
        result.add(this.labelAVG);
        JLabel label13 = new JLabel("Max. time:");
        label13.setBounds(posXda + 280, posYda, 70, 20);
        result.add(label13);
        this.labelLFT = new JLabel("---");
        this.labelLFT.setBounds(posXda + 350, posYda, 40, 20);
        result.add(this.labelLFT);
        JLabel label16 = new JLabel("TPN trans:");
        label16.setBounds(posXda, posYda += 20, 70, 20);
        result.add(label16);
        this.labelTPNtrans = new JLabel("---");
        this.labelTPNtrans.setBounds(posXda + 75, posYda, 40, 20);
        result.add(this.labelTPNtrans);
        JLabel label17 = new JLabel("DPN trans:");
        label17.setBounds(posXda + 110, posYda, 70, 20);
        result.add(label17);
        this.labelDPNtrans = new JLabel("---");
        this.labelDPNtrans.setBounds(posXda + 180, posYda, 40, 20);
        result.add(this.labelDPNtrans);
        JLabel label18 = new JLabel("TDPN trans:");
        label18.setBounds(posXda + 220, posYda, 70, 20);
        result.add(label18);
        this.labelTDPNtrans = new JLabel("---");
        this.labelTDPNtrans.setBounds(posXda + 290, posYda, 40, 20);
        result.add(this.labelTDPNtrans);
        JLabel label19 = new JLabel("PN trans:");
        label19.setBounds(posXda + 330, posYda, 70, 20);
        result.add(label19);
        this.labelPNtrans = new JLabel("---");
        this.labelPNtrans.setBounds(posXda + 400, posYda, 40, 20);
        result.add(this.labelPNtrans);
        JLabel comLabel = new JLabel("Description:");
        comLabel.setBounds(posXda, posYda += 20, 70, 20);
        result.add(comLabel);
        this.descriptionTextArea = new JTextArea();
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newComment = "";
                if (field != null) {
                    newComment = field.getText();
                }
                HolmesInvariantsViewer.this.changeInvDescr(newComment);
                HolmesInvariantsViewer.this.overlord.markNetChange();
            }
        });
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BorderLayout());
        descPanel.add((Component)new JScrollPane(this.descriptionTextArea), "Center");
        descPanel.setBounds(posXda, posYda += 20, 550, 50);
        result.add(descPanel);
        JButton calcButton = new JButton("<html>&nbsp;&nbsp;&nbsp;Recalculate statistics</html>");
        calcButton.setBounds(570, 20, 200, 35);
        calcButton.setMargin(new Insets(0, 0, 0, 0));
        calcButton.setIcon(Tools.getResIcon16("/icons/invViewer/recalculateInvStats.png"));
        calcButton.setToolTipText("Show previous invariant data.");
        calcButton.addActionListener(actionEvent -> {
            if (GUIManager.getDefaultGUIManager().getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
                JOptionPane.showMessageDialog(null, "Net simulator working. Unable to retrieve transitions statistics..", "Simulator working", 0);
                this.transStats = null;
                this.problem = true;
            } else {
                StateSimulator ss = new StateSimulator();
                SimulatorGlobals ownSettings = new SimulatorGlobals();
                ownSettings.setNetType(SimulatorGlobals.SimNetType.BASIC, false);
                ownSettings.setMaxMode(false);
                ownSettings.setSingleMode(false);
                ss.initiateSim(false, ownSettings);
                this.transStats = ss.simulateForInvariantTrans(1000, 20, false);
                this.problem = this.transStats == null;
            }
        });
        result.add(calcButton);
        JButton showNotepadButton = new JButton("<html>&nbsp;&nbsp;&nbsp;Show data in notepad</html>");
        showNotepadButton.setBounds(570, 60, 200, 35);
        showNotepadButton.setMargin(new Insets(0, 0, 0, 0));
        showNotepadButton.setIcon(Tools.getResIcon32("/icons/invViewer/showInNotepad.png"));
        showNotepadButton.setToolTipText("Show invariants data in internal notepad.");
        showNotepadButton.addActionListener(actionEvent -> {
            if (this.currentSelected > 0) {
                this.showInvariantNotepad(this.currentSelected);
            }
        });
        result.add(showNotepadButton);
        JCheckBox maximumModeCheckBox = new JCheckBox("MCT/transitions table");
        maximumModeCheckBox.setBounds(570, 130, 150, 20);
        maximumModeCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            boolean bl = this.showTransTable = !abstractButton.getModel().isSelected();
            if (this.currentSelected > 0) {
                this.fillData(this.currentSelected);
            } else {
                this.clearSelection();
            }
        });
        result.add(maximumModeCheckBox);
        return result;
    }

    protected void showTransitionTable(int invNo) {
        if (--invNo == -1) {
            return;
        }
        InvariantsViewerTableModel modelTransition = new InvariantsViewerTableModel(false);
        this.table.setModel(modelTransition);
        this.table.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(0).setMinWidth(30);
        this.table.getColumnModel().getColumn(0).setMaxWidth(30);
        this.table.getColumnModel().getColumn(1).setHeaderValue("Transition");
        this.table.getColumnModel().getColumn(1).setPreferredWidth(800);
        this.table.getColumnModel().getColumn(1).setMinWidth(100);
        this.table.getColumnModel().getColumn(2).setHeaderValue("Supp.");
        this.table.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(2).setMinWidth(50);
        this.table.getColumnModel().getColumn(2).setMaxWidth(50);
        this.table.getColumnModel().getColumn(3).setHeaderValue("Firing%");
        this.table.getColumnModel().getColumn(3).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(3).setMinWidth(80);
        this.table.getColumnModel().getColumn(4).setMaxWidth(80);
        this.table.getColumnModel().getColumn(4).setHeaderValue("stdDev");
        this.table.getColumnModel().getColumn(4).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(4).setMinWidth(80);
        this.table.getColumnModel().getColumn(4).setMaxWidth(80);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
        this.table.setRowSorter(sorter);
        this.table.setName("InvTransTable");
        this.table.setFillsViewportHeight(true);
        this.table.setDefaultRenderer(Object.class, this.tableRenderer);
        ArrayList<Integer> invariant = this.invariantsMatrix.get(invNo);
        for (int t = 0; t < this.transitions.size(); ++t) {
            if (invariant.get(t) == 0) continue;
            ArrayList<String> row = new ArrayList<String>();
            row.add("" + t);
            row.add(this.transitions.get(t).getName());
            row.add("" + invariant.get(t));
            if (this.problem) {
                row.add("n/a");
                row.add("n/a");
            } else {
                Object value = formatter.format((Object)(this.transStats.get(0).get(t) * 100.0));
                int index = ((String)value).indexOf(",");
                if (index == 1) {
                    value = "0" + (String)value;
                }
                row.add((String)value + "%");
                value = formatter.format((Object)(this.transStats.get(1).get(t) * 100.0));
                row.add((String)value + "%");
            }
            modelTransition.addNew(row);
        }
        this.table.setAutoResizeMode(4);
        this.table.validate();
    }

    protected void showMCTTransTable(int invNo) {
        if (--invNo == -1) {
            return;
        }
        InvariantsViewerTableModel modelMCTandTrans = new InvariantsViewerTableModel(true);
        this.table.setModel(modelMCTandTrans);
        this.table.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(0).setMinWidth(60);
        this.table.getColumnModel().getColumn(0).setMaxWidth(60);
        this.table.getColumnModel().getColumn(1).setHeaderValue("Element");
        this.table.getColumnModel().getColumn(1).setPreferredWidth(800);
        this.table.getColumnModel().getColumn(1).setMinWidth(100);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
        this.table.setRowSorter(sorter);
        this.table.setName("TransitionMCTInvTable");
        this.table.setFillsViewportHeight(true);
        this.table.setDefaultRenderer(Object.class, this.tableRenderer);
        ArrayList<ArrayList<Transition>> mcts = this.pn.getMCTMatrix();
        ArrayList<Integer> invariant = new ArrayList<Integer>((Collection)this.invariantsMatrix.get(invNo));
        for (int mctIndex = 0; mctIndex < mcts.size() - 1; ++mctIndex) {
            ArrayList<Transition> mctSet = mcts.get(mctIndex);
            int firstTindex = this.transitions.indexOf(mctSet.get(0));
            if ((Integer)invariant.get(firstTindex) == 0) continue;
            ArrayList<String> row = new ArrayList<String>();
            row.add("MCT" + (mctIndex + 1));
            row.add(this.pn.getMCTname(mctIndex));
            modelMCTandTrans.addNew(row);
            for (Transition trans : mctSet) {
                int tIndex = this.transitions.indexOf(trans);
                invariant.set(tIndex, 0);
            }
        }
        for (int t = 0; t < this.transitions.size(); ++t) {
            if ((Integer)invariant.get(t) == 0) continue;
            ArrayList<String> row = new ArrayList<String>();
            row.add("t" + t);
            row.add(this.transitions.get(t).getName());
            modelMCTandTrans.addNew(row);
        }
        this.table.setAutoResizeMode(4);
        this.table.validate();
    }

    private void changeInvDescr(String newComment) {
        if (this.currentSelected > 0) {
            this.pn.accessT_InvDescriptions().set(this.currentSelected - 1, newComment);
        }
    }

    private void fillData(int invNo) {
        ArrayList<Integer> data;
        if (invNo == 0) {
            return;
        }
        if ((data = InvariantsTools.singleT_invAnalysis(this.invariantsMatrix, --invNo, this.transitions, this.readArcTransLocations, this.incidenceMatrix, this.supportMatrix)).get(0) == 0) {
            this.labelMinimal.setText("yes");
        } else {
            this.labelMinimal.setText("no");
        }
        if (data.get(1) == 1) {
            this.labelFeasible.setText("yes");
        } else {
            this.labelFeasible.setText("no");
        }
        if (data.get(2) == 0) {
            this.labelSub.setText("no");
            this.labelSur.setText("no");
        } else if (data.get(2) == -1) {
            this.labelSub.setText("yes");
            this.labelSur.setText("no");
        } else if (data.get(2) == 1) {
            this.labelSub.setText("no");
            this.labelSur.setText("yes");
        } else {
            this.labelSub.setText("n-Inv");
            this.labelSur.setText("n-Inv");
        }
        if (data.get(3) == 1) {
            this.labelCanon.setText("yes");
        } else {
            this.labelCanon.setText("no");
        }
        this.labelInT.setText("" + data.get(4));
        this.labelPureInT.setText("" + data.get(5));
        this.labelOutT.setText("" + data.get(6));
        this.labelReadArcs.setText("" + data.get(7));
        this.labelInhibitors.setText("" + data.get(8));
        if (this.showTransTable) {
            this.showTransitionTable(this.currentSelected);
        } else {
            this.showMCTTransTable(this.currentSelected);
        }
        this.tableScrollPane.setViewportView(this.table);
        this.tableScrollPane.repaint();
        this.descriptionTextArea.setText(this.overlord.getWorkspace().getProject().getT_InvDescription(invNo));
        ArrayList<Double> timeVector = TimeComputations.getT_InvTimeValues(this.invariantsMatrix.get(invNo), this.transitions);
        try {
            assert (timeVector != null);
            this.labelEFT.setText(String.format("%.2f", timeVector.get(0) + timeVector.get(3)));
            this.labelAVG.setText(String.format("%.2f", timeVector.get(2) + timeVector.get(3)));
            this.labelLFT.setText(String.format("%.2f", timeVector.get(1) + timeVector.get(3)));
            this.labelTPNtrans.setText("" + timeVector.get(5).intValue());
            this.labelDPNtrans.setText("" + timeVector.get(6).intValue());
            this.labelTDPNtrans.setText("" + timeVector.get(7).intValue());
            this.labelPNtrans.setText("" + timeVector.get(4).intValue());
        }
        catch (Exception e) {
            this.overlord.log("Error: " + e, "error", true);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void showInvariantNotepad(int invNo) {
        void var11_17;
        if (invNo == 0) {
            return;
        }
        HolmesNotepad note = new HolmesNotepad(800, 600);
        ArrayList<Integer> invariant = this.invariantsMatrix.get(--invNo);
        ArrayList<Integer> mcts = new ArrayList<Integer>();
        ArrayList<CallSite> singleT = new ArrayList<CallSite>();
        ArrayList<Integer> transMCTvector = this.overlord.getWorkspace().getProject().getMCTtransIndicesVector();
        int transNumber = 0;
        for (int t = 0; t < invariant.size(); ++t) {
            int fireValue = invariant.get(t);
            if (fireValue == 0) continue;
            ++transNumber;
            int mctNo = transMCTvector.get(t);
            if (mctNo == -1) {
                singleT.add((CallSite)((Object)("T" + t + "_" + this.transitions.get(t).getName())));
                continue;
            }
            if (mcts.contains(mctNo)) continue;
            mcts.add(mctNo);
        }
        Collections.sort(mcts);
        String description = this.overlord.getWorkspace().getProject().accessT_InvDescriptions().get(invNo);
        note.addTextLineNL("T-Invariant " + (invNo + 1), "text");
        note.addTextLineNL("Description: " + description, "text");
        note.addTextLineNL("Total number of transitions: " + transNumber, "text");
        ArrayList<Double> timeVector = TimeComputations.getT_InvTimeValues(invariant, this.transitions);
        assert (timeVector != null);
        note.addTextLineNL("Minimum firing time: " + String.format("%.2f", timeVector.get(0) + timeVector.get(3)), "text");
        note.addTextLineNL("Maximum firing time: " + String.format("%.2f", timeVector.get(1) + timeVector.get(3)), "text");
        note.addTextLineNL("Average firing time: " + String.format("%.2f", timeVector.get(2) + timeVector.get(3)), "text");
        note.addTextLineNL("TPN trans: " + timeVector.get(5).intValue() + " | DPN trans: " + timeVector.get(6).intValue() + " | TDPN trans: " + timeVector.get(7).intValue() + " | PN trans: " + timeVector.get(4).intValue(), "text");
        note.addTextLineNL(" ", "text");
        note.addTextLineNL("Support structure:", "text");
        Iterator mctNo = mcts.iterator();
        while (mctNo.hasNext()) {
            int n = (Integer)mctNo.next();
            String MCTname = this.overlord.getWorkspace().getProject().getMCTname(n);
            note.addTextLineNL("  [MCT: " + (n + 1) + "]: " + MCTname, "text");
        }
        for (String string : singleT) {
            note.addTextLineNL(string, "text");
        }
        note.addTextLineNL("", "text");
        note.addTextLineNL("All transitions of INV #" + (invNo + 1) + ":", "text");
        if (this.transitions.size() != invariant.size()) {
            this.transitions = this.overlord.getWorkspace().getProject().getTransitions();
            if (this.transitions == null || this.transitions.size() != invariant.size()) {
                this.overlord.log("Critical error in invariants subwindow. Invariants support size refers to non-existing transitions.", "error", true);
                return;
            }
        }
        StringBuilder vector = new StringBuilder();
        boolean bl = false;
        while (var11_17 < invariant.size()) {
            int fireValue = invariant.get((int)var11_17);
            vector.append(fireValue).append(";");
            if (fireValue != 0) {
                Transition realT = this.transitions.get((int)var11_17);
                String t1 = Tools.setToSize("t" + (int)var11_17, 5, false);
                String t2 = Tools.setToSize("Fired: " + fireValue, 12, false);
                note.addTextLineNL(t1 + t2 + " ; " + realT.getName(), "text");
            }
            ++var11_17;
        }
        vector = new StringBuilder(vector.substring(0, vector.length() - 1));
        note.addTextLineNL("", "text");
        note.addTextLineNL("Invariant vector:", "text");
        note.addTextLineNL(vector.toString(), "text");
        note.setCaretFirstLine();
        note.setVisible(true);
    }

    private void clearSelection() {
        this.labelMinimal.setText("---");
        this.labelFeasible.setText("---");
        this.labelSub.setText("---");
        this.labelSur.setText("---");
        this.labelCanon.setText("---");
        this.labelPureInT.setText("---");
        this.labelInT.setText("---");
        this.labelOutT.setText("---");
        this.labelReadArcs.setText("---");
        this.labelInhibitors.setText("---");
        this.labelEFT.setText("---");
        this.labelAVG.setText("---");
        this.labelLFT.setText("---");
        this.labelTPNtrans.setText("---");
        this.labelDPNtrans.setText("---");
        this.labelTDPNtrans.setText("---");
        this.labelPNtrans.setText("---");
        this.table.setModel(new DefaultTableModel());
    }

    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createTitledBorder("Tables"));
        result.setPreferredSize(new Dimension(150, 500));
        DefaultTableModel tableModel = new DefaultTableModel();
        this.table = new JTable(tableModel);
        this.tableRenderer = new InvariantsTableRenderer(this.table);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isControlDown()) {
                    HolmesInvariantsViewer.this.cellClickAction();
                }
            }
        });
        this.table.setAutoResizeMode(0);
        this.tableScrollPane = new JScrollPane(this.table, 20, 30);
        result.add((Component)this.tableScrollPane, "Center");
        return result;
    }

    protected void cellClickAction() {
        try {
            int row = this.table.getSelectedRow();
            if (this.table.getName().equals("InvTransTable")) {
                String id = this.table.getValueAt(row, 0).toString();
                int transId = Integer.parseInt(id);
                new HolmesNodeInfo(this.transitions.get(transId), (JFrame)this);
            }
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (759541509) | Exception:  " + ex.getMessage(), "error", true);
        }
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
    }
}

