/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.analyse.InvariantsCalculator;
import holmes.analyse.InvariantsCalculatorFeasible;
import holmes.analyse.InvariantsTools;
import holmes.darkgui.GUIManager;
import holmes.files.io.IOprotocols;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.Tools;
import holmes.varia.Check;
import holmes.windows.HolmesNotepad;
import holmes.workspace.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.DefaultCaret;

public class HolmesInvariantsGenerator
extends JFrame {
    private static final long serialVersionUID = 5805567123988000425L;
    private GUIManager overlord;
    private JFrame ego;
    private JTextArea logFieldTinv;
    private JTextArea logFieldPinv;
    private InvariantsCalculator invGenerator = null;
    public boolean isGeneratorWorking = false;
    public boolean noAction = false;
    private boolean detailsTinv = true;
    private boolean detailsPinv = true;
    private int feasibleCalcMode = 1;
    private boolean showInvDiff = false;

    public HolmesInvariantsGenerator() {
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (641603807) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.ego = this;
        this.setVisible(false);
        this.setTitle("Invariants generator and tools");
        this.overlord = GUIManager.getDefaultGUIManager();
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(682, 570));
        this.setLocation(50, 50);
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        JPanel mainPanel = this.createMainPanel();
        this.add((Component)mainPanel, "Center");
    }

    private JPanel createMainPanel() {
        JPanel main = new JPanel(new BorderLayout());
        JPanel panelTinv = new JPanel();
        panelTinv.setLayout(null);
        JPanel buttonPanelT = this.createUpperButtonPanelTinv(0, 0, 660, 90);
        JPanel logMainPanelT = this.createLogMainPanelTinv(0, 90, 530, 400);
        JPanel sideButtonPanelT = this.createRightButtonPanelTinv(530, 90, 130, 400);
        panelTinv.add(buttonPanelT);
        panelTinv.add(logMainPanelT);
        panelTinv.add(sideButtonPanelT);
        panelTinv.repaint();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("T-invariants", Tools.getResIcon22("/icons/invWindow/tInvIcon.png"), panelTinv, "T-invariants");
        tabbedPane.setMnemonicAt(0, 49);
        JPanel panelPinv = new JPanel();
        panelPinv.setLayout(null);
        JPanel buttonPanelP = this.createUpperButtonPanelPinv(0, 0, 660, 90);
        JPanel logMainPanelP = this.createLogMainPanelPinv(0, 90, 530, 400);
        JPanel sideButtonPanelP = this.createRightButtonPanelPinv(530, 90, 130, 400);
        panelPinv.add(buttonPanelP);
        panelPinv.add(logMainPanelP);
        panelPinv.add(sideButtonPanelP);
        panelPinv.repaint();
        tabbedPane.addTab("P-invariants", Tools.getResIcon22("/icons/invWindow/pInvIcon.png"), panelPinv, "P-invariants");
        tabbedPane.setMnemonicAt(1, 50);
        main.add((Component)tabbedPane, "Center");
        return main;
    }

    private JPanel createUpperButtonPanelTinv(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        panel.setBounds(x, y, width, height);
        int posX = 10;
        int posY = 10;
        JButton generateButton = new JButton("Generate");
        generateButton.setBounds(posX, posY, 110, 60);
        generateButton.setMargin(new Insets(0, 0, 0, 0));
        generateButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        generateButton.addActionListener(actionEvent -> {
            if (this.isGeneratorWorking) {
                JOptionPane.showMessageDialog(null, "Invariants generation already in progress.", "Generator working", 2);
            } else {
                this.setGeneratorStatus(true);
                this.invGenerator = new InvariantsCalculator(true);
                this.invGenerator.setShowInvDiff(this.showInvDiff);
                Thread myThread = new Thread(this.invGenerator);
                myThread.start();
            }
        });
        generateButton.setFocusPainted(false);
        panel.add(generateButton);
        JButton INAgenerateButton = new JButton();
        INAgenerateButton.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;INA<br>generator</html>");
        INAgenerateButton.setBounds(posX + 130, posY, 120, 36);
        INAgenerateButton.setMargin(new Insets(0, 0, 0, 0));
        INAgenerateButton.setIcon(Tools.getResIcon22("/icons/invWindow/inaGenerator.png"));
        INAgenerateButton.addActionListener(actionEvent -> {
            if (this.overlord.getINAStatus()) {
                this.setGeneratorStatus(true);
                this.overlord.io.generateINAinvariants(true);
                this.overlord.reset.setT_invariantsStatus(true);
                this.overlord.accessNetTablesWindow().resetT_invData();
                this.overlord.markNetChange();
            } else {
                JOptionPane.showMessageDialog(null, "INAwin32.exe status set to non ready. Please read initial warnings\nin the Holmes log windows for more information.", "INAwin32 problem", 0);
            }
        });
        INAgenerateButton.setFocusPainted(false);
        panel.add(INAgenerateButton);
        JButton loadInvariantsButton = new JButton();
        loadInvariantsButton.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;Load<br>t-invariants</html>");
        loadInvariantsButton.setBounds(posX + 255, posY, 120, 36);
        loadInvariantsButton.setMargin(new Insets(0, 0, 0, 0));
        loadInvariantsButton.setIcon(Tools.getResIcon22("/icons/invWindow/loadInvariants.png"));
        loadInvariantsButton.addActionListener(actionEvent -> {
            this.overlord.accessNetTablesWindow().resetT_invData();
            boolean status = this.overlord.io.loadExternalAnalysis(true);
            if (status) {
                this.logFieldTinv.append("\n");
                this.logFieldTinv.append("=====================================================================\n");
                this.logFieldTinv.append("Loaded t-invariants: " + this.overlord.getWorkspace().getProject().getT_InvMatrix().size() + "\n");
                this.logFieldTinv.append("=====================================================================\n");
                this.overlord.markNetChange();
            } else {
                this.logFieldTinv.append("\n");
                this.logFieldTinv.append("Loading t-invariants from file has been unsuccessfull.\n");
            }
        });
        loadInvariantsButton.setFocusPainted(false);
        panel.add(loadInvariantsButton);
        JButton saveInvariantsButton = new JButton();
        saveInvariantsButton.setText("<html>&nbsp;&nbsp;&nbsp;Export<br>t-invariants</html>");
        saveInvariantsButton.setBounds(posX + 380, posY, 120, 36);
        saveInvariantsButton.setMargin(new Insets(0, 0, 0, 0));
        saveInvariantsButton.setIcon(Tools.getResIcon22("/icons/invWindow/saveInvariants.png"));
        saveInvariantsButton.addActionListener(actionEvent -> {
            boolean status = this.overlord.io.exportGeneratedInvariants(true);
            if (status) {
                this.logFieldTinv.append("\n");
                this.logFieldTinv.append("=====================================================================\n");
                this.logFieldTinv.append("Saved t-invariants: " + this.overlord.getWorkspace().getProject().getT_InvMatrix().size() + "\n");
                this.logFieldTinv.append("=====================================================================\n");
            } else {
                this.logFieldTinv.append("\n");
                this.logFieldTinv.append("Saving t-invariants has been unsuccessfull.\n");
            }
        });
        saveInvariantsButton.setFocusPainted(false);
        panel.add(saveInvariantsButton);
        JButton showInvariantsButton = new JButton();
        showInvariantsButton.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;Show<br>t-invariants</html>");
        showInvariantsButton.setBounds(posX + 505, posY, 120, 36);
        showInvariantsButton.setMargin(new Insets(0, 0, 0, 0));
        showInvariantsButton.setIcon(Tools.getResIcon22("/icons/invWindow/showInvariants.png"));
        showInvariantsButton.addActionListener(actionEvent -> this.showNotepadInvariants(true));
        showInvariantsButton.setFocusPainted(false);
        panel.add(showInvariantsButton);
        JButton saveInvButton = new JButton();
        saveInvButton.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;Save<br>t-invariants</html>");
        saveInvButton.setBounds(posX + 130, posY + 40, 120, 36);
        saveInvButton.setMargin(new Insets(0, 0, 0, 0));
        saveInvButton.setIcon(Tools.getResIcon22("/icons/invWindow/showInvariants.png"));
        saveInvButton.addActionListener(actionEvent -> this.saveInvKajaType(true));
        saveInvButton.setFocusPainted(false);
        panel.add(saveInvButton);
        JButton makeFeasibleButton = new JButton();
        makeFeasibleButton.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;Make<br>&nbsp;&nbsp;feasible</html>");
        makeFeasibleButton.setBounds(posX + 255, posY + 40, 120, 36);
        makeFeasibleButton.setMargin(new Insets(0, 0, 0, 0));
        makeFeasibleButton.setIcon(Tools.getResIcon22("/icons/invWindow/makeFeasible.png"));
        makeFeasibleButton.addActionListener(actionEvent -> this.checkAndMakeFeasible());
        makeFeasibleButton.setFocusPainted(false);
        panel.add(makeFeasibleButton);
        JCheckBox feasModeCheckBox = new JCheckBox("Feasible adv. mode");
        feasModeCheckBox.setBounds(posX + 380, posY + 36, 140, 20);
        feasModeCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.feasibleCalcMode = abstractButton.getModel().isSelected() ? 1 : 0;
        });
        feasModeCheckBox.setSelected(true);
        panel.add(feasModeCheckBox);
        JCheckBox invPurityCheckBox = new JCheckBox("Clean non-inv.");
        invPurityCheckBox.setBounds(posX + 380, posY + 56, 120, 20);
        invPurityCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                GUIManager.getDefaultGUIManager().getSettingsManager().setValue("analysisRemoveNonInv", "1", true);
            } else {
                GUIManager.getDefaultGUIManager().getSettingsManager().setValue("analysisRemoveNonInv", "0", true);
            }
        });
        invPurityCheckBox.setSelected(GUIManager.getDefaultGUIManager().getSettingsManager().getValue("analysisRemoveNonInv").equals("1"));
        panel.add(invPurityCheckBox);
        JCheckBox removeSingleInvCheckBox = new JCheckBox("Remove 1-el. inv.");
        removeSingleInvCheckBox.setBounds(posX + 510, posY + 56, 120, 20);
        removeSingleInvCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                GUIManager.getDefaultGUIManager().getSettingsManager().setValue("analysisRemoveSingleElementInv", "1", true);
            } else {
                GUIManager.getDefaultGUIManager().getSettingsManager().setValue("analysisRemoveSingleElementInv", "0", true);
            }
        });
        removeSingleInvCheckBox.setSelected(GUIManager.getDefaultGUIManager().getSettingsManager().getValue("analysisRemoveSingleElementInv").equals("1"));
        panel.add(removeSingleInvCheckBox);
        return panel;
    }

    private void saveInvKajaType(boolean t_inv) {
        block6: {
            block5: {
                if (!t_inv) break block5;
                ArrayList<ArrayList<Integer>> t_invariants = this.overlord.getWorkspace().getProject().getT_InvMatrix();
                if (t_invariants == null) break block6;
                ArrayList<Transition> transitions = this.overlord.getWorkspace().getProject().getTransitions();
                HolmesNotepad notePad = new HolmesNotepad(900, 600);
                notePad.setVisible(true);
                notePad.addTextLineNL("T-invariants - Kaja Style:", "text");
                for (int i = 0; i < t_invariants.size(); ++i) {
                    ArrayList<Integer> inv = t_invariants.get(i);
                    StringBuilder vector = new StringBuilder("x" + i + " - ");
                    for (int j = 0; j < inv.size(); ++j) {
                        int value = inv.get(j);
                        if (value == 0) continue;
                        vector.append("t").append(this.overlord.getWorkspace().getProject().getTransitions().lastIndexOf(transitions.get(j))).append(";");
                    }
                    notePad.addTextLineNL(vector.toString(), "text");
                }
                break block6;
            }
            ArrayList<ArrayList<Integer>> p_invariants = this.overlord.getWorkspace().getProject().getT_InvMatrix();
            if (p_invariants != null) {
                ArrayList<Place> places = this.overlord.getWorkspace().getProject().getPlaces();
                HolmesNotepad notePad = new HolmesNotepad(900, 600);
                notePad.setVisible(true);
                notePad.addTextLineNL("P-invariants - Kaja Style:", "text");
                for (int i = 0; i < p_invariants.size(); ++i) {
                    ArrayList<Integer> inv = p_invariants.get(i);
                    StringBuilder vector = new StringBuilder("x" + i + " - ");
                    for (int j = 0; j < inv.size(); ++j) {
                        int value = inv.get(j);
                        if (value == 0) continue;
                        vector.append("p").append(this.overlord.getWorkspace().getProject().getPlaces().lastIndexOf(places.get(j))).append(";");
                    }
                    notePad.addTextLineNL(vector.toString(), "text");
                }
            }
        }
    }

    private JPanel createLogMainPanelTinv(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder("T-invariants log window"));
        panel.setBounds(x, y, width, height);
        this.logFieldTinv = new JTextArea();
        this.logFieldTinv.setLineWrap(true);
        this.logFieldTinv.setEditable(false);
        DefaultCaret caret = (DefaultCaret)this.logFieldTinv.getCaret();
        caret.setUpdatePolicy(2);
        JPanel logFieldPanel = new JPanel();
        logFieldPanel.setLayout(new BorderLayout());
        logFieldPanel.add((Component)new JScrollPane(this.logFieldTinv), "Center");
        logFieldPanel.setBounds(10, 20, width - 20, height - 25);
        panel.add(logFieldPanel);
        return panel;
    }

    private JPanel createRightButtonPanelTinv(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder("Tools"));
        panel.setBounds(x, y, width, height);
        int posX = 10;
        int posY = 18;
        JButton cardinalityButton = new JButton();
        cardinalityButton.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Check<br />&nbsp;&nbsp;&nbsp;canonity</html>");
        cardinalityButton.setBounds(posX, posY, 110, 32);
        cardinalityButton.setMargin(new Insets(0, 0, 0, 0));
        cardinalityButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_canon.png"));
        cardinalityButton.addActionListener(actionEvent -> {
            ArrayList<ArrayList<Integer>> invariants = this.overlord.getWorkspace().getProject().getT_InvMatrix();
            if (invariants == null || invariants.size() == 0) {
                JOptionPane.showMessageDialog(this.ego, "No t-invariants to analyze.", "No invariants", 1);
            } else {
                this.logFieldTinv.append("\n");
                this.logFieldTinv.append("=====================================================================\n");
                this.logFieldTinv.append("Checking canonicality for " + invariants.size() + " t-invariants.\n");
                int card = InvariantsTools.checkCanonity(invariants);
                this.logFieldTinv.append("Non canonical t-invariants: " + card + "\n");
                this.logFieldTinv.append("=====================================================================\n");
            }
        });
        cardinalityButton.setFocusPainted(false);
        panel.add(cardinalityButton);
        JButton minSuppButton = new JButton();
        minSuppButton.setText("<html>Check sup.<br />&nbsp;minimality</html>");
        minSuppButton.setBounds(posX, posY + 38, 110, 32);
        minSuppButton.setMargin(new Insets(0, 0, 0, 0));
        minSuppButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_minsup.png"));
        minSuppButton.addActionListener(actionEvent -> {
            ArrayList<ArrayList<Integer>> invariants = this.overlord.getWorkspace().getProject().getT_InvMatrix();
            if (invariants == null || invariants.size() == 0) {
                JOptionPane.showMessageDialog(this.ego, "No t-invariants to analyze.", "No invariants", 1);
            } else {
                this.logFieldTinv.append("\n");
                this.logFieldTinv.append("=====================================================================\n");
                this.logFieldTinv.append("Checking support minimality for " + invariants.size() + " t-invariants.\n");
                int value = InvariantsTools.checkSupportMinimality(invariants);
                this.logFieldTinv.append("Non support-minimal t-invariants: " + value + "\n");
                this.logFieldTinv.append("=====================================================================\n");
            }
        });
        minSuppButton.setFocusPainted(false);
        panel.add(minSuppButton);
        JButton checkMatrixZeroButton = new JButton();
        checkMatrixZeroButton.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;Check<br />&nbsp;&nbsp;&nbsp;&nbsp;C&nbsp;&middot;&nbsp;x = 0</html>");
        checkMatrixZeroButton.setBounds(posX, posY + 76, 110, 32);
        checkMatrixZeroButton.setMargin(new Insets(0, 0, 0, 0));
        checkMatrixZeroButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_invC.png"));
        checkMatrixZeroButton.addActionListener(actionEvent -> {
            ArrayList<ArrayList<Integer>> invariants = this.overlord.getWorkspace().getProject().getT_InvMatrix();
            if (invariants == null || invariants.size() == 0) {
                JOptionPane.showMessageDialog(this.ego, "No t-invariants to analyze.", "No invariants", 1);
            } else {
                this.logFieldTinv.append("\n");
                this.logFieldTinv.append("=====================================================================\n");
                this.logFieldTinv.append("Checking t0invariants correctness for " + invariants.size() + " invariants.\n");
                InvariantsCalculator ic = new InvariantsCalculator(true);
                ArrayList<ArrayList<Integer>> results = InvariantsTools.analyseInvariantDetails(ic.getCMatrix(), invariants, true);
                this.logFieldTinv.append("t-invariants (Cx = 0): " + results.get(0).get(0) + "\n");
                this.logFieldTinv.append("Sur-invariants (Cx > 0): " + results.get(0).get(1) + "\n");
                this.logFieldTinv.append("Sub-invariants (Cx < 0): " + results.get(0).get(2) + "\n");
                this.logFieldTinv.append("Non-invariants (Cx <=> 0): " + results.get(0).get(3) + "\n");
                this.logFieldTinv.append("=====================================================================\n");
                if (this.detailsTinv) {
                    this.showSubSurT_invInfo(results, invariants.size());
                }
            }
        });
        checkMatrixZeroButton.setFocusPainted(false);
        panel.add(checkMatrixZeroButton);
        JButton loadRefButton = new JButton();
        loadRefButton.setText("<html>&nbsp;&nbsp;&nbsp;Ref. set<br />&nbsp;&nbsp;&nbsp;compare</html>");
        loadRefButton.setBounds(posX, posY + 114, 110, 32);
        loadRefButton.setMargin(new Insets(0, 0, 0, 0));
        loadRefButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_ref.png"));
        loadRefButton.addActionListener(actionEvent -> this.testReference(true));
        loadRefButton.setFocusPainted(false);
        panel.add(loadRefButton);
        JButton testRefButton = new JButton();
        testRefButton.setText("<html>&nbsp;&nbsp;Incidence<br />&nbsp;&nbsp;&nbsp;matrix</html>");
        testRefButton.setBounds(posX, posY + 180, 110, 32);
        testRefButton.setMargin(new Insets(0, 0, 0, 0));
        testRefButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_ref.png"));
        testRefButton.addActionListener(actionEvent -> this.getIncMatrix(true));
        testRefButton.setFocusPainted(false);
        panel.add(testRefButton);
        JCheckBox detailsCheckBox = new JCheckBox("Details");
        detailsCheckBox.setBounds(posX, posY + 144, 110, 20);
        detailsCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.detailsTinv = abstractButton.getModel().isSelected();
        });
        detailsCheckBox.setSelected(true);
        panel.add(detailsCheckBox);
        JCheckBox showDiffCheckBox = new JCheckBox("Show difference");
        showDiffCheckBox.setBounds(posX, posY + 220, 130, 20);
        showDiffCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.showInvDiff = abstractButton.getModel().isSelected();
        });
        showDiffCheckBox.setSelected(false);
        panel.add(showDiffCheckBox);
        return panel;
    }

    private JPanel createUpperButtonPanelPinv(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        panel.setBounds(x, y, width, height);
        int posX = 10;
        int posY = 10;
        JButton generateButton = new JButton("<html>Generate<br>p-inv.</html>");
        generateButton.setBounds(posX, posY, 110, 60);
        generateButton.setMargin(new Insets(0, 0, 0, 0));
        generateButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        generateButton.addActionListener(actionEvent -> {
            if (this.isGeneratorWorking) {
                JOptionPane.showMessageDialog(null, "Invariants generation already in progress.", "Generator working", 2);
            } else {
                this.setGeneratorStatus(true);
                this.invGenerator = new InvariantsCalculator(false);
                Thread myThread = new Thread(this.invGenerator);
                myThread.start();
            }
        });
        generateButton.setFocusPainted(false);
        panel.add(generateButton);
        JButton INAgenerateButton = new JButton();
        INAgenerateButton.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;INA<br>generator</html>");
        INAgenerateButton.setBounds(posX + 130, posY, 120, 36);
        INAgenerateButton.setMargin(new Insets(0, 0, 0, 0));
        INAgenerateButton.setIcon(Tools.getResIcon22("/icons/invWindow/inaGenerator.png"));
        INAgenerateButton.addActionListener(actionEvent -> {
            if (this.overlord.getINAStatus()) {
                this.setGeneratorStatus(true);
                this.overlord.io.generateINAinvariants(false);
                this.overlord.reset.setP_invariantsStatus(true);
                ArrayList<ArrayList<Integer>> pInv = this.overlord.getWorkspace().getProject().getP_InvMatrix();
                this.overlord.markNetChange();
            } else {
                JOptionPane.showMessageDialog(null, "INAwin32.exe status set to non ready. Please read initial warnings\nin the Holmes log windows for more information.", "INAwin32 problem", 0);
            }
        });
        INAgenerateButton.setFocusPainted(false);
        panel.add(INAgenerateButton);
        JButton loadInvariantsButton = new JButton();
        loadInvariantsButton.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;Load<br>p-invariants</html>");
        loadInvariantsButton.setBounds(posX + 255, posY, 120, 36);
        loadInvariantsButton.setMargin(new Insets(0, 0, 0, 0));
        loadInvariantsButton.setIcon(Tools.getResIcon22("/icons/invWindow/loadInvariants.png"));
        loadInvariantsButton.addActionListener(actionEvent -> {
            boolean status = this.overlord.io.loadExternalAnalysis(false);
            if (status) {
                this.logFieldPinv.append("\n");
                this.logFieldPinv.append("=====================================================================\n");
                this.logFieldPinv.append("Loaded p-invariants: " + this.overlord.getWorkspace().getProject().getP_InvMatrix().size() + "\n");
                this.logFieldPinv.append("=====================================================================\n");
                this.overlord.markNetChange();
            } else {
                this.logFieldPinv.append("\n");
                this.logFieldPinv.append("P-invariants reading has been unsuccessfull.\n");
            }
        });
        loadInvariantsButton.setFocusPainted(false);
        panel.add(loadInvariantsButton);
        JButton saveInvariantsButton = new JButton();
        saveInvariantsButton.setText("<html>&nbsp;&nbsp;&nbsp;Export<br>p-invariants</html>");
        saveInvariantsButton.setBounds(posX + 380, posY, 120, 36);
        saveInvariantsButton.setMargin(new Insets(0, 0, 0, 0));
        saveInvariantsButton.setIcon(Tools.getResIcon22("/icons/invWindow/saveInvariants.png"));
        saveInvariantsButton.addActionListener(actionEvent -> {
            boolean status = this.overlord.io.exportGeneratedInvariants(false);
            if (status) {
                this.logFieldPinv.append("\n");
                this.logFieldPinv.append("=====================================================================\n");
                this.logFieldPinv.append("Saved p-invariants: " + this.overlord.getWorkspace().getProject().getP_InvMatrix().size() + "\n");
                this.logFieldPinv.append("=====================================================================\n");
            } else {
                this.logFieldPinv.append("\n");
                this.logFieldPinv.append("Saving p-invariants has been unsuccessfull.\n");
            }
        });
        saveInvariantsButton.setFocusPainted(false);
        panel.add(saveInvariantsButton);
        JButton showInvariantsButton = new JButton();
        showInvariantsButton.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;Show<br>p-invariants</html>");
        showInvariantsButton.setBounds(posX + 505, posY, 120, 36);
        showInvariantsButton.setMargin(new Insets(0, 0, 0, 0));
        showInvariantsButton.setIcon(Tools.getResIcon22("/icons/invWindow/showInvariants.png"));
        showInvariantsButton.addActionListener(actionEvent -> this.showNotepadInvariants(false));
        showInvariantsButton.setFocusPainted(false);
        panel.add(showInvariantsButton);
        JCheckBox invPurityCheckBox = new JCheckBox("Clean non-inv.");
        invPurityCheckBox.setBounds(posX + 380, posY + 56, 120, 20);
        invPurityCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                GUIManager.getDefaultGUIManager().getSettingsManager().setValue("analysisRemoveNonInv", "1", true);
            } else {
                GUIManager.getDefaultGUIManager().getSettingsManager().setValue("analysisRemoveNonInv", "0", true);
            }
        });
        invPurityCheckBox.setSelected(GUIManager.getDefaultGUIManager().getSettingsManager().getValue("analysisRemoveNonInv").equals("1"));
        panel.add(invPurityCheckBox);
        JCheckBox removeSingleInvCheckBox = new JCheckBox("Remove 1-el. inv.");
        removeSingleInvCheckBox.setBounds(posX + 510, posY + 56, 120, 20);
        removeSingleInvCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                GUIManager.getDefaultGUIManager().getSettingsManager().setValue("analysisRemoveSingleElementInv", "1", true);
            } else {
                GUIManager.getDefaultGUIManager().getSettingsManager().setValue("analysisRemoveSingleElementInv", "0", true);
            }
        });
        removeSingleInvCheckBox.setSelected(GUIManager.getDefaultGUIManager().getSettingsManager().getValue("analysisRemoveSingleElementInv").equals("1"));
        panel.add(removeSingleInvCheckBox);
        return panel;
    }

    private JPanel createLogMainPanelPinv(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder("P-invariants log window"));
        panel.setBounds(x, y, width, height);
        this.logFieldPinv = new JTextArea();
        this.logFieldPinv.setLineWrap(true);
        this.logFieldPinv.setEditable(false);
        DefaultCaret caret = (DefaultCaret)this.logFieldPinv.getCaret();
        caret.setUpdatePolicy(2);
        JPanel logFieldPanel = new JPanel();
        logFieldPanel.setLayout(new BorderLayout());
        logFieldPanel.add((Component)new JScrollPane(this.logFieldPinv), "Center");
        logFieldPanel.setBounds(10, 20, width - 20, height - 25);
        panel.add(logFieldPanel);
        return panel;
    }

    private JPanel createRightButtonPanelPinv(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder("Tools"));
        panel.setBounds(x, y, width, height);
        int posX = 10;
        int posY = 18;
        JButton cardinalityButton = new JButton();
        cardinalityButton.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Check<br />&nbsp;&nbsp;&nbsp;canonity</html>");
        cardinalityButton.setBounds(posX, posY, 110, 32);
        cardinalityButton.setMargin(new Insets(0, 0, 0, 0));
        cardinalityButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_canon.png"));
        cardinalityButton.addActionListener(actionEvent -> {
            ArrayList<ArrayList<Integer>> p_invariants = this.overlord.getWorkspace().getProject().getP_InvMatrix();
            if (p_invariants == null || p_invariants.size() == 0) {
                JOptionPane.showMessageDialog(this.ego, "No p-invariants to analyze.", "No p-invariants", 1);
            } else {
                this.logFieldPinv.append("\n");
                this.logFieldPinv.append("=====================================================================\n");
                this.logFieldPinv.append("Checking canonicality for " + p_invariants.size() + " p-invariants.\n");
                int card = InvariantsTools.checkCanonity(p_invariants);
                this.logFieldPinv.append("Non canonical p-invariants: " + card + "\n");
                this.logFieldPinv.append("=====================================================================\n");
            }
        });
        cardinalityButton.setFocusPainted(false);
        panel.add(cardinalityButton);
        JButton minSuppButton = new JButton();
        minSuppButton.setText("<html>Check sup.<br>&nbsp;minimality</html>");
        minSuppButton.setBounds(posX, posY + 38, 110, 32);
        minSuppButton.setMargin(new Insets(0, 0, 0, 0));
        minSuppButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_minsup.png"));
        minSuppButton.addActionListener(actionEvent -> {
            ArrayList<ArrayList<Integer>> p_invariants = this.overlord.getWorkspace().getProject().getP_InvMatrix();
            if (p_invariants == null || p_invariants.size() == 0) {
                JOptionPane.showMessageDialog(null, "No p-invariants to analyze.", "No p-invariants", 1);
            } else {
                this.logFieldPinv.append("\n");
                this.logFieldPinv.append("=====================================================================\n");
                this.logFieldPinv.append("Checking support minimality for " + p_invariants.size() + " p-invariants.\n");
                int value = InvariantsTools.checkSupportMinimality(p_invariants);
                this.logFieldPinv.append("Non support-minimal p-invariants: " + value + "\n");
                this.logFieldPinv.append("=====================================================================\n");
            }
        });
        minSuppButton.setFocusPainted(false);
        panel.add(minSuppButton);
        JButton checkMatrixZeroButton = new JButton();
        checkMatrixZeroButton.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;Check<br>&nbsp;&nbsp;&nbsp;&nbsp;C&nbsp;&middot;&nbsp;x = 0</html>");
        checkMatrixZeroButton.setBounds(posX, posY + 76, 110, 32);
        checkMatrixZeroButton.setMargin(new Insets(0, 0, 0, 0));
        checkMatrixZeroButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_invC.png"));
        checkMatrixZeroButton.addActionListener(actionEvent -> {
            ArrayList<ArrayList<Integer>> p_invariants = this.overlord.getWorkspace().getProject().getP_InvMatrix();
            if (p_invariants == null || p_invariants.size() == 0) {
                JOptionPane.showMessageDialog(null, "No invariants to analyze.", "No invariants", 1);
            } else {
                this.logFieldPinv.append("\n");
                this.logFieldPinv.append("=====================================================================\n");
                this.logFieldPinv.append("Checking invariants correctness for " + p_invariants.size() + " invariants.\n");
                InvariantsCalculator ic = new InvariantsCalculator(true);
                ArrayList<ArrayList<Integer>> results = InvariantsTools.analyseInvariantDetails(ic.getCMatrix(), p_invariants, false);
                this.logFieldPinv.append("T-invariants (Cx = 0): " + results.get(0).get(0) + "\n");
                this.logFieldPinv.append("Sur-invariants (Cx > 0): " + results.get(0).get(1) + "\n");
                this.logFieldPinv.append("Sub-invariants (Cx < 0): " + results.get(0).get(2) + "\n");
                this.logFieldPinv.append("Non-invariants (Cx <=> 0): " + results.get(0).get(3) + "\n");
                this.logFieldPinv.append("=====================================================================\n");
                if (this.detailsPinv) {
                    this.showSubSurP_invInfo(results, p_invariants.size());
                }
            }
        });
        checkMatrixZeroButton.setFocusPainted(false);
        panel.add(checkMatrixZeroButton);
        JButton loadRefButton = new JButton();
        loadRefButton.setText("<html>&nbsp;&nbsp;&nbsp;Ref. set<br>&nbsp;&nbsp;&nbsp;compare</html>");
        loadRefButton.setBounds(posX, posY + 114, 110, 32);
        loadRefButton.setMargin(new Insets(0, 0, 0, 0));
        loadRefButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_ref.png"));
        loadRefButton.addActionListener(actionEvent -> this.testReference(false));
        loadRefButton.setFocusPainted(false);
        panel.add(loadRefButton);
        JButton testRefButton = new JButton();
        testRefButton.setText("<html>&nbsp;&nbsp;Incidence<br>&nbsp;&nbsp;&nbsp;matrix</html>");
        testRefButton.setBounds(posX, posY + 180, 110, 32);
        testRefButton.setMargin(new Insets(0, 0, 0, 0));
        testRefButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_ref.png"));
        testRefButton.addActionListener(actionEvent -> this.getIncMatrix(false));
        testRefButton.setFocusPainted(false);
        panel.add(testRefButton);
        JCheckBox detailsCheckBox = new JCheckBox("Details");
        detailsCheckBox.setBounds(posX, posY + 144, 110, 20);
        detailsCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.detailsPinv = abstractButton.getModel().isSelected();
        });
        detailsCheckBox.setSelected(true);
        panel.add(detailsCheckBox);
        return panel;
    }

    protected void getIncMatrix(boolean Tinv) {
        HolmesNotepad notePad;
        int i;
        HashMap<Place, Integer> placesMap = new HashMap<Place, Integer>();
        HashMap<Transition, Integer> transitionsMap = new HashMap<Transition, Integer>();
        ArrayList<Place> places = this.overlord.getWorkspace().getProject().getPlaces();
        ArrayList<Transition> transitions = this.overlord.getWorkspace().getProject().getTransitions();
        ArrayList<Arc> arcs = this.overlord.getWorkspace().getProject().getArcs();
        for (i = 0; i < places.size(); ++i) {
            placesMap.put(places.get(i), i);
        }
        for (i = 0; i < transitions.size(); ++i) {
            transitionsMap.put(transitions.get(i), i);
        }
        ArrayList<ArrayList<Integer>> globalIncidenceMatrix = new ArrayList<ArrayList<Integer>>();
        for (int trans = 0; trans < transitions.size(); ++trans) {
            ArrayList<Integer> transRow = new ArrayList<Integer>();
            for (int place = 0; place < places.size(); ++place) {
                transRow.add(0);
            }
            globalIncidenceMatrix.add(transRow);
        }
        for (Arc oneArc : arcs) {
            int incidenceValue;
            int pPosition;
            int tPosition;
            if (oneArc.getArcType() != Arc.TypeOfArc.NORMAL) continue;
            if (oneArc.getStartNode().getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                tPosition = (Integer)transitionsMap.get(oneArc.getStartNode());
                pPosition = (Integer)placesMap.get(oneArc.getEndNode());
                incidenceValue = oneArc.getWeight();
            } else {
                tPosition = (Integer)transitionsMap.get(oneArc.getEndNode());
                pPosition = (Integer)placesMap.get(oneArc.getStartNode());
                incidenceValue = -1 * oneArc.getWeight();
            }
            int oldValue = globalIncidenceMatrix.get(tPosition).get(pPosition);
            if (oldValue != 0) {
                ArrayList<Integer> hiddenReadArc = new ArrayList<Integer>();
                hiddenReadArc.add(pPosition);
                hiddenReadArc.add(tPosition);
            }
            globalIncidenceMatrix.get(tPosition).set(pPosition, oldValue + incidenceValue);
        }
        if (Tinv) {
            notePad = new HolmesNotepad(900, 600);
            notePad.setVisible(true);
            notePad.addTextLineNL("", "text");
            for (int t = 0; t < globalIncidenceMatrix.size(); ++t) {
                ArrayList<Integer> transRow = globalIncidenceMatrix.get(t);
                StringBuilder text = new StringBuilder("t" + t + " ");
                for (Integer integer : transRow) {
                    text.append(" ").append(integer);
                }
                notePad.addTextLineNL(text.toString(), "text");
            }
        } else {
            globalIncidenceMatrix = InvariantsTools.transposeMatrix(globalIncidenceMatrix);
            notePad = new HolmesNotepad(900, 600);
            notePad.setVisible(true);
            notePad.addTextLineNL("", "text");
            for (int p = 0; p < globalIncidenceMatrix.size(); ++p) {
                ArrayList<Integer> placeRow = globalIncidenceMatrix.get(p);
                StringBuilder text = new StringBuilder("p" + p + " ");
                for (Integer integer : placeRow) {
                    text.append(" ").append(integer);
                }
                notePad.addTextLineNL(text.toString(), "text");
            }
        }
    }

    protected void testReference(boolean t_inv) {
        ArrayList<ArrayList<Integer>> invariants = Check.invExistsWithWarning(t_inv);
        if (invariants == null) {
            return;
        }
        String lastPath = this.overlord.getLastPath();
        FileFilter[] filters = new FileFilter[]{t_inv ? new ExtensionFileFilter("INA t-nvariants file (.inv)", new String[]{"INV"}) : new ExtensionFileFilter("INA p-invariants file (.inv)", new String[]{"INV"})};
        String selectedFile = Tools.selectFileDialog(lastPath, filters, "Load invariants", "Select invariant file", "");
        if (selectedFile.equals("")) {
            return;
        }
        File file = new File(selectedFile);
        if (!file.exists()) {
            return;
        }
        IOprotocols io = new IOprotocols();
        boolean status = t_inv ? io.readT_invariants(file.getPath()) : io.readP_invariants(file.getPath());
        if (!status) {
            return;
        }
        this.refTest(invariants, io.getInvariantsList(), t_inv);
    }

    private void refTest(ArrayList<ArrayList<Integer>> invRefMatrix, ArrayList<ArrayList<Integer>> invLoadedMatrix, boolean t_inv) {
        if (invRefMatrix != null) {
            String symbol = "t-";
            if (!t_inv) {
                symbol = "p-";
            }
            ArrayList<ArrayList<Integer>> res = InvariantsTools.compareTwoInvariantsSets(invRefMatrix, invLoadedMatrix);
            this.accessLogField(t_inv).append("\n");
            this.accessLogField(t_inv).append("=====================================================================\n");
            this.accessLogField(t_inv).append("Prev. computed set size:   " + invRefMatrix.size() + "\n");
            this.accessLogField(t_inv).append("Loaded (now) set size:    " + invLoadedMatrix.size() + "\n");
            this.accessLogField(t_inv).append("Common set size (load & ref): " + res.get(0).size() + "\n");
            this.accessLogField(t_inv).append("Loaded " + symbol + "invariants not in a computed set:  " + res.get(1).size() + "\n");
            this.accessLogField(t_inv).append("Computed " + symbol + "invariants not in a loaded set:  " + res.get(2).size() + "\n");
            this.accessLogField(t_inv).append("Repetitions in common set: " + res.get(3).get(0) + "\n");
            this.accessLogField(t_inv).append("Total repetitions in loaded:" + res.get(3).get(1) + "\n");
            this.accessLogField(t_inv).append("\n");
            this.accessLogField(t_inv).append("Inititating further tests for the loaded set of " + invLoadedMatrix.size() + " " + symbol + "invariants.\n");
            int card = InvariantsTools.checkCanonity(invLoadedMatrix);
            this.accessLogField(t_inv).append("-> Non canonical " + symbol + "invariants found : " + card + "\n");
            int value = InvariantsTools.checkSupportMinimality(invLoadedMatrix);
            this.accessLogField(t_inv).append("-> Non support-minimal " + symbol + "invariants found: " + value + "\n");
            InvariantsCalculator ic = new InvariantsCalculator(true);
            ArrayList<ArrayList<Integer>> results = InvariantsTools.analyseInvariantDetails(ic.getCMatrix(), invLoadedMatrix, t_inv);
            this.accessLogField(t_inv).append(" " + symbol + "invariants (Cx = 0): " + results.get(0).get(0) + "\n");
            this.accessLogField(t_inv).append("Sur-" + symbol + "invariants (Cx > 0): " + results.get(0).get(1) + "\n");
            this.accessLogField(t_inv).append("Sun-" + symbol + "invariants (Cx < 0): " + results.get(0).get(2) + "\n");
            this.accessLogField(t_inv).append("Non-" + symbol + "invariants (Cx <=> 0): " + results.get(0).get(3) + "\n");
            this.accessLogField(t_inv).append("=====================================================================\n");
            this.accessLogField(t_inv).append("\n");
            if (this.detailsPinv) {
                this.showSubSurT_invInfo(results, invLoadedMatrix.size());
            }
        }
    }

    private void showSubSurT_invInfo(ArrayList<ArrayList<Integer>> results, int invMatrixSize) {
        int value;
        int p;
        int surPlaceMaxName = 0;
        int subPlaceMaxName = 0;
        ArrayList<Integer> surInvVector = results.get(1);
        ArrayList<Integer> subInvVector = results.get(2);
        ArrayList<Integer> noInvVector = results.get(3);
        HolmesNotepad notePad = new HolmesNotepad(900, 600);
        notePad.setVisible(true);
        notePad.addTextLineNL("", "text");
        notePad.addTextLineNL("Vectors analysed: " + invMatrixSize, "text");
        notePad.addTextLineNL("Canonical t-invariants: " + results.get(0).get(0), "text");
        notePad.addTextLineNL("Sur-t-invariants: " + results.get(0).get(1), "text");
        notePad.addTextLineNL("Sub-t-invariants: " + results.get(0).get(2), "text");
        notePad.addTextLineNL("Non t-invariants vectors: " + results.get(0).get(3), "text");
        notePad.addTextLineNL("", "text");
        ArrayList<Place> places = this.overlord.getWorkspace().getProject().getPlaces();
        int size = places.size();
        if (results.get(0).get(1) > 0 || results.get(0).get(2) > 0) {
            for (p = 0; p < size; ++p) {
                int nameSize;
                value = surInvVector.get(p);
                if (value != 0 && (nameSize = places.get(p).getName().length()) > surPlaceMaxName) {
                    surPlaceMaxName = nameSize;
                }
                if ((value = subInvVector.get(p).intValue()) == 0 || (nameSize = places.get(p).getName().length()) <= subPlaceMaxName) continue;
                subPlaceMaxName = nameSize;
            }
        }
        if (results.get(0).get(1) > 0) {
            notePad.addTextLineNL("Places for which sur-t-invariants leaves tokens (tokens>0) :", "text");
            notePad.addTextLineNL("(in parenthesis number of sur-t-invariants for each place):", "text");
            for (p = 0; p < size; ++p) {
                value = surInvVector.get(p);
                if (value == 0) continue;
                String line = "p_" + p + Tools.setToSize(places.get(p).getName(), surPlaceMaxName + 3, false) + ": " + value;
                notePad.addTextLineNL(line, "text");
            }
        }
        notePad.addTextLineNL("", "text");
        if (results.get(0).get(2) > 0) {
            notePad.addTextLineNL("Places for which sub-t-invariants takes tokens (tokens<0):", "text");
            notePad.addTextLineNL("(in parenthesis number of sub-t-invariants for each place):", "text");
            for (p = 0; p < size; ++p) {
                value = subInvVector.get(p);
                if (value == 0) continue;
                String line = "p_" + p + Tools.setToSize(places.get(p).getName(), subPlaceMaxName + 2, false) + ": " + value;
                notePad.addTextLineNL(line, "text");
            }
        }
        if (results.get(0).get(3) > 0) {
            notePad.addTextLineNL("Places for which non-invariants takes or produces tokens:", "text");
            notePad.addTextLineNL("(in parenthesis number of non-t-invariants for each place):", "text");
            for (p = 0; p < size; ++p) {
                value = noInvVector.get(p);
                if (value == 0) continue;
                String line = "p_" + p + Tools.setToSize(places.get(p).getName(), subPlaceMaxName + 2, false) + ": " + value;
                notePad.addTextLineNL(line, "text");
            }
        }
    }

    private void showSubSurP_invInfo(ArrayList<ArrayList<Integer>> results, int invMatrixSize) {
        int value;
        int t;
        int surTransMaxName = 0;
        int subTransMaxName = 0;
        ArrayList<Integer> surInvVector = results.get(1);
        ArrayList<Integer> subInvVector = results.get(2);
        ArrayList<Integer> noInvVector = results.get(3);
        HolmesNotepad notePad = new HolmesNotepad(900, 600);
        notePad.setVisible(true);
        notePad.addTextLineNL("", "text");
        notePad.addTextLineNL("Vectors analysed: " + invMatrixSize, "text");
        notePad.addTextLineNL("Canonical p-invariants: " + results.get(0).get(0), "text");
        notePad.addTextLineNL("Sur-p-invariants: " + results.get(0).get(1), "text");
        notePad.addTextLineNL("Sub-p-invariants: " + results.get(0).get(2), "text");
        notePad.addTextLineNL("Non p-invariants vectors: " + results.get(0).get(3), "text");
        notePad.addTextLineNL("", "text");
        ArrayList<Transition> transitions = this.overlord.getWorkspace().getProject().getTransitions();
        int size = transitions.size();
        if (results.get(0).get(1) > 0 || results.get(0).get(2) > 0) {
            for (t = 0; t < size; ++t) {
                int nameSize;
                value = surInvVector.get(t);
                if (value != 0 && (nameSize = transitions.get(t).getName().length()) > surTransMaxName) {
                    surTransMaxName = nameSize;
                }
                if ((value = subInvVector.get(t).intValue()) == 0 || (nameSize = transitions.get(t).getName().length()) <= subTransMaxName) continue;
                subTransMaxName = nameSize;
            }
        }
        if (results.get(0).get(1) > 0) {
            notePad.addTextLineNL("Problematics transitions for sur-p-invariants:", "text");
            notePad.addTextLineNL("(in parenthesis number of sur-p-invariants for each transition):", "text");
            for (t = 0; t < size; ++t) {
                value = surInvVector.get(t);
                if (value == 0) continue;
                String line = "t_" + t + Tools.setToSize(transitions.get(t).getName(), surTransMaxName + 3, false) + ": " + value;
                notePad.addTextLineNL(line, "text");
            }
        }
        notePad.addTextLineNL("", "text");
        if (results.get(0).get(2) > 0) {
            notePad.addTextLineNL("Problematics transitions for sub-p-invariants:", "text");
            notePad.addTextLineNL("(in parenthesis number of sub-p-invariants for each transition):", "text");
            for (t = 0; t < size; ++t) {
                value = subInvVector.get(t);
                if (value == 0) continue;
                String line = "t_" + t + Tools.setToSize(transitions.get(t).getName(), subTransMaxName + 2, false) + ": " + value;
                notePad.addTextLineNL(line, "text");
            }
        }
        if (results.get(0).get(3) > 0) {
            notePad.addTextLineNL("Problematics transitions for non p-invariant vector:", "text");
            notePad.addTextLineNL("(in parenthesis number of non p-invariants for each transition):", "text");
            for (t = 0; t < size; ++t) {
                value = noInvVector.get(t);
                if (value == 0) continue;
                String line = "t_" + t + Tools.setToSize(transitions.get(t).getName(), subTransMaxName + 2, false) + ": " + value;
                notePad.addTextLineNL(line, "text");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAndMakeFeasible() {
        ArrayList<ArrayList<Integer>> invariants = Check.invExistsWithWarning(true);
        if (invariants == null) {
            return;
        }
        InvariantsCalculatorFeasible invF = new InvariantsCalculatorFeasible(invariants, true);
        invariants = invF.getMinFeasible(this.feasibleCalcMode);
        Object[] options = new Object[]{"Save & replace", "Save only", "Replace only", "Cancel"};
        int n = JOptionPane.showOptionDialog(null, "New (feasible) invariants set computed. What to do now?\nSave it to file and replace the current set.\nSave it to file only (do not replace current set).\nDo not save to file, only replace current set.\nDiscart new feasible invariants set.", "What to do?", 0, 3, null, options, options[3]);
        if (n == 0) {
            PetriNet project = this.overlord.getWorkspace().getProject();
            project.setT_InvMatrix(invariants, false);
            this.overlord.io.exportGeneratedInvariants(true);
            this.overlord.getT_invBox().showT_invBoxWindow(project.getT_InvMatrix());
            this.overlord.markNetChange();
        } else if (n == 1) {
            ArrayList<ArrayList<Integer>> invBackup = this.overlord.getWorkspace().getProject().getT_InvMatrix();
            try {
                this.overlord.getWorkspace().getProject().setT_InvMatrix(invariants, false);
                this.overlord.io.exportGeneratedInvariants(true);
            }
            catch (Exception ex) {
                GUIManager.getDefaultGUIManager().log("Error (453526573) | Exception:  " + ex.getMessage(), "error", true);
            }
            finally {
                this.overlord.getWorkspace().getProject().setT_InvMatrix(invBackup, false);
            }
        } else if (n == 2) {
            PetriNet project = this.overlord.getWorkspace().getProject();
            project.setT_InvMatrix(invariants, false);
            this.overlord.getT_invBox().showT_invBoxWindow(project.getT_InvMatrix());
            this.overlord.markNetChange();
        }
    }

    protected void showNotepadInvariants(boolean t_inv) {
        block6: {
            block5: {
                if (!t_inv) break block5;
                ArrayList<ArrayList<Integer>> t_invariants = this.overlord.getWorkspace().getProject().getT_InvMatrix();
                if (t_invariants == null) break block6;
                HolmesNotepad notePad = new HolmesNotepad(900, 600);
                notePad.setVisible(true);
                notePad.addTextLineNL("T-invariants:", "text");
                for (ArrayList<Integer> inv : t_invariants) {
                    StringBuilder vector = new StringBuilder();
                    for (int value : inv) {
                        vector.append(value).append(";");
                    }
                    vector = new StringBuilder(vector.substring(0, vector.length() - 1));
                    notePad.addTextLineNL(vector.toString(), "text");
                }
                break block6;
            }
            ArrayList<ArrayList<Integer>> p_invariants = this.overlord.getWorkspace().getProject().getP_InvMatrix();
            if (p_invariants != null) {
                HolmesNotepad notePad = new HolmesNotepad(900, 600);
                notePad.setVisible(true);
                notePad.addTextLineNL("P-invariants:", "text");
                for (ArrayList<Integer> inv : p_invariants) {
                    StringBuilder vector = new StringBuilder();
                    for (int value : inv) {
                        vector.append(value).append(";");
                    }
                    vector = new StringBuilder(vector.substring(0, vector.length() - 1));
                    notePad.addTextLineNL(vector.toString(), "text");
                }
            }
        }
    }

    public JTextArea accessLogField(boolean t_inv) {
        if (t_inv) {
            return this.accessLogFieldTinv();
        }
        return this.accessLogFieldPinv();
    }

    public JTextArea accessLogFieldTinv() {
        return this.logFieldTinv;
    }

    public JTextArea accessLogFieldPinv() {
        return this.logFieldPinv;
    }

    public void resetInvariantGenerator() {
        this.invGenerator = null;
        this.setGeneratorStatus(false);
    }

    public void setGeneratorStatus(boolean status) {
        this.isGeneratorWorking = status;
    }
}

