/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.darkgui.GUIManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.functions.FunctionContainer;
import holmes.petrinet.functions.FunctionsTools;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.tables.FunctionalTransAuxTableModel;
import holmes.tables.FunctionalTransTableModel;
import holmes.tables.FunctionalTransTableRenderer;
import holmes.utilities.Tools;
import holmes.windows.HolmesNotepad;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.nfunk.jep.JEP;

public class HolmesFunctionsBuilder
extends JFrame {
    private static final long serialVersionUID = 1235426932930026597L;
    private static final DecimalFormat formatter = new DecimalFormat("#.###");
    private Transition transition;
    private ArrayList<Place> places;
    private ArrayList<Arc> arcs;
    private GUIManager overlord = GUIManager.getDefaultGUIManager();
    private PetriNet pn = this.overlord.getWorkspace().getProject();
    private boolean mainSimulatorActive;
    private JTable tableFunc;
    private FunctionalTransTableModel tableFuncModel;
    private JTextField idField;
    private JTextField functionField;
    private JCheckBox enabledCheckBox;
    private JButton validateButton;
    private JTextField currentResult;
    private JTextArea commentField;

    public HolmesFunctionsBuilder(Transition trans) {
        this.transition = trans;
        this.places = this.pn.getPlaces();
        this.arcs = this.pn.getArcs();
        this.setTitle("Transition: " + trans.getName());
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (282969598) | Exception:  " + ex.getMessage(), "error", true);
        }
        if (GUIManager.getDefaultGUIManager().getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
            this.mainSimulatorActive = true;
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesFunctionsBuilder.this.overlord.getFrame().setEnabled(true);
            }
        });
        if (this.places.size() == 0) {
            JOptionPane.showMessageDialog(null, "At least one places required.", "Error: to few places", 0);
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (this.mainSimulatorActive) {
            JOptionPane.showMessageDialog(null, "Function editor unavailable when simulator is working.", "Error: simulation in progress", 0);
            this.dispatchEvent(new WindowEvent(this, 201));
        } else {
            this.overlord.getFrame().setEnabled(false);
            this.setResizable(false);
            this.initializeComponents();
            this.setVisible(true);
        }
    }

    private void initializeComponents() {
        this.setLocation(20, 20);
        this.setSize(new Dimension(900, 650));
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel tablePanel = this.createTablePanel();
        mainPanel.add((Component)tablePanel, "North");
        mainPanel.add((Component)this.createAuxPanel(), "Center");
        this.add(mainPanel);
    }

    private JPanel createAuxPanel() {
        JPanel resultPanel = new JPanel(new BorderLayout());
        resultPanel.setPreferredSize(new Dimension(900, 400));
        resultPanel.add((Component)this.createBuilderPanel(), "North");
        resultPanel.add((Component)this.createPlacesTablePanel(), "Center");
        return resultPanel;
    }

    private JPanel createBuilderPanel() {
        JPanel resultPanel = new JPanel(null);
        resultPanel.setPreferredSize(new Dimension(900, 160));
        resultPanel.setBorder(BorderFactory.createTitledBorder("Function builder"));
        int posX = 15;
        int posY = 15;
        JLabel labelID = new JLabel("ID:");
        labelID.setBounds(posX, posY, 50, 20);
        resultPanel.add(labelID);
        this.idField = new JTextField();
        this.idField.setBounds(posX, posY + 20, 60, 20);
        this.idField.setEditable(false);
        resultPanel.add(this.idField);
        JLabel labelFunction = new JLabel("Function edit field:");
        labelFunction.setBounds(posX + 65, posY, 150, 20);
        resultPanel.add(labelFunction);
        this.functionField = new JTextField();
        this.functionField.setBounds(posX + 65, posY + 20, 350, 20);
        resultPanel.add(this.functionField);
        JLabel labelEnable = new JLabel("Enabled?");
        labelEnable.setBounds(posX + 420, posY, 60, 20);
        resultPanel.add(labelEnable);
        this.enabledCheckBox = new JCheckBox("");
        this.enabledCheckBox.setBounds(posX + 435, posY + 20, 40, 20);
        resultPanel.add(this.enabledCheckBox);
        JLabel resultLabel = new JLabel("Result:");
        resultLabel.setBounds(posX + 490, posY, 80, 20);
        resultPanel.add(resultLabel);
        this.currentResult = new JTextField();
        this.currentResult.setBounds(posX + 490, posY + 20, 110, 20);
        resultPanel.add(this.currentResult);
        this.validateButton = new JButton(Tools.getResIcon16("/icons/functionsWindow/addFIcon.png"));
        this.validateButton.setText("Check and add");
        this.validateButton.setToolTipText("Validate the equation and add it to transition functions list");
        this.validateButton.setMargin(new Insets(0, 0, 0, 0));
        this.validateButton.setBounds(posX + 650, posY + 20, 120, 22);
        this.validateButton.addActionListener(actionEvent -> this.addFunctionAction());
        resultPanel.add(this.validateButton);
        JButton clearButton = new JButton(Tools.getResIcon16("/icons/functionsWindow/removeFIcon.png"));
        clearButton.setText("Clear function");
        clearButton.setToolTipText("Clear the equation from the list");
        clearButton.setMargin(new Insets(0, 0, 0, 0));
        clearButton.setBounds(posX + 650, posY + 50, 120, 22);
        clearButton.addActionListener(actionEvent -> {
            int row = this.tableFunc.getSelectedRow();
            if (row == -1) {
                return;
            }
            String fID = (String)this.tableFunc.getValueAt(row, 0);
            FunctionContainer container = this.transition.fpnExtension.getFunctionContainer(fID);
            container.simpleExpression = "";
            container.correct = false;
            container.enabled = false;
            this.tableFunc.getModel().setValueAt("", row, 2);
            this.tableFunc.getModel().setValueAt(false, row, 3);
            this.tableFunc.getModel().setValueAt(false, row, 6);
            this.tableFuncModel.fireTableDataChanged();
            this.idField.setText("");
            this.functionField.setText("");
            this.enabledCheckBox.setSelected(false);
            this.currentResult.setText("");
            this.commentField.setText("");
            this.overlord.markNetChange();
        });
        resultPanel.add(clearButton);
        JButton helpButton = new JButton(Tools.getResIcon16("/icons/functionsWindow/helpIcon.png"));
        helpButton.setText("<html>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Help&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</html>");
        helpButton.setToolTipText("Show list of operations and functions");
        helpButton.setMargin(new Insets(0, 0, 0, 0));
        helpButton.setBounds(posX + 650, posY + 80, 120, 22);
        helpButton.addActionListener(actionEvent -> this.helpNotepad());
        resultPanel.add(helpButton);
        JCheckBox functionalActiveButton = new JCheckBox("Functional transition");
        functionalActiveButton.setBounds(posX + 650, posY + 110, 150, 20);
        functionalActiveButton.setSelected(this.transition.fpnExtension.isFunctional());
        functionalActiveButton.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.transition.fpnExtension.setFunctional(abstractButton.getModel().isSelected());
            this.pn.repaintAllGraphPanels();
            this.overlord.markNetChange();
        });
        resultPanel.add(functionalActiveButton);
        JLabel errLabel = new JLabel("Error log:", 2);
        errLabel.setBounds(posX, posY += 40, 140, 20);
        resultPanel.add(errLabel);
        this.commentField = new JTextArea();
        this.commentField.setLineWrap(true);
        this.commentField.setEditable(false);
        JPanel errorSubPanel = new JPanel();
        errorSubPanel.setLayout(new BorderLayout());
        errorSubPanel.add((Component)new JScrollPane(this.commentField), "Center");
        errorSubPanel.setBounds(posX, posY += 20, 600, 70);
        resultPanel.add(errorSubPanel);
        return resultPanel;
    }

    protected void helpNotepad() {
        HolmesNotepad notePad = new HolmesNotepad(640, 500);
        notePad.setVisible(true);
        notePad.addTextLineNL("Arithemic and logic operators:", "text");
        notePad.addTextLineNL("", "text");
        notePad.addTextLineNL("                                      |Double |Complex|String |Vector|", "text");
        notePad.addTextLineNL(" Power                         ^      |   X   |   X   |       |      |", "text");
        notePad.addTextLineNL(" Boolean Not                   !      |   X   |       |       |      |", "text");
        notePad.addTextLineNL(" Unary Plus, Unary Minus       +x, -x |   X   |   X   |       |      |", "text");
        notePad.addTextLineNL(" Modulus                       %      |   X   |       |       |      |", "text");
        notePad.addTextLineNL(" Division                      /      |   X   |   X   |       |   X  |", "text");
        notePad.addTextLineNL(" Multiplication                *      |   X   |   X   |       |   X  |", "text");
        notePad.addTextLineNL(" Addition, Subtraction         +, -   |   X   |   X   |   X   |      |", "text");
        notePad.addTextLineNL(" Less of Equal, More or Equal  <=, >= |   X   |       |       |      |", "text");
        notePad.addTextLineNL(" Less than, Greater than       <, >   |   X   |       |       |      |", "text");
        notePad.addTextLineNL(" Not Equal, Equal              !=, == |   X   |   X   |   X   |      |", "text");
        notePad.addTextLineNL(" Boolean And                   &&     |   X   |       |       |      |", "text");
        notePad.addTextLineNL(" Boolean Or                    ||     |   X   |       |       |      |", "text");
        notePad.addTextLineNL("                                                                     ", "text");
        notePad.addTextLineNL("", "text");
        notePad.addTextLineNL(" Mathematical functions table:", "text");
        notePad.addTextLineNL("                                      |Double |Complex|", "text");
        notePad.addTextLineNL(" Sine                        sin()    |   X   |   X   |", "text");
        notePad.addTextLineNL(" Cosine                      cos()    |   X   |   X   |", "text");
        notePad.addTextLineNL(" Tangent                     tan()    |   X   |   X   |", "text");
        notePad.addTextLineNL(" Arc Sine                    asin()   |   X   |   X   |", "text");
        notePad.addTextLineNL(" Arc Cosine                  acos()   |   X   |   X   |", "text");
        notePad.addTextLineNL(" Arc Tangent                 atan()   |   X   |   X   |", "text");
        notePad.addTextLineNL(" Hyperbolic Sine             sinh()   |   X   |   X   |", "text");
        notePad.addTextLineNL(" Hyperbolic Cosine           cosh()   |   X   |   X   |", "text");
        notePad.addTextLineNL(" Hyperbolic Tangent          tanh()   |   X   |   X   |", "text");
        notePad.addTextLineNL(" Inverse Hyperbolic Sine     asinh()  |   X   |   X   |", "text");
        notePad.addTextLineNL(" Inverse Hyperbolic Cosine   acosh()  |   X   |   X   |", "text");
        notePad.addTextLineNL(" Inverse Hyperbolic Tangent  atanh()  |   X   |   X   |", "text");
        notePad.addTextLineNL(" Natural Logarithm           ln()     |   X   |   X   |", "text");
        notePad.addTextLineNL(" Logarithm base 10           log()    |   X   |   X   |", "text");
        notePad.addTextLineNL(" Angle                       angle()  |   X   |       |", "text");
        notePad.addTextLineNL(" Absolute Value / Magnitude  abs()    |   X   |   X   |", "text");
        notePad.addTextLineNL(" Random number (between 0-1) rand()   |       |       |", "text");
        notePad.addTextLineNL(" Modulus                     mod()    |   X   |       |", "text");
        notePad.addTextLineNL(" Square Root                 sqrt()   |   X   |   X   |", "text");
        notePad.addTextLineNL(" Sum                         sum()    |   X   |       |", "text");
        notePad.addTextLineNL("               Complex numbers arythmetic:             ", "text");
        notePad.addTextLineNL(" Real Component              re()     |       |   X   |", "text");
        notePad.addTextLineNL(" Imaginary Component         im()     |       |   X   |", "text");
        notePad.setCaretFirstLine();
    }

    private void addFunctionAction() {
        int row = this.tableFunc.getSelectedRow();
        if (row == -1) {
            return;
        }
        this.commentField.setText("");
        this.currentResult.setText("");
        String fID = (String)this.tableFunc.getValueAt(row, 0);
        boolean enabled = this.enabledCheckBox.isSelected();
        FunctionContainer container = this.transition.fpnExtension.getFunctionContainer(fID);
        boolean correct = FunctionsTools.validateFunction(container, this.functionField.getText(), false, this.commentField, this.places);
        if (!correct) {
            enabled = false;
        }
        this.transition.fpnExtension.updateFunctionString(fID, container.simpleExpression, correct, enabled);
        this.tableFunc.getModel().setValueAt(container.simpleExpression, row, 2);
        this.tableFunc.getModel().setValueAt(correct, row, 3);
        this.tableFunc.getModel().setValueAt(enabled, row, 6);
        JEP myParser = new JEP();
        myParser.addStandardFunctions();
        for (String key : container.involvedPlaces.keySet()) {
            Place place = container.involvedPlaces.get(key);
            myParser.addVariable(key, place.getTokensNumber());
        }
        myParser.parseExpression(container.simpleExpression);
        double result = myParser.getValue();
        if (Double.valueOf(result).isNaN()) {
            this.currentResult.setText("Not-A-Number");
            container.correct = false;
            container.enabled = false;
            this.tableFunc.getModel().setValueAt(container.correct, row, 3);
            this.tableFunc.getModel().setValueAt(container.enabled, row, 6);
        } else {
            this.currentResult.setText(formatter.format(result));
        }
        this.tableFuncModel.fireTableDataChanged();
        this.tableFunc.setRowSelectionInterval(row, row);
        this.overlord.markNetChange();
    }

    private JPanel createTablePanel() {
        JPanel tablesSubPanel = new JPanel(new BorderLayout());
        tablesSubPanel.setPreferredSize(new Dimension(640, 200));
        tablesSubPanel.setLocation(0, 0);
        tablesSubPanel.setBorder(BorderFactory.createTitledBorder("Tables:"));
        this.tableFuncModel = new FunctionalTransTableModel();
        this.tableFunc = new JTable(this.tableFuncModel);
        this.tableFunc.getColumnModel().getColumn(0).setHeaderValue("fID");
        this.tableFunc.getColumnModel().getColumn(0).setPreferredWidth(70);
        this.tableFunc.getColumnModel().getColumn(0).setMinWidth(70);
        this.tableFunc.getColumnModel().getColumn(0).setMaxWidth(70);
        this.tableFunc.getColumnModel().getColumn(1).setHeaderValue("Place name");
        this.tableFunc.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.tableFunc.getColumnModel().getColumn(1).setMinWidth(100);
        this.tableFunc.getColumnModel().getColumn(2).setHeaderValue("Function");
        this.tableFunc.getColumnModel().getColumn(2).setPreferredWidth(300);
        this.tableFunc.getColumnModel().getColumn(2).setMinWidth(100);
        this.tableFunc.getColumnModel().getColumn(3).setHeaderValue("Correct");
        this.tableFunc.getColumnModel().getColumn(3).setPreferredWidth(60);
        this.tableFunc.getColumnModel().getColumn(3).setMinWidth(60);
        this.tableFunc.getColumnModel().getColumn(3).setMaxWidth(60);
        this.tableFunc.getColumnModel().getColumn(4).setHeaderValue("Arc type");
        this.tableFunc.getColumnModel().getColumn(4).setPreferredWidth(80);
        this.tableFunc.getColumnModel().getColumn(4).setMinWidth(80);
        this.tableFunc.getColumnModel().getColumn(4).setMaxWidth(80);
        this.tableFunc.getColumnModel().getColumn(5).setHeaderValue("Weight");
        this.tableFunc.getColumnModel().getColumn(5).setPreferredWidth(50);
        this.tableFunc.getColumnModel().getColumn(5).setMinWidth(50);
        this.tableFunc.getColumnModel().getColumn(5).setMaxWidth(50);
        this.tableFunc.getColumnModel().getColumn(6).setHeaderValue("Enabled");
        this.tableFunc.getColumnModel().getColumn(6).setPreferredWidth(60);
        this.tableFunc.getColumnModel().getColumn(6).setMinWidth(60);
        this.tableFunc.getColumnModel().getColumn(6).setMaxWidth(60);
        FunctionalTransTableRenderer tableRenderer = new FunctionalTransTableRenderer(this.tableFunc);
        this.tableFunc.setDefaultRenderer(Object.class, tableRenderer);
        this.tableFunc.setDefaultRenderer(Integer.class, tableRenderer);
        this.tableFunc.setDefaultRenderer(Boolean.class, tableRenderer);
        this.tableFunc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isControlDown()) {
                    HolmesFunctionsBuilder.this.cellClickedFuncTable();
                }
            }
        });
        this.transition.fpnExtension.checkFunctions(this.arcs, this.places);
        ArrayList<FunctionContainer> fVector = this.transition.fpnExtension.accessFunctionsList();
        for (FunctionContainer fc : fVector) {
            if (!fc.inTransArc) continue;
            this.tableFuncModel.addNew(fc.fID, fc.arc.getStartNode().getName(), fc.simpleExpression, fc.correct, fc.arc.getArcType(), fc.arc.getWeight(), fc.enabled);
        }
        for (FunctionContainer fc : fVector) {
            if (fc.inTransArc) continue;
            this.tableFuncModel.addNew(fc.fID, fc.arc.getEndNode().getName(), fc.simpleExpression, fc.correct, fc.arc.getArcType(), fc.arc.getWeight(), fc.enabled);
        }
        this.tableFunc.setAutoResizeMode(4);
        JScrollPane tableScrollPane = new JScrollPane(this.tableFunc, 20, 30);
        tablesSubPanel.add((Component)tableScrollPane, "Center");
        return tablesSubPanel;
    }

    protected void cellClickedFuncTable() {
        int row = this.tableFunc.getSelectedRow();
        if (row > -1) {
            Arc.TypeOfArc type = (Arc.TypeOfArc)((Object)this.tableFunc.getValueAt(row, 4));
            if (type == Arc.TypeOfArc.NORMAL) {
                this.functionField.setEnabled(true);
                this.enabledCheckBox.setEnabled(true);
                this.validateButton.setEnabled(true);
                this.currentResult.setEnabled(true);
                String ID = (String)this.tableFunc.getValueAt(row, 0);
                String function = (String)this.tableFunc.getValueAt(row, 2);
                boolean enabled = (Boolean)this.tableFunc.getValueAt(row, 6);
                this.idField.setText(ID);
                this.functionField.setText(function);
                this.enabledCheckBox.setSelected(enabled);
            } else {
                this.functionField.setEnabled(false);
                this.enabledCheckBox.setEnabled(false);
                this.validateButton.setEnabled(false);
                this.currentResult.setEnabled(false);
                this.functionField.setText("Function possible only for a normal arc");
                this.enabledCheckBox.setSelected(false);
            }
        }
    }

    private JPanel createPlacesTablePanel() {
        JPanel resultPanel = new JPanel(new BorderLayout());
        resultPanel.setPreferredSize(new Dimension(900, 200));
        resultPanel.setBorder(BorderFactory.createTitledBorder("Places table for selection"));
        FunctionalTransAuxTableModel auxTableModel = new FunctionalTransAuxTableModel();
        JTable auxTable = new JTable(auxTableModel);
        auxTable.getColumnModel().getColumn(0).setHeaderValue("ID");
        auxTable.getColumnModel().getColumn(0).setPreferredWidth(40);
        auxTable.getColumnModel().getColumn(0).setMinWidth(40);
        auxTable.getColumnModel().getColumn(0).setMaxWidth(40);
        auxTable.getColumnModel().getColumn(1).setHeaderValue("Tokens");
        auxTable.getColumnModel().getColumn(1).setPreferredWidth(60);
        auxTable.getColumnModel().getColumn(1).setMinWidth(60);
        auxTable.getColumnModel().getColumn(1).setMaxWidth(60);
        auxTable.getColumnModel().getColumn(2).setHeaderValue("Place name:");
        auxTable.getColumnModel().getColumn(2).setMinWidth(100);
        auxTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 1 || !e.isControlDown()) {
                    // empty if block
                }
            }
        });
        int index = 0;
        for (Place place : this.places) {
            auxTableModel.addNew("p" + index, "" + place.getTokensNumber(), place.getName().replace("_", " "));
            ++index;
        }
        auxTable.setAutoResizeMode(4);
        JScrollPane auxTableScrollPane = new JScrollPane(auxTable, 20, 30);
        resultPanel.add((Component)auxTableScrollPane, "Center");
        return resultPanel;
    }
}

