/*
 * Decompiled with CFR 0.152.
 */
package holmes.varia;

import holmes.darkgui.GUIManager;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Transition;
import holmes.workspace.WorkspaceSheet;
import java.awt.Dimension;
import java.awt.Point;
import java.util.ArrayList;

public class NetworkTransformations {
    public void extendNetwork(boolean magnify) {
        ArrayList<Node> nodes = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes();
        ArrayList<ArrayList<Integer>> sheetsToChange = this.prepareChangeMatrix();
        for (Node node : nodes) {
            for (ElementLocation el : node.getElementLocations()) {
                Point oldOne = el.getPosition();
                double x = oldOne.getX();
                double y = oldOne.getY();
                if (magnify) {
                    x *= 1.1;
                    y *= 1.1;
                } else {
                    x /= 1.1;
                    y /= 1.1;
                }
                int sheetID = GUIManager.getDefaultGUIManager().IDtoIndex(el.getSheetID());
                if ((double)sheetsToChange.get(sheetID).get(1).intValue() < x) {
                    sheetsToChange.get(sheetID).set(0, sheetID);
                    sheetsToChange.get(sheetID).set(1, (int)x);
                }
                if ((double)sheetsToChange.get(sheetID).get(2).intValue() < y) {
                    sheetsToChange.get(sheetID).set(0, sheetID);
                    sheetsToChange.get(sheetID).set(2, (int)y);
                }
                el.getPosition().setLocation(x, y);
                if (!(node instanceof Transition)) continue;
                for (Arc arc : el.getInArcs()) {
                    arc.updateAllBreakPointsLocationsNetExtension(magnify);
                }
                for (Arc arc : el.getOutArcs()) {
                    arc.updateAllBreakPointsLocationsNetExtension(magnify);
                }
            }
        }
        for (ArrayList arrayList : sheetsToChange) {
            if ((Integer)arrayList.get(0) <= -1) continue;
            GraphPanel gp = GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get((Integer)arrayList.get(0)).getGraphPanel();
            gp.setOriginSize(new Dimension((Integer)arrayList.get(1) + 100, (Integer)arrayList.get(2) + 100));
            gp.setSize(new Dimension((Integer)arrayList.get(1) + 100, (Integer)arrayList.get(2) + 100));
            GUIManager.getDefaultGUIManager().getWorkspace().getSheets().get((Integer)arrayList.get(0)).getContainerPanel().setSize(new Dimension((Integer)arrayList.get(1) + 100, (Integer)arrayList.get(2) + 100));
        }
        this.alignNetToGrid();
        GUIManager.getDefaultGUIManager().getWorkspace().getProject().repaintAllGraphPanels();
    }

    public void alignNetToGrid() {
        ArrayList<Node> nodes = GUIManager.getDefaultGUIManager().getWorkspace().getProject().getNodes();
        for (Node n : nodes) {
            for (ElementLocation el : n.getElementLocations()) {
                Point oldXY = el.getPosition();
                el.setPosition(NetworkTransformations.alignToGrid(oldXY));
                for (Arc arc : el.getInArcs()) {
                    arc.alignBreakPoints();
                }
                for (Arc arc : el.getOutArcs()) {
                    arc.alignBreakPoints();
                }
            }
        }
    }

    public static Point alignToGrid(Point coordinates) {
        int x = coordinates.x;
        int y = coordinates.y;
        int deviationX = x % 20;
        x = deviationX <= 10 ? (x -= deviationX) : (x += 20 - deviationX);
        int deviationY = y % 20;
        y = deviationY <= 10 ? (y -= deviationY) : (y += 20 - deviationY);
        if (x == 0) {
            x = 20;
        }
        if (y == 0) {
            y = 20;
        }
        return new Point(x, y);
    }

    private ArrayList<ArrayList<Integer>> prepareChangeMatrix() {
        ArrayList<ArrayList<Integer>> sheetsToChange = new ArrayList<ArrayList<Integer>>();
        ArrayList<WorkspaceSheet> sheets = GUIManager.getDefaultGUIManager().getWorkspace().getSheets();
        for (int i = 0; i < sheets.size(); ++i) {
            ArrayList<Integer> points = new ArrayList<Integer>();
            points.add(-1);
            points.add(-1);
            points.add(-1);
            sheetsToChange.add(points);
        }
        return sheetsToChange;
    }
}

