/*
 * Decompiled with CFR 0.152.
 */
package holmes.varia;

import holmes.analyse.InvariantsTools;
import holmes.darkgui.GUIManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public final class Check {
    private static GUIManager overlord = GUIManager.getDefaultGUIManager();

    private Check() {
    }

    public static ArrayList<ArrayList<Integer>> invExists(boolean t_inv) {
        ArrayList<ArrayList<Integer>> invariants = t_inv ? GUIManager.getDefaultGUIManager().getWorkspace().getProject().getT_InvMatrix() : GUIManager.getDefaultGUIManager().getWorkspace().getProject().getP_InvMatrix();
        if (invariants == null || invariants.size() < 1) {
            return null;
        }
        return invariants;
    }

    public static ArrayList<ArrayList<Integer>> invExistsWithWarning(boolean t_inv) {
        ArrayList<ArrayList<Integer>> invariants = Check.invExists(t_inv);
        String symbol = "T-";
        if (!t_inv) {
            symbol = "P-";
        }
        if (invariants == null) {
            JOptionPane.showMessageDialog(null, symbol + "invariants matrix empty! Operation cannot start.", "Warning", 2);
            return null;
        }
        return invariants;
    }

    public static ArrayList<Integer> getArcClassCount() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int normal = 0;
        int readArc = 0;
        int inhibitor = 0;
        int reset = 0;
        int equal = 0;
        int meta = 0;
        int doubleArc = 0;
        int xtpnArc = 0;
        ArrayList<Arc> arcs = overlord.getWorkspace().getProject().getArcs();
        for (Arc a : arcs) {
            if (a.getArcType() == Arc.TypeOfArc.NORMAL) {
                if (InvariantsTools.isDoubleArc(a)) {
                    ++doubleArc;
                    continue;
                }
                ++normal;
                continue;
            }
            if (a.getArcType() == Arc.TypeOfArc.READARC) {
                ++readArc;
                continue;
            }
            if (a.getArcType() == Arc.TypeOfArc.INHIBITOR) {
                ++inhibitor;
                continue;
            }
            if (a.getArcType() == Arc.TypeOfArc.RESET) {
                ++reset;
                continue;
            }
            if (a.getArcType() == Arc.TypeOfArc.EQUAL) {
                ++equal;
                continue;
            }
            if (a.getArcType() != Arc.TypeOfArc.META_ARC) continue;
            ++meta;
        }
        result.add(normal);
        result.add(readArc);
        result.add(inhibitor);
        result.add(reset);
        result.add(equal);
        result.add(doubleArc);
        result.add(meta);
        result.add(xtpnArc);
        return result;
    }

    public static ArrayList<Integer> identifyNetElements() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        ArrayList<Node> nodes = overlord.getWorkspace().getProject().getNodes();
        int places = 0;
        int tTrans = 0;
        int trans = 0;
        int meta = 0;
        int functions = 0;
        int stochastics = 0;
        int placesXTPN = 0;
        int transitionsXTPN = 0;
        for (Node node : nodes) {
            if (node.getType() == PetriNetElement.PetriNetElementType.PLACE) {
                ++places;
                if (!(node instanceof PlaceXTPN)) continue;
                ++placesXTPN;
                continue;
            }
            if (node.getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                ++trans;
                if (((Transition)node).getTransType() == Transition.TransitionType.TPN) {
                    ++tTrans;
                }
                if (((Transition)node).fpnExtension.isFunctional()) {
                    ++functions;
                }
                if (((Transition)node).getTransType() == Transition.TransitionType.XTPN) {
                    ++transitionsXTPN;
                }
                if (((Transition)node).getTransType() != Transition.TransitionType.SPN) continue;
                ++stochastics;
                continue;
            }
            if (node.getType() != PetriNetElement.PetriNetElementType.META) continue;
            ++meta;
        }
        result.add(places);
        result.add(trans);
        result.add(tTrans);
        result.add(meta);
        result.add(functions);
        result.add(stochastics);
        result.add(placesXTPN);
        result.add(transitionsXTPN);
        return result;
    }

    public static boolean isHierarchical() {
        ArrayList<Node> nodes = overlord.getWorkspace().getProject().getNodes();
        for (Node node : nodes) {
            if (node.getType() != PetriNetElement.PetriNetElementType.META) continue;
            return true;
        }
        return false;
    }

    public static PetriNet.GlobalNetType getSuggestedNetType() {
        ArrayList<Integer> netElements = Check.identifyNetElements();
        ArrayList<Integer> arcClasses = Check.getArcClassCount();
        int placesXTPN = netElements.get(6);
        int transitionsXTPN = netElements.get(7);
        if (placesXTPN > 0 || transitionsXTPN > 0) {
            return PetriNet.GlobalNetType.XTPN;
        }
        int places = netElements.get(0);
        int transitions = netElements.get(1);
        int timeTransitions = netElements.get(2);
        int functionalTransitions = netElements.get(4);
        int stochasticTransitions = netElements.get(5);
        int inhibitorArc = arcClasses.get(2);
        int resetA = arcClasses.get(3);
        int equalArc = arcClasses.get(4);
        boolean extMarker = false;
        if (inhibitorArc > 0 || resetA > 0 || equalArc > 0) {
            extMarker = true;
        }
        if (timeTransitions == 0 && functionalTransitions == 0) {
            if (functionalTransitions > 0) {
                if (extMarker) {
                    return PetriNet.GlobalNetType.FPN_extArcs;
                }
                return PetriNet.GlobalNetType.FPN;
            }
            if (extMarker) {
                return PetriNet.GlobalNetType.PN_extArcs;
            }
            return PetriNet.GlobalNetType.PN;
        }
        if (timeTransitions > 0) {
            if (functionalTransitions > 0) {
                if (extMarker) {
                    return PetriNet.GlobalNetType.timeFPN_extArcs;
                }
                return PetriNet.GlobalNetType.timeFPN;
            }
            if (extMarker) {
                return PetriNet.GlobalNetType.TPN_extArcs;
            }
            return PetriNet.GlobalNetType.TPN;
        }
        if (functionalTransitions > 0) {
            if (extMarker) {
                return PetriNet.GlobalNetType.FPN_extArcs;
            }
            return PetriNet.GlobalNetType.FPN;
        }
        return null;
    }

    public static PetriNet.GlobalFileNetType suggestesFileFormat(PetriNet.GlobalNetType netType) {
        return switch (netType) {
            case PetriNet.GlobalNetType.PN -> PetriNet.GlobalFileNetType.SPPED;
            case PetriNet.GlobalNetType.PN_extArcs -> PetriNet.GlobalFileNetType.SPEPT;
            case PetriNet.GlobalNetType.TPN -> PetriNet.GlobalFileNetType.SPTPT;
            case PetriNet.GlobalNetType.TPN_extArcs, PetriNet.GlobalNetType.FPN, PetriNet.GlobalNetType.timeFPN, PetriNet.GlobalNetType.FPN_extArcs, PetriNet.GlobalNetType.timeFPN_extArcs, PetriNet.GlobalNetType.SPN, PetriNet.GlobalNetType.functionalSPN -> PetriNet.GlobalFileNetType.HOLMESPROJECT;
            default -> null;
        };
    }

    public static String getNetName(PetriNet.GlobalNetType netType) {
        return switch (netType) {
            case PetriNet.GlobalNetType.PN -> "Classical Petri Net";
            case PetriNet.GlobalNetType.PN_extArcs -> "Extended Petri Net";
            case PetriNet.GlobalNetType.TPN -> "Time(d) Petri Net";
            case PetriNet.GlobalNetType.TPN_extArcs -> "Extended Time(d) Petri Net (hybrid)";
            case PetriNet.GlobalNetType.FPN -> "Functional Petri Net";
            case PetriNet.GlobalNetType.timeFPN -> "Time(d) Functional Petri Net (hybrid)";
            case PetriNet.GlobalNetType.FPN_extArcs -> "Extended Functional Petri Net";
            case PetriNet.GlobalNetType.timeFPN_extArcs -> "Extended Time(d) Functional Petri Net (VERY hybrid)";
            case PetriNet.GlobalNetType.SPN -> "Stochastic Petri Net";
            case PetriNet.GlobalNetType.functionalSPN -> "Stochastic Functional Petri Net (VERY hybrid)";
            default -> null;
        };
    }

    public static String getExtension(PetriNet.GlobalFileNetType netFileFormat) {
        return switch (netFileFormat) {
            default -> throw new IncompatibleClassChangeError();
            case PetriNet.GlobalFileNetType.SPEPT -> "SPEPT";
            case PetriNet.GlobalFileNetType.SPPED -> "SPPED";
            case PetriNet.GlobalFileNetType.SPTPT -> "SPTPT";
            case PetriNet.GlobalFileNetType.HOLMESPROJECT -> "project";
        };
    }
}

