/*
 * Decompiled with CFR 0.152.
 */
package holmes.utilities;

import holmes.darkgui.GUIManager;
import holmes.utilities.HolmesFileView;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public final class Tools {
    public static String lastExtension = "";

    private Tools() {
    }

    public static void copyFileByPath(String source, String target) throws IOException {
        int length;
        File file1 = new File(source);
        File file2 = new File(target);
        FileInputStream inStream = new FileInputStream(file1);
        FileOutputStream outStream = new FileOutputStream(file2);
        byte[] buffer = new byte[1024];
        while ((length = ((InputStream)inStream).read(buffer)) > 0) {
            ((OutputStream)outStream).write(buffer, 0, length);
        }
        ((InputStream)inStream).close();
        ((OutputStream)outStream).close();
    }

    public static void copyFileDirectly(File source, File target) {
        try {
            int length;
            FileInputStream inStream = new FileInputStream(source);
            FileOutputStream outStream = new FileOutputStream(target);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)inStream).read(buffer)) > 0) {
                ((OutputStream)outStream).write(buffer, 0, length);
            }
            ((InputStream)inStream).close();
            ((OutputStream)outStream).close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "I/O operation failed for reason unknown. You can now start panicking.\nHave a nice day!", "Critical error", 0);
        }
    }

    public static String selectFileDialog(String lastPath, FileFilter[] filter, String buttonText, String buttonToolTip, String suggestedFileName) {
        String resultPath;
        JFileChooser fc = lastPath == null ? new JFileChooser() : new JFileChooser(lastPath);
        fc.setFileView(new HolmesFileView());
        for (FileFilter fileFilter : filter) {
            fc.addChoosableFileFilter(fileFilter);
        }
        fc.setFileFilter(filter[0]);
        if (!buttonText.equals("")) {
            fc.setApproveButtonText(buttonText);
        }
        if (!buttonToolTip.equals("")) {
            fc.setApproveButtonToolTipText(buttonToolTip);
        }
        if (suggestedFileName.length() > 0) {
            fc.setSelectedFile(new File(suggestedFileName));
        }
        fc.setAcceptAllFileFilterUsed(false);
        int returnVal = fc.showDialog(fc, fc.getApproveButtonText());
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            resultPath = f.getPath();
        } else {
            resultPath = "";
        }
        lastExtension = fc.getFileFilter().getDescription().toLowerCase();
        return resultPath;
    }

    public static String selectNetSaveFileDialog(String lastPath, FileFilter[] filter, String buttonText, String buttonToolTip, String suggestedFileName) {
        String resultPath;
        JFileChooser fc = lastPath == null ? new JFileChooser() : new JFileChooser(lastPath);
        fc.setFileView(new HolmesFileView());
        for (FileFilter fileFilter : filter) {
            fc.addChoosableFileFilter(fileFilter);
        }
        fc.setFileFilter(filter[0]);
        if (!buttonText.equals("")) {
            fc.setApproveButtonText(buttonText);
        }
        if (!buttonToolTip.equals("")) {
            fc.setApproveButtonToolTipText(buttonToolTip);
        }
        if (suggestedFileName.length() > 0) {
            fc.setSelectedFile(new File(suggestedFileName));
        }
        fc.setAcceptAllFileFilterUsed(false);
        int returnVal = fc.showDialog(fc, fc.getApproveButtonText());
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            resultPath = f.getPath();
        } else {
            resultPath = "";
        }
        lastExtension = fc.getFileFilter().getDescription().toLowerCase();
        return resultPath;
    }

    public static String selectDirectoryDialog(String lastPath, String buttonText, String buttonToolTip) {
        int returnVal;
        String resultDir = "";
        JFileChooser fc = lastPath == null ? new JFileChooser() : (lastPath.equals("") ? new JFileChooser() : new JFileChooser(lastPath));
        fc.setFileView(new HolmesFileView());
        fc.setFileSelectionMode(1);
        fc.setAcceptAllFileFilterUsed(false);
        if (!buttonText.equals("")) {
            fc.setApproveButtonText(buttonText);
        }
        if (!buttonToolTip.equals("")) {
            fc.setApproveButtonToolTipText(buttonToolTip);
        }
        if ((returnVal = fc.showDialog(fc, fc.getApproveButtonText())) == 0) {
            resultDir = fc.getSelectedFile().getPath();
        }
        return resultDir;
    }

    public static String getFilePath(File x) {
        if (x == null) {
            return null;
        }
        String absolutePath = x.getAbsolutePath();
        String filePath = absolutePath.substring(0, absolutePath.lastIndexOf(File.separator));
        return filePath + "\\";
    }

    public static String getFileName(File x) {
        if (x == null) {
            return null;
        }
        String absolutePath = x.getAbsolutePath();
        String filePath = absolutePath.substring(absolutePath.lastIndexOf(File.separator));
        return filePath + "\\";
    }

    public static boolean ifExist(String path) {
        File tmp = new File(path);
        return tmp.exists();
    }

    public static ImageIcon getResIcon16(String resPath) {
        ImageIcon icon;
        try {
            icon = new ImageIcon(Tools.class.getResource(resPath));
        }
        catch (Exception e) {
            try {
                icon = new ImageIcon(Tools.class.getResource("/nullIcon16.png"));
            }
            catch (Exception e2) {
                icon = new ImageIcon();
            }
        }
        return icon;
    }

    public static ImageIcon getResIcon22(String resPath) {
        ImageIcon icon;
        try {
            icon = new ImageIcon(Tools.class.getResource(resPath));
        }
        catch (Exception e) {
            try {
                icon = new ImageIcon(Tools.class.getResource("/nullIcon22.png"));
            }
            catch (Exception e2) {
                icon = new ImageIcon();
            }
        }
        return icon;
    }

    public static ImageIcon getResIcon32(String resPath) {
        ImageIcon icon;
        try {
            icon = new ImageIcon(Tools.class.getResource(resPath));
        }
        catch (Exception e) {
            try {
                icon = new ImageIcon(Tools.class.getResource("/nullIcon32.png"));
            }
            catch (Exception e2) {
                icon = new ImageIcon();
            }
        }
        return icon;
    }

    public static ImageIcon getResIcon48(String resPath) {
        ImageIcon icon;
        try {
            icon = new ImageIcon(Tools.class.getResource(resPath));
        }
        catch (Exception e) {
            try {
                icon = new ImageIcon(Tools.class.getResource("/nullIcon48.png"));
            }
            catch (Exception e2) {
                icon = new ImageIcon();
            }
        }
        return icon;
    }

    public static Image getImageFromIcon(String resPath) {
        Image result;
        resPath = resPath.toLowerCase();
        try {
            ImageIcon icon = new ImageIcon(Tools.class.getResource(resPath));
            result = icon.getImage();
        }
        catch (Exception e) {
            try {
                ImageIcon icon = new ImageIcon(Tools.class.getResource("/nullIcon16.png"));
                result = icon.getImage();
            }
            catch (Exception e2) {
                System.out.println("CRITICAL EXCEPTION IN getImageFromIcon. No FAILSAFE IMAGE: /nullIcon16.png IN JAR");
                return null;
            }
        }
        return result;
    }

    public static String setToSize(String source, int size, boolean left) {
        if (size <= source.length()) {
            return source;
        }
        int oldSize = source.length();
        StringBuilder sourceBuilder = new StringBuilder(source);
        for (int i = 0; i < size - oldSize; ++i) {
            if (left) {
                sourceBuilder.insert(0, " ");
                continue;
            }
            sourceBuilder.append(" ");
        }
        source = sourceBuilder.toString();
        return source;
    }

    public static String cutValue(double value) {
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(GUIManager.getDefaultGUIManager().getLocale());
        otherSymbols.setDecimalSeparator('.');
        DecimalFormat df = new DecimalFormat("#.##", otherSymbols);
        return df.format(value);
    }

    public static String cutValueExt(double value, int howMany) {
        NumberFormat formatter = DecimalFormat.getInstance();
        formatter.setMinimumFractionDigits(2);
        formatter.setMaximumFractionDigits(howMany);
        formatter.setRoundingMode(RoundingMode.HALF_UP);
        return formatter.format(value).replace(",", ".");
    }

    public static int absolute(int i) {
        if (i < 0) {
            return -i;
        }
        return i;
    }

    public static boolean overwriteDecision(String selectedFilePath) {
        String name;
        int ind;
        File file = new File(selectedFilePath);
        if (file.exists() && (ind = (name = selectedFilePath).lastIndexOf("\\")) > 1) {
            name = name.substring(ind + 1);
            Object[] options = new Object[]{"Yes", "No"};
            int n = JOptionPane.showOptionDialog(null, "File " + name + " already exists.\nDo you want to overwrite it?", "File exists", 0, 3, null, options, options[1]);
            return n != 1;
        }
        return true;
    }

    public static String convertToCode(String line) {
        line = line.replace("\n", "#5475");
        line = line.replace(" ", "&nbsp;");
        return line;
    }

    public static String decodeString(String line) {
        line = line.replace("#5475", "\n");
        line = line.replace("&nbsp;", " ");
        return line;
    }

    private static long binomial(int n, int k) {
        if (k > n - k) {
            k = n - k;
        }
        long b = 1L;
        int i = 1;
        int m = n;
        while (i <= k) {
            b = b * (long)m / (long)i;
            ++i;
            --m;
        }
        return b;
    }

    public static String getTime(long milisecond) {
        String s;
        long minutes;
        String m;
        long seconds = milisecond /= 1000L;
        long hours = seconds / 3600L;
        String h = "" + hours;
        if (h.length() == 1) {
            h = "0" + h;
        }
        if ((m = "" + (minutes = (seconds -= hours * 3600L) / 60L)).length() == 1) {
            m = "0" + m;
        }
        if ((s = "" + (seconds -= minutes * 60L)).length() == 1) {
            s = "0" + s;
        }
        return h + ":" + m + ":" + s;
    }
}

