/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables.simKnock;

import holmes.petrinet.data.NetSimulationData;
import holmes.petrinet.elements.Transition;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class SimKnockTransTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -5809682023062187908L;
    private static final DecimalFormat formatter3 = new DecimalFormat("#.#####");
    private String[] columnNames = new String[]{"ID", "Transition name", "AvgF", "MinF", "MaxF", "noF", "stdDev", "S1 %", "S2 %", "S3 %", "S4 %", "S5 %"};
    private ArrayList<TransContainer> dataMatrix = new ArrayList();
    private int dataSize = 0;

    public void addNew(NetSimulationData data, int index, Transition t) {
        TransContainer tc = new TransContainer();
        tc.ID = index;
        tc.name = t != null ? t.getName() : "Transition " + index;
        if (data.disabledTotals.contains(index)) {
            tc.name = " <OFFLINE> " + tc.name;
        } else if (data.transFiringsAvg.get(index) == 0.0) {
            tc.name = " <KNOCKOUT> " + tc.name;
        }
        tc.firingAvg = data.transFiringsAvg.get(index);
        tc.firingMin = data.transFiringsMin.get(index);
        tc.firingMax = data.transFiringsMax.get(index);
        tc.noFiring = "" + data.transZeroFiring.get(index);
        tc.stdDev = data.transStdDev.get(index);
        tc.s1 = data.transWithinStdDev.get(index).get(0) * 100 / data.reps;
        tc.s2 = data.transWithinStdDev.get(index).get(1) * 100 / data.reps;
        tc.s3 = data.transWithinStdDev.get(index).get(2) * 100 / data.reps;
        tc.s4 = data.transWithinStdDev.get(index).get(3) * 100 / data.reps;
        tc.s5 = data.transWithinStdDev.get(index).get(4) * 100 / data.reps;
        this.dataMatrix.add(tc);
        ++this.dataSize;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.dataMatrix.isEmpty()) {
            return Object.class;
        }
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return switch (columnIndex) {
            case 0 -> this.dataMatrix.get((int)rowIndex).ID;
            case 1 -> this.dataMatrix.get((int)rowIndex).name;
            case 2 -> formatter3.format((Object)this.dataMatrix.get((int)rowIndex).firingAvg);
            case 3 -> formatter3.format((Object)this.dataMatrix.get((int)rowIndex).firingMin);
            case 4 -> formatter3.format((Object)this.dataMatrix.get((int)rowIndex).firingMax);
            case 5 -> this.dataMatrix.get((int)rowIndex).noFiring;
            case 6 -> this.dataMatrix.get((int)rowIndex).stdDev;
            case 7 -> this.dataMatrix.get((int)rowIndex).s1;
            case 8 -> this.dataMatrix.get((int)rowIndex).s2;
            case 9 -> this.dataMatrix.get((int)rowIndex).s3;
            case 10 -> this.dataMatrix.get((int)rowIndex).s4;
            case 11 -> this.dataMatrix.get((int)rowIndex).s5;
            default -> throw new IllegalArgumentException("Invalid column index");
        };
    }

    public static class TransContainer {
        public int ID;
        public String name;
        public double firingAvg;
        public double firingMin;
        public double firingMax;
        public String noFiring;
        public double stdDev;
        public double s1;
        public double s2;
        public double s3;
        public double s4;
        public double s5;
    }
}

