/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables.simKnock;

import holmes.petrinet.data.NetSimulationData;
import holmes.petrinet.elements.Transition;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class SimKnockTransCompTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -2454782753413053173L;
    public int tableType = 0;
    private String[] columnNames = new String[]{"ID", "Transition name", "AvgFRef", "stdDevRef", "AvgFKnock", "stdDevKnock", "diffPerc", "noF", "sig1", "sig2"};
    private ArrayList<TransCompContainer> dataMatrix = new ArrayList();
    private int dataSize = 0;

    public ArrayList<TransCompContainer> accessDataMatrix() {
        return this.dataMatrix;
    }

    public void addNew(NetSimulationData dataRef, NetSimulationData dataKnock, int index, Transition t) {
        TransCompContainer tc = new TransCompContainer();
        tc.ID = index;
        tc.name = t != null ? t.getName() : "Transition " + index;
        tc.firingAvgRef = dataRef.transFiringsAvg.get(index);
        tc.stdDevRef = dataRef.transStdDev.get(index);
        tc.firingAvgKnock = dataKnock.transFiringsAvg.get(index);
        tc.stdDevKnock = dataKnock.transStdDev.get(index);
        if (dataKnock.disabledTotals.contains(index)) {
            tc.name = " <OFFLINE> " + tc.name;
        } else if (dataKnock.transFiringsAvg.get(index) == 0.0) {
            tc.name = " <KNOCKOUT> " + tc.name;
        }
        tc.firingAvgPercDiff = 0.0;
        double diff = tc.firingAvgRef - tc.firingAvgKnock;
        if (tc.firingAvgRef != 0.0) {
            if ((diff = diff / tc.firingAvgRef * 100.0) < 0.0) {
                tc.firingAvgPercDiff = diff *= -1.0;
                tc.firingAvgPercDiff = (tc.firingAvgKnock - tc.firingAvgRef) * 100.0;
            } else {
                tc.firingAvgPercDiff = diff *= -1.0;
                tc.firingAvgPercDiff = (tc.firingAvgKnock - tc.firingAvgRef) * 100.0;
            }
            if (tc.firingAvgKnock == 0.0) {
                tc.firingAvgPercDiff = -999999.0;
            }
        } else {
            tc.firingAvgPercDiff = tc.firingAvgKnock == 0.0 ? Double.valueOf(999991.0) : Double.valueOf(999999.0);
        }
        tc.noFiringKnock = "" + dataKnock.transZeroFiring.get(index);
        tc.firingAvgKnock *= 100.0;
        tc.firingAvgRef *= 100.0;
        tc.signifLvl1 = tc.firingAvgRef > tc.firingAvgKnock ? (dataRef.transFiringsMin.get(index) > dataKnock.transFiringsMax.get(index) ? "OK" : "no") : (dataRef.transFiringsMax.get(index) < dataKnock.transFiringsMin.get(index) ? "OK" : "no");
        tc.signifLvl2 = tc.firingAvgRef > tc.firingAvgKnock ? (tc.firingAvgRef - tc.stdDevRef > tc.firingAvgKnock + tc.stdDevKnock ? "OK" : "no") : (tc.firingAvgRef + tc.stdDevRef < tc.firingAvgKnock - tc.stdDevKnock ? "OK" : "no");
        this.dataMatrix.add(tc);
        ++this.dataSize;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.dataMatrix.isEmpty()) {
            return Object.class;
        }
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return switch (columnIndex) {
            case 0 -> this.dataMatrix.get((int)rowIndex).ID;
            case 1 -> this.dataMatrix.get((int)rowIndex).name;
            case 2 -> this.dataMatrix.get((int)rowIndex).firingAvgRef;
            case 3 -> this.dataMatrix.get((int)rowIndex).stdDevRef;
            case 4 -> this.dataMatrix.get((int)rowIndex).firingAvgKnock;
            case 5 -> this.dataMatrix.get((int)rowIndex).stdDevKnock;
            case 6 -> this.dataMatrix.get((int)rowIndex).firingAvgPercDiff;
            case 7 -> this.dataMatrix.get((int)rowIndex).noFiringKnock;
            case 8 -> this.dataMatrix.get((int)rowIndex).signifLvl1;
            case 9 -> this.dataMatrix.get((int)rowIndex).signifLvl2;
            default -> throw new IllegalArgumentException("Invalid column index");
        };
    }

    public static class TransCompContainer {
        public int ID;
        public String name;
        public double firingAvgRef;
        public double stdDevRef;
        public double firingAvgKnock;
        public double stdDevKnock;
        public Double firingAvgPercDiff;
        public String noFiringKnock;
        public String signifLvl1;
        public String signifLvl2;
    }
}

