/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables.simKnock;

import holmes.tables.simKnock.SimKnockPlacesCompAllTableModel;
import holmes.tables.simKnock.SimKnockTransCompAllTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class SimKnockTableRenderer
implements TableCellRenderer {
    public DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();
    private JTable table;
    private static final DecimalFormat formatter6 = new DecimalFormat("#.#####");
    private static final DecimalFormat formatter3 = new DecimalFormat("#.####");
    private static final DecimalFormat formatter2 = new DecimalFormat("#.##");
    private static final DecimalFormat formatter1 = new DecimalFormat("#.#");
    private static final Font fontNormal = new Font("Verdana", 0, 12);
    private static final Font fontBold = new Font("Verdana", 1, 12);
    private static final Font fontNormal2 = new Font("Verdana", 0, 10);
    private static final Font fontBold2 = new Font("Verdana", 1, 10);
    private int mode = 0;

    public SimKnockTableRenderer(JTable table) {
        this.table = table;
    }

    public void setMode(int value) {
        this.mode = value;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.mode == 1) {
            return this.paintCellsCompTrans(table, value, isSelected, hasFocus, row, column);
        }
        if (this.mode == 2) {
            return this.paintCellsCompPlaces(table, value, isSelected, hasFocus, row, column);
        }
        if (this.mode == 3) {
            return this.paintCellsCompAll(value, isSelected, hasFocus, row, column);
        }
        return this.paintCellsDefault(value, isSelected, hasFocus, row, column);
    }

    private Component paintCellsCompTrans(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (column == 1) {
            String name = value.toString();
            if (name.contains("<OFFLINE")) {
                JLabel oLabel = (JLabel)this.DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                oLabel.setForeground(Color.black);
                oLabel.setBackground(Color.red);
                oLabel.setFont(fontNormal);
                oLabel.setText(name);
                return oLabel;
            }
            if (name.contains("<KNOCKOUT")) {
                JLabel oLabel = (JLabel)this.DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                oLabel.setForeground(Color.black);
                oLabel.setBackground(Color.lightGray);
                oLabel.setFont(fontNormal);
                oLabel.setText(name);
                return oLabel;
            }
        } else {
            if (column == 6) {
                JLabel oLabel = (JLabel)this.DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                oLabel.setForeground(Color.black);
                oLabel.setFont(fontNormal);
                if (value instanceof Double) {
                    double val = (Double)value;
                    if (val == -999999.0) {
                        oLabel.setText("-inf");
                    } else if (val == 999999.0) {
                        oLabel.setText("+inf");
                    } else if (val == 999991.0) {
                        oLabel.setText(" --- ");
                    } else if (val > 1000.0) {
                        oLabel.setForeground(Color.red);
                        oLabel.setFont(fontBold);
                        oLabel.setText(">1000 %");
                    } else if (val < -1000.0) {
                        oLabel.setForeground(Color.red);
                        oLabel.setFont(fontBold);
                        oLabel.setText("<-1000 %");
                    } else {
                        if (val > 75.0 || val < -75.0) {
                            oLabel.setForeground(Color.red);
                            oLabel.setFont(fontBold);
                        } else if (val > 45.0 || val < -45.0) {
                            oLabel.setForeground(Color.orange);
                            oLabel.setFont(fontBold);
                        }
                        oLabel.setText(formatter2.format((Double)value) + "%");
                    }
                } else {
                    oLabel.setText(value + "%");
                }
                return oLabel;
            }
            if (column == 8 || column == 9) {
                JLabel oLabel = (JLabel)this.DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                oLabel.setForeground(Color.black);
                oLabel.setFont(fontNormal);
                if (value instanceof String) {
                    String val = value.toString();
                    if (val.contains("OK")) {
                        oLabel.setForeground(Color.black);
                        oLabel.setBackground(Color.green);
                        oLabel.setFont(fontBold);
                        oLabel.setText("OK");
                    } else {
                        oLabel.setForeground(Color.black);
                        oLabel.setBackground(Color.white);
                        oLabel.setFont(fontBold);
                        oLabel.setText("n/a");
                    }
                } else {
                    oLabel.setText(value.toString());
                }
                return oLabel;
            }
        }
        if (value instanceof Double) {
            double val = (Double)value;
            value = column == 2 || column == 4 ? formatter2.format(value) : (val < 10.0 ? formatter3.format(value) : (val < 100.0 ? formatter2.format(value) : formatter1.format(value)));
        }
        Component renderer = this.DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        renderer.setForeground(Color.black);
        renderer.setBackground(Color.white);
        renderer.setFont(fontNormal);
        return renderer;
    }

    private Component paintCellsCompPlaces(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (column == 1) {
            String name = value.toString();
            if (name.contains("<OFFLINE")) {
                JLabel oLabel = (JLabel)this.DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                oLabel.setForeground(Color.black);
                oLabel.setBackground(Color.red);
                oLabel.setFont(fontNormal);
                oLabel.setText(name);
                return oLabel;
            }
            if (name.contains("<KNOCKOUT")) {
                JLabel oLabel = (JLabel)this.DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                oLabel.setForeground(Color.black);
                oLabel.setBackground(Color.lightGray);
                oLabel.setFont(fontNormal);
                oLabel.setText(name);
                return oLabel;
            }
        } else {
            if (column == 6) {
                if (value instanceof Double) {
                    double val = (Double)value;
                    String sign = "+";
                    if (val < 0.0) {
                        sign = "";
                    }
                    JLabel oLabel = (JLabel)this.DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    oLabel.setForeground(Color.black);
                    oLabel.setFont(fontNormal);
                    oLabel.setText(sign + formatter2.format((Double)value));
                    return oLabel;
                }
                JLabel oLabel = (JLabel)this.DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                oLabel.setForeground(Color.black);
                oLabel.setFont(fontNormal);
                oLabel.setText(formatter2.format((Double)value));
                return oLabel;
            }
            if (column == 8 || column == 9) {
                JLabel oLabel = (JLabel)this.DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                oLabel.setForeground(Color.black);
                oLabel.setFont(fontNormal);
                if (value instanceof String) {
                    String val = value.toString();
                    if (val.contains("OK")) {
                        oLabel.setForeground(Color.black);
                        oLabel.setBackground(Color.green);
                        oLabel.setFont(fontBold);
                        oLabel.setText("OK");
                    } else {
                        oLabel.setForeground(Color.black);
                        oLabel.setBackground(Color.white);
                        oLabel.setFont(fontBold);
                        oLabel.setText("n/a");
                    }
                } else {
                    oLabel.setText(value.toString());
                }
                return oLabel;
            }
        }
        if (value instanceof Double) {
            double val = (Double)value;
            value = val < 10.0 ? formatter3.format(value) : (val < 100.0 ? formatter2.format(value) : formatter1.format(value));
        }
        Component renderer = this.DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        renderer.setForeground(Color.black);
        renderer.setBackground(Color.white);
        renderer.setFont(fontNormal);
        return renderer;
    }

    private Component paintCellsDefault(Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (column == 1) {
            String name = value.toString();
            if (name.contains("<OFFLINE")) {
                JLabel oLabel = (JLabel)this.DEFAULT_RENDERER.getTableCellRendererComponent(this.table, value, isSelected, hasFocus, row, column);
                oLabel.setForeground(Color.black);
                oLabel.setBackground(Color.red);
                oLabel.setFont(fontNormal);
                oLabel.setText(name);
                return oLabel;
            }
            if (name.contains("<KNOCKOUT")) {
                JLabel oLabel = (JLabel)this.DEFAULT_RENDERER.getTableCellRendererComponent(this.table, value, isSelected, hasFocus, row, column);
                oLabel.setForeground(Color.black);
                oLabel.setBackground(Color.lightGray);
                oLabel.setFont(fontNormal);
                oLabel.setText(name);
                return oLabel;
            }
        }
        if (value instanceof Double || value instanceof Number) {
            double val = (Double)value;
            value = val < 1.0 ? formatter6.format(value) : (val < 10.0 ? formatter3.format(value) : (val < 100.0 ? formatter2.format(value) : formatter1.format(value)));
        }
        Component renderer = this.DEFAULT_RENDERER.getTableCellRendererComponent(this.table, value, isSelected, hasFocus, row, column);
        renderer.setForeground(Color.black);
        renderer.setBackground(Color.white);
        renderer.setFont(fontNormal);
        return renderer;
    }

    private Component paintCellsCompAll(Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (column > 2) {
            Object name = value.toString();
            if (((String)name).contains("-999999.0")) {
                JLabel oLabel = (JLabel)this.DEFAULT_RENDERER.getTableCellRendererComponent(this.table, value, isSelected, hasFocus, row, column);
                oLabel.setForeground(Color.black);
                oLabel.setBackground(Color.green);
                oLabel.setFont(fontNormal2);
                oLabel.setText("-inf");
                return oLabel;
            }
            if (((String)name).contains("999999.0")) {
                JLabel oLabel = (JLabel)this.DEFAULT_RENDERER.getTableCellRendererComponent(this.table, value, isSelected, hasFocus, row, column);
                oLabel.setForeground(Color.black);
                oLabel.setBackground(Color.green);
                oLabel.setFont(fontNormal2);
                oLabel.setText("+inf");
                return oLabel;
            }
            if (((String)name).contains("999990.0")) {
                JLabel oLabel = (JLabel)this.DEFAULT_RENDERER.getTableCellRendererComponent(this.table, value, isSelected, hasFocus, row, column);
                oLabel.setForeground(Color.black);
                oLabel.setBackground(Color.lightGray);
                oLabel.setFont(fontNormal2);
                oLabel.setText("0 / 0");
                return oLabel;
            }
            String tName = this.table.getName();
            JLabel oLabel = (JLabel)this.DEFAULT_RENDERER.getTableCellRendererComponent(this.table, value, isSelected, hasFocus, row, column);
            oLabel.setForeground(Color.black);
            oLabel.setBackground(Color.white);
            oLabel.setFont(fontNormal2);
            if (tName.contains("Places")) {
                SimKnockPlacesCompAllTableModel model = (SimKnockPlacesCompAllTableModel)this.table.getModel();
                Object firstCell = this.table.getValueAt(row, 0);
                int realRow = Integer.parseInt(firstCell.toString());
                SimKnockPlacesCompAllTableModel.DetailsPlace det = model.pTableData.get(realRow).get(column);
                double difference = det.diff;
                if (difference >= 100.0 || difference <= -100.0) {
                    oLabel.setForeground(Color.black);
                    oLabel.setBackground(Color.red);
                    oLabel.setFont(fontBold2);
                    if (det.diff >= 1000.0) {
                        oLabel.setText(">+1000%");
                        return oLabel;
                    }
                    if (det.diff <= -1000.0) {
                        oLabel.setText("<-1000%");
                        return oLabel;
                    }
                } else if (difference > 75.0 || difference < -75.0) {
                    oLabel.setForeground(Color.black);
                    oLabel.setBackground(Color.orange);
                    oLabel.setFont(fontBold2);
                } else if (difference > 45.0 || difference < -45.0) {
                    oLabel.setForeground(Color.black);
                    oLabel.setBackground(Color.yellow);
                    oLabel.setFont(fontBold2);
                }
                name = difference < 0.0 ? (String)name + "%" : "+" + (String)name + "%";
            } else {
                SimKnockTransCompAllTableModel model = (SimKnockTransCompAllTableModel)this.table.getModel();
                Object firstCell = this.table.getValueAt(row, 0);
                int realRow = Integer.parseInt(firstCell.toString());
                SimKnockTransCompAllTableModel.DetailsTrans det = model.tTableData.get(realRow).get(column);
                double difference = det.diff;
                if (difference >= 100.0 || difference <= -100.0) {
                    oLabel.setForeground(Color.black);
                    oLabel.setBackground(Color.red);
                    oLabel.setFont(fontBold2);
                    if (det.diff >= 1000.0) {
                        oLabel.setText(">+1000%");
                        return oLabel;
                    }
                    if (det.diff <= -1000.0) {
                        oLabel.setText("<-1000%");
                        return oLabel;
                    }
                } else if (difference > 75.0 || difference < -75.0) {
                    oLabel.setForeground(Color.black);
                    oLabel.setBackground(Color.orange);
                    oLabel.setFont(fontBold2);
                } else if (difference > 45.0 || difference < -45.0) {
                    oLabel.setForeground(Color.black);
                    oLabel.setBackground(Color.yellow);
                    oLabel.setFont(fontBold2);
                }
                name = difference < 0.0 ? (String)name + "%" : "+" + (String)name + "%";
            }
            oLabel.setText((String)name);
            return oLabel;
        }
        Component renderer = this.DEFAULT_RENDERER.getTableCellRendererComponent(this.table, value, isSelected, hasFocus, row, column);
        renderer.setForeground(Color.black);
        renderer.setBackground(Color.white);
        renderer.setFont(fontNormal2);
        return renderer;
    }
}

