/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables.simKnock;

import holmes.petrinet.data.NetSimulationData;
import holmes.petrinet.elements.Place;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class SimKnockPlacesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7417629500439797992L;
    private String[] columnNames = new String[]{"ID", "Place name", "AvgT", "MinT", "MaxT", "noT", "stdDev", "S1 %", "S2 %", "S3 %", "S4 %", "S5 %"};
    private ArrayList<PlaceContainer> dataMatrix = new ArrayList();
    private int dataSize = 0;

    public void addNew(NetSimulationData data, int index, Place p) {
        PlaceContainer pc = new PlaceContainer();
        pc.ID = index;
        pc.name = p != null ? p.getName() : "Place " + index;
        if (data.placeTokensAvg.get(index) == 0.0) {
            pc.name = "<KNOCKOUT>" + pc.name;
        }
        pc.tokenAvg = data.placeTokensAvg.get(index);
        pc.tokenMin = data.placeTokensMin.get(index);
        pc.tokenMax = data.placeTokensMax.get(index);
        pc.noTokens = "" + data.placeZeroTokens.get(index);
        pc.stdDev = data.placeStdDev.get(index);
        pc.s1 = data.placeWithinStdDev.get(index).get(0) * 100 / data.reps;
        pc.s2 = data.placeWithinStdDev.get(index).get(1) * 100 / data.reps;
        pc.s3 = data.placeWithinStdDev.get(index).get(2) * 100 / data.reps;
        pc.s4 = data.placeWithinStdDev.get(index).get(3) * 100 / data.reps;
        pc.s5 = data.placeWithinStdDev.get(index).get(4) * 100 / data.reps;
        this.dataMatrix.add(pc);
        ++this.dataSize;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.dataMatrix.isEmpty()) {
            return Object.class;
        }
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return switch (columnIndex) {
            case 0 -> this.dataMatrix.get((int)rowIndex).ID;
            case 1 -> this.dataMatrix.get((int)rowIndex).name;
            case 2 -> this.dataMatrix.get((int)rowIndex).tokenAvg;
            case 3 -> this.dataMatrix.get((int)rowIndex).tokenMin;
            case 4 -> this.dataMatrix.get((int)rowIndex).tokenMax;
            case 5 -> this.dataMatrix.get((int)rowIndex).noTokens;
            case 6 -> this.dataMatrix.get((int)rowIndex).stdDev;
            case 7 -> this.dataMatrix.get((int)rowIndex).s1;
            case 8 -> this.dataMatrix.get((int)rowIndex).s2;
            case 9 -> this.dataMatrix.get((int)rowIndex).s3;
            case 10 -> this.dataMatrix.get((int)rowIndex).s4;
            case 11 -> this.dataMatrix.get((int)rowIndex).s5;
            default -> throw new IllegalArgumentException("Invalid column index");
        };
    }

    public static class PlaceContainer {
        public int ID;
        public String name;
        public double tokenAvg;
        public double tokenMin;
        public double tokenMax;
        public String noTokens;
        public double stdDev;
        public double s1;
        public double s2;
        public double s3;
        public double s4;
        public double s5;
    }
}

