/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables.simKnock;

import holmes.petrinet.data.NetSimulationData;
import holmes.petrinet.elements.Place;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class SimKnockPlacesCompTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5141687750658780227L;
    private String[] columnNames = new String[]{"ID", "Place name", "AvgTRef", "stdDRef", "AvgTKnock", "stdDKnock", "diffPerc", "noT", "sig1", "sig2"};
    private ArrayList<PlaceCompContainer> dataMatrix = new ArrayList();
    private int dataSize = 0;

    public ArrayList<PlaceCompContainer> accessDataMatrix() {
        return this.dataMatrix;
    }

    public void addNew(NetSimulationData dataRef, NetSimulationData dataKnock, int index, Place p) {
        PlaceCompContainer pc = new PlaceCompContainer();
        pc.ID = index;
        pc.name = p != null ? p.getName() : "Place " + index;
        pc.tokenAvgRef = dataRef.placeTokensAvg.get(index);
        pc.stdDevRef = dataRef.placeStdDev.get(index);
        pc.tokenAvgKnock = dataKnock.placeTokensAvg.get(index);
        pc.stdDevKnock = dataKnock.placeStdDev.get(index);
        if (dataKnock.placeTokensAvg.get(index) == 0.0) {
            pc.name = "<KNOCKOUT>" + pc.name;
        }
        pc.tokenAvgPercDiff = 0.0;
        double diff = pc.tokenAvgRef - pc.tokenAvgKnock;
        pc.tokenAvgPercDiff = diff < 0.0 ? Double.valueOf(diff *= -1.0) : Double.valueOf(diff *= -1.0);
        pc.noTokensKnock = "" + dataKnock.placeZeroTokens.get(index);
        pc.signifLvl1 = pc.tokenAvgRef > pc.tokenAvgKnock ? (dataRef.placeTokensMin.get(index) > dataKnock.placeTokensMax.get(index) ? "OK" : "no") : (dataRef.placeTokensMax.get(index) < dataKnock.placeTokensMin.get(index) ? "OK" : "no");
        pc.signifLvl2 = pc.tokenAvgRef > pc.tokenAvgKnock ? (pc.tokenAvgRef - pc.stdDevRef > pc.tokenAvgKnock + pc.stdDevKnock ? "OK" : "no") : (pc.tokenAvgRef + pc.stdDevRef < pc.tokenAvgKnock - pc.stdDevKnock ? "OK" : "no");
        this.dataMatrix.add(pc);
        ++this.dataSize;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.dataMatrix.isEmpty()) {
            return Object.class;
        }
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return switch (columnIndex) {
            case 0 -> this.dataMatrix.get((int)rowIndex).ID;
            case 1 -> this.dataMatrix.get((int)rowIndex).name;
            case 2 -> this.dataMatrix.get((int)rowIndex).tokenAvgRef;
            case 3 -> this.dataMatrix.get((int)rowIndex).stdDevRef;
            case 4 -> this.dataMatrix.get((int)rowIndex).tokenAvgKnock;
            case 5 -> this.dataMatrix.get((int)rowIndex).stdDevKnock;
            case 6 -> this.dataMatrix.get((int)rowIndex).tokenAvgPercDiff;
            case 7 -> this.dataMatrix.get((int)rowIndex).noTokensKnock;
            case 8 -> this.dataMatrix.get((int)rowIndex).signifLvl1;
            case 9 -> this.dataMatrix.get((int)rowIndex).signifLvl2;
            default -> throw new IllegalArgumentException("Invalid column index");
        };
    }

    public static class PlaceCompContainer {
        public int ID;
        public String name;
        public double tokenAvgRef;
        public double stdDevRef;
        public double tokenAvgKnock;
        public double stdDevKnock;
        public Double tokenAvgPercDiff;
        public String noTokensKnock;
        public String signifLvl1;
        public String signifLvl2;
    }
}

