/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables.managers;

import holmes.darkgui.GUIManager;
import holmes.windows.managers.HolmesStatesManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.table.AbstractTableModel;

public class StatesPlacesTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7776195572631920285L;
    private String[] columnNames;
    private ArrayList<ArrayList<String>> dataMatrix;
    private int dataSize;
    private HolmesStatesManager boss;
    public boolean changes = false;

    public StatesPlacesTableModel(int placesNumber, HolmesStatesManager boss) {
        this.boss = boss;
        this.clearModel(placesNumber);
    }

    public void clearModel(int placesNumber) {
        this.columnNames = new String[placesNumber + 2];
        this.columnNames[0] = "Selected";
        this.columnNames[1] = "mID";
        for (int i = 0; i < placesNumber; ++i) {
            this.columnNames[i + 2] = "t" + i;
        }
        this.dataMatrix = new ArrayList();
        this.dataSize = 0;
    }

    public void addNew(ArrayList<String> dataRow) {
        this.dataMatrix.add(dataRow);
        ++this.dataSize;
    }

    public void setSelected(int row) {
        for (int i = 0; i < this.dataSize; ++i) {
            if (i == row) {
                this.dataMatrix.get(i).set(0, "X");
                continue;
            }
            this.dataMatrix.get(i).set(0, "");
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.dataMatrix.isEmpty()) {
            return Object.class;
        }
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column > 1;
    }

    public boolean isCellEditable(EventObject evt) {
        if (evt instanceof MouseEvent) {
            int clickCount = 1;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        }
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex < 2) {
            return this.dataMatrix.get(rowIndex).get(columnIndex);
        }
        try {
            String returnValue = this.dataMatrix.get(rowIndex).get(columnIndex);
            String strVal = returnValue.toString();
            return Double.parseDouble(strVal);
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        try {
            double newValue = Double.parseDouble(value.toString());
            if (newValue < 0.0) {
                newValue = 0.0;
            }
            ArrayList<String> rowVector = this.dataMatrix.get(row);
            rowVector.set(col, "" + (int)newValue);
            this.boss.changeState(row, col, newValue);
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (688206518) | Exception:  " + ex.getMessage(), "error", true);
        }
    }

    public void setQuietlyValueAt(Object value, int row, int col) {
        try {
            double newValue = Double.parseDouble(value.toString());
            if (newValue < 0.0) {
                newValue = 0.0;
            }
            ArrayList<String> rowVector = this.dataMatrix.get(row);
            rowVector.set(col, "" + (int)newValue);
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (128622084) | Exception:  " + ex.getMessage(), "error", true);
        }
    }
}

