/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables.managers;

import holmes.petrinet.data.SSAplacesVector;
import holmes.windows.managers.HolmesSSAplacesEditor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;

public class SSAplacesEditorTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 5334544477964813872L;
    private String[] columnNames;
    private ArrayList<SSAdataClass> dataMatrix;
    private int dataSize;
    private HolmesSSAplacesEditor boss;
    private int ssaVectorIndex;
    public boolean changes = false;
    private SSAplacesVector.SSAdataType dataType;

    public SSAplacesEditorTableModel(HolmesSSAplacesEditor boss, int ssaVectorIndex, SSAplacesVector.SSAdataType dataType) {
        this.boss = boss;
        this.ssaVectorIndex = ssaVectorIndex;
        this.dataType = dataType;
        this.clearModel();
    }

    public void clearModel() {
        this.columnNames = new String[3];
        this.columnNames[0] = "ID";
        this.columnNames[1] = "Place Name";
        this.columnNames[2] = "Value";
        this.dataMatrix = new ArrayList();
        this.dataSize = 0;
    }

    public void addNew(int ID, String name, double value) {
        SSAdataClass row = new SSAdataClass();
        row.ID = ID;
        row.name = name;
        row.ssaValue = value;
        this.dataMatrix.add(row);
        ++this.dataSize;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.dataMatrix.isEmpty()) {
            return Object.class;
        }
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 2;
    }

    public boolean isCellEditable(EventObject evt) {
        if (evt instanceof MouseEvent) {
            int clickCount = 1;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        }
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.dataMatrix.get((int)rowIndex).ID;
            }
            case 1: {
                return this.dataMatrix.get((int)rowIndex).name;
            }
            case 2: {
                return this.dataMatrix.get((int)rowIndex).ssaValue;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        double newValue = 0.0;
        try {
            if (col == 2) {
                newValue = Double.parseDouble(value.toString());
                if (this.dataType == SSAplacesVector.SSAdataType.MOLECULES) {
                    if (newValue > 0.9) {
                        this.dataMatrix.get((int)row).ssaValue = newValue;
                        this.boss.changeRealValue(this.ssaVectorIndex, row, newValue);
                    } else {
                        JOptionPane.showMessageDialog(this.boss, "Data type set for molecules. Expected number from a range of\n1 to (usually) billions - not fractions (there is no " + newValue + " molecule!).", "Invalid value, integer number of molecules expected", 2);
                    }
                } else if (newValue < 10.0) {
                    this.dataMatrix.get((int)row).ssaValue = newValue;
                    this.boss.changeRealValue(this.ssaVectorIndex, row, newValue);
                } else {
                    JOptionPane.showMessageDialog(this.boss, "Data type set for concentration. Units are moles/litre. Expected number \nfrom a range of 0 to (usually) tiny fraction (e.g. 1e-12). This value will\nbe MULTIPLIED by Avogadro constant (6.022*10^23 molecules!)", "Invalid value, moles/litre expected", 2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class SSAdataClass {
        public int ID;
        public String name;
        public Double ssaValue;
    }
}

