/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables.managers;

import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.extensions.TransitionSPNExtension;
import holmes.windows.managers.HolmesSPNeditor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.table.DefaultTableModel;

public class SPNsingleVectorTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = -6898959322396110431L;
    private String[] columnNames;
    private ArrayList<FRDataClass> dataMatrix;
    private int dataSize;
    private HolmesSPNeditor boss;
    private int frVectorIndex;
    public boolean changes = false;

    public SPNsingleVectorTableModel(HolmesSPNeditor boss, int frVectorIndex) {
        this.boss = boss;
        this.frVectorIndex = frVectorIndex;
        this.clearModel();
    }

    public void clearModel() {
        this.columnNames = new String[4];
        this.columnNames[0] = "ID";
        this.columnNames[1] = "Transition Name";
        this.columnNames[2] = "Firing rate";
        this.columnNames[3] = "SPN subtype";
        this.dataMatrix = new ArrayList();
        this.dataSize = 0;
    }

    public void addNew(int ID, String name, String SPNtransData, TransitionSPNExtension.StochaticsType sType) {
        FRDataClass row = new FRDataClass();
        row.ID = ID;
        row.name = name;
        row.dataVector = SPNtransData;
        row.subType = sType;
        this.dataMatrix.add(row);
        ++this.dataSize;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.dataMatrix.isEmpty()) {
            return Object.class;
        }
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public boolean isCellEditable(EventObject evt) {
        if (evt instanceof MouseEvent) {
            int clickCount = 1;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        }
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return switch (columnIndex) {
            case 0 -> Integer.valueOf(this.dataMatrix.get((int)rowIndex).ID);
            case 1 -> this.dataMatrix.get((int)rowIndex).name;
            case 2 -> this.dataMatrix.get((int)rowIndex).dataVector;
            case 3 -> this.dataMatrix.get((int)rowIndex).subType;
            default -> null;
        };
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        try {
            if (col == 2) {
                this.dataMatrix.get((int)row).dataVector = value.toString();
            } else if (col == 3) {
                this.dataMatrix.get((int)row).subType = (TransitionSPNExtension.StochaticsType)((Object)value);
            }
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (497476884) | Exception:  " + ex.getMessage(), "error", true);
        }
    }

    public static class FRDataClass {
        public int ID;
        public String name;
        public String dataVector;
        public TransitionSPNExtension.StochaticsType subType;
    }
}

