/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class TransitionsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -1557850148390063580L;
    private String[] columnNames = new String[]{"ID", "Transition name", "Pre-P", "Post-P", "Fired", "Inv"};
    private ArrayList<TransitionContainer> dataMatrix = new ArrayList();
    private int dataSize = 0;

    public void addNew(int id, String name, int preP, int postP, float fired, int inv) {
        TransitionContainer tc = new TransitionContainer();
        tc.ID = id;
        tc.name = name;
        tc.preP = preP;
        tc.postP = postP;
        tc.fired = fired;
        tc.inInv = inv;
        this.dataMatrix.add(tc);
        ++this.dataSize;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.dataMatrix.isEmpty()) {
            return Object.class;
        }
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return switch (columnIndex) {
            case 0 -> this.dataMatrix.get((int)rowIndex).ID;
            case 1 -> this.dataMatrix.get((int)rowIndex).name;
            case 2 -> this.dataMatrix.get((int)rowIndex).preP;
            case 3 -> this.dataMatrix.get((int)rowIndex).postP;
            case 4 -> Float.valueOf(this.dataMatrix.get((int)rowIndex).fired);
            case 5 -> this.dataMatrix.get((int)rowIndex).inInv;
            default -> throw new IllegalArgumentException("Invalid column index");
        };
    }

    public static class TransitionContainer {
        public int ID;
        public String name;
        public int preP;
        public int postP;
        public float fired;
        public int inInv;
    }
}

