/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables;

import holmes.darkgui.GUIManager;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class InvariantsSimulatorTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -1557850148390063580L;
    private ArrayList<Integer> infeasibleInvariants;
    private ArrayList<Integer> zeroDeadTransitions;
    private String[] columnNames;
    private ArrayList<ArrayList<String>> dataMatrix;
    private int dataSize;

    public InvariantsSimulatorTableModel(int transNumber) {
        this.columnNames = new String[transNumber + 2];
        this.columnNames[0] = "ID";
        this.columnNames[1] = "Trans.#:";
        for (int i = 0; i < transNumber; ++i) {
            this.columnNames[i + 2] = "t" + i;
        }
        this.dataMatrix = new ArrayList();
        this.dataSize = 0;
    }

    public void addNew(ArrayList<String> dataRow) {
        this.dataMatrix.add(dataRow);
        ++this.dataSize;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.dataMatrix.isEmpty()) {
            return Object.class;
        }
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String returnValue = null;
        if (columnIndex < 2) {
            try {
                returnValue = this.dataMatrix.get(rowIndex).get(columnIndex);
                return returnValue;
            }
            catch (Exception e) {
                GUIManager.getDefaultGUIManager().log("Invariants table malfunction: non-numerical value in 1st or 2nd column.", "error", true);
            }
        } else {
            returnValue = this.dataMatrix.get(rowIndex).get(columnIndex);
            return returnValue.toString();
        }
        return returnValue;
    }

    public void setInfeasibleInvariants(ArrayList<Integer> infInv) {
        this.infeasibleInvariants = infInv;
    }

    public ArrayList<Integer> getInfeasibleInvariants() {
        return this.infeasibleInvariants;
    }

    public void setZeroDeadTransitions(ArrayList<Integer> zeroTrans) {
        this.zeroDeadTransitions = zeroTrans;
    }

    public ArrayList<Integer> getZeroDeadTransitions() {
        return this.zeroDeadTransitions;
    }
}

