/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables;

import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.Arc;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;

public class FunctionalTransTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 7486251580290447103L;
    private String[] columnNames = new String[]{"Place", "Place name", "Function", "OK", "Arc type", "Weight", "Enabled"};
    private ArrayList<FContainer> dataMatrix = new ArrayList();
    private int dataSize = 0;

    public void addNew(String pID, String name, String function, boolean isOK, Arc.TypeOfArc arcType, int weight, boolean enable) {
        FContainer fC = new FContainer();
        fC.pID = pID;
        fC.name = name;
        fC.function = function;
        fC.correct = isOK;
        fC.arcType = arcType;
        fC.weight = weight;
        fC.enabled = enable;
        this.dataMatrix.add(fC);
        ++this.dataSize;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.dataMatrix.isEmpty()) {
            return Object.class;
        }
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return switch (columnIndex) {
            case 0 -> this.dataMatrix.get((int)rowIndex).pID;
            case 1 -> this.dataMatrix.get((int)rowIndex).name;
            case 2 -> this.dataMatrix.get((int)rowIndex).function;
            case 3 -> Boolean.valueOf(this.dataMatrix.get((int)rowIndex).correct);
            case 4 -> this.dataMatrix.get((int)rowIndex).arcType;
            case 5 -> Integer.valueOf(this.dataMatrix.get((int)rowIndex).weight);
            case 6 -> Boolean.valueOf(this.dataMatrix.get((int)rowIndex).enabled);
            default -> throw new IllegalArgumentException("Invalid column index");
        };
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        try {
            switch (col) {
                case 2: {
                    this.dataMatrix.get((int)row).function = value.toString();
                    break;
                }
                case 3: {
                    this.dataMatrix.get((int)row).correct = (Boolean)value;
                    break;
                }
                case 4: {
                    this.dataMatrix.get((int)row).arcType = (Arc.TypeOfArc)((Object)value);
                    break;
                }
                case 5: {
                    this.dataMatrix.get((int)row).weight = (Integer)value;
                    break;
                }
                case 6: {
                    this.dataMatrix.get((int)row).enabled = (Boolean)value;
                }
            }
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (267990506) | Exception:  " + ex.getMessage(), "error", true);
        }
    }

    public static class FContainer {
        public String pID;
        public String name;
        public String function;
        public boolean correct;
        public Arc.TypeOfArc arcType;
        public int weight;
        public boolean enabled;
    }
}

