/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.subnets;

import holmes.darkgui.GUIManager;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.subnets.SubnetsGraphics;
import holmes.petrinet.subnets.SubnetsSnoopyCompatibility;
import holmes.petrinet.subnets.SubnetsTools;
import holmes.windows.HolmesNotepad;
import holmes.workspace.Workspace;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import javax.swing.JOptionPane;

public class SubnetsControl {
    GUIManager overlord;

    public SubnetsControl(GUIManager boss) {
        this.overlord = boss;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addArcToMetanode(ElementLocation startPTLocation, ElementLocation endMetanodeLocation, Arc semiArc) {
        Workspace workspace = this.overlord.getWorkspace();
        ArrayList<Arc> arcs = workspace.getProject().getArcs();
        MetaNode metanode = (MetaNode)endMetanodeLocation.getParentNode();
        int subnetID = metanode.getRepresentedSheetID();
        Node startNode = startPTLocation.getParentNode();
        int howManyExists = 0;
        ElementLocation oneOfMany = null;
        for (ElementLocation el : startNode.getElementLocations()) {
            if (el.getSheetID() != subnetID) continue;
            ++howManyExists;
            oneOfMany = el;
        }
        boolean askStupidQuestions = !this.overlord.getSettingsManager().getValue("editorSnoopyCompatibleMode").equals("1");
        boolean hasMetaArc = this.checkIfInMetaArcExists(startPTLocation, metanode);
        boolean addIdAlready = false;
        if (!hasMetaArc) {
            addIdAlready = true;
        } else if (howManyExists > 0 && askStupidQuestions) {
            Object[] options = new Object[]{"Add another portal", "Don't add new arc/portal"};
            int n = JOptionPane.showOptionDialog(null, "Subnet " + subnetID + " already contains " + howManyExists + " portal(s) of\n" + startNode.getName() + ".\nAdd another one?", "Add another portal symbol?", 0, 3, null, options, options[0]);
            if (n != 0) return false;
            addIdAlready = true;
        } else {
            addIdAlready = true;
        }
        if (!addIdAlready) return false;
        ElementLocation newPortal = null;
        newPortal = oneOfMany == null ? new ElementLocation(subnetID, new Point(50, 50), startNode) : new ElementLocation(subnetID, new Point(oneOfMany.getPosition().x + 15, oneOfMany.getPosition().y + 15), startNode);
        ElementLocation newNameEL = new ElementLocation(subnetID, new Point(0, 0), startNode);
        startNode.getElementLocations().add(newPortal);
        startNode.getTextsLocations(GUIManager.locationMoveType.NAME).add(newNameEL);
        startNode.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(newNameEL);
        startNode.getTextsLocations(GUIManager.locationMoveType.BETA).add(newNameEL);
        startNode.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(newNameEL);
        startNode.getTextsLocations(GUIManager.locationMoveType.TAU).add(newNameEL);
        startNode.setPortal(true);
        Arc arc = new Arc(IdGenerator.getNextId(), semiArc.getStartLocation(), endMetanodeLocation, Arc.TypeOfArc.META_ARC);
        arcs.add(arc);
        int index = workspace.getIndexOfId(subnetID);
        workspace.getSheets().get(index).getGraphPanel().repaint();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addArcFromMetanode(ElementLocation endPTNode, ElementLocation startMetanode, Arc semiArc) {
        Workspace workspace = this.overlord.getWorkspace();
        ArrayList<Arc> arcs = workspace.getProject().getArcs();
        MetaNode metanode = (MetaNode)startMetanode.getParentNode();
        int subnetID = metanode.getRepresentedSheetID();
        Node endNode = endPTNode.getParentNode();
        int howManyExists = 0;
        ElementLocation oneOfMany = null;
        for (ElementLocation el : endNode.getElementLocations()) {
            if (el.getSheetID() != subnetID) continue;
            ++howManyExists;
            oneOfMany = el;
        }
        boolean hasMetaArc = this.checkIfOutMetaExists(endPTNode, metanode);
        boolean addIdAlready = false;
        if (!hasMetaArc) {
            addIdAlready = true;
        } else if (howManyExists > 0) {
            Object[] options = new Object[]{"Add another portal", "Don't add new arc/portal"};
            int n = JOptionPane.showOptionDialog(null, "Subnet " + subnetID + " already contains " + howManyExists + " portal(s) of\n" + endNode.getName() + ".\nAdd another one?", "Add another portal symbol?", 0, 3, null, options, options[0]);
            if (n != 0) return false;
            addIdAlready = true;
        } else {
            addIdAlready = true;
        }
        if (!addIdAlready) return false;
        ElementLocation newPortal = null;
        newPortal = oneOfMany == null ? new ElementLocation(subnetID, new Point(50, 50), endNode) : new ElementLocation(subnetID, new Point(oneOfMany.getPosition().x + 15, oneOfMany.getPosition().y + 15), endNode);
        ElementLocation newNameEL = new ElementLocation(subnetID, new Point(0, 0), endNode);
        endNode.getElementLocations().add(newPortal);
        endNode.getTextsLocations(GUIManager.locationMoveType.NAME).add(newNameEL);
        endNode.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(newNameEL);
        endNode.getTextsLocations(GUIManager.locationMoveType.BETA).add(newNameEL);
        endNode.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(newNameEL);
        endNode.getTextsLocations(GUIManager.locationMoveType.TAU).add(newNameEL);
        endNode.setPortal(true);
        Arc arc = new Arc(IdGenerator.getNextId(), startMetanode, endPTNode, Arc.TypeOfArc.META_ARC);
        arcs.add(arc);
        int index = workspace.getIndexOfId(subnetID);
        workspace.getSheets().get(index).getGraphPanel().repaint();
        return true;
    }

    public void addMetaArc(Arc arc) {
        Random gen = new Random();
        ArrayList<MetaNode> metanodes = this.overlord.getWorkspace().getProject().getMetaNodes();
        ElementLocation startEL = arc.getStartLocation();
        ElementLocation endEL = arc.getEndLocation();
        ElementLocation ourPatient = null;
        boolean isInterfIN = false;
        if (SubnetsTools.isInterface(startEL, metanodes) > 0) {
            ourPatient = startEL;
            isInterfIN = true;
        } else if (SubnetsTools.isInterface(endEL, metanodes) > 0) {
            ourPatient = endEL;
        } else {
            return;
        }
        int subSheetID = ourPatient.getSheetID();
        Node metanode = null;
        for (MetaNode meta : metanodes) {
            if (meta.getRepresentedSheetID() != subSheetID) continue;
            metanode = meta;
            break;
        }
        if (metanode == null) {
            this.overlord.log("Error: no metanode found.", "error", true);
        }
        ElementLocation metaEL = metanode.getElementLocations().get(0);
        int sheetID = metaEL.getSheetID();
        Point point = metaEL.getPosition();
        Node parent = ourPatient.getParentNode();
        int metaArcs = 0;
        int interfArc = 0;
        if (isInterfIN) {
            metaArcs = SubnetsTools.countInMetaArcs(parent, (MetaNode)metanode);
            interfArc = SubnetsTools.countInterfaceInArcs(parent, ourPatient.getSheetID(), true);
        } else {
            metaArcs = SubnetsTools.countOutMetaArcs(parent, (MetaNode)metanode);
            interfArc = SubnetsTools.countInterfaceOutArcs(parent, ourPatient.getSheetID(), true);
        }
        if (interfArc <= metaArcs) {
            return;
        }
        boolean uncompressed = this.overlord.getSettingsManager().getValue("editorSubnetCompressMode").equals("1");
        if (uncompressed) {
            ElementLocation nexus = SubnetsTools.getNexusEL(parent, (MetaNode)metanode);
            if (nexus == null) {
                uncompressed = false;
            } else {
                Arc newArc = null;
                newArc = isInterfIN ? new Arc(IdGenerator.getNextId(), nexus, metaEL, Arc.TypeOfArc.META_ARC) : new Arc(IdGenerator.getNextId(), metaEL, nexus, Arc.TypeOfArc.META_ARC);
                this.overlord.getWorkspace().getProject().getArcs().add(newArc);
            }
        }
        if (!uncompressed) {
            int newX = gen.nextInt(160) - 80;
            int newY = gen.nextInt(100) + 15;
            if (!isInterfIN) {
                newY *= -1;
            }
            ElementLocation newEL = new ElementLocation(sheetID, new Point(point.x + newX, point.y - newY), parent);
            ElementLocation newNameEL = new ElementLocation(sheetID, new Point(0, 0), parent);
            parent.getElementLocations().add(newEL);
            parent.getTextsLocations(GUIManager.locationMoveType.NAME).add(newNameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(newNameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.BETA).add(newNameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(newNameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.TAU).add(newNameEL);
            parent.setPortal(true);
            Arc newArc = null;
            newArc = isInterfIN ? new Arc(IdGenerator.getNextId(), newEL, metaEL, Arc.TypeOfArc.META_ARC) : new Arc(IdGenerator.getNextId(), metaEL, newEL, Arc.TypeOfArc.META_ARC);
            this.overlord.getWorkspace().getProject().getArcs().add(newArc);
        }
    }

    private boolean checkIfInMetaArcExists(ElementLocation startLocation, MetaNode metanode) {
        Node parent = startLocation.getParentNode();
        for (ElementLocation el : parent.getElementLocations()) {
            for (Arc arc : el.accessMetaOutArcs()) {
                if (!arc.getEndLocation().getParentNode().equals(metanode)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkIfOutMetaExists(ElementLocation endLocation, MetaNode metanode) {
        Node parent = endLocation.getParentNode();
        for (ElementLocation el : parent.getElementLocations()) {
            for (Arc arc : el.accessMetaInArcs()) {
                if (!arc.getStartLocation().getParentNode().equals(metanode)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean changeSubnetType(MetaNode metanode, MetaNode.MetaType desiredType) {
        if (this.overlord.getSettingsManager().getValue("editorSnoopyCompatibleMode").equals("1")) {
            if (desiredType == MetaNode.MetaType.SUBNET) {
                JOptionPane.showMessageDialog(null, "Snoopy compatibility mode is activated in program options.\nDual interface (PT) subnetworks are not allowed.", "Compatibility issue", 1);
                return false;
            }
        } else if (desiredType == MetaNode.MetaType.SUBNET) {
            metanode.setMetaType(desiredType);
            return true;
        }
        int sheetID = metanode.getRepresentedSheetID();
        if (desiredType == MetaNode.MetaType.SUBNETPLACE) {
            ArrayList<ElementLocation> elements = this.getSubnetElementLocations(sheetID);
            for (ElementLocation el : elements) {
                if (!el.getParentNode().isPortal() || el.getParentNode() instanceof Transition || !(el.getParentNode() instanceof Place)) continue;
                for (ElementLocation internalEL : el.getParentNode().getElementLocations()) {
                    if (internalEL.getSheetID() == sheetID) continue;
                    JOptionPane.showMessageDialog(null, "Subnet (type T or TP) contains place portals as interfaces to other subnetworks.\nSubnet P-type can only be connected by transition portals.", "Compatibility issue", 1);
                    return false;
                }
            }
        } else if (desiredType == MetaNode.MetaType.SUBNETTRANS) {
            ArrayList<ElementLocation> elements = this.getSubnetElementLocations(sheetID);
            for (ElementLocation el : elements) {
                if (!el.getParentNode().isPortal() || el.getParentNode() instanceof Place || !(el.getParentNode() instanceof Transition)) continue;
                for (ElementLocation internalEL : el.getParentNode().getElementLocations()) {
                    if (internalEL.getSheetID() == sheetID) continue;
                    JOptionPane.showMessageDialog(null, "Subnet (type P or TP) contains place portals as interfaces to other subnetworks.\nSubnet T-type can only be connected by place portals.", "Compatibility issue", 1);
                    return false;
                }
            }
        }
        metanode.setMetaType(desiredType);
        return true;
    }

    public ArrayList<ElementLocation> getSubnetElementLocations(int sheetID) {
        ArrayList<ElementLocation> result = new ArrayList<ElementLocation>();
        ArrayList<Node> nodes = this.overlord.getWorkspace().getProject().getNodes();
        for (Node n : nodes) {
            for (ElementLocation el : n.getElementLocations()) {
                if (el.getSheetID() != sheetID) continue;
                result.add(el);
            }
        }
        return result;
    }

    public ArrayList<Integer> getSubnetsVector() {
        int shNumber;
        ArrayList<Integer> result = new ArrayList<Integer>();
        ArrayList<Node> nodes = this.overlord.getWorkspace().getProject().getNodes();
        for (Node n : nodes) {
            for (ElementLocation el : n.getElementLocations()) {
                int shNumber2;
                int sheetID = el.getSheetID();
                if (sheetID > (shNumber2 = result.size()) - 1) {
                    SubnetsGraphics.updateVector(result, sheetID - shNumber2 + 1, 0);
                }
                int value = result.get(sheetID) + 1;
                result.set(sheetID, value);
            }
        }
        int sheetsNumber = this.overlord.getWorkspace().getSheets().size();
        if (sheetsNumber > (shNumber = result.size())) {
            SubnetsGraphics.updateVector(result, sheetsNumber - shNumber, 0);
        }
        return result;
    }

    public void removeMetaNode(int sheetID) {
        PetriNet pn = this.overlord.getWorkspace().getProject();
        ArrayList<MetaNode> metanodes = pn.getMetaNodes();
        ArrayList<Arc> arcs = pn.getArcs();
        ArrayList<Node> nodes = pn.getNodes();
        boolean removed = false;
        boolean found = false;
        if (metanodes.size() == 0) {
            return;
        }
        for (MetaNode node : metanodes) {
            if (node.getRepresentedSheetID() != sheetID) continue;
            found = true;
            if (node.getInArcs().size() > 0 || node.getOutArcs().size() > 0) {
                this.overlord.log("Serious internal problem encountered. MetaNode should NEVER have normal arcs. Please contact authors. Also, net analysis may be wrong.", "error", true);
                for (ElementLocation el : node.getElementLocations()) {
                    Arc arc;
                    Arc a;
                    Iterator<Arc> i = el.getInArcs().iterator();
                    while (i.hasNext()) {
                        a = i.next();
                        arcs.remove(a);
                        a.unlinkElementLocations();
                        if (a.getPairedArc() != null) {
                            arc = a.getPairedArc();
                            arc.unlinkElementLocations();
                            arcs.remove(arc);
                        }
                        i.remove();
                    }
                    i = el.getOutArcs().iterator();
                    while (i.hasNext()) {
                        a = i.next();
                        arcs.remove(a);
                        a.unlinkElementLocations();
                        if (a.getPairedArc() != null) {
                            arc = a.getPairedArc();
                            arc.unlinkElementLocations();
                            arcs.remove(arc);
                        }
                        i.remove();
                    }
                }
            }
            for (ElementLocation el : node.getElementLocations()) {
                for (Arc arc : el.accessMetaInArcs()) {
                    ElementLocation startEL = arc.getStartLocation();
                    startEL.accessMetaOutArcs().remove(arc);
                    arcs.remove(arc);
                }
                for (Arc arc : el.accessMetaOutArcs()) {
                    ElementLocation endEL = arc.getEndLocation();
                    endEL.accessMetaInArcs().remove(arc);
                    arcs.remove(arc);
                }
            }
            nodes.remove(node);
            removed = true;
            break;
        }
        if (!found) {
            this.overlord.log("Metanode for sheet " + sheetID + " does not exist.", "warning", true);
        } else if (!removed) {
            this.overlord.log("Failed to remove metanode for sheet " + sheetID, "error", true);
        }
    }

    public void validateMetaArcs(ArrayList<Integer> sheetModified, boolean forceFix, boolean doNotRemove) {
        boolean compressMetaArcs = this.overlord.getSettingsManager().getValue("editorSubnetCompressMode").equals("1");
        ArrayList<MetaNode> metanodes = this.overlord.getWorkspace().getProject().getMetaNodes();
        ArrayList<Arc> arcs = this.overlord.getWorkspace().getProject().getArcs();
        for (int sheetID : sheetModified) {
            if (sheetID == 0 && !forceFix) continue;
            ArrayList<ElementLocation> subnetElements = this.getSubnetElementLocations(sheetID);
            MetaNode metanodeRepresSubnet = null;
            for (MetaNode meta : metanodes) {
                if (meta.getRepresentedSheetID() != sheetID) continue;
                metanodeRepresSubnet = meta;
                break;
            }
            if (metanodeRepresSubnet == null) {
                this.overlord.log("Unexpected error: metanode graphical symbol not found for existing subnet ID: " + sheetID, "error", true);
                break;
            }
            ArrayList<Node> alreadyChecked = new ArrayList<Node>();
            for (ElementLocation el : subnetElements) {
                Node parent;
                ElementLocation lonely;
                Object cand;
                Node nodeToFix = el.getParentNode();
                if (!nodeToFix.isPortal() || el.getParentNode() instanceof MetaNode || alreadyChecked.contains(nodeToFix)) continue;
                alreadyChecked.add(nodeToFix);
                int inInterfaceLinks = 0;
                int outInterfaceLinks = 0;
                for (ElementLocation element : nodeToFix.getElementLocations()) {
                    if (element.getSheetID() != sheetID) continue;
                    outInterfaceLinks += element.getInArcs().size();
                    inInterfaceLinks += element.getOutArcs().size();
                    outInterfaceLinks += element.accessMetaInArcs().size();
                    inInterfaceLinks += element.accessMetaOutArcs().size();
                }
                ElementLocation metaEL = metanodeRepresSubnet.getElementLocations().get(0);
                int metaSheet = metaEL.getSheetID();
                ArrayList<Arc> inMetaArcs = new ArrayList<Arc>();
                ArrayList<Arc> outMetaArcs = new ArrayList<Arc>();
                for (Arc arc : metaEL.accessMetaInArcs()) {
                    if (!arc.getStartNode().equals(nodeToFix)) continue;
                    inMetaArcs.add(arc);
                }
                for (Arc arc : metaEL.accessMetaOutArcs()) {
                    if (!arc.getEndNode().equals(nodeToFix)) continue;
                    outMetaArcs.add(arc);
                }
                if (inInterfaceLinks > inMetaArcs.size()) {
                    ElementLocation pattern = null;
                    for (ElementLocation cand2 : nodeToFix.getElementLocations()) {
                        if (cand2.getSheetID() != metaSheet) continue;
                        pattern = cand2;
                        break;
                    }
                    if (pattern != null) {
                        if (compressMetaArcs) {
                            this.addAllMissingInMetaArcsCompression(metaEL, pattern, inInterfaceLinks - inMetaArcs.size(), arcs);
                        } else {
                            this.addAllMissingInMetaArcs(metaEL, pattern, inInterfaceLinks - inMetaArcs.size(), arcs);
                        }
                    }
                } else if (inInterfaceLinks < inMetaArcs.size() && !doNotRemove) {
                    int toRemove = inMetaArcs.size() - inInterfaceLinks;
                    ArrayList<Arc> arrayList = new ArrayList<Arc>();
                    for (int r = inMetaArcs.size() - 1; r >= inInterfaceLinks; --r) {
                        cand = ((Arc)inMetaArcs.get(r)).getStartLocation();
                        if (((ElementLocation)cand).accessMetaOutArcs().size() == 1 && ((ElementLocation)cand).accessMetaInArcs().size() == 0 & ((ElementLocation)cand).getInArcs().size() == 0 && ((ElementLocation)cand).getOutArcs().size() == 0) {
                            arrayList.add((Arc)inMetaArcs.get(r));
                        }
                        if (arrayList.size() == toRemove) break;
                    }
                    int elNumber = 0;
                    for (Arc arc : outMetaArcs) {
                        if (!arc.getEndNode().equals(nodeToFix)) continue;
                        ++elNumber;
                    }
                    for (Arc arc : arrayList) {
                        arc.unlinkElementLocations();
                        arcs.remove(arc);
                        --toRemove;
                        if (elNumber <= 1) continue;
                        lonely = arc.getStartLocation();
                        parent = lonely.getParentNode();
                        parent.getElementLocations().remove(lonely);
                        --elNumber;
                    }
                    arrayList.clear();
                    for (int r = inMetaArcs.size() - 1; r >= 0; --r) {
                        if (toRemove > 0) {
                            arrayList.add((Arc)inMetaArcs.get(r));
                        }
                        --toRemove;
                    }
                    for (Arc arc : arrayList) {
                        arc.unlinkElementLocations();
                        arcs.remove(arc);
                    }
                }
                if (outInterfaceLinks > outMetaArcs.size()) {
                    ElementLocation pattern = null;
                    for (ElementLocation cand2 : nodeToFix.getElementLocations()) {
                        if (cand2.getSheetID() != metaSheet) continue;
                        pattern = cand2;
                        break;
                    }
                    if (pattern == null) continue;
                    if (compressMetaArcs) {
                        this.addAllMissingOutMetaArcsCompression(metaEL, pattern, outInterfaceLinks - outMetaArcs.size(), arcs);
                        continue;
                    }
                    this.addAllMissingOutMetaArcs(metaEL, pattern, outInterfaceLinks - outMetaArcs.size(), arcs);
                    continue;
                }
                if (outInterfaceLinks >= outMetaArcs.size() || doNotRemove) continue;
                int toRemove = outMetaArcs.size() - outInterfaceLinks;
                ArrayList<Arc> arrayList = new ArrayList<Arc>();
                for (int r = outMetaArcs.size() - 1; r >= outInterfaceLinks; --r) {
                    cand = ((Arc)outMetaArcs.get(r)).getEndLocation();
                    if (((ElementLocation)cand).accessMetaInArcs().size() == 1 && ((ElementLocation)cand).accessMetaOutArcs().size() == 0 & ((ElementLocation)cand).getInArcs().size() == 0 && ((ElementLocation)cand).getOutArcs().size() == 0) {
                        arrayList.add((Arc)outMetaArcs.get(r));
                    }
                    if (arrayList.size() == toRemove) break;
                }
                int elNumber = 0;
                for (Arc arc : outMetaArcs) {
                    if (!arc.getEndNode().equals(nodeToFix)) continue;
                    ++elNumber;
                }
                for (Arc arc : arrayList) {
                    arc.unlinkElementLocations();
                    arcs.remove(arc);
                    --toRemove;
                    if (elNumber <= 1) continue;
                    lonely = arc.getEndLocation();
                    parent = lonely.getParentNode();
                    parent.getElementLocations().remove(lonely);
                    --elNumber;
                }
                arrayList.clear();
                for (int r = outMetaArcs.size() - 1; r >= 0; --r) {
                    if (toRemove > 0) {
                        arrayList.add((Arc)outMetaArcs.get(r));
                    }
                    --toRemove;
                }
                for (Arc arc : arrayList) {
                    arc.unlinkElementLocations();
                    arcs.remove(arc);
                }
            }
        }
    }

    public void addAllMissingInMetaArcs(ElementLocation metanodeEL, ElementLocation pattern, int howMany, ArrayList<Arc> arcs) {
        Random gen = new Random();
        Node parent = pattern.getParentNode();
        int sheetID = pattern.getSheetID();
        Point refMetaPoint = metanodeEL.getPosition();
        for (int i = 0; i < howMany; ++i) {
            ElementLocation nameEL = new ElementLocation(sheetID, new Point(0, 0), parent);
            int newX = gen.nextInt(160) - 80;
            int newY = gen.nextInt(100) + 15;
            Point point = new Point(refMetaPoint.x + newX, refMetaPoint.y - newY);
            ElementLocation newPortalEL = new ElementLocation(sheetID, point, parent);
            parent.setPortal(true);
            parent.getElementLocations().add(newPortalEL);
            parent.getTextsLocations(GUIManager.locationMoveType.NAME).add(nameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(nameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.BETA).add(nameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(nameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.TAU).add(nameEL);
            Arc arc = new Arc(IdGenerator.getNextId(), newPortalEL, metanodeEL, Arc.TypeOfArc.META_ARC);
            arcs.add(arc);
        }
    }

    public void addAllMissingInMetaArcsCompression(ElementLocation metanodeEL, ElementLocation pattern, int howMany, ArrayList<Arc> arcs) {
        Node nodeTP = pattern.getParentNode();
        ElementLocation nexus = null;
        int currentMax = 0;
        ArrayList<Arc> inMetaArcsFromNodeTP = new ArrayList<Arc>();
        int howManyElements = 0;
        for (Arc arc : metanodeEL.accessMetaInArcs()) {
            if (!arc.getStartNode().equals(nodeTP)) continue;
            ++howManyElements;
            inMetaArcsFromNodeTP.add(arc);
            int outArcs = arc.getStartLocation().accessMetaOutArcs().size();
            if (outArcs <= currentMax) continue;
            currentMax = outArcs;
            nexus = arc.getStartLocation();
        }
        Point p1 = metanodeEL.getPosition();
        double distance = 9.9999999E7;
        if (nexus == null) {
            for (ElementLocation anyone : nodeTP.getElementLocations()) {
                if (anyone.getSheetID() != metanodeEL.getSheetID()) continue;
                if (nexus == null) {
                    nexus = anyone;
                    continue;
                }
                Point p2 = nexus.getPosition();
                double currDist = Math.sqrt(Math.pow(p2.getX() - p1.getX(), 2.0) + Math.pow(p2.getY() - p1.getY(), 2.0));
                if (!(currDist < distance)) continue;
                distance = currDist;
                nexus = anyone;
            }
        }
        for (Arc arc : inMetaArcsFromNodeTP) {
            ElementLocation other = arc.getStartLocation();
            if (other.equals(nexus)) continue;
            for (Arc arcSwitch : other.accessMetaOutArcs()) {
                arcSwitch.modifyStartLocation(nexus);
                nexus.accessMetaOutArcs().add(arcSwitch);
            }
            other.accessMetaOutArcs().clear();
            if (howManyElements <= 1 || other.accessMetaInArcs().size() != 0 || other.getInArcs().size() != 0 || other.getOutArcs().size() != 0) continue;
            nodeTP.getElementLocations().remove(other);
            --howManyElements;
        }
        for (int i = 0; i < howMany; ++i) {
            Arc arc;
            arc = new Arc(IdGenerator.getNextId(), nexus, metanodeEL, Arc.TypeOfArc.META_ARC);
            arcs.add(arc);
        }
    }

    public void addAllMissingOutMetaArcs(ElementLocation metanodeEL, ElementLocation pattern, int howMany, ArrayList<Arc> arcs) {
        Random gen = new Random();
        Node parent = pattern.getParentNode();
        int sheetID = pattern.getSheetID();
        Point refMetaPoint = metanodeEL.getPosition();
        for (int i = 0; i < howMany; ++i) {
            ElementLocation nameEL = new ElementLocation(sheetID, new Point(0, 0), parent);
            int newX = gen.nextInt(160) - 80;
            int newY = gen.nextInt(100) + 15;
            Point point = new Point(refMetaPoint.x + newX, refMetaPoint.y + newY);
            ElementLocation newPortalEL = new ElementLocation(sheetID, point, parent);
            parent.setPortal(true);
            parent.getElementLocations().add(newPortalEL);
            parent.getTextsLocations(GUIManager.locationMoveType.NAME).add(nameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(nameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.BETA).add(nameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(nameEL);
            parent.getTextsLocations(GUIManager.locationMoveType.TAU).add(nameEL);
            Arc arc = new Arc(IdGenerator.getNextId(), metanodeEL, newPortalEL, Arc.TypeOfArc.META_ARC);
            arcs.add(arc);
        }
    }

    public void addAllMissingOutMetaArcsCompression(ElementLocation metanodeEL, ElementLocation pattern, int howMany, ArrayList<Arc> arcs) {
        Node nodeTP = pattern.getParentNode();
        ElementLocation nexus = null;
        int currentMax = 0;
        ArrayList<Arc> outMetaArcsToNodeTP = new ArrayList<Arc>();
        int howManyElements = 0;
        for (Arc arc : metanodeEL.accessMetaOutArcs()) {
            if (!arc.getEndNode().equals(nodeTP)) continue;
            ++howManyElements;
            outMetaArcsToNodeTP.add(arc);
            int inArcs = arc.getEndLocation().accessMetaInArcs().size();
            if (inArcs <= currentMax) continue;
            currentMax = inArcs;
            nexus = arc.getEndLocation();
        }
        Point p1 = metanodeEL.getPosition();
        double distance = 9.9999999E7;
        if (nexus == null) {
            for (ElementLocation anyone : nodeTP.getElementLocations()) {
                if (anyone.getSheetID() != metanodeEL.getSheetID()) continue;
                if (nexus == null) {
                    nexus = anyone;
                    continue;
                }
                Point p2 = nexus.getPosition();
                double currDist = Math.sqrt(Math.pow(p2.getX() - p1.getX(), 2.0) + Math.pow(p2.getY() - p1.getY(), 2.0));
                if (!(currDist < distance)) continue;
                distance = currDist;
                nexus = anyone;
            }
        }
        for (Arc arc : outMetaArcsToNodeTP) {
            ElementLocation other = arc.getEndLocation();
            if (other.equals(nexus)) continue;
            for (Arc arcSwitch : other.accessMetaInArcs()) {
                arcSwitch.modifyEndLocation(nexus);
                nexus.accessMetaInArcs().add(arcSwitch);
            }
            other.accessMetaInArcs().clear();
            if (howManyElements <= 1 || other.accessMetaOutArcs().size() != 0 || other.getInArcs().size() != 0 || other.getOutArcs().size() != 0) continue;
            nodeTP.getElementLocations().remove(other);
            --howManyElements;
        }
        for (int i = 0; i < howMany; ++i) {
            Arc arc;
            arc = new Arc(IdGenerator.getNextId(), metanodeEL, nexus, Arc.TypeOfArc.META_ARC);
            arcs.add(arc);
        }
    }

    public void clearAllMetaArcs(Node node, int subnet) {
        ArrayList<MetaNode> metanodes = this.overlord.getWorkspace().getProject().getMetaNodes();
        MetaNode meta = SubnetsTools.getMetaForSubnet(metanodes, subnet);
        meta.removeAllInConnectionsWith(node);
        meta.removeAllOutConnectionsWith(node);
    }

    public boolean checkSnoopyCompatibility() {
        int i;
        boolean status = false;
        SubnetsSnoopyCompatibility sc = new SubnetsSnoopyCompatibility();
        ArrayList<ArrayList<Integer>> results = sc.macroCheck();
        if (results == null) {
            return true;
        }
        status = sc.checkAndFix(true);
        HolmesNotepad notePad = new HolmesNotepad(900, 600);
        ArrayList<Integer> problemMultiEL = results.get(0);
        ArrayList<Integer> problemWrongType = results.get(1);
        ArrayList<MetaNode> metanodes = this.overlord.getWorkspace().getProject().getMetaNodes();
        int size = problemWrongType.size();
        notePad.addTextLineNL("Multiple locations of metanodes: ", "text");
        for (i = 0; i < size; ++i) {
            if (problemMultiEL.get(i) == 0) continue;
            notePad.addTextLineNL("   Metanode: " + metanodes.get(i).getName() + " [SUBNET: " + metanodes.get(i).getRepresentedSheetID() + "]", "text");
        }
        notePad.addTextLineNL(" ------ ", "text");
        notePad.addTextLineNL("Wrong types of subnets: ", "text");
        for (i = 0; i < size; ++i) {
            if (problemWrongType.get(i) == 0) continue;
            notePad.addTextLineNL("   Metanode: " + metanodes.get(i).getName() + " [SUBNET: " + metanodes.get(i).getRepresentedSheetID() + "] [TYPE: " + metanodes.get(i).getMetaType() + "]", "text");
        }
        notePad.addTextLineNL(" ------ ", "text");
        notePad.setVisible(true);
        return status;
    }

    public boolean checkIfExpendable(ElementLocation el) {
        MetaNode meta2;
        Node parent = el.getParentNode();
        if (el.accessMetaInArcs().size() > 0) {
            ArrayList<MetaNode> metanodesInSubnet = new ArrayList<MetaNode>();
            for (Arc arc : el.accessMetaInArcs()) {
                MetaNode meta2 = (MetaNode)arc.getStartNode();
                if (metanodesInSubnet.contains(meta2)) continue;
                metanodesInSubnet.add(meta2);
            }
            int size = metanodesInSubnet.size();
            block1: for (int m = 0; m < size; ++m) {
                meta2 = (MetaNode)metanodesInSubnet.get(m);
                for (ElementLocation elementLocation : meta2.getElementLocations()) {
                    boolean found = false;
                    for (Arc arc : elementLocation.accessMetaOutArcs()) {
                        if (!arc.getEndNode().equals(parent) || arc.getEndLocation().equals(el)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    metanodesInSubnet.remove(meta2);
                    --m;
                    --size;
                    continue block1;
                }
            }
            if (metanodesInSubnet.size() > 0) {
                for (MetaNode meta2 : metanodesInSubnet) {
                    int repID = meta2.getRepresentedSheetID();
                    for (ElementLocation element : parent.getElementLocations()) {
                        if (element.getSheetID() != repID) continue;
                        return false;
                    }
                }
            }
        }
        if (el.accessMetaOutArcs().size() > 0) {
            ArrayList<MetaNode> metanodesOutSubnet = new ArrayList<MetaNode>();
            for (Arc arc : el.accessMetaOutArcs()) {
                meta2 = (MetaNode)arc.getEndNode();
                if (metanodesOutSubnet.contains(meta2)) continue;
                metanodesOutSubnet.add(meta2);
            }
            int size = metanodesOutSubnet.size();
            block7: for (int m = 0; m < size; ++m) {
                meta2 = (MetaNode)metanodesOutSubnet.get(m);
                for (ElementLocation elementLocation : meta2.getElementLocations()) {
                    boolean found = false;
                    for (Arc arc : elementLocation.accessMetaInArcs()) {
                        if (!arc.getStartNode().equals(parent) || arc.getStartLocation().equals(el)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    metanodesOutSubnet.remove(meta2);
                    --m;
                    --size;
                    continue block7;
                }
            }
            if (metanodesOutSubnet.size() > 0) {
                for (MetaNode meta2 : metanodesOutSubnet) {
                    int repID = meta2.getRepresentedSheetID();
                    for (ElementLocation element : parent.getElementLocations()) {
                        if (element.getSheetID() != repID) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }
}

