/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.simulators.xtpn;

import holmes.darkgui.GUIManager;
import holmes.petrinet.data.MultisetM;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.petrinet.functions.FunctionsTools;
import holmes.petrinet.simulators.IRandomGenerator;
import holmes.petrinet.simulators.QuickSimTools;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.xtpn.SimulatorEngineXTPN;
import holmes.petrinet.simulators.xtpn.StateSimDataContainer;
import holmes.windows.xtpn.HolmesSimXTPN;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class StateSimulatorXTPN
implements Runnable {
    private GUIManager overlord;
    private SimulatorEngineXTPN engineXTPN;
    private SimulatorGlobals sg;
    private ArrayList<TransitionXTPN> transitions = new ArrayList();
    private ArrayList<PlaceXTPN> places = new ArrayList();
    private MultisetM backupState_MultisetM = new MultisetM();
    ArrayList<ArrayList<SimulatorEngineXTPN.NextXTPNstep>> nextXTPNsteps;
    SimulatorEngineXTPN.NextXTPNstep infoNode;
    ArrayList<TransitionXTPN> consumingTokensTransitionsXTPN = new ArrayList();
    ArrayList<TransitionXTPN> consumingTokensTransitionsClassical = new ArrayList();
    ArrayList<TransitionXTPN> producingTokensTransitionsAll = new ArrayList();
    ArrayList<ArrayList<TransitionXTPN>> transitionsAfterSubtracting = new ArrayList();
    private int simulationType;
    private boolean readyToSimulate = false;
    private boolean terminate = false;
    public double simStepsCounter = 0.0;
    public double simTimeCounter = 0.0;
    public double simLastTimeChange = 0.0;
    public JProgressBar progressBar;
    private HolmesSimXTPN boss;
    private QuickSimTools quickSim;

    public StateSimulatorXTPN() {
        this.engineXTPN = new SimulatorEngineXTPN();
        this.overlord = GUIManager.getDefaultGUIManager();
        this.sg = this.overlord.simSettings;
    }

    public boolean initiateSim(SimulatorGlobals ownSettings) {
        this.transitions.clear();
        for (Transition trans : this.overlord.getWorkspace().getProject().getTransitions()) {
            if (!(trans instanceof TransitionXTPN)) {
                this.transitions.clear();
                this.overlord.log("Error, non-XTPN transitions found in list sent into SimulatorXTPN!", "error", true);
                return false;
            }
            this.transitions.add((TransitionXTPN)trans);
        }
        for (Place place : this.overlord.getWorkspace().getProject().getPlaces()) {
            if (!(place instanceof PlaceXTPN)) {
                this.transitions.clear();
                this.overlord.log("Error, non-XTPN places found in list sent into SimulatorXTPN!", "error", true);
                return false;
            }
            this.places.add((PlaceXTPN)place);
        }
        if (this.transitions == null || this.places == null) {
            this.readyToSimulate = false;
            return this.readyToSimulate;
        }
        if (this.transitions.size() <= 0 || this.places.size() <= 0) {
            this.readyToSimulate = false;
            return this.readyToSimulate;
        }
        this.engineXTPN.setEngine(ownSettings.getNetType(), this.transitions, this.places);
        this.readyToSimulate = true;
        return this.readyToSimulate;
    }

    public void restartEngine() {
        this.terminate = false;
        this.simStepsCounter = 0.0;
        this.simTimeCounter = 0.0;
        this.simLastTimeChange = 0.0;
        this.readyToSimulate = true;
    }

    public IRandomGenerator getRandomGenerator() {
        return this.engineXTPN.getGenerator();
    }

    public void setThreadDetails(int simulationType, Object ... blackBox) {
        this.simulationType = simulationType;
        if (simulationType == 1) {
            this.quickSim = (QuickSimTools)blackBox[0];
            this.sg = (SimulatorGlobals)blackBox[1];
            this.progressBar = (JProgressBar)blackBox[2];
        } else if (simulationType == 2) {
            this.quickSim = (QuickSimTools)blackBox[0];
            this.sg = (SimulatorGlobals)blackBox[1];
            this.progressBar = (JProgressBar)blackBox[2];
        } else if (simulationType == 3) {
            this.quickSim = (QuickSimTools)blackBox[0];
            this.sg = (SimulatorGlobals)blackBox[1];
            this.progressBar = (JProgressBar)blackBox[2];
        } else if (simulationType == 4) {
            this.boss = (HolmesSimXTPN)blackBox[0];
            this.sg = (SimulatorGlobals)blackBox[1];
            this.progressBar = (JProgressBar)blackBox[2];
        }
    }

    @Override
    public void run() {
        this.terminate = false;
        if (this.simulationType == 1) {
            StateSimDataContainer result = this.quickSimGatherData();
            this.quickSim.finishedStatsDataXTPN(result, this.transitions, this.places);
        } else if (this.simulationType == 2) {
            StateSimDataContainer result = this.quickSimGatherDataRepetitions(false, 0);
            this.quickSim.finishedStatsDataXTPN(result, this.transitions, this.places);
        } else if (this.simulationType == 3) {
            ArrayList<StateSimDataContainer> result = this.quickSimKnockout();
            this.quickSim.finishedStatsDataXTPN_Knockout(result, this.transitions, this.places);
        } else if (this.simulationType == 4) {
            StateSimDataContainer result = this.simulateNet();
            this.boss.completeSimulationProcedures_Mk1(result);
        }
        this.terminate = false;
    }

    public void setCancelStatus(boolean status) {
        this.terminate = status;
        if (status) {
            this.readyToSimulate = false;
        }
    }

    private ArrayList<ArrayList<Double>> processSimStep() {
        ArrayList<Double> placesTokensVector = new ArrayList<Double>();
        ArrayList<Double> placesTimeVector = new ArrayList<Double>();
        ArrayList<ArrayList<Double>> placesResultVectors = new ArrayList<ArrayList<Double>>();
        placesResultVectors.add(placesTokensVector);
        placesResultVectors.add(placesTimeVector);
        ArrayList<SimulatorEngineXTPN.NextXTPNstep> classicalInputTransitions = this.engineXTPN.revalidateNetState();
        this.nextXTPNsteps = this.engineXTPN.computeNextState();
        this.nextXTPNsteps.set(4, classicalInputTransitions);
        this.nextXTPNsteps.get((int)6).get((int)0).changeType += classicalInputTransitions.size();
        this.infoNode = this.nextXTPNsteps.get(6).get(0);
        if (this.infoNode.changeType == 0) {
            this.terminate = true;
        }
        this.engineXTPN.updateNetTime(this.infoNode.timeToChange);
        this.simStepsCounter += 1.0;
        double oldTIme = this.simTimeCounter;
        this.simTimeCounter += this.infoNode.timeToChange;
        this.consumingTokensTransitionsXTPN = this.engineXTPN.returnConsumingTransXTPNVector(this.nextXTPNsteps);
        this.consumingTokensTransitionsClassical = this.engineXTPN.returnConsumingTransClassicalVector(this.nextXTPNsteps);
        this.producingTokensTransitionsAll = this.engineXTPN.returnProducingTransVector(this.nextXTPNsteps);
        if (this.consumingTokensTransitionsXTPN.size() > 0 || this.consumingTokensTransitionsClassical.size() > 0) {
            this.transitionsAfterSubtracting = this.consumeTokensSubphase();
            this.engineXTPN.endSubtractPhase(this.transitionsAfterSubtracting);
        }
        if (this.producingTokensTransitionsAll.size() > 0) {
            this.engineXTPN.endProductionPhase(this.producingTokensTransitionsAll);
        }
        ArrayList<TransitionXTPN> stateChangedTransitions = new ArrayList<TransitionXTPN>();
        for (TransitionXTPN trans : this.producingTokensTransitionsAll) {
            ++trans.simHistoryXTPN.simFiredState;
            if (trans.isBetaModeActive()) {
                ++trans.simHistoryXTPN.simProductionState;
                trans.simHistoryXTPN.simProductionTime += this.infoNode.timeToChange;
                if (trans.simHistoryXTPN.storeHistory) {
                    trans.simHistoryXTPN.addHistoryMoment(2.0, this.infoNode.timeToChange);
                }
            } else if (trans.isAlphaModeActive()) {
                ++trans.simHistoryXTPN.simActiveState;
                trans.simHistoryXTPN.simActiveTime += this.infoNode.timeToChange;
                if (trans.simHistoryXTPN.storeHistory) {
                    trans.simHistoryXTPN.addHistoryMoment(1.0, this.infoNode.timeToChange);
                }
            } else {
                ++trans.simHistoryXTPN.simActiveState;
                trans.simHistoryXTPN.simActiveTime += this.infoNode.timeToChange;
                if (trans.simHistoryXTPN.storeHistory) {
                    trans.simHistoryXTPN.addHistoryMoment(1.0, this.infoNode.timeToChange);
                }
            }
            if (trans.simHistoryXTPN.storeHistory) {
                trans.simHistoryXTPN.addHistoryMoment(3.0, this.infoNode.timeToChange);
            }
            stateChangedTransitions.add(trans);
        }
        if (this.transitionsAfterSubtracting.size() == 3) {
            for (TransitionXTPN trans : this.transitionsAfterSubtracting.get(2)) {
                ++trans.simHistoryXTPN.simActiveState;
                trans.simHistoryXTPN.simActiveTime += this.infoNode.timeToChange;
                stateChangedTransitions.add(trans);
                if (!trans.simHistoryXTPN.storeHistory) continue;
                trans.simHistoryXTPN.addHistoryMoment(1.0, this.infoNode.timeToChange);
            }
            for (TransitionXTPN trans : this.transitionsAfterSubtracting.get(0)) {
                if (this.producingTokensTransitionsAll.contains(trans)) continue;
                if (trans.isBetaModeActive()) {
                    ++trans.simHistoryXTPN.simActiveState;
                    trans.simHistoryXTPN.simActiveTime += this.infoNode.timeToChange;
                    if (trans.simHistoryXTPN.storeHistory) {
                        trans.simHistoryXTPN.addHistoryMoment(1.0, this.infoNode.timeToChange);
                    }
                }
                stateChangedTransitions.add(trans);
            }
        }
        for (TransitionXTPN trans : this.transitions) {
            if (stateChangedTransitions.contains(trans)) continue;
            if (trans.isActivated_xTPN()) {
                ++trans.simHistoryXTPN.simActiveState;
                trans.simHistoryXTPN.simActiveTime += this.infoNode.timeToChange;
                if (!trans.simHistoryXTPN.storeHistory) continue;
                trans.simHistoryXTPN.addHistoryMoment(1.0, this.infoNode.timeToChange);
                continue;
            }
            if (trans.isProducing_xTPN()) {
                ++trans.simHistoryXTPN.simProductionState;
                trans.simHistoryXTPN.simProductionTime += this.infoNode.timeToChange;
                if (!trans.simHistoryXTPN.storeHistory) continue;
                trans.simHistoryXTPN.addHistoryMoment(2.0, this.infoNode.timeToChange);
                continue;
            }
            ++trans.simHistoryXTPN.simInactiveState;
            trans.simHistoryXTPN.simInactiveTime += this.infoNode.timeToChange;
            if (!trans.simHistoryXTPN.storeHistory) continue;
            trans.simHistoryXTPN.addHistoryMoment(0.0, this.infoNode.timeToChange);
        }
        for (PlaceXTPN place : this.places) {
            if (place.isGammaModeActive()) {
                placesTokensVector.add(Double.valueOf(place.accessMultiset().size()));
                continue;
            }
            placesTokensVector.add(Double.valueOf(place.getTokensNumber()));
        }
        placesTimeVector.add(this.simTimeCounter);
        this.consumingTokensTransitionsXTPN.clear();
        this.consumingTokensTransitionsClassical.clear();
        this.producingTokensTransitionsAll.clear();
        this.transitionsAfterSubtracting.clear();
        this.nextXTPNsteps.clear();
        this.simLastTimeChange = this.infoNode.timeToChange;
        return placesResultVectors;
    }

    public ArrayList<ArrayList<TransitionXTPN>> consumeTokensSubphase() {
        ArrayList<Arc> arcs;
        ArrayList<ArrayList<TransitionXTPN>> launchedTransitions = new ArrayList<ArrayList<TransitionXTPN>>();
        ArrayList<TransitionXTPN> launchedXTPN = new ArrayList<TransitionXTPN>();
        ArrayList<TransitionXTPN> launchedClassical = new ArrayList<TransitionXTPN>();
        ArrayList<TransitionXTPN> deactivated = new ArrayList<TransitionXTPN>();
        for (TransitionXTPN transition : this.consumingTokensTransitionsXTPN) {
            if (transition.isActiveTransitionXTPN(this.sg.getCalculationsAccuracy())) {
                arcs = transition.getInArcs();
                for (Arc arc : arcs) {
                    PlaceXTPN place = (PlaceXTPN)arc.getStartNode();
                    if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR) continue;
                    int weight = arc.getWeight();
                    if (transition.fpnExtension.isFunctional()) {
                        weight = FunctionsTools.getFunctionalArcWeight(transition, arc, place);
                    }
                    ArrayList<Double> removedTokens = place.removeTokensForProduction_XTPN(weight, 0, this.engineXTPN.getGenerator());
                    if (arc.getArcType() != Arc.TypeOfArc.READARC) continue;
                    transition.readArcReturnVector.add(new TransitionXTPN.TokensBack(place, weight, removedTokens));
                }
                launchedXTPN.add(transition);
                continue;
            }
            deactivated.add(transition);
            transition.deactivateTransitionXTPN(false);
            transition.setActivationStatusXTPN(false);
            transition.setProductionStatus_xTPN(false);
            this.producingTokensTransitionsAll.remove(transition);
        }
        boolean mustFireSOMETHING = false;
        int activatedXTPN = this.consumingTokensTransitionsXTPN.size();
        int producedXTPN = this.producingTokensTransitionsAll.size() - 1;
        double time = this.infoNode.timeToChange;
        if (activatedXTPN == 0 && producedXTPN == 0 && time == 0.0) {
            mustFireSOMETHING = true;
        }
        int fireClassSoFar = 0;
        Iterator<TransitionXTPN> iteratorTrans = this.consumingTokensTransitionsClassical.iterator();
        while (iteratorTrans.hasNext()) {
            TransitionXTPN transition = iteratorTrans.next();
            if (!(mustFireSOMETHING && fireClassSoFar == 0 || this.engineXTPN.getGenerator().nextInt(100) >= 50 || transition.isImmediateXTPN())) {
                transition.deactivateTransitionXTPN(false);
                this.producingTokensTransitionsAll.remove(transition);
                iteratorTrans.remove();
                continue;
            }
            if (transition.isActiveTransitionXTPN(this.sg.getCalculationsAccuracy())) {
                ++fireClassSoFar;
                transition.setLaunching(true);
                arcs = transition.getInArcs();
                for (Arc arc : arcs) {
                    PlaceXTPN place = (PlaceXTPN)arc.getStartNode();
                    if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR) continue;
                    int weight = arc.getWeight();
                    if (transition.fpnExtension.isFunctional()) {
                        weight = FunctionsTools.getFunctionalArcWeight(transition, arc, place);
                    }
                    place.removeTokensForProduction_XTPN(weight, 0, this.engineXTPN.getGenerator());
                }
                launchedClassical.add(transition);
                continue;
            }
            deactivated.add(transition);
            transition.deactivateTransitionXTPN(false);
            this.producingTokensTransitionsAll.remove(transition);
        }
        launchedTransitions.add(launchedXTPN);
        launchedTransitions.add(launchedClassical);
        launchedTransitions.add(deactivated);
        return launchedTransitions;
    }

    public void createBackupState() {
        this.backupState_MultisetM.clearMultiset();
        for (PlaceXTPN place : this.places) {
            if (place.isGammaModeActive()) {
                this.backupState_MultisetM.addMultiset_K_toMultiset_M(new ArrayList<Double>(place.accessMultiset()), 1);
                continue;
            }
            int tokens = place.getTokensNumber();
            ArrayList<Double> fakeMultiset = new ArrayList<Double>();
            fakeMultiset.add(Double.valueOf(tokens));
            this.backupState_MultisetM.addMultiset_K_toMultiset_M(fakeMultiset, 0);
        }
        for (TransitionXTPN trans : this.transitions) {
            trans.deactivateTransitionXTPN(false);
            trans.simHistoryXTPN.cleanHistoryVectors();
        }
    }

    public void restoreInternalMarkingZero() {
        for (int placeIndex = 0; placeIndex < this.places.size(); ++placeIndex) {
            PlaceXTPN place = this.places.get(placeIndex);
            if (this.backupState_MultisetM.isPlaceStoredAsGammaActive(placeIndex)) {
                place.setGammaModeStatus(true);
                place.replaceMultiset(new ArrayList<Double>(this.backupState_MultisetM.accessMultiset_K(placeIndex)));
                place.setTokensNumber(this.backupState_MultisetM.accessMultiset_K(placeIndex).size());
                continue;
            }
            place.setGammaModeStatus(false);
            place.accessMultiset().clear();
            double tokensNo = this.backupState_MultisetM.accessMultiset_K(placeIndex).get(0);
            place.setTokensNumber((int)tokensNo);
        }
        for (TransitionXTPN trans : this.transitions) {
            trans.deactivateTransitionXTPN(false);
            trans.simHistoryXTPN.resetSimVariables_XTPN();
            trans.simHistoryXTPN.cleanHistoryVectors();
        }
    }

    public ArrayList<ArrayList<Double>> simulateNetSinglePlace(SimulatorGlobals ownSettings, PlaceXTPN place, int repetitions) {
        ArrayList<Double> tokensNumber = new ArrayList<Double>();
        ArrayList<Double> timeVector = new ArrayList<Double>();
        if (!this.readyToSimulate) {
            JOptionPane.showMessageDialog(null, "XTPN Simulation cannot start, engine initialization failed.", "Simulation problem", 0);
            return null;
        }
        this.createBackupState();
        for (TransitionXTPN trans : this.transitions) {
            trans.simHistoryXTPN.storeHistory = false;
        }
        for (int rep = 0; rep < repetitions; ++rep) {
            int i = 0;
            while ((long)i < ownSettings.getSimSteps_XTPN() && !this.terminate) {
                this.processSimStep();
                if (rep == 0) {
                    if (place.isGammaModeActive()) {
                        tokensNumber.add((double)place.accessMultiset().size() / (double)repetitions);
                    } else {
                        tokensNumber.add((double)place.getTokensNumber() / (double)repetitions);
                    }
                    timeVector.add(this.simTimeCounter / (double)repetitions);
                } else {
                    if (place.isGammaModeActive()) {
                        tokensNumber.set(i, (Double)tokensNumber.get(i) + (double)(place.accessMultiset().size() / repetitions));
                    } else {
                        tokensNumber.set(i, (Double)tokensNumber.get(i) + (double)(place.getTokensNumber() / repetitions));
                    }
                    timeVector.set(i, (Double)timeVector.get(i) + this.simTimeCounter / (double)repetitions);
                }
                ++i;
            }
            this.restoreInternalMarkingZero();
            this.restartEngine();
        }
        ArrayList<ArrayList<Double>> resultVectors = new ArrayList<ArrayList<Double>>();
        resultVectors.add(tokensNumber);
        resultVectors.add(timeVector);
        this.readyToSimulate = false;
        return resultVectors;
    }

    public ArrayList<ArrayList<Double>> simulateNetSingleTransition(SimulatorGlobals ownSettings, TransitionXTPN transition, int repetitions) {
        ArrayList<Double> statusVector = new ArrayList<Double>();
        ArrayList<Double> timeVector = new ArrayList<Double>();
        ArrayList<Double> statsVector = new ArrayList<Double>();
        statsVector.addAll(Arrays.asList(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        if (!this.readyToSimulate) {
            JOptionPane.showMessageDialog(null, "XTPN Simulation cannot start, engine initialization failed.", "Simulation problem", 0);
            return null;
        }
        this.createBackupState();
        transition.simHistoryXTPN.storeHistory = true;
        for (int rep = 0; rep < repetitions; ++rep) {
            int step = 0;
            while ((long)step < ownSettings.getSimSteps_XTPN() && !this.terminate) {
                this.processSimStep();
                if (rep == 0) {
                    statusVector.add(transition.simHistoryXTPN.statesHistory.get(step) / (double)repetitions);
                    timeVector.add(this.simTimeCounter / (double)repetitions);
                    statsVector.set(0, (double)ownSettings.getSimSteps_XTPN() / (double)repetitions);
                    statsVector.set(1, this.simTimeCounter / (double)repetitions);
                    statsVector.set(2, (double)transition.simHistoryXTPN.simInactiveState / (double)repetitions);
                    statsVector.set(3, (double)transition.simHistoryXTPN.simActiveState / (double)repetitions);
                    statsVector.set(4, (double)transition.simHistoryXTPN.simProductionState / (double)repetitions);
                    statsVector.set(5, (double)transition.simHistoryXTPN.simFiredState / (double)repetitions);
                    statsVector.set(6, transition.simHistoryXTPN.simInactiveTime / (double)repetitions);
                    statsVector.set(7, transition.simHistoryXTPN.simActiveTime / (double)repetitions);
                    statsVector.set(8, transition.simHistoryXTPN.simProductionTime / (double)repetitions);
                } else {
                    statusVector.set(step, (Double)statusVector.get(step) + transition.simHistoryXTPN.statesHistory.get(step) / (double)repetitions);
                    timeVector.set(step, (Double)timeVector.get(step) + this.simTimeCounter / (double)repetitions);
                    statsVector.set(0, (Double)statsVector.get(0) + (double)ownSettings.getSimSteps_XTPN() / (double)repetitions);
                    statsVector.set(1, (Double)statsVector.get(1) + this.simTimeCounter / (double)repetitions);
                    statsVector.set(2, (Double)statsVector.get(2) + (double)transition.simHistoryXTPN.simInactiveState / (double)repetitions);
                    statsVector.set(3, (Double)statsVector.get(3) + (double)transition.simHistoryXTPN.simActiveState / (double)repetitions);
                    statsVector.set(4, (Double)statsVector.get(4) + (double)transition.simHistoryXTPN.simProductionState / (double)repetitions);
                    statsVector.set(5, (Double)statsVector.get(5) + (double)transition.simHistoryXTPN.simFiredState / (double)repetitions);
                    statsVector.set(6, (Double)statsVector.get(6) + transition.simHistoryXTPN.simInactiveTime / (double)repetitions);
                    statsVector.set(7, (Double)statsVector.get(7) + transition.simHistoryXTPN.simActiveTime / (double)repetitions);
                    statsVector.set(8, (Double)statsVector.get(8) + transition.simHistoryXTPN.simProductionTime / (double)repetitions);
                }
                ++step;
            }
            this.restoreInternalMarkingZero();
            this.restartEngine();
            transition.simHistoryXTPN.storeHistory = true;
        }
        ArrayList<ArrayList<Double>> resultVectors = new ArrayList<ArrayList<Double>>();
        resultVectors.add(statusVector);
        resultVectors.add(timeVector);
        resultVectors.add(statsVector);
        this.readyToSimulate = false;
        return resultVectors;
    }

    public ArrayList<Double> simulateNetSingleTransitionStatistics(SimulatorGlobals ownSettings, TransitionXTPN transition) {
        ArrayList<Double> dataVector = new ArrayList<Double>();
        if (!this.readyToSimulate) {
            JOptionPane.showMessageDialog(null, "XTPN Simulation cannot start, engine initialization failed.", "Simulation problem", 0);
            return dataVector;
        }
        this.createBackupState();
        for (TransitionXTPN trans : this.transitions) {
            trans.simHistoryXTPN.storeHistory = false;
        }
        int step = 0;
        if (ownSettings.isTimeSimulation_XTPN()) {
            while (this.simTimeCounter < ownSettings.getSimTime_XTPN() && !this.terminate) {
                this.processSimStep();
                ++step;
            }
        } else {
            step = 0;
            while ((long)step < ownSettings.getSimSteps_XTPN() && !this.terminate) {
                this.processSimStep();
                ++step;
            }
        }
        for (TransitionXTPN trans : this.transitions) {
            if (!trans.equals(transition)) continue;
            dataVector.add(Double.valueOf(step));
            dataVector.add(this.simTimeCounter);
            dataVector.add(Double.valueOf(trans.simHistoryXTPN.simInactiveState));
            dataVector.add(Double.valueOf(trans.simHistoryXTPN.simActiveState));
            dataVector.add(Double.valueOf(trans.simHistoryXTPN.simProductionState));
            dataVector.add(Double.valueOf(trans.simHistoryXTPN.simFiredState));
            dataVector.add(trans.simHistoryXTPN.simInactiveTime);
            dataVector.add(trans.simHistoryXTPN.simActiveTime);
            dataVector.add(trans.simHistoryXTPN.simProductionTime);
            break;
        }
        this.readyToSimulate = false;
        this.restoreInternalMarkingZero();
        return dataVector;
    }

    public StateSimDataContainer simulateNet() {
        StateSimDataContainer resMatrix = new StateSimDataContainer();
        if (!this.readyToSimulate) {
            JOptionPane.showMessageDialog(null, "XTPN Simulation cannot start, engine initialization failed.", "Simulation problem", 0);
            return resMatrix;
        }
        this.createBackupState();
        resMatrix = this.sg.isTimeSimulation_XTPN() ? this.simulateNetTime() : this.simulateNetSteps();
        SimulatorGlobals ssg = this.overlord.simSettings;
        this.readyToSimulate = false;
        this.restoreInternalMarkingZero();
        return resMatrix;
    }

    public StateSimDataContainer simulateNetSteps() {
        StateSimDataContainer resMatrix = new StateSimDataContainer();
        ArrayList<Double> averageTransFire = new ArrayList<Double>();
        ArrayList<ArrayList<Double>> tokensInSteps = new ArrayList<ArrayList<Double>>();
        ArrayList<Double> avgTimeForStep = new ArrayList<Double>();
        Date dateStart = new Date();
        int repetitionsValue = this.sg.getSimRepetitions_XTPN();
        boolean onlySelected = this.sg.isPartialRecordingSteps();
        int selSteps = 0;
        if (onlySelected) {
            selSteps = this.sg.getRecordedSteps();
        }
        boolean recordStats = this.sg.isStatsRecorded();
        ArrayList<Double> averageTokens = new ArrayList<Double>();
        ArrayList<ArrayList<Double>> transStatsFinal = new ArrayList<ArrayList<Double>>();
        for (PlaceXTPN ignored : this.places) {
            averageTokens.add(0.0);
        }
        for (TransitionXTPN trans : this.transitions) {
            trans.simHistoryXTPN.storeHistory = true;
            averageTransFire.add(0.0);
            transStatsFinal.add(new ArrayList<Double>(Arrays.asList(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)));
            resMatrix.transitionsSimHistory.add(new ArrayList());
        }
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(repetitionsValue * 10);
        int progress = 0;
        resMatrix.simReps = repetitionsValue;
        for (int rep = 0; rep < this.sg.getSimRepetitions_XTPN(); ++rep) {
            int tenth = (int)this.sg.getSimSteps_XTPN() / 10;
            int maxUpdate = 0;
            int realStep = 0;
            int step = 0;
            while ((long)step < this.sg.getSimSteps_XTPN() && !this.terminate) {
                ArrayList<ArrayList<Double>> placesStatusVectors = this.processSimStep();
                if (step > 0 && onlySelected && step % selSteps != 0) {
                    if (step % tenth == 0 && maxUpdate < 10) {
                        this.progressBar.setValue(progress++);
                        this.progressBar.update(this.progressBar.getGraphics());
                        ++maxUpdate;
                    }
                } else {
                    double state;
                    TransitionStepStats stepHist;
                    int tID;
                    int placeID;
                    if (rep == 0) {
                        tokensInSteps.add(placesStatusVectors.get(0));
                        for (placeID = 0; placeID < placesStatusVectors.get(0).size(); ++placeID) {
                            averageTokens.set(placeID, (Double)averageTokens.get(placeID) + placesStatusVectors.get(0).get(placeID));
                        }
                        avgTimeForStep.add(placesStatusVectors.get(1).get(0));
                        for (tID = 0; tID < this.transitions.size(); ++tID) {
                            TransitionXTPN trans = this.transitions.get(tID);
                            stepHist = new TransitionStepStats();
                            state = trans.simHistoryXTPN.statesHistory.get(trans.simHistoryXTPN.statesHistory.size() - 1);
                            if (state == 0.0) {
                                stepHist.inactive += 1.0 / (double)repetitionsValue;
                            } else if (state == 1.0) {
                                stepHist.active += 1.0 / (double)repetitionsValue;
                            } else if (state == 2.0) {
                                stepHist.producing += 1.0 / (double)repetitionsValue;
                            } else if (state == 3.0) {
                                stepHist.fired += 1.0 / (double)repetitionsValue;
                                averageTransFire.set(tID, (Double)averageTransFire.get(tID) + 1.0);
                            }
                            resMatrix.transitionsSimHistory.get(tID).add(stepHist);
                        }
                    } else if (rep < repetitionsValue - 1) {
                        for (placeID = 0; placeID < placesStatusVectors.get(0).size(); ++placeID) {
                            double tokens = placesStatusVectors.get(0).get(placeID);
                            ((ArrayList)tokensInSteps.get(realStep)).set(placeID, (Double)((ArrayList)tokensInSteps.get(realStep)).get(placeID) + tokens);
                            averageTokens.set(placeID, (Double)averageTokens.get(placeID) + tokens);
                        }
                        avgTimeForStep.set(realStep, (Double)avgTimeForStep.get(realStep) + placesStatusVectors.get(1).get(0));
                        for (tID = 0; tID < this.transitions.size(); ++tID) {
                            TransitionXTPN trans = this.transitions.get(tID);
                            stepHist = new TransitionStepStats();
                            state = trans.simHistoryXTPN.statesHistory.get(trans.simHistoryXTPN.statesHistory.size() - 1);
                            if (state == 0.0) {
                                resMatrix.transitionsSimHistory.get((int)tID).get((int)realStep).inactive += 1.0 / (double)repetitionsValue;
                                continue;
                            }
                            if (state == 1.0) {
                                resMatrix.transitionsSimHistory.get((int)tID).get((int)realStep).active += 1.0 / (double)repetitionsValue;
                                continue;
                            }
                            if (state == 2.0) {
                                resMatrix.transitionsSimHistory.get((int)tID).get((int)realStep).producing += 1.0 / (double)repetitionsValue;
                                continue;
                            }
                            if (state != 3.0) continue;
                            resMatrix.transitionsSimHistory.get((int)tID).get((int)realStep).fired += 1.0 / (double)repetitionsValue;
                            averageTransFire.set(tID, (Double)averageTransFire.get(tID) + 1.0);
                        }
                        ++realStep;
                    } else {
                        for (placeID = 0; placeID < placesStatusVectors.get(0).size(); ++placeID) {
                            double tokens = placesStatusVectors.get(0).get(placeID);
                            ((ArrayList)tokensInSteps.get(realStep)).set(placeID, (Double)((ArrayList)tokensInSteps.get(realStep)).get(placeID) + tokens);
                            ((ArrayList)tokensInSteps.get(realStep)).set(placeID, (Double)((ArrayList)tokensInSteps.get(realStep)).get(placeID) / (double)repetitionsValue);
                            averageTokens.set(placeID, (Double)averageTokens.get(placeID) + tokens);
                        }
                        avgTimeForStep.set(realStep, (Double)avgTimeForStep.get(realStep) + placesStatusVectors.get(1).get(0));
                        avgTimeForStep.set(realStep, (Double)avgTimeForStep.get(realStep) / (double)repetitionsValue);
                        for (tID = 0; tID < this.transitions.size(); ++tID) {
                            TransitionXTPN trans = this.transitions.get(tID);
                            stepHist = new TransitionStepStats();
                            state = trans.simHistoryXTPN.statesHistory.get(trans.simHistoryXTPN.statesHistory.size() - 1);
                            if (state == 0.0) {
                                resMatrix.transitionsSimHistory.get((int)tID).get((int)realStep).inactive += 1.0 / (double)repetitionsValue;
                                continue;
                            }
                            if (state == 1.0) {
                                resMatrix.transitionsSimHistory.get((int)tID).get((int)realStep).active += 1.0 / (double)repetitionsValue;
                                continue;
                            }
                            if (state == 2.0) {
                                resMatrix.transitionsSimHistory.get((int)tID).get((int)realStep).producing += 1.0 / (double)repetitionsValue;
                                continue;
                            }
                            if (state != 3.0) continue;
                            resMatrix.transitionsSimHistory.get((int)tID).get((int)realStep).fired += 1.0 / (double)repetitionsValue;
                            averageTransFire.set(tID, (Double)averageTransFire.get(tID) + 1.0);
                        }
                        ++realStep;
                    }
                    if (step % tenth == 0 && maxUpdate < 10) {
                        this.progressBar.setValue(progress++);
                        this.progressBar.update(this.progressBar.getGraphics());
                        ++maxUpdate;
                    }
                }
                ++step;
            }
            resMatrix.simSteps += (double)this.sg.getSimSteps_XTPN();
            for (int transID = 0; transID < this.transitions.size(); ++transID) {
                ((ArrayList)transStatsFinal.get(transID)).set(0, (Double)((ArrayList)transStatsFinal.get(transID)).get(0) + (double)this.transitions.get((int)transID).simHistoryXTPN.simInactiveState);
                ((ArrayList)transStatsFinal.get(transID)).set(1, (Double)((ArrayList)transStatsFinal.get(transID)).get(1) + (double)this.transitions.get((int)transID).simHistoryXTPN.simActiveState);
                ((ArrayList)transStatsFinal.get(transID)).set(2, (Double)((ArrayList)transStatsFinal.get(transID)).get(2) + (double)this.transitions.get((int)transID).simHistoryXTPN.simProductionState);
                ((ArrayList)transStatsFinal.get(transID)).set(3, (Double)((ArrayList)transStatsFinal.get(transID)).get(3) + (double)this.transitions.get((int)transID).simHistoryXTPN.simFiredState);
                ((ArrayList)transStatsFinal.get(transID)).set(4, (Double)((ArrayList)transStatsFinal.get(transID)).get(4) + this.transitions.get((int)transID).simHistoryXTPN.simInactiveTime);
                ((ArrayList)transStatsFinal.get(transID)).set(5, (Double)((ArrayList)transStatsFinal.get(transID)).get(5) + this.transitions.get((int)transID).simHistoryXTPN.simActiveTime);
                ((ArrayList)transStatsFinal.get(transID)).set(6, (Double)((ArrayList)transStatsFinal.get(transID)).get(6) + this.transitions.get((int)transID).simHistoryXTPN.simProductionTime);
            }
            resMatrix.simTime += this.simTimeCounter;
            this.simTimeCounter = 0.0;
            this.restoreInternalMarkingZero();
            for (TransitionXTPN trans : this.transitions) {
                trans.simHistoryXTPN.storeHistory = true;
            }
        }
        this.progressBar.setValue(repetitionsValue * 10);
        this.progressBar.update(this.progressBar.getGraphics());
        int realSimulatedSteps = tokensInSteps.size();
        for (int transID = 0; transID < this.transitions.size(); ++transID) {
            ((ArrayList)transStatsFinal.get(transID)).set(0, (Double)((ArrayList)transStatsFinal.get(transID)).get(0) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(transID)).set(1, (Double)((ArrayList)transStatsFinal.get(transID)).get(1) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(transID)).set(2, (Double)((ArrayList)transStatsFinal.get(transID)).get(2) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(transID)).set(3, (Double)((ArrayList)transStatsFinal.get(transID)).get(3) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(transID)).set(4, (Double)((ArrayList)transStatsFinal.get(transID)).get(4) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(transID)).set(5, (Double)((ArrayList)transStatsFinal.get(transID)).get(5) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(transID)).set(6, (Double)((ArrayList)transStatsFinal.get(transID)).get(6) / (double)repetitionsValue);
            averageTransFire.set(transID, (Double)averageTransFire.get(transID) / (double)(repetitionsValue * realSimulatedSteps));
            this.transitions.get((int)transID).simHistoryXTPN.cleanHistoryVectors();
        }
        for (int pID = 0; pID < this.places.size(); ++pID) {
            averageTokens.set(pID, (Double)averageTokens.get(pID) / (double)(repetitionsValue * realSimulatedSteps));
        }
        resMatrix.simSteps /= (double)repetitionsValue;
        resMatrix.simTime /= (double)repetitionsValue;
        resMatrix.avgTokens = averageTokens;
        resMatrix.avgFired = averageTransFire;
        resMatrix.avgTimeForStep = avgTimeForStep;
        resMatrix.fullTokensHistory = tokensInSteps;
        resMatrix.transitionsStatistics = transStatsFinal;
        Date dateEnd = new Date();
        resMatrix.compTime = dateEnd.getTime() - dateStart.getTime();
        return resMatrix;
    }

    /*
     * WARNING - void declaration
     */
    public StateSimDataContainer simulateNetTime() {
        StateSimDataContainer resMatrix = new StateSimDataContainer();
        ArrayList<Double> averageTransFire = new ArrayList<Double>();
        ArrayList<ArrayList<Double>> tokensInSteps = new ArrayList<ArrayList<Double>>();
        Date dateStart = new Date();
        int repetitionsValue = this.sg.getSimRepetitions_XTPN();
        ArrayList<Double> avgTimeForStep = new ArrayList<Double>();
        ArrayList<ArrayList<Double>> transStatsFinal = new ArrayList<ArrayList<Double>>();
        for (TransitionXTPN transitionXTPN : this.transitions) {
            transitionXTPN.simHistoryXTPN.storeHistory = true;
            averageTransFire.add(0.0);
            transStatsFinal.add(new ArrayList<Double>(Arrays.asList(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)));
            resMatrix.transitionsSimHistory.add(new ArrayList());
        }
        ArrayList<Double> averageTokens = new ArrayList<Double>();
        for (PlaceXTPN ignored : this.places) {
            averageTokens.add(0.0);
        }
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(repetitionsValue * 10);
        boolean bl = false;
        resMatrix.simReps = repetitionsValue;
        for (int rep = 0; rep < repetitionsValue; ++rep) {
            int tenth = (int)this.sg.getSimTime_XTPN() / 10;
            int maxUpdate = 0;
            int step = 0;
            int realStep = 0;
            boolean rep2forceContinue = false;
            if (rep > 0) {
                rep2forceContinue = true;
            }
            while (!(!(this.simTimeCounter < this.sg.getSimTime_XTPN()) && !rep2forceContinue || this.terminate || rep > 0 && step >= avgTimeForStep.size())) {
                double state;
                TransitionStepStats stepHist;
                int tID;
                int placeID;
                ArrayList<ArrayList<Double>> placesStatusVectors = this.processSimStep();
                if (rep == 0) {
                    tokensInSteps.add(placesStatusVectors.get(0));
                    for (placeID = 0; placeID < placesStatusVectors.get(0).size(); ++placeID) {
                        averageTokens.set(placeID, (Double)averageTokens.get(placeID) + placesStatusVectors.get(0).get(placeID));
                    }
                    avgTimeForStep.add(placesStatusVectors.get(1).get(0));
                    for (tID = 0; tID < this.transitions.size(); ++tID) {
                        TransitionXTPN trans = this.transitions.get(tID);
                        stepHist = new TransitionStepStats();
                        state = trans.simHistoryXTPN.statesHistory.get(trans.simHistoryXTPN.statesHistory.size() - 1);
                        if (state == 0.0) {
                            stepHist.inactive += 1.0 / (double)repetitionsValue;
                        } else if (state == 1.0) {
                            stepHist.active += 1.0 / (double)repetitionsValue;
                        } else if (state == 2.0) {
                            stepHist.producing += 1.0 / (double)repetitionsValue;
                        } else if (state == 3.0) {
                            stepHist.fired += 1.0 / (double)repetitionsValue;
                            averageTransFire.set(tID, (Double)averageTransFire.get(tID) + 1.0);
                        }
                        resMatrix.transitionsSimHistory.get(tID).add(stepHist);
                    }
                } else if (rep < repetitionsValue - 1) {
                    for (placeID = 0; placeID < placesStatusVectors.get(0).size(); ++placeID) {
                        double tokens = placesStatusVectors.get(0).get(placeID);
                        ((ArrayList)tokensInSteps.get(realStep)).set(placeID, (Double)((ArrayList)tokensInSteps.get(realStep)).get(placeID) + tokens);
                        averageTokens.set(placeID, (Double)averageTokens.get(placeID) + tokens);
                    }
                    avgTimeForStep.set(realStep, (Double)avgTimeForStep.get(realStep) + placesStatusVectors.get(1).get(0));
                    for (tID = 0; tID < this.transitions.size(); ++tID) {
                        TransitionXTPN trans = this.transitions.get(tID);
                        stepHist = new TransitionStepStats();
                        state = trans.simHistoryXTPN.statesHistory.get(trans.simHistoryXTPN.statesHistory.size() - 1);
                        if (state == 0.0) {
                            resMatrix.transitionsSimHistory.get((int)tID).get((int)realStep).inactive += 1.0 / (double)repetitionsValue;
                            continue;
                        }
                        if (state == 1.0) {
                            resMatrix.transitionsSimHistory.get((int)tID).get((int)realStep).active += 1.0 / (double)repetitionsValue;
                            continue;
                        }
                        if (state == 2.0) {
                            resMatrix.transitionsSimHistory.get((int)tID).get((int)realStep).producing += 1.0 / (double)repetitionsValue;
                            continue;
                        }
                        if (state != 3.0) continue;
                        resMatrix.transitionsSimHistory.get((int)tID).get((int)realStep).fired += 1.0 / (double)repetitionsValue;
                        averageTransFire.set(tID, (Double)averageTransFire.get(tID) + 1.0);
                    }
                    ++realStep;
                } else {
                    for (placeID = 0; placeID < placesStatusVectors.get(0).size(); ++placeID) {
                        double tokens = placesStatusVectors.get(0).get(placeID);
                        ((ArrayList)tokensInSteps.get(realStep)).set(placeID, (Double)((ArrayList)tokensInSteps.get(realStep)).get(placeID) + tokens);
                        ((ArrayList)tokensInSteps.get(realStep)).set(placeID, (Double)((ArrayList)tokensInSteps.get(realStep)).get(placeID) / (double)repetitionsValue);
                        averageTokens.set(placeID, (Double)averageTokens.get(placeID) + tokens);
                        averageTokens.set(placeID, (Double)averageTokens.get(placeID) / (double)this.sg.getSimSteps_XTPN());
                    }
                    avgTimeForStep.set(realStep, (Double)avgTimeForStep.get(realStep) + placesStatusVectors.get(1).get(0));
                    avgTimeForStep.set(realStep, (Double)avgTimeForStep.get(realStep) / (double)repetitionsValue);
                    for (tID = 0; tID < this.transitions.size(); ++tID) {
                        TransitionXTPN trans = this.transitions.get(tID);
                        stepHist = new TransitionStepStats();
                        state = trans.simHistoryXTPN.statesHistory.get(trans.simHistoryXTPN.statesHistory.size() - 1);
                        if (state == 0.0) {
                            resMatrix.transitionsSimHistory.get((int)realStep).get((int)tID).inactive += 1.0 / (double)repetitionsValue;
                            continue;
                        }
                        if (state == 1.0) {
                            resMatrix.transitionsSimHistory.get((int)realStep).get((int)tID).active += 1.0 / (double)repetitionsValue;
                            continue;
                        }
                        if (state == 2.0) {
                            resMatrix.transitionsSimHistory.get((int)realStep).get((int)tID).producing += 1.0 / (double)repetitionsValue;
                            continue;
                        }
                        if (state != 3.0) continue;
                        resMatrix.transitionsSimHistory.get((int)realStep).get((int)tID).fired += 1.0 / (double)repetitionsValue;
                        averageTransFire.set(tID, (Double)averageTransFire.get(tID) + 1.0);
                    }
                    ++realStep;
                }
                if (step % tenth == 0 && maxUpdate < 10) {
                    void var9_12;
                    this.progressBar.setValue((int)(++var9_12));
                    this.progressBar.update(this.progressBar.getGraphics());
                    ++maxUpdate;
                }
                ++step;
            }
            resMatrix.simSteps += (double)this.sg.getSimSteps_XTPN();
            for (int transID = 0; transID < this.transitions.size(); ++transID) {
                ((ArrayList)transStatsFinal.get(transID)).set(0, (Double)((ArrayList)transStatsFinal.get(transID)).get(0) + (double)this.transitions.get((int)transID).simHistoryXTPN.simInactiveState);
                ((ArrayList)transStatsFinal.get(transID)).set(1, (Double)((ArrayList)transStatsFinal.get(transID)).get(1) + (double)this.transitions.get((int)transID).simHistoryXTPN.simActiveState);
                ((ArrayList)transStatsFinal.get(transID)).set(2, (Double)((ArrayList)transStatsFinal.get(transID)).get(2) + (double)this.transitions.get((int)transID).simHistoryXTPN.simProductionState);
                ((ArrayList)transStatsFinal.get(transID)).set(3, (Double)((ArrayList)transStatsFinal.get(transID)).get(3) + (double)this.transitions.get((int)transID).simHistoryXTPN.simFiredState);
                ((ArrayList)transStatsFinal.get(transID)).set(4, (Double)((ArrayList)transStatsFinal.get(transID)).get(4) + this.transitions.get((int)transID).simHistoryXTPN.simInactiveTime);
                ((ArrayList)transStatsFinal.get(transID)).set(5, (Double)((ArrayList)transStatsFinal.get(transID)).get(5) + this.transitions.get((int)transID).simHistoryXTPN.simActiveTime);
                ((ArrayList)transStatsFinal.get(transID)).set(6, (Double)((ArrayList)transStatsFinal.get(transID)).get(6) + this.transitions.get((int)transID).simHistoryXTPN.simProductionTime);
            }
            resMatrix.simTime += this.simTimeCounter;
            this.simTimeCounter = 0.0;
            this.restoreInternalMarkingZero();
            for (TransitionXTPN trans : this.transitions) {
                trans.simHistoryXTPN.storeHistory = true;
            }
        }
        this.progressBar.setValue(repetitionsValue * 10);
        this.progressBar.update(this.progressBar.getGraphics());
        int realSimulatedSteps = tokensInSteps.size();
        for (int tID = 0; tID < this.transitions.size(); ++tID) {
            ((ArrayList)transStatsFinal.get(tID)).set(0, (Double)((ArrayList)transStatsFinal.get(tID)).get(0) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(tID)).set(1, (Double)((ArrayList)transStatsFinal.get(tID)).get(1) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(tID)).set(2, (Double)((ArrayList)transStatsFinal.get(tID)).get(2) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(tID)).set(3, (Double)((ArrayList)transStatsFinal.get(tID)).get(3) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(tID)).set(4, (Double)((ArrayList)transStatsFinal.get(tID)).get(4) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(tID)).set(5, (Double)((ArrayList)transStatsFinal.get(tID)).get(5) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(tID)).set(6, (Double)((ArrayList)transStatsFinal.get(tID)).get(6) / (double)repetitionsValue);
            averageTransFire.set(tID, (Double)averageTransFire.get(tID) / (double)(repetitionsValue * realSimulatedSteps));
            this.transitions.get((int)tID).simHistoryXTPN.cleanHistoryVectors();
        }
        for (int pID = 0; pID < this.places.size(); ++pID) {
            averageTokens.set(pID, (Double)averageTokens.get(pID) / (double)(repetitionsValue * realSimulatedSteps));
        }
        resMatrix.simSteps /= (double)repetitionsValue;
        resMatrix.simTime /= (double)repetitionsValue;
        resMatrix.avgTokens = averageTokens;
        resMatrix.avgFired = averageTransFire;
        resMatrix.avgTimeForStep = avgTimeForStep;
        resMatrix.fullTokensHistory = tokensInSteps;
        resMatrix.transitionsStatistics = transStatsFinal;
        Date dateEnd = new Date();
        resMatrix.compTime = dateEnd.getTime() - dateStart.getTime();
        return resMatrix;
    }

    public StateSimDataContainer quickSimGatherData() {
        int pID;
        ArrayList<ArrayList<Double>> placesStatusVectors;
        int tenth;
        StateSimDataContainer resMatrix = new StateSimDataContainer();
        Date dateStart = new Date();
        resMatrix.simReps = 0.0;
        if (!this.readyToSimulate) {
            JOptionPane.showMessageDialog(null, "XTPN Simulation cannot start, engine initialization failed.", "Simulation problem", 0);
            return resMatrix;
        }
        this.createBackupState();
        int step = 0;
        ArrayList<Double> tokensAvg = new ArrayList<Double>();
        for (PlaceXTPN ignored : this.places) {
            tokensAvg.add(0.0);
        }
        if (this.sg.isTimeSimulation_XTPN()) {
            this.progressBar.setValue(0);
            this.progressBar.setMaximum((int)this.sg.getSimTime_XTPN());
            tenth = (int)(this.sg.getSimTime_XTPN() / 10.0);
            while (this.simTimeCounter < this.sg.getSimTime_XTPN() && !this.terminate) {
                placesStatusVectors = this.processSimStep();
                for (pID = 0; pID < placesStatusVectors.get(0).size(); ++pID) {
                    tokensAvg.set(pID, (Double)tokensAvg.get(pID) + placesStatusVectors.get(0).get(pID));
                }
                if ((int)this.simTimeCounter % tenth == 0) {
                    this.progressBar.setValue((int)this.simTimeCounter);
                    this.progressBar.update(this.progressBar.getGraphics());
                }
                ++step;
            }
            this.progressBar.setValue((int)this.sg.getSimTime_XTPN());
            this.progressBar.update(this.progressBar.getGraphics());
            resMatrix.simSteps = step;
        } else {
            this.progressBar.setValue(0);
            this.progressBar.setMaximum((int)this.sg.getSimSteps_XTPN() - 1);
            tenth = (int)this.sg.getSimSteps_XTPN() / 10;
            step = 0;
            while ((long)step < this.sg.getSimSteps_XTPN() && !this.terminate) {
                placesStatusVectors = this.processSimStep();
                for (pID = 0; pID < placesStatusVectors.get(0).size(); ++pID) {
                    tokensAvg.set(pID, (Double)tokensAvg.get(pID) + placesStatusVectors.get(0).get(pID));
                }
                if (step % tenth == 0) {
                    this.progressBar.setValue(step);
                    this.progressBar.update(this.progressBar.getGraphics());
                }
                ++step;
            }
            this.progressBar.setValue((int)this.sg.getSimSteps_XTPN() - 1);
            this.progressBar.update(this.progressBar.getGraphics());
            resMatrix.simSteps = this.sg.getSimSteps_XTPN();
        }
        resMatrix.simTime = this.simTimeCounter;
        for (int pID2 = 0; pID2 < tokensAvg.size(); ++pID2) {
            double avg = (Double)tokensAvg.get(pID2) / (double)step;
            tokensAvg.set(pID2, avg);
        }
        resMatrix.avgTokens = tokensAvg;
        for (TransitionXTPN trans : this.transitions) {
            ArrayList<Double> dataVector = new ArrayList<Double>();
            dataVector.add(Double.valueOf(trans.simHistoryXTPN.simInactiveState));
            dataVector.add(Double.valueOf(trans.simHistoryXTPN.simActiveState));
            dataVector.add(Double.valueOf(trans.simHistoryXTPN.simProductionState));
            dataVector.add(Double.valueOf(trans.simHistoryXTPN.simFiredState));
            dataVector.add(trans.simHistoryXTPN.simInactiveTime);
            dataVector.add(trans.simHistoryXTPN.simActiveTime);
            dataVector.add(trans.simHistoryXTPN.simProductionTime);
            resMatrix.transitionsStatistics.add(dataVector);
        }
        Date dateEnd = new Date();
        resMatrix.compTime = dateEnd.getTime() - dateStart.getTime();
        this.readyToSimulate = false;
        this.restoreInternalMarkingZero();
        return resMatrix;
    }

    /*
     * WARNING - void declaration
     */
    public StateSimDataContainer quickSimGatherDataRepetitions(boolean knockoutSubSim, int startingProgress) {
        StateSimDataContainer resMatrix = new StateSimDataContainer();
        Date dateStart = new Date();
        if (!this.readyToSimulate) {
            JOptionPane.showMessageDialog(null, "XTPN Simulation cannot start, engine initialization failed.", "Simulation problem", 0);
            return resMatrix;
        }
        this.createBackupState();
        int repetitionsValue = this.sg.getSimRepetitions_XTPN();
        ArrayList<Double> tokensAvg = new ArrayList<Double>();
        ArrayList<Double> tokensAvgFinal = new ArrayList<Double>();
        for (PlaceXTPN placeXTPN : this.places) {
            tokensAvg.add(0.0);
            tokensAvgFinal.add(0.0);
        }
        ArrayList<ArrayList<Double>> transStatsFinal = new ArrayList<ArrayList<Double>>();
        for (TransitionXTPN ignored : this.transitions) {
            transStatsFinal.add(new ArrayList<Double>(Arrays.asList(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0)));
        }
        if (!knockoutSubSim) {
            this.progressBar.setValue(0);
            this.progressBar.setMaximum(repetitionsValue * 10);
        }
        int n = startingProgress;
        resMatrix.simReps = repetitionsValue;
        for (int rep = 0; rep < repetitionsValue; ++rep) {
            void var9_12;
            int pID;
            ArrayList<ArrayList<Double>> placesStatusVectors;
            int tenth;
            int step = 0;
            if (this.sg.isTimeSimulation_XTPN()) {
                tenth = (int)this.sg.getSimTime_XTPN() / 10;
                int counter = 1;
                while (this.simTimeCounter < this.sg.getSimTime_XTPN() && !this.terminate) {
                    placesStatusVectors = this.processSimStep();
                    for (pID = 0; pID < placesStatusVectors.get(0).size(); ++pID) {
                        tokensAvg.set(pID, (Double)tokensAvg.get(pID) + placesStatusVectors.get(0).get(pID));
                    }
                    ++step;
                    if ((int)this.simTimeCounter < counter * tenth) continue;
                    this.progressBar.setValue((int)var9_12++);
                    this.progressBar.update(this.progressBar.getGraphics());
                    ++counter;
                }
                resMatrix.simSteps += (double)step;
            } else {
                tenth = (int)this.sg.getSimSteps_XTPN() / 10;
                int maxUpdate = 0;
                step = 0;
                while ((long)step < this.sg.getSimSteps_XTPN() && !this.terminate) {
                    placesStatusVectors = this.processSimStep();
                    for (pID = 0; pID < placesStatusVectors.get(0).size(); ++pID) {
                        tokensAvg.set(pID, (Double)tokensAvg.get(pID) + placesStatusVectors.get(0).get(pID));
                    }
                    if (step % tenth == 0 && maxUpdate < 10) {
                        this.progressBar.setValue((int)var9_12++);
                        this.progressBar.update(this.progressBar.getGraphics());
                        ++maxUpdate;
                    }
                    ++step;
                }
                resMatrix.simSteps += (double)this.sg.getSimSteps_XTPN();
            }
            for (int pID2 = 0; pID2 < tokensAvg.size(); ++pID2) {
                double avg = (Double)tokensAvg.get(pID2) / (double)step;
                tokensAvgFinal.set(pID2, (Double)tokensAvgFinal.get(pID2) + avg);
                tokensAvg.set(pID2, 0.0);
            }
            for (int tID = 0; tID < this.transitions.size(); ++tID) {
                ((ArrayList)transStatsFinal.get(tID)).set(0, (Double)((ArrayList)transStatsFinal.get(tID)).get(0) + (double)this.transitions.get((int)tID).simHistoryXTPN.simInactiveState);
                ((ArrayList)transStatsFinal.get(tID)).set(1, (Double)((ArrayList)transStatsFinal.get(tID)).get(1) + (double)this.transitions.get((int)tID).simHistoryXTPN.simActiveState);
                ((ArrayList)transStatsFinal.get(tID)).set(2, (Double)((ArrayList)transStatsFinal.get(tID)).get(2) + (double)this.transitions.get((int)tID).simHistoryXTPN.simProductionState);
                ((ArrayList)transStatsFinal.get(tID)).set(3, (Double)((ArrayList)transStatsFinal.get(tID)).get(3) + (double)this.transitions.get((int)tID).simHistoryXTPN.simFiredState);
                ((ArrayList)transStatsFinal.get(tID)).set(4, (Double)((ArrayList)transStatsFinal.get(tID)).get(4) + this.transitions.get((int)tID).simHistoryXTPN.simInactiveTime);
                ((ArrayList)transStatsFinal.get(tID)).set(5, (Double)((ArrayList)transStatsFinal.get(tID)).get(5) + this.transitions.get((int)tID).simHistoryXTPN.simActiveTime);
                ((ArrayList)transStatsFinal.get(tID)).set(6, (Double)((ArrayList)transStatsFinal.get(tID)).get(6) + this.transitions.get((int)tID).simHistoryXTPN.simProductionTime);
            }
            resMatrix.simTime += this.simTimeCounter;
            this.simTimeCounter = 0.0;
            this.restoreInternalMarkingZero();
        }
        resMatrix.simSteps /= (double)repetitionsValue;
        resMatrix.simTime /= (double)repetitionsValue;
        if (!knockoutSubSim) {
            this.progressBar.setValue(repetitionsValue * 10);
            this.progressBar.update(this.progressBar.getGraphics());
        }
        for (int tID = 0; tID < this.transitions.size(); ++tID) {
            ((ArrayList)transStatsFinal.get(tID)).set(0, (Double)((ArrayList)transStatsFinal.get(tID)).get(0) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(tID)).set(1, (Double)((ArrayList)transStatsFinal.get(tID)).get(1) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(tID)).set(2, (Double)((ArrayList)transStatsFinal.get(tID)).get(2) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(tID)).set(3, (Double)((ArrayList)transStatsFinal.get(tID)).get(3) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(tID)).set(4, (Double)((ArrayList)transStatsFinal.get(tID)).get(4) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(tID)).set(5, (Double)((ArrayList)transStatsFinal.get(tID)).get(5) / (double)repetitionsValue);
            ((ArrayList)transStatsFinal.get(tID)).set(6, (Double)((ArrayList)transStatsFinal.get(tID)).get(6) / (double)repetitionsValue);
        }
        resMatrix.transitionsStatistics = transStatsFinal;
        for (int pID = 0; pID < this.places.size(); ++pID) {
            tokensAvgFinal.set(pID, (Double)tokensAvgFinal.get(pID) / (double)repetitionsValue);
        }
        resMatrix.avgTokens = tokensAvgFinal;
        Date dateEnd = new Date();
        resMatrix.compTime = dateEnd.getTime() - dateStart.getTime();
        this.readyToSimulate = false;
        this.restoreInternalMarkingZero();
        return resMatrix;
    }

    public ArrayList<StateSimDataContainer> quickSimKnockout() {
        ArrayList<StateSimDataContainer> resultSets = new ArrayList<StateSimDataContainer>();
        int repetitionsValue = this.sg.getSimRepetitions_XTPN();
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(repetitionsValue * 10 * 2);
        StateSimDataContainer knockoutSet = this.quickSimGatherDataRepetitions(true, 0);
        this.restartEngine();
        ArrayList<Boolean> disabledVector = new ArrayList<Boolean>();
        for (TransitionXTPN trans : this.transitions) {
            disabledVector.add(trans.isKnockedOut());
            trans.setKnockout(false);
        }
        StateSimDataContainer referenceSet = this.quickSimGatherDataRepetitions(true, repetitionsValue * 10);
        for (int tID = 0; tID < disabledVector.size(); ++tID) {
            this.transitions.get(tID).setKnockout((Boolean)disabledVector.get(tID));
        }
        this.progressBar.setValue(repetitionsValue * 10 * 2);
        this.progressBar.update(this.progressBar.getGraphics());
        resultSets.add(referenceSet);
        resultSets.add(knockoutSet);
        return resultSets;
    }

    public static final class TransitionStepStats {
        public double inactive = 0.0;
        public double active = 0.0;
        public double producing = 0.0;
        public double fired = 0.0;
    }
}

