/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.simulators.xtpn;

import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.petrinet.functions.FunctionsTools;
import holmes.petrinet.simulators.HighQualityRandom;
import holmes.petrinet.simulators.IRandomGenerator;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.StandardRandom;
import holmes.petrinet.simulators.xtpn.IEngineXTPN;
import java.util.ArrayList;
import java.util.Collections;

public class SimulatorEngineXTPN
implements IEngineXTPN {
    private GUIManager overlord;
    private SimulatorGlobals sg;
    private SimulatorGlobals.SimNetType netSimTypeXTPN = SimulatorGlobals.SimNetType.XTPN;
    private ArrayList<TransitionXTPN> transitions;
    private ArrayList<PlaceXTPN> places;
    private IRandomGenerator generator;
    private boolean graphicalSimulation = false;
    private boolean globalMAK = false;

    public void setGraphicalSimulation(boolean status) {
        this.graphicalSimulation = status;
    }

    public SimulatorEngineXTPN() {
        this.overlord = GUIManager.getDefaultGUIManager();
        this.generator = new StandardRandom(System.currentTimeMillis());
        this.sg = this.overlord.simSettings;
        this.globalMAK = GUIManager.getDefaultGUIManager().getSettingsManager().getValue("simXTPNmassAction").equals("1");
        this.transitions = new ArrayList();
        this.places = new ArrayList();
    }

    @Override
    public void setEngine(SimulatorGlobals.SimNetType simulationType, ArrayList<TransitionXTPN> transitions, ArrayList<PlaceXTPN> places) {
        this.netSimTypeXTPN = simulationType;
        this.sg = this.overlord.simSettings;
        this.transitions = transitions;
        this.places = places;
        this.globalMAK = GUIManager.getDefaultGUIManager().getSettingsManager().getValue("simXTPNmassAction").equals("1");
        this.generator = this.overlord.simSettings.getGeneratorType() == 1 ? new HighQualityRandom(System.currentTimeMillis()) : new StandardRandom(System.currentTimeMillis());
    }

    @Override
    public void setNetSimType(SimulatorGlobals.SimNetType simulationType) {
        if (simulationType == SimulatorGlobals.SimNetType.XTPN || simulationType == SimulatorGlobals.SimNetType.XTPNfunc || simulationType == SimulatorGlobals.SimNetType.XTPNext || simulationType == SimulatorGlobals.SimNetType.XTPNext_func) {
            this.netSimTypeXTPN = simulationType;
        } else {
            this.overlord.log("Wrong simulation type for XTPN simulator: " + simulationType, "error", true);
        }
    }

    public ArrayList<NextXTPNstep> revalidateNetState() {
        ArrayList<NextXTPNstep> classicalInputOnes = new ArrayList<NextXTPNstep>();
        for (PlaceXTPN place : this.places) {
            place.removeOldTokens_XTPN();
        }
        for (TransitionXTPN transition : this.transitions) {
            if (transition.isProducing_xTPN()) continue;
            if (!transition.isActivated_xTPN()) {
                double rand;
                double max;
                if (transition.isInputTransition()) {
                    if (transition.isAlphaModeActive()) {
                        double min = transition.getAlphaMinValue();
                        rand = this.getSafeRandomValueXTPN(transition, min, max = transition.getAlphaMaxValue());
                        if (rand < this.sg.getCalculationsAccuracy()) {
                            min = transition.getBetaMinValue();
                            max = transition.getBetaMaxValue();
                            rand = this.getSafeRandomValueXTPN(transition, min, max);
                            assert (rand > this.sg.getCalculationsAccuracy()) : "Alfy s\u0105 zerami, beta te\u017c?! Jakim cudem?";
                            transition.setTauBetaValue(rand);
                            transition.setTimerBetaValue(0.0);
                            transition.setProductionStatus_xTPN(true);
                            continue;
                        }
                        transition.setTauAlphaValue(rand);
                        transition.setTimerAlfaValue(0.0);
                        transition.setActivationStatusXTPN(true);
                        continue;
                    }
                    if (transition.isBetaModeActive()) {
                        double min = transition.getBetaMinValue();
                        max = transition.getBetaMaxValue();
                        rand = this.getSafeRandomValueXTPN(transition, min, max);
                        transition.setTauBetaValue(rand);
                        transition.setTimerBetaValue(0.0);
                        transition.setProductionStatus_xTPN(true);
                        if (!this.graphicalSimulation) continue;
                        for (Arc arc : transition.getOutArcs()) {
                            arc.arcXTPNbox.setXTPNprodStatus(true);
                        }
                        continue;
                    }
                    classicalInputOnes.add(new NextXTPNstep(transition, -1.0, 3));
                    continue;
                }
                if (!transition.isActiveTransitionXTPN(this.sg.getCalculationsAccuracy())) continue;
                if (transition.isAlphaModeActive()) {
                    double min = transition.getAlphaMinValue();
                    rand = this.getSafeRandomValueXTPN(transition, min, max = transition.getAlphaMaxValue());
                    if (rand < this.sg.getCalculationsAccuracy()) {
                        min = transition.getBetaMinValue();
                        max = transition.getBetaMaxValue();
                        rand = this.getSafeRandomValueXTPN(transition, min, max);
                        assert (rand > this.sg.getCalculationsAccuracy()) : "Alfy s\u0105 zerami, beta te\u017c?! Jakim cudem?";
                        transition.setTauBetaValue(rand);
                        transition.setTimerBetaValue(0.0);
                        transition.setProductionStatus_xTPN(true);
                        if (this.graphicalSimulation) {
                            for (Arc arc : transition.getOutArcs()) {
                                arc.arcXTPNbox.setXTPNprodStatus(true);
                            }
                        }
                    } else {
                        transition.setTauAlphaValue(rand);
                        transition.setTimerAlfaValue(0.0);
                        transition.setActivationStatusXTPN(true);
                    }
                } else if (transition.isBetaModeActive()) {
                    double min = transition.getBetaMinValue();
                    max = transition.getBetaMaxValue();
                    rand = this.getSafeRandomValueXTPN(transition, min, max);
                    transition.setTauBetaValue(rand);
                    transition.setTimerBetaValue(0.0);
                    if (this.graphicalSimulation) {
                        for (Arc arc : transition.getOutArcs()) {
                            arc.arcXTPNbox.setXTPNprodStatus(true);
                        }
                    }
                    transition.setActivationStatusXTPN(true);
                }
                if (!this.graphicalSimulation) continue;
                ArrayList<Arc> arcs = transition.getInArcs();
                for (Arc arc : arcs) {
                    arc.arcXTPNbox.setXTPNactStatus(true);
                }
                continue;
            }
            if (transition.isInputTransition() || transition.isActiveTransitionXTPN(this.sg.getCalculationsAccuracy())) continue;
            transition.deactivateTransitionXTPN(this.graphicalSimulation);
        }
        return classicalInputOnes;
    }

    public ArrayList<ArrayList<NextXTPNstep>> computeNextState() {
        ArrayList<ArrayList<NextXTPNstep>> stateVector = new ArrayList<ArrayList<NextXTPNstep>>();
        ArrayList<NextXTPNstep> placesMaturity = new ArrayList<NextXTPNstep>();
        ArrayList<NextXTPNstep> placesAging = new ArrayList<NextXTPNstep>();
        ArrayList<NextXTPNstep> transProdStart = new ArrayList<NextXTPNstep>();
        ArrayList<NextXTPNstep> transProdEnd = new ArrayList<NextXTPNstep>();
        ArrayList<NextXTPNstep> transOtherClassical = new ArrayList<NextXTPNstep>();
        double currentMinTime = Double.MAX_VALUE;
        block0: for (PlaceXTPN place : this.places) {
            if (!place.isGammaModeActive() || place.accessMultiset().size() == 0) continue;
            double gammaMin = place.getGammaMinValue();
            double gammaMax = place.getGammaMaxValue();
            boolean closestToGammaMaxSearchMakesNoSense = false;
            for (double kappa : place.accessMultiset()) {
                double timeDifference;
                if (kappa < gammaMin) {
                    timeDifference = gammaMin - kappa;
                    assert (timeDifference >= 0.0);
                    if (timeDifference > currentMinTime) continue block0;
                    if (currentMinTime - timeDifference > 0.0 && !(Math.abs(currentMinTime - timeDifference) < this.sg.getCalculationsAccuracy())) {
                        placesMaturity.clear();
                        placesAging.clear();
                        currentMinTime = timeDifference;
                    }
                    placesMaturity.add(new NextXTPNstep(place, timeDifference, 0));
                    continue;
                }
                if (!(kappa < gammaMax) || closestToGammaMaxSearchMakesNoSense) continue;
                timeDifference = gammaMax - kappa;
                assert (timeDifference >= 0.0);
                if (timeDifference > currentMinTime) {
                    closestToGammaMaxSearchMakesNoSense = true;
                    continue;
                }
                if (currentMinTime - timeDifference > 0.0 && !(Math.abs(currentMinTime - timeDifference) < this.sg.getCalculationsAccuracy())) {
                    placesMaturity.clear();
                    placesAging.clear();
                    currentMinTime = timeDifference;
                }
                placesAging.add(new NextXTPNstep(place, timeDifference, 1));
            }
        }
        for (TransitionXTPN transition : this.transitions) {
            double timeDifference;
            if (!transition.isAlphaModeActive() && !transition.isBetaModeActive()) {
                if (!transition.isActiveTransitionXTPN(this.sg.getCalculationsAccuracy())) continue;
                transOtherClassical.add(new NextXTPNstep(transition, 0.0, 4));
                continue;
            }
            double tauAlpha = transition.getTauAlphaValue();
            double tauBeta = transition.getTauBetaValue();
            double timerAlpha = transition.getTimerAlfaValue();
            double timerBeta = transition.getTimerBetaValue();
            if (!transition.isAlphaModeActive() && transition.isActivated_xTPN()) {
                timeDifference = tauBeta - timerBeta;
                if (currentMinTime - timeDifference > 0.0 && !(Math.abs(currentMinTime - timeDifference) < this.sg.getCalculationsAccuracy())) {
                    placesMaturity.clear();
                    placesAging.clear();
                    transProdStart.clear();
                    transProdEnd.clear();
                    currentMinTime = timeDifference;
                }
                transProdStart.add(new NextXTPNstep(transition, timeDifference, 2));
                continue;
            }
            if (transition.isAlphaModeActive() && transition.isActivated_xTPN()) {
                timeDifference = tauAlpha - timerAlpha;
                assert (timeDifference >= 0.0);
                if (timeDifference > currentMinTime) continue;
                if (currentMinTime - timeDifference > 0.0 && !(Math.abs(currentMinTime - timeDifference) < this.sg.getCalculationsAccuracy())) {
                    placesMaturity.clear();
                    placesAging.clear();
                    transProdStart.clear();
                    transProdEnd.clear();
                    currentMinTime = timeDifference;
                }
                transProdStart.add(new NextXTPNstep(transition, timeDifference, 2));
                if (transition.isBetaModeActive()) continue;
                transProdEnd.add(new NextXTPNstep(transition, timeDifference, 3));
                continue;
            }
            if (!transition.isProducing_xTPN()) continue;
            if (transition.isBetaModeActive()) {
                timeDifference = tauBeta - timerBeta;
                assert (timeDifference >= 0.0);
                if (timeDifference > currentMinTime) continue;
                if (currentMinTime - timeDifference > 0.0 && !(Math.abs(currentMinTime - timeDifference) < this.sg.getCalculationsAccuracy())) {
                    placesMaturity.clear();
                    placesAging.clear();
                    transProdStart.clear();
                    transProdEnd.clear();
                    currentMinTime = timeDifference;
                }
                transProdEnd.add(new NextXTPNstep(transition, timeDifference, 3));
                continue;
            }
            currentMinTime = 0.0;
            transProdEnd.add(new NextXTPNstep(transition, 0.0, 3));
        }
        stateVector.add(placesMaturity);
        stateVector.add(placesAging);
        stateVector.add(transProdStart);
        stateVector.add(transProdEnd);
        stateVector.add(null);
        stateVector.add(transOtherClassical);
        int elements = placesMaturity.size() + placesAging.size() + transProdStart.size() + transProdEnd.size();
        ArrayList<NextXTPNstep> specialVector = new ArrayList<NextXTPNstep>();
        if (currentMinTime == Double.MAX_VALUE) {
            currentMinTime = 0.0;
        }
        if (currentMinTime > Double.MAX_VALUE && transOtherClassical.size() > 0) {
            currentMinTime = 0.0;
        }
        specialVector.add(new NextXTPNstep(null, currentMinTime, elements));
        stateVector.add(specialVector);
        return stateVector;
    }

    public void updateNetTime(double tau) {
        for (PlaceXTPN place : this.places) {
            if (!place.isGammaModeActive()) continue;
            place.incTokensTime_XTPN(tau);
        }
        for (TransitionXTPN transition : this.transitions) {
            if (transition.getTimerAlfaValue() >= 0.0) {
                transition.updateTimerAlfaValue(tau);
            }
            if (!(transition.getTimerBetaValue() >= 0.0)) continue;
            transition.updateTimerBetaValue(tau);
        }
    }

    public void endSubtractPhase(ArrayList<ArrayList<TransitionXTPN>> launchedTransitions) {
        ArrayList<TransitionXTPN> launchedXTPN = launchedTransitions.get(0);
        ArrayList<TransitionXTPN> launchedClassical = launchedTransitions.get(1);
        for (TransitionXTPN transition : launchedXTPN) {
            transition.setLaunching(false);
            if (!(Math.abs(transition.getTauAlphaValue() - transition.getTimerAlfaValue()) < this.sg.getCalculationsAccuracy())) continue;
            if (transition.isBetaModeActive()) {
                if (transition.getTimerBetaValue() >= 0.0) {
                    transition.setProductionStatus_xTPN(true);
                    transition.setTauAlphaValue(-1.0);
                    transition.setTimerAlfaValue(-1.0);
                } else {
                    transition.setProductionStatus_xTPN(true);
                    double min = transition.getBetaMinValue();
                    double max = transition.getBetaMaxValue();
                    double rand = this.getSafeRandomValueXTPN(transition, min, max);
                    transition.setTauBetaValue(rand);
                    transition.setTimerBetaValue(0.0);
                    transition.setTauAlphaValue(-1.0);
                    transition.setTimerAlfaValue(-1.0);
                }
                if (!this.graphicalSimulation) continue;
                for (Arc arc : transition.getOutArcs()) {
                    arc.arcXTPNbox.setXTPNprodStatus(true);
                }
                continue;
            }
            transition.setProductionStatus_xTPN(true);
        }
        for (TransitionXTPN transition : launchedClassical) {
            transition.setProductionStatus_xTPN(true);
        }
    }

    public void endProductionPhase(ArrayList<TransitionXTPN> producingTokensTransitionsAll) {
        for (TransitionXTPN transition : producingTokensTransitionsAll) {
            transition.setLaunching(false);
            ArrayList<Arc> arcs = transition.getOutArcs();
            for (Arc arc : arcs) {
                if (this.graphicalSimulation) {
                    arc.arcXTPNbox.setXTPNprodStatus(false);
                }
                PlaceXTPN place = (PlaceXTPN)arc.getEndNode();
                if (arc.getArcType() != Arc.TypeOfArc.NORMAL && arc.getArcType() != Arc.TypeOfArc.READARC) {
                    this.overlord.log("Warning: non-standard arc used to produce tokens: " + place.getName() + " arc: " + arc, "warning", true);
                }
                if (arc.getArcType() == Arc.TypeOfArc.READARC && this.sg.isXTPNreadArcActive()) continue;
                int weight = arc.getWeight();
                if (transition.fpnExtension.isFunctional()) {
                    weight = FunctionsTools.getFunctionalArcWeight(transition, arc, place);
                }
                place.addTokens_XTPN(weight, 0.0);
            }
            double tau = transition.getTauBetaValue();
            if (this.sg.isXTPNreadArcActive()) {
                if (tau < 0.0) {
                    tau = 0.0;
                }
                for (TransitionXTPN.TokensBack box : transition.readArcReturnVector) {
                    ArrayList<Double> returnedTokens = new ArrayList<Double>();
                    double gammaMax = box.placeBack.getGammaMaxValue();
                    for (int i = 0; i < box.multisetBack.size(); ++i) {
                        if (!(box.multisetBack.get(i) + tau <= gammaMax)) continue;
                        returnedTokens.add(box.multisetBack.get(i) + tau);
                    }
                    box.placeBack.accessMultiset().addAll(returnedTokens);
                    Collections.sort(box.placeBack.accessMultiset());
                    Collections.reverse(box.placeBack.accessMultiset());
                    box.placeBack.modifyTokensNumber(returnedTokens.size());
                    box.Clear();
                }
            }
            transition.deactivateTransitionXTPN(this.graphicalSimulation);
            transition.setActivationStatusXTPN(false);
            transition.setProductionStatus_xTPN(false);
            transition.readArcReturnVector.clear();
        }
    }

    public ArrayList<TransitionXTPN> returnConsumingTransXTPNVector(ArrayList<ArrayList<NextXTPNstep>> nextXTPNsteps) {
        ArrayList<TransitionXTPN> consumingTokensTransitionsXTPN = new ArrayList<TransitionXTPN>();
        for (NextXTPNstep element : nextXTPNsteps.get(2)) {
            consumingTokensTransitionsXTPN.add((TransitionXTPN)element.nodeTP);
        }
        Collections.shuffle(consumingTokensTransitionsXTPN);
        return consumingTokensTransitionsXTPN;
    }

    public ArrayList<TransitionXTPN> returnConsumingTransClassicalVector(ArrayList<ArrayList<NextXTPNstep>> nextXTPNsteps) {
        ArrayList<TransitionXTPN> consumingTokensTransitionsClassical = new ArrayList<TransitionXTPN>();
        for (NextXTPNstep element : nextXTPNsteps.get(5)) {
            consumingTokensTransitionsClassical.add((TransitionXTPN)element.nodeTP);
        }
        Collections.shuffle(consumingTokensTransitionsClassical);
        return consumingTokensTransitionsClassical;
    }

    public ArrayList<TransitionXTPN> returnProducingTransVector(ArrayList<ArrayList<NextXTPNstep>> nextXTPNsteps) {
        ArrayList<TransitionXTPN> producingTokensTransitions = new ArrayList<TransitionXTPN>();
        for (NextXTPNstep element : nextXTPNsteps.get(3)) {
            producingTokensTransitions.add((TransitionXTPN)element.nodeTP);
        }
        for (NextXTPNstep element : nextXTPNsteps.get(5)) {
            producingTokensTransitions.add((TransitionXTPN)element.nodeTP);
        }
        for (NextXTPNstep element : nextXTPNsteps.get(2)) {
            if (((TransitionXTPN)element.nodeTP).isAlphaModeActive() || !((TransitionXTPN)element.nodeTP).isBetaModeActive() || ((TransitionXTPN)element.nodeTP).getTimerBetaValue() != ((TransitionXTPN)element.nodeTP).getTauBetaValue()) continue;
            producingTokensTransitions.add((TransitionXTPN)element.nodeTP);
        }
        return producingTokensTransitions;
    }

    private double getSafeRandomValueXTPN(TransitionXTPN transition, double min, double max) {
        double range = max - min;
        if (range < this.sg.getCalculationsAccuracy()) {
            return min;
        }
        if (transition.isMassActionKineticsActiveXTPN() || this.globalMAK) {
            double denominator = transition.maxFiresPossible();
            return this.generator.nextDouble(min, max) / denominator;
        }
        return this.generator.nextDouble(min, max);
    }

    @Override
    public IRandomGenerator getGenerator() {
        return this.generator;
    }

    public static class NextXTPNstep {
        Node nodeTP;
        double timeToChange;
        int changeType;

        public NextXTPNstep(Node n, double tau, int change) {
            this.nodeTP = n;
            this.timeToChange = tau;
            this.changeType = change;
        }
    }
}

