/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.simulators;

import holmes.darkgui.GUIManager;
import holmes.petrinet.data.NetSimulationData;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.petrinet.functions.FunctionsTools;
import holmes.petrinet.simulators.IEngine;
import holmes.petrinet.simulators.QuickSimTools;
import holmes.petrinet.simulators.SPNengine;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.SimulatorStandardPN;
import holmes.windows.ssim.HolmesSim;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class StateSimulator
implements Runnable {
    private GUIManager overlord;
    private ArrayList<Transition> transitions;
    private ArrayList<Transition> time_transitions;
    private ArrayList<Place> places;
    private boolean readyToSimulate = false;
    public double timeNetStepCounter = 0.0;
    public double timeNetPartStepCounter = 0.0;
    private ArrayList<ArrayList<Integer>> placesData = null;
    private ArrayList<Double> placesAvgData = null;
    private ArrayList<Long> placesTotalData = null;
    private ArrayList<ArrayList<Integer>> transitionsData = null;
    private ArrayList<Integer> transitionsTotalFiring = null;
    private ArrayList<Double> transitionsAvgData = null;
    private ArrayList<Integer> internalBackupMarkingZero = new ArrayList();
    private IEngine engine = new SimulatorStandardPN();
    private boolean terminate = false;
    public JProgressBar progressBar;
    private HolmesSim boss;
    private int simulationType;
    private NetSimulationData currentDataPackage;
    private ArrayList<ArrayList<Double>> quickSimAllStats;
    private QuickSimTools quickSim;

    public StateSimulator() {
        this.overlord = GUIManager.getDefaultGUIManager();
    }

    public void setThreadDetails(int simulationType, Object ... blackBox) {
        this.simulationType = simulationType;
        if (simulationType == 1) {
            this.boss = (HolmesSim)blackBox[0];
            this.progressBar = (JProgressBar)blackBox[1];
        } else if (simulationType == 2) {
            this.boss = (HolmesSim)blackBox[0];
            this.progressBar = (JProgressBar)blackBox[1];
            this.currentDataPackage = (NetSimulationData)blackBox[2];
        } else if (simulationType == 3) {
            this.boss = (HolmesSim)blackBox[0];
            this.progressBar = (JProgressBar)blackBox[1];
            this.currentDataPackage = (NetSimulationData)blackBox[2];
        } else if (simulationType == 4) {
            this.boss = (HolmesSim)blackBox[0];
            this.progressBar = (JProgressBar)blackBox[1];
            this.currentDataPackage = (NetSimulationData)blackBox[2];
        } else if (simulationType == 5) {
            this.progressBar = (JProgressBar)blackBox[0];
            this.quickSim = (QuickSimTools)blackBox[1];
        } else if (simulationType == 6) {
            this.progressBar = (JProgressBar)blackBox[0];
            this.quickSim = (QuickSimTools)blackBox[1];
        }
    }

    @Override
    public void run() {
        this.terminate = false;
        if (this.simulationType == 1) {
            this.simulateNetAll();
            this.boss.completeSimulationProcedures();
        } else if (this.simulationType == 2) {
            NetSimulationData data = this.simulateNetReferenceAndKnockout();
            this.boss.accessKnockoutTab().action.completeRefSimulationResults(data, this.transitions, this.places);
        } else if (this.simulationType == 3) {
            NetSimulationData data = this.simulateNetReferenceAndKnockout();
            this.boss.accessKnockoutTab().action.completeKnockoutSimulationResults(data, this.transitions, this.places);
        } else if (this.simulationType == 4) {
            NetSimulationData data = this.simulateNetReferenceAndKnockout();
            this.boss.accessKnockoutTab().action.pingPongSimulation(data, this.transitions, this.places, this.terminate);
        } else if (this.simulationType == 5) {
            this.quickSimGatherData();
            this.quickSim.finishedStatsData(this.quickSimAllStats, this.transitions, this.places);
        } else if (this.simulationType == 6) {
            this.quickSimGatherDataNoReps();
            this.quickSim.finishedStatsData(this.quickSimAllStats, this.transitions, this.places);
        }
        this.terminate = false;
    }

    public boolean initiateSim(boolean useGlobals, SimulatorGlobals ownSettings) {
        this.checkEngine(useGlobals);
        this.transitions = this.overlord.getWorkspace().getProject().getTransitions();
        this.time_transitions = this.overlord.getWorkspace().getProject().getTimeTransitions();
        this.places = this.overlord.getWorkspace().getProject().getPlaces();
        if (this.transitions == null || this.places == null) {
            this.readyToSimulate = false;
            return this.readyToSimulate;
        }
        if (this.transitions.size() <= 0 || this.places.size() <= 0) {
            this.readyToSimulate = false;
            return this.readyToSimulate;
        }
        this.placesData = new ArrayList();
        this.placesAvgData = new ArrayList();
        this.placesTotalData = new ArrayList();
        this.transitionsData = new ArrayList();
        this.transitionsTotalFiring = new ArrayList();
        this.transitionsAvgData = new ArrayList();
        for (int t = 0; t < this.transitions.size(); ++t) {
            this.transitionsTotalFiring.add(0);
        }
        for (int p = 0; p < this.places.size(); ++p) {
            this.placesAvgData.add(0.0);
            this.placesTotalData.add(0L);
        }
        if (useGlobals || ownSettings == null) {
            this.engine.setEngine(this.overlord.simSettings.getNetType(), this.overlord.simSettings.isMaxMode(), this.overlord.simSettings.isSingleMode(), this.transitions, this.time_transitions, this.places);
        } else {
            this.engine.setEngine(ownSettings.getNetType(), ownSettings.isMaxMode(), ownSettings.isSingleMode(), this.transitions, this.time_transitions, this.places);
        }
        this.readyToSimulate = true;
        return this.readyToSimulate;
    }

    private void checkEngine(boolean useGlobals) {
        if (useGlobals) {
            int engineType = this.overlord.simSettings.getSimulatorType();
            if (engineType == 0) {
                if (!(this.engine instanceof SimulatorStandardPN)) {
                    this.engine = new SimulatorStandardPN();
                }
            } else if (engineType == 1) {
                if (!(this.engine instanceof SPNengine)) {
                    this.engine = new SPNengine();
                }
            } else if (!(this.engine instanceof SimulatorStandardPN)) {
                this.engine = new SimulatorStandardPN();
            }
        } else if (!(this.engine instanceof SimulatorStandardPN)) {
            this.engine = new SimulatorStandardPN();
        }
    }

    public void clearData() {
        this.placesData = new ArrayList();
        this.placesAvgData = new ArrayList();
        this.placesTotalData = new ArrayList();
        this.transitionsData = new ArrayList();
        this.transitionsTotalFiring = new ArrayList();
        this.transitionsAvgData = new ArrayList();
        for (int t = 0; t < this.transitions.size(); ++t) {
            this.transitionsTotalFiring.add(0);
        }
        for (int p = 0; p < this.places.size(); ++p) {
            this.placesAvgData.add(0.0);
            this.placesTotalData.add(0L);
        }
        this.terminate = false;
        this.readyToSimulate = true;
    }

    public void simulateNetAll() {
        int p;
        if (!this.readyToSimulate) {
            JOptionPane.showMessageDialog(null, "Simulation cannot start, engine initialization failed.", "Simulation problem", 0);
            return;
        }
        this.prepareNetM0();
        int stepsLimit = this.overlord.simSettings.getSimSteps();
        int updateTime = stepsLimit / 50;
        String max = "50% firing chance";
        if (this.overlord.simSettings.isMaxMode()) {
            max = "maximum";
        }
        this.overlord.log("Starting states simulation for " + stepsLimit + " steps in " + max + " mode.", "text", true);
        int trueSteps = 0;
        for (int i = 0; i < stepsLimit && !this.terminate; ++i) {
            this.progressBar.setValue(i + 1);
            ++trueSteps;
            if (i % updateTime == 0) {
                this.progressBar.update(this.progressBar.getGraphics());
            }
            if (!this.isPossibleStep()) break;
            ArrayList<Transition> launchableTransitions = this.engine.getTransLaunchList(this.overlord.simSettings.isEmptySteps());
            this.launchSubtractPhase(launchableTransitions);
            this.removeDPNtransition(launchableTransitions);
            ArrayList<Integer> transRow = new ArrayList<Integer>();
            for (int t = 0; t < this.transitions.size(); ++t) {
                transRow.add(0);
            }
            if (launchableTransitions != null) {
                for (Transition trans : launchableTransitions) {
                    int index = this.transitions.lastIndexOf(trans);
                    transRow.set(index, 1);
                    int fired = this.transitionsTotalFiring.get(index);
                    this.transitionsTotalFiring.set(index, fired + 1);
                }
            }
            this.transitionsData.add(transRow);
            this.launchAddPhase(launchableTransitions);
            ArrayList<Integer> marking = new ArrayList<Integer>();
            for (int p2 = 0; p2 < this.places.size(); ++p2) {
                int tokens = this.places.get(p2).getTokensNumber();
                marking.add(tokens);
                double sumOfTokens = this.placesAvgData.get(p2);
                this.placesAvgData.set(p2, sumOfTokens + (double)tokens);
            }
            this.placesData.add(marking);
        }
        for (p = 0; p < this.places.size(); ++p) {
            double sumOfTokens = this.placesAvgData.get(p);
            this.placesTotalData.set(p, (long)sumOfTokens);
        }
        for (int t = 0; t < this.transitions.size(); ++t) {
            this.transitionsAvgData.add((double)this.transitionsTotalFiring.get(t).intValue() / (double)trueSteps);
        }
        for (p = 0; p < this.places.size(); ++p) {
            double sumOfTokens = this.placesAvgData.get(p);
            this.placesAvgData.set(p, sumOfTokens / (double)trueSteps);
        }
        this.overlord.log("Simulation ended. Restoring zero marking.", "text", true);
        this.readyToSimulate = false;
        this.restoreInternalMarkingZero();
    }

    public NetSimulationData simulateNetReferenceAndKnockout() {
        double val;
        int support5;
        int support3;
        int support;
        int t;
        int p;
        if (!this.readyToSimulate) {
            JOptionPane.showMessageDialog(null, "Simulation cannot start, engine initialization failed.", "Simulation problem", 0);
            return null;
        }
        this.prepareNetM0();
        int pBarTotal = 0;
        ArrayList<Long> totalPlaceTokensInTurn = new ArrayList<Long>();
        ArrayList<Integer> totalTransFiringInTurn = new ArrayList<Integer>();
        ArrayList placesAll = new ArrayList();
        ArrayList transAll = new ArrayList();
        int stepsLimit = this.overlord.simSettings.getSimSteps();
        int repetitions = this.overlord.simSettings.getRepetitions();
        boolean emptySteps = this.overlord.simSettings.isEmptySteps();
        int placeNumber = this.places.size();
        int transNumber = this.transitions.size();
        this.currentDataPackage.maxMode = this.overlord.simSettings.isMaxMode();
        this.currentDataPackage.netSimType = this.overlord.simSettings.getNetType();
        this.currentDataPackage.steps = stepsLimit;
        this.currentDataPackage.reps = repetitions;
        this.currentDataPackage.placesNumber = placeNumber;
        this.currentDataPackage.transNumber = transNumber;
        for (int p2 = 0; p2 < placeNumber; ++p2) {
            totalPlaceTokensInTurn.add(0L);
            this.currentDataPackage.placeTokensAvg.add(0.0);
            this.currentDataPackage.placeTokensMin.add((Double)Double.MAX_VALUE);
            this.currentDataPackage.placeTokensMax.add(0.0);
            this.currentDataPackage.placeZeroTokens.add(0);
            this.currentDataPackage.startingState = this.overlord.getWorkspace().getProject().accessStatesManager().getCurrentStatePN();
        }
        for (int t2 = 0; t2 < transNumber; ++t2) {
            totalTransFiringInTurn.add(0);
            this.currentDataPackage.transFiringsAvg.add(0.0);
            this.currentDataPackage.transFiringsMin.add((Double)Double.MAX_VALUE);
            this.currentDataPackage.transFiringsMax.add(0.0);
            this.currentDataPackage.transZeroFiring.add(0);
        }
        int pBarInterval = repetitions * stepsLimit / 100;
        int pBarStep = 0;
        this.progressBar.setMaximum(repetitions * stepsLimit);
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(0);
        for (int turn = 0; turn < repetitions; ++turn) {
            int val2;
            double oldMax;
            double oldMin;
            int p3;
            int realStepCounter = 0;
            for (int p4 = 0; p4 < placeNumber; ++p4) {
                totalPlaceTokensInTurn.set(p4, 0L);
            }
            for (int t3 = 0; t3 < transNumber; ++t3) {
                totalTransFiringInTurn.set(t3, 0);
            }
            for (int i = 0; i < stepsLimit && !this.terminate; ++i) {
                ArrayList<Transition> launchingTransitions;
                ++realStepCounter;
                ++pBarTotal;
                if (++pBarStep == pBarInterval) {
                    pBarStep = 0;
                    this.progressBar.setValue(pBarTotal);
                    this.progressBar.update(this.progressBar.getGraphics());
                }
                if (this.isPossibleStep()) {
                    launchingTransitions = this.engine.getTransLaunchList(emptySteps);
                    this.launchSubtractPhase(launchingTransitions);
                    this.removeDPNtransition(launchingTransitions);
                    if (launchingTransitions != null) {
                        for (Transition trans : launchingTransitions) {
                            int index = this.transitions.lastIndexOf(trans);
                            int val3 = (Integer)totalTransFiringInTurn.get(index) + 1;
                            totalTransFiringInTurn.set(index, val3);
                        }
                    }
                } else {
                    --pBarTotal;
                    break;
                }
                this.launchAddPhase(launchingTransitions);
                for (p3 = 0; p3 < placeNumber; ++p3) {
                    long val4 = (Long)totalPlaceTokensInTurn.get(p3) + (long)this.places.get(p3).getTokensNumber();
                    totalPlaceTokensInTurn.set(p3, val4);
                }
            }
            ArrayList<Double> histVector = new ArrayList<Double>();
            for (p3 = 0; p3 < placeNumber; ++p3) {
                double simTokenValue = ((Long)totalPlaceTokensInTurn.get(p3)).longValue();
                histVector.add(simTokenValue /= (double)realStepCounter);
                double oldVal = this.currentDataPackage.placeTokensAvg.get(p3) + simTokenValue;
                this.currentDataPackage.placeTokensAvg.set(p3, oldVal);
                oldMin = this.currentDataPackage.placeTokensMin.get(p3);
                if (simTokenValue < oldMin) {
                    this.currentDataPackage.placeTokensMin.set(p3, simTokenValue);
                }
                if (simTokenValue > (oldMax = this.currentDataPackage.placeTokensMax.get(p3).doubleValue())) {
                    this.currentDataPackage.placeTokensMax.set(p3, simTokenValue);
                }
                if (simTokenValue != 0.0) continue;
                val2 = this.currentDataPackage.placeZeroTokens.get(p3) + 1;
                this.currentDataPackage.placeZeroTokens.set(p3, val2);
            }
            placesAll.add(histVector);
            histVector = new ArrayList();
            for (int t4 = 0; t4 < transNumber; ++t4) {
                double simFiringValue = ((Integer)totalTransFiringInTurn.get(t4)).intValue();
                histVector.add(simFiringValue /= (double)realStepCounter);
                double oldVal = this.currentDataPackage.transFiringsAvg.get(t4) + simFiringValue;
                this.currentDataPackage.transFiringsAvg.set(t4, oldVal);
                oldMin = this.currentDataPackage.transFiringsMin.get(t4);
                if (simFiringValue < oldMin) {
                    this.currentDataPackage.transFiringsMin.set(t4, simFiringValue);
                }
                if (simFiringValue > (oldMax = this.currentDataPackage.transFiringsMax.get(t4).doubleValue())) {
                    this.currentDataPackage.transFiringsMax.set(t4, simFiringValue);
                }
                if (simFiringValue != 0.0) continue;
                val2 = this.currentDataPackage.transZeroFiring.get(t4) + 1;
                this.currentDataPackage.transZeroFiring.set(t4, val2);
            }
            transAll.add(histVector);
            this.restoreInternalMarkingZero();
        }
        for (int p5 = 0; p5 < placeNumber; ++p5) {
            double oldVal = this.currentDataPackage.placeTokensAvg.get(p5) / (double)repetitions;
            this.currentDataPackage.placeTokensAvg.set(p5, oldVal);
        }
        for (int t5 = 0; t5 < transNumber; ++t5) {
            double oldVal = this.currentDataPackage.transFiringsAvg.get(t5) / (double)repetitions;
            this.currentDataPackage.transFiringsAvg.set(t5, oldVal);
        }
        for (p = 0; p < placeNumber; ++p) {
            double variance = 0.0;
            double avg = this.currentDataPackage.placeTokensAvg.get(p);
            for (int r = 0; r < repetitions; ++r) {
                double val5 = (Double)((ArrayList)placesAll.get(r)).get(p);
                val5 = avg - val5;
                variance += val5 * val5;
            }
            this.currentDataPackage.placeStdDev.add(Math.sqrt(variance /= (double)repetitions));
        }
        for (t = 0; t < transNumber; ++t) {
            double variance = 0.0;
            double avg = this.currentDataPackage.transFiringsAvg.get(t);
            for (int r = 0; r < repetitions; ++r) {
                double val6 = (Double)((ArrayList)transAll.get(r)).get(t);
                val6 = avg - val6;
                variance += val6 * val6;
            }
            double sigma = Math.sqrt(variance /= (double)repetitions);
            this.currentDataPackage.transStdDev.add(sigma);
        }
        for (p = 0; p < placeNumber; ++p) {
            double stdDev = this.currentDataPackage.placeStdDev.get(p);
            double avg = this.currentDataPackage.placeTokensAvg.get(p);
            support = 0;
            int support2 = 0;
            support3 = 0;
            int support4 = 0;
            support5 = 0;
            for (int r = 0; r < repetitions; ++r) {
                val = (Double)((ArrayList)placesAll.get(r)).get(p);
                if (!(avg - 5.0 * stdDev < val) || !(val < avg + 5.0 * stdDev)) continue;
                ++support5;
                if (!(avg - 4.0 * stdDev < val) || !(val < avg + 4.0 * stdDev)) continue;
                ++support4;
                if (!(avg - 3.0 * stdDev < val) || !(val < avg + 3.0 * stdDev)) continue;
                ++support3;
                if (!(avg - 2.0 * stdDev < val) || !(val < avg + 2.0 * stdDev)) continue;
                ++support2;
                if (!(avg - stdDev < val) || !(val < avg + stdDev)) continue;
                ++support;
            }
            ArrayList<Integer> res = new ArrayList<Integer>();
            res.add(support);
            res.add(support2);
            res.add(support3);
            res.add(support4);
            res.add(support5);
            this.currentDataPackage.placeWithinStdDev.add(res);
        }
        for (t = 0; t < transNumber; ++t) {
            double stdDev = this.currentDataPackage.transStdDev.get(t);
            double avg = this.currentDataPackage.transFiringsAvg.get(t);
            support = 0;
            int support2 = 0;
            support3 = 0;
            int support4 = 0;
            support5 = 0;
            for (int r = 0; r < repetitions; ++r) {
                val = (Double)((ArrayList)transAll.get(r)).get(t);
                if (!(avg - 5.0 * stdDev < val) || !(val < avg + 5.0 * stdDev)) continue;
                ++support5;
                if (!(avg - 4.0 * stdDev < val) || !(val < avg + 4.0 * stdDev)) continue;
                ++support4;
                if (!(avg - 3.0 * stdDev < val) || !(val < avg + 3.0 * stdDev)) continue;
                ++support3;
                if (!(avg - 2.0 * stdDev < val) || !(val < avg + 2.0 * stdDev)) continue;
                ++support2;
                if (!(avg - stdDev < val) || !(val < avg + stdDev)) continue;
                ++support;
            }
            ArrayList<Integer> res = new ArrayList<Integer>();
            res.add(support);
            res.add(support2);
            res.add(support3);
            res.add(support4);
            res.add(support5);
            this.currentDataPackage.transWithinStdDev.add(res);
        }
        this.restoreInternalMarkingZero();
        return this.currentDataPackage;
    }

    public int simulateNetSimple(int steps, boolean placesToo, boolean emptySteps) {
        int p;
        if (!this.readyToSimulate) {
            this.overlord.log("Simulation simple mode cannot start.", "warning", true);
            return 0;
        }
        this.prepareNetM0();
        int internalSteps = 0;
        for (int i = 0; i < steps; ++i) {
            ++internalSteps;
            if (!this.isPossibleStep()) break;
            ArrayList<Transition> launchableTransitions = this.engine.getTransLaunchList(emptySteps);
            this.launchSubtractPhase(launchableTransitions);
            this.removeDPNtransition(launchableTransitions);
            if (launchableTransitions != null) {
                for (Transition trans : launchableTransitions) {
                    int index = this.transitions.lastIndexOf(trans);
                    int fired = this.transitionsTotalFiring.get(index);
                    this.transitionsTotalFiring.set(index, fired + 1);
                }
            }
            this.launchAddPhase(launchableTransitions);
            if (!placesToo) continue;
            for (int p2 = 0; p2 < this.places.size(); ++p2) {
                int tokens = this.places.get(p2).getTokensNumber();
                double sumOfTokens = this.placesAvgData.get(p2);
                this.placesAvgData.set(p2, sumOfTokens + (double)tokens);
            }
        }
        for (p = 0; p < this.places.size(); ++p) {
            double sumOfTokens = this.placesAvgData.get(p);
            this.placesTotalData.set(p, (long)sumOfTokens);
        }
        for (int t = 0; t < this.transitions.size(); ++t) {
            this.transitionsAvgData.add((double)this.transitionsTotalFiring.get(t).intValue() / (double)internalSteps);
        }
        if (placesToo) {
            for (p = 0; p < this.places.size(); ++p) {
                double sumOfTokens = this.placesAvgData.get(p);
                this.placesAvgData.set(p, sumOfTokens / (double)internalSteps);
            }
        }
        this.readyToSimulate = false;
        this.restoreInternalMarkingZero();
        return internalSteps;
    }

    public ArrayList<Integer> simulateNetSinglePlace(int steps, Place place, boolean emptySteps) {
        if (!this.readyToSimulate) {
            this.overlord.log("Simulation for place " + place.getName() + " cannot start.", "warning", true);
            return null;
        }
        this.prepareNetM0();
        ArrayList<Integer> placeDataVector = new ArrayList<Integer>();
        for (int i = 0; i < steps && this.isPossibleStep(); ++i) {
            ArrayList<Transition> launchableTransitions = this.engine.getTransLaunchList(emptySteps);
            this.launchSubtractPhase(launchableTransitions);
            this.removeDPNtransition(launchableTransitions);
            this.launchAddPhase(launchableTransitions);
            placeDataVector.add(place.getTokensNumber());
        }
        this.readyToSimulate = false;
        this.restoreInternalMarkingZero();
        return placeDataVector;
    }

    public ArrayList<Integer> simulateNetSingleTransition(int steps, Transition trans, boolean emptySteps) {
        if (!this.readyToSimulate) {
            this.overlord.log("Simulation for transition " + trans.getName() + " cannot start.", "warning", true);
            return null;
        }
        this.prepareNetM0();
        int sum = 0;
        int internalSteps = 0;
        ArrayList<Integer> transDataVector = new ArrayList<Integer>();
        for (int i = 0; i < steps; ++i) {
            ++internalSteps;
            if (!this.isPossibleStep()) break;
            ArrayList<Transition> launchableTransitions = this.engine.getTransLaunchList(emptySteps);
            this.launchSubtractPhase(launchableTransitions);
            this.removeDPNtransition(launchableTransitions);
            if (launchableTransitions != null) {
                if (launchableTransitions.contains(trans)) {
                    transDataVector.add(1);
                    ++sum;
                } else {
                    transDataVector.add(0);
                }
            } else {
                for (int j = 0; j < this.transitions.size(); ++j) {
                    transDataVector.add(0);
                }
            }
            this.launchAddPhase(launchableTransitions);
        }
        this.readyToSimulate = false;
        transDataVector.add(sum);
        transDataVector.add(internalSteps);
        this.restoreInternalMarkingZero();
        return transDataVector;
    }

    public ArrayList<ArrayList<Double>> simulateForInvariantTrans(int steps, int reps, boolean emptySteps) {
        int t;
        ArrayList<ArrayList<Double>> result = new ArrayList<ArrayList<Double>>();
        if (!this.readyToSimulate) {
            this.overlord.log("Simulation simple mode cannot start.", "warning", true);
            return null;
        }
        this.prepareNetM0();
        ArrayList firingHistory = new ArrayList();
        for (int r = 0; r < reps; ++r) {
            ArrayList<Double> transFiring = new ArrayList<Double>();
            for (t = 0; t < this.transitions.size(); ++t) {
                transFiring.add(0.0);
            }
            int internalSteps = 0;
            for (int i = 0; i < steps && this.isPossibleStep(); ++i) {
                ArrayList<Transition> launchableTransitions = this.engine.getTransLaunchList(emptySteps);
                this.launchSubtractPhase(launchableTransitions);
                this.removeDPNtransition(launchableTransitions);
                ++internalSteps;
                if (launchableTransitions != null) {
                    for (Transition trans : launchableTransitions) {
                        int index = this.transitions.lastIndexOf(trans);
                        double fired = (Double)transFiring.get(index);
                        transFiring.set(index, fired + 1.0);
                    }
                }
                this.launchAddPhase(launchableTransitions);
            }
            for (int t2 = 0; t2 < transFiring.size(); ++t2) {
                double fired = (Double)transFiring.get(t2);
                transFiring.set(t2, fired /= (double)internalSteps);
            }
            firingHistory.add(transFiring);
            this.restoreInternalMarkingZero();
        }
        ArrayList<Double> avgFiring = new ArrayList<Double>();
        ArrayList<Double> stdDev = new ArrayList<Double>();
        for (t = 0; t < this.transitions.size(); ++t) {
            avgFiring.add(0.0);
        }
        for (t = 0; t < this.transitions.size(); ++t) {
            for (int r = 0; r < reps; ++r) {
                double value = (Double)((ArrayList)firingHistory.get(r)).get(t);
                double oldRes = (Double)avgFiring.get(t);
                avgFiring.set(t, oldRes + value);
            }
            double oldRes = (Double)avgFiring.get(t);
            avgFiring.set(t, oldRes /= (double)reps);
        }
        for (t = 0; t < this.transitions.size(); ++t) {
            double variance = 0.0;
            for (int r = 0; r < reps; ++r) {
                double value = (Double)avgFiring.get(t);
                double diff = value - (Double)((ArrayList)firingHistory.get(r)).get(t);
                variance += diff * diff;
            }
            stdDev.add(Math.sqrt(variance /= (double)reps));
        }
        this.readyToSimulate = false;
        this.restoreInternalMarkingZero();
        result.add(avgFiring);
        result.add(stdDev);
        return result;
    }

    public void setCancelStatus(boolean val) {
        this.terminate = val;
        if (val) {
            this.readyToSimulate = false;
        }
    }

    public boolean getCancelStatus() {
        return this.terminate;
    }

    private void removeDPNtransition(ArrayList<Transition> launchingTransitions) {
        if (launchingTransitions == null) {
            return;
        }
        for (int t = 0; t < launchingTransitions.size(); ++t) {
            Transition test_t = launchingTransitions.get(t);
            if (!test_t.timeExtension.isDPN() || test_t.timeExtension.getDPNtimer() != 0.0 || test_t.timeExtension.getDPNduration() == 0.0) continue;
            launchingTransitions.remove(test_t);
            --t;
        }
    }

    private void launchSubtractPhase(ArrayList<Transition> launchingTransitions) {
        if (launchingTransitions == null) {
            return;
        }
        for (Transition transition : launchingTransitions) {
            if (transition.timeExtension.getDPNtimer() > 0.0) continue;
            transition.setLaunching(true);
            ArrayList<Arc> arcs = transition.getInArcs();
            for (Arc arc : arcs) {
                Place place = (Place)arc.getStartNode();
                if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR || arc.getArcType() == Arc.TypeOfArc.READARC) continue;
                if (arc.getArcType() == Arc.TypeOfArc.RESET) {
                    int tokens = place.getTokensNumber();
                    place.modifyTokensNumber(-tokens);
                    continue;
                }
                if (arc.getArcType() == Arc.TypeOfArc.EQUAL) {
                    place.modifyTokensNumber(-arc.getWeight());
                    continue;
                }
                FunctionsTools.functionalExtraction(transition, arc, place);
            }
        }
    }

    private boolean isPossibleStep() {
        if (this.engine instanceof SimulatorStandardPN) {
            for (Transition transition : this.transitions) {
                if (!transition.isActive()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void launchAddPhase(ArrayList<Transition> launchingTransitions) {
        if (launchingTransitions == null) {
            return;
        }
        for (Transition transition : launchingTransitions) {
            transition.setLaunching(false);
            ArrayList<Arc> arcs = transition.getOutArcs();
            for (Arc arc : arcs) {
                Place place = (Place)arc.getEndNode();
                if (arc.getArcType() == Arc.TypeOfArc.READARC) continue;
                if (arc.getArcType() != Arc.TypeOfArc.NORMAL) {
                    // empty if block
                }
                FunctionsTools.functionalAddition(transition, arc, place);
            }
            transition.timeExtension.resetTimeVariables();
        }
        launchingTransitions.clear();
    }

    public ArrayList<ArrayList<Integer>> getPlacesData() {
        return this.placesData;
    }

    public ArrayList<ArrayList<Integer>> getTransitionsData() {
        return this.transitionsData;
    }

    public ArrayList<Integer> getTransitionsCompactData() {
        return this.transitionsTotalFiring;
    }

    public ArrayList<Double> getTransitionsAvgData() {
        return this.transitionsAvgData;
    }

    public ArrayList<Double> getPlacesAvgData() {
        return this.placesAvgData;
    }

    public ArrayList<Long> getPlacesTotalData() {
        return this.placesTotalData;
    }

    public void prepareNetM0() {
        this.overlord.getWorkspace().getProject().restoreMarkingZeroFast(this.transitions);
        this.saveInternalMarkingZero();
        this.clearTransitionsValues();
    }

    private void clearTransitionsValues() {
        for (Transition transition : this.transitions) {
            transition.setLaunching(false);
            if (transition.getTransType() == Transition.TransitionType.TPN) {
                transition.timeExtension.resetTimeVariables();
            }
            if (!(transition instanceof TransitionXTPN)) continue;
            ((TransitionXTPN)transition).resetTimeVariables_xTPN();
        }
    }

    private void saveInternalMarkingZero() {
        this.internalBackupMarkingZero.clear();
        for (Place place : this.places) {
            this.internalBackupMarkingZero.add(place.getTokensNumber());
        }
    }

    public void restoreInternalMarkingZero() {
        for (int i = 0; i < this.places.size(); ++i) {
            this.places.get(i).setTokensNumber(this.internalBackupMarkingZero.get(i));
            this.places.get(i).freeReservedTokens();
        }
        this.clearTransitionsValues();
    }

    public void setEngine(int type) {
        this.readyToSimulate = false;
        if (type == 1) {
            this.engine = new SPNengine();
            this.overlord.simSettings.setSimulatorType(1);
        } else {
            this.engine = new SimulatorStandardPN();
            this.overlord.simSettings.setSimulatorType(0);
        }
    }

    public IEngine getEngine() {
        return this.engine;
    }

    public ArrayList<ArrayList<Double>> quickSimGatherData() {
        int p;
        int t;
        if (!this.readyToSimulate) {
            this.overlord.log("Simulation simple mode cannot start.", "warning", true);
            return null;
        }
        this.prepareNetM0();
        ArrayList firingHistory = new ArrayList();
        ArrayList tokensHistory = new ArrayList();
        int steps = this.overlord.simSettings.getSimSteps();
        int reps = this.overlord.simSettings.getRepetitions();
        if (reps > 20) {
            reps = 20;
        }
        boolean emptySteps = this.overlord.simSettings.isEmptySteps();
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(reps * steps);
        int trueStep = 0;
        int updateTime = reps * steps / 50;
        for (int r = 0; r < reps; ++r) {
            ArrayList<Double> transFiring = new ArrayList<Double>();
            ArrayList<Double> tokensSum = new ArrayList<Double>();
            for (t = 0; t < this.transitions.size(); ++t) {
                transFiring.add(0.0);
            }
            for (p = 0; p < this.places.size(); ++p) {
                tokensSum.add(0.0);
            }
            int internalSteps = 0;
            for (int i = 0; i < steps; ++i) {
                if (++trueStep < 0) {
                    trueStep = Integer.MAX_VALUE;
                }
                this.progressBar.setValue(trueStep);
                if (trueStep % updateTime == 0) {
                    this.progressBar.update(this.progressBar.getGraphics());
                }
                if (!this.isPossibleStep()) break;
                ArrayList<Transition> launchableTransitions = this.engine.getTransLaunchList(emptySteps);
                this.launchSubtractPhase(launchableTransitions);
                this.removeDPNtransition(launchableTransitions);
                ++internalSteps;
                if (launchableTransitions != null) {
                    for (Transition trans : launchableTransitions) {
                        int index = this.transitions.lastIndexOf(trans);
                        double fired = (Double)transFiring.get(index);
                        transFiring.set(index, fired + 1.0);
                    }
                }
                this.launchAddPhase(launchableTransitions);
                for (int p2 = 0; p2 < this.places.size(); ++p2) {
                    double oldVal = (Double)tokensSum.get(p2);
                    tokensSum.set(p2, oldVal + (double)this.places.get(p2).getTokensNumber());
                }
            }
            for (int t2 = 0; t2 < transFiring.size(); ++t2) {
                double fired = (Double)transFiring.get(t2);
                transFiring.set(t2, fired /= (double)internalSteps);
            }
            firingHistory.add(transFiring);
            for (int p3 = 0; p3 < this.places.size(); ++p3) {
                double tokens = (Double)tokensSum.get(p3);
                tokensSum.set(p3, tokens /= (double)internalSteps);
            }
            tokensHistory.add(tokensSum);
            this.restoreInternalMarkingZero();
        }
        ArrayList<Double> avgFiring = new ArrayList<Double>();
        ArrayList<Double> stdDev = new ArrayList<Double>();
        ArrayList<Double> avgTokens = new ArrayList<Double>();
        for (t = 0; t < this.transitions.size(); ++t) {
            avgFiring.add(0.0);
        }
        for (p = 0; p < this.places.size(); ++p) {
            avgTokens.add(0.0);
        }
        for (t = 0; t < this.transitions.size(); ++t) {
            for (int r = 0; r < reps; ++r) {
                double value = (Double)((ArrayList)firingHistory.get(r)).get(t);
                double oldRes = (Double)avgFiring.get(t);
                avgFiring.set(t, oldRes + value);
            }
            double oldRes = (Double)avgFiring.get(t);
            avgFiring.set(t, oldRes /= (double)reps);
        }
        for (p = 0; p < this.places.size(); ++p) {
            for (int r = 0; r < reps; ++r) {
                double value = (Double)((ArrayList)tokensHistory.get(r)).get(p);
                double oldRes = (Double)avgTokens.get(p);
                avgTokens.set(p, oldRes + value);
            }
            double oldRes = (Double)avgTokens.get(p);
            avgTokens.set(p, oldRes /= (double)reps);
        }
        for (t = 0; t < this.transitions.size(); ++t) {
            double variance = 0.0;
            for (int r = 0; r < reps; ++r) {
                double value = (Double)avgFiring.get(t);
                double diff = value - (Double)((ArrayList)firingHistory.get(r)).get(t);
                variance += diff * diff;
            }
            stdDev.add(Math.sqrt(variance /= (double)reps));
        }
        this.readyToSimulate = false;
        this.restoreInternalMarkingZero();
        this.quickSimAllStats = new ArrayList();
        this.quickSimAllStats.add(avgFiring);
        this.quickSimAllStats.add(stdDev);
        this.quickSimAllStats.addAll(tokensHistory);
        return this.quickSimAllStats;
    }

    public ArrayList<ArrayList<Double>> quickSimGatherDataNoReps() {
        if (!this.readyToSimulate) {
            this.overlord.log("Simulation simple mode cannot start.", "warning", true);
            return null;
        }
        this.prepareNetM0();
        int steps = this.overlord.simSettings.getSimSteps();
        boolean emptySteps = this.overlord.simSettings.isEmptySteps();
        ArrayList<Double> transFiring = new ArrayList<Double>();
        ArrayList<Double> tokensSum = new ArrayList<Double>();
        for (int t = 0; t < this.transitions.size(); ++t) {
            transFiring.add(0.0);
        }
        for (int p = 0; p < this.places.size(); ++p) {
            tokensSum.add(0.0);
        }
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(steps);
        int updateTime = steps / 50;
        int internalSteps = 0;
        for (int i = 0; i < steps && this.isPossibleStep(); ++i) {
            ArrayList<Transition> launchableTransitions = this.engine.getTransLaunchList(emptySteps);
            this.launchSubtractPhase(launchableTransitions);
            this.removeDPNtransition(launchableTransitions);
            ++internalSteps;
            if (launchableTransitions != null) {
                for (Transition trans : launchableTransitions) {
                    int index = this.transitions.lastIndexOf(trans);
                    double fired = (Double)transFiring.get(index);
                    transFiring.set(index, fired + 1.0);
                }
            }
            this.launchAddPhase(launchableTransitions);
            for (int p = 0; p < this.places.size(); ++p) {
                double oldVal = (Double)tokensSum.get(p);
                tokensSum.set(p, oldVal + (double)this.places.get(p).getTokensNumber());
            }
            this.progressBar.setValue(internalSteps);
            if (internalSteps % updateTime != 0) continue;
            this.progressBar.update(this.progressBar.getGraphics());
        }
        for (int t = 0; t < transFiring.size(); ++t) {
            double fired = (Double)transFiring.get(t);
            transFiring.set(t, fired /= (double)internalSteps);
        }
        for (int p = 0; p < this.places.size(); ++p) {
            double tokens = (Double)tokensSum.get(p);
            tokensSum.set(p, tokens /= (double)internalSteps);
        }
        this.restoreInternalMarkingZero();
        this.readyToSimulate = false;
        this.quickSimAllStats = new ArrayList();
        this.quickSimAllStats.add(transFiring);
        this.quickSimAllStats.add(null);
        this.quickSimAllStats.add(tokensSum);
        return this.quickSimAllStats;
    }
}

