/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.simulators;

import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionColored;
import holmes.petrinet.simulators.HighQualityRandom;
import holmes.petrinet.simulators.IEngine;
import holmes.petrinet.simulators.IRandomGenerator;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.StandardRandom;
import java.util.ArrayList;
import java.util.Collections;

public class SimulatorStandardPN
implements IEngine {
    private GUIManager overlord;
    private SimulatorGlobals.SimNetType netSimType = SimulatorGlobals.SimNetType.BASIC;
    private ArrayList<Transition> transitions = null;
    private ArrayList<Transition> time_transitions = null;
    private ArrayList<Integer> transitionsIndexList = null;
    private ArrayList<Integer> timeTransitionsIndexList = null;
    private ArrayList<Transition> launchableTransitions = null;
    private IRandomGenerator generator;
    private boolean maxMode = false;
    private boolean singleMode = false;
    private double planckDistance = 1.0;
    private boolean TDPNdecision1 = false;

    public SimulatorStandardPN() {
        this.overlord = GUIManager.getDefaultGUIManager();
        this.generator = new StandardRandom(System.currentTimeMillis());
    }

    @Override
    public void setEngine(SimulatorGlobals.SimNetType simulationType, boolean maxMode, boolean singleMode, ArrayList<Transition> transitions, ArrayList<Transition> time_transitions, ArrayList<Place> places) {
        this.netSimType = simulationType;
        this.maxMode = maxMode;
        this.singleMode = singleMode;
        this.generator = this.overlord.simSettings.getGeneratorType() == 1 ? new HighQualityRandom(System.currentTimeMillis()) : new StandardRandom(System.currentTimeMillis());
        this.TDPNdecision1 = this.overlord.getSettingsManager().getValue("simTDPNrunWhenEft").equals("1");
        this.transitions = transitions;
        this.time_transitions = time_transitions;
        this.transitionsIndexList = new ArrayList();
        this.timeTransitionsIndexList = new ArrayList();
        this.launchableTransitions = new ArrayList();
        for (int t = 0; t < transitions.size(); ++t) {
            this.transitionsIndexList.add(t);
        }
        for (int i = 0; i < time_transitions.size(); ++i) {
            this.timeTransitionsIndexList.add(i);
        }
    }

    @Override
    public void setNetSimType(SimulatorGlobals.SimNetType simulationType) {
        this.netSimType = simulationType;
    }

    @Override
    public void setMaxMode(boolean value) {
        this.maxMode = value;
    }

    @Override
    public void setSingleMode(boolean value) {
        this.singleMode = value;
        if (this.singleMode && GUIManager.getDefaultGUIManager().getSettingsManager().getValue("simSingleMode").equals("1")) {
            this.maxMode = true;
        }
    }

    @Override
    public ArrayList<Transition> getTransLaunchList(boolean emptySteps) {
        if (emptySteps) {
            this.generateNormal();
        } else {
            this.generateWithoutEmptySteps();
        }
        return this.launchableTransitions;
    }

    private ArrayList<Transition> generateWithoutEmptySteps() {
        boolean generated = false;
        int safetyCounter = 0;
        while (!generated) {
            this.generateLaunchingTransitions(this.netSimType);
            if (this.launchableTransitions.size() > 0) {
                generated = true;
                continue;
            }
            if (this.netSimType == SimulatorGlobals.SimNetType.TIME || this.netSimType == SimulatorGlobals.SimNetType.HYBRID) {
                return this.launchableTransitions;
            }
            if (++safetyCounter != 9 || this.isPossibleStep(this.transitions)) continue;
            GUIManager.getDefaultGUIManager().log("Error, no active transition, yet generateValidLaunchingTransitions has been activated. Please advise authors if this error show up frequently.", "error", true);
            generated = true;
        }
        if (!this.singleMode) {
            return this.launchableTransitions;
        }
        int happyWinner = this.generator.nextInt(this.launchableTransitions.size());
        Transition winner = this.launchableTransitions.get(happyWinner);
        this.launchableTransitions.clear();
        this.launchableTransitions.add(winner);
        return this.launchableTransitions;
    }

    private ArrayList<Transition> generateNormal() {
        this.generateLaunchingTransitions(this.netSimType);
        return this.launchableTransitions;
    }

    private void generateLaunchingTransitions(SimulatorGlobals.SimNetType simulationType) {
        Transition transition;
        this.launchableTransitions.clear();
        if (simulationType == SimulatorGlobals.SimNetType.BASIC) {
            Collections.shuffle(this.transitionsIndexList);
            for (Integer integer : this.transitionsIndexList) {
                transition = this.transitions.get(integer);
                if (!transition.isActive() || this.generator.nextInt(100) >= 50 && !this.maxMode) continue;
                transition.bookRequiredTokens();
                this.launchableTransitions.add(transition);
            }
        }
        if (simulationType == SimulatorGlobals.SimNetType.COLOR) {
            Collections.shuffle(this.transitionsIndexList);
            for (Integer integer : this.transitionsIndexList) {
                transition = this.transitions.get(integer);
                if (!(transition instanceof TransitionColored) || !((TransitionColored)transition).isColorActive() || this.generator.nextInt(100) >= 50 && !this.maxMode) continue;
                transition.bookRequiredTokens();
                this.launchableTransitions.add(transition);
            }
        } else if (simulationType == SimulatorGlobals.SimNetType.HYBRID) {
            this.timeTransDecisions();
            Collections.shuffle(this.transitionsIndexList);
            for (int i = 0; i < this.transitions.size(); ++i) {
                Transition transition2 = this.transitions.get(this.transitionsIndexList.get(i));
                if (transition2.getTransType() != Transition.TransitionType.PN || this.launchableTransitions.contains(transition2) || !transition2.isActive() || this.generator.nextInt(100) >= 50 && !this.maxMode) continue;
                transition2.bookRequiredTokens();
                this.launchableTransitions.add(transition2);
            }
        } else if (simulationType == SimulatorGlobals.SimNetType.TIME) {
            this.timeTransDecisions();
        }
        for (Transition transition2 : this.launchableTransitions) {
            transition2.returnBookedTokens();
        }
    }

    private void timeTransDecisions() {
        int lft;
        int i;
        Collections.shuffle(this.timeTransitionsIndexList);
        ArrayList<Integer> indexTTList = new ArrayList<Integer>(this.timeTransitionsIndexList);
        ArrayList<Integer> indexDPNList = new ArrayList<Integer>();
        for (i = 0; i < this.time_transitions.size(); ++i) {
            if (!this.time_transitions.get((int)i).timeExtension.isDPN()) continue;
            if (this.time_transitions.get((int)i).timeExtension.isDPNforcedToFire()) {
                this.launchableTransitions.add(this.time_transitions.get(i));
                indexTTList.remove((Object)i);
                continue;
            }
            indexDPNList.add(i);
        }
        Collections.shuffle(indexTTList);
        Collections.shuffle(indexDPNList);
        for (i = 0; i < indexDPNList.size(); ++i) {
            int index = (Integer)indexDPNList.get(i);
            Transition dpn_transition = this.time_transitions.get(index);
            if (dpn_transition.timeExtension.isTPN()) {
                if (dpn_transition.timeExtension.isTPNforcedToFired()) {
                    int decision = this.DPNdecision(dpn_transition, index, indexDPNList, indexTTList);
                    if (decision == -1) {
                        --i;
                        continue;
                    }
                    if (decision != 0) continue;
                }
                if (dpn_transition.isActive()) {
                    int decision;
                    if (dpn_transition.timeExtension.getTPNtimerLimit() == -1.0) {
                        int eft = (int)dpn_transition.timeExtension.getEFT();
                        lft = (int)dpn_transition.timeExtension.getLFT();
                        if (this.TDPNdecision1) {
                            dpn_transition.timeExtension.setTPNtimerLimit(eft);
                        } else {
                            dpn_transition.timeExtension.setTPNtimerLimit(this.getRandomInt(eft, lft));
                        }
                        dpn_transition.timeExtension.setTPNtimer(0.0);
                        if (lft == 0) {
                            decision = this.DPNdecision(dpn_transition, index, indexDPNList, indexTTList);
                            if (decision == -1) {
                                --i;
                                continue;
                            }
                            if (decision != 0) continue;
                        }
                        indexTTList.remove((Object)index);
                        continue;
                    }
                    double oldTimer = dpn_transition.timeExtension.getTPNtimer();
                    dpn_transition.timeExtension.setTPNtimer(oldTimer += this.planckDistance);
                    if (dpn_transition.timeExtension.isTPNforcedToFired()) {
                        decision = this.DPNdecision(dpn_transition, index, indexDPNList, indexTTList);
                        if (decision == -1) {
                            --i;
                            continue;
                        }
                        if (decision != 0) continue;
                    }
                    indexTTList.remove((Object)index);
                    continue;
                }
                indexTTList.remove((Object)index);
                dpn_transition.timeExtension.resetTimeVariables();
                continue;
            }
            int decision = this.DPNdecision(dpn_transition, index, indexDPNList, indexTTList);
            if (decision == -1) {
                --i;
                continue;
            }
            if (decision != 0) continue;
        }
        for (int index : indexTTList) {
            Transition ttransition = this.time_transitions.get(index);
            if (ttransition.isActive()) {
                if (ttransition.timeExtension.isTPNforcedToFired()) {
                    this.launchableTransitions.add(ttransition);
                    ttransition.bookRequiredTokens();
                    continue;
                }
                if (ttransition.timeExtension.getTPNtimerLimit() == -1.0) {
                    int eft = (int)ttransition.timeExtension.getEFT();
                    lft = (int)ttransition.timeExtension.getLFT();
                    ttransition.timeExtension.setTPNtimerLimit(this.getRandomInt(eft, lft));
                    ttransition.timeExtension.setTPNtimer(0.0);
                    if (lft != 0) continue;
                    this.launchableTransitions.add(ttransition);
                    ttransition.bookRequiredTokens();
                    continue;
                }
                double oldTimer = ttransition.timeExtension.getTPNtimer();
                ttransition.timeExtension.setTPNtimer(oldTimer += this.planckDistance);
                if (!ttransition.timeExtension.isTPNforcedToFired()) continue;
                this.launchableTransitions.add(ttransition);
                ttransition.bookRequiredTokens();
                continue;
            }
            ttransition.timeExtension.setTPNtimerLimit(-1.0);
            ttransition.timeExtension.setTPNtimer(-1.0);
        }
    }

    private int DPNdecision(Transition dpn_transition, int index, ArrayList<Integer> indexDPNList, ArrayList<Integer> indexTTList) {
        double timer = dpn_transition.timeExtension.getDPNtimer();
        if (timer == -1.0 && dpn_transition.isActive()) {
            dpn_transition.timeExtension.setDPNtimer(0.0);
            this.launchableTransitions.add(dpn_transition);
            dpn_transition.bookRequiredTokens();
            indexDPNList.remove((Object)index);
            indexTTList.remove((Object)index);
            return -1;
        }
        if (timer > -1.0) {
            dpn_transition.timeExtension.setDPNtimer(timer += this.planckDistance);
            indexDPNList.remove((Object)index);
            if (dpn_transition.timeExtension.isDPNforcedToFire()) {
                this.launchableTransitions.add(dpn_transition);
            }
            indexTTList.remove((Object)index);
            return -1;
        }
        if (!dpn_transition.isActive()) {
            indexTTList.remove((Object)index);
            return 0;
        }
        return 1;
    }

    private boolean isPossibleStep(ArrayList<Transition> transitions) {
        for (Transition transition : transitions) {
            if (!transition.isActive()) continue;
            return true;
        }
        return false;
    }

    private int getRandomInt(int min, int max) {
        if (min == 0 && max == 0) {
            return 0;
        }
        if (min == max) {
            return min;
        }
        return this.generator.nextInt(max - min + 1) + min;
    }

    private void oldHybrid() {
        int i;
        Collections.shuffle(this.timeTransitionsIndexList);
        boolean ttPriority = false;
        for (i = 0; i < this.time_transitions.size(); ++i) {
            Transition timeTransition = this.time_transitions.get(this.timeTransitionsIndexList.get(i));
            if (timeTransition.isActive()) {
                if (timeTransition.timeExtension.isTPNforcedToFired()) {
                    if (!ttPriority) continue;
                    this.launchableTransitions.add(timeTransition);
                    timeTransition.bookRequiredTokens();
                    continue;
                }
                if (timeTransition.timeExtension.getTPNtimerLimit() == -1.0) {
                    int eft = (int)timeTransition.timeExtension.getEFT();
                    int lft = (int)timeTransition.timeExtension.getLFT();
                    int randomTime = this.getRandomInt(eft, lft);
                    timeTransition.timeExtension.setTPNtimerLimit(randomTime);
                    timeTransition.timeExtension.setTPNtimer(0.0);
                    if (!ttPriority || lft != 0) continue;
                    this.launchableTransitions.add(timeTransition);
                    timeTransition.bookRequiredTokens();
                    continue;
                }
                int oldTimer = (int)timeTransition.timeExtension.getTPNtimer();
                timeTransition.timeExtension.setTPNtimer(++oldTimer);
                if (!ttPriority || !timeTransition.timeExtension.isTPNforcedToFired()) continue;
                this.launchableTransitions.add(timeTransition);
                timeTransition.bookRequiredTokens();
                continue;
            }
            timeTransition.timeExtension.setTPNtimerLimit(-1.0);
            timeTransition.timeExtension.setTPNtimer(-1.0);
        }
        Collections.shuffle(this.transitionsIndexList);
        for (i = 0; i < this.transitions.size(); ++i) {
            Transition transition = this.transitions.get(this.transitionsIndexList.get(i));
            if (this.launchableTransitions.contains(transition)) continue;
            if (transition.getTransType() == Transition.TransitionType.TPN) {
                if (transition.isActive()) {
                    if (!transition.timeExtension.isTPNforcedToFired()) continue;
                    this.launchableTransitions.add(transition);
                    transition.bookRequiredTokens();
                    continue;
                }
                transition.timeExtension.setTPNtimerLimit(-1.0);
                transition.timeExtension.setTPNtimer(-1.0);
                continue;
            }
            if (!transition.isActive() || this.generator.nextInt(100) >= 50 && !this.maxMode) continue;
            transition.bookRequiredTokens();
            this.launchableTransitions.add(transition);
        }
    }

    @Override
    public IRandomGenerator getGenerator() {
        return this.generator;
    }
}

