/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.simulators;

import holmes.darkgui.GUIController;
import holmes.darkgui.GUIManager;
import holmes.darkgui.dockwindows.HolmesDockWindowsTable;
import holmes.darkgui.holmesInterface.HolmesRoundedButton;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.StateSimulator;
import holmes.petrinet.simulators.xtpn.StateSimDataContainer;
import holmes.petrinet.simulators.xtpn.StateSimulatorXTPN;
import holmes.utilities.Tools;
import holmes.windows.HolmesNotepad;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class QuickSimTools {
    private GUIManager overlord = GUIManager.getDefaultGUIManager();
    private StateSimulator stateSimulatorPN;
    private StateSimulatorXTPN stateSimulatorXTPN;
    private boolean scanTransitions = true;
    private boolean scanPlaces = true;
    private boolean markArcs = true;
    private HolmesRoundedButton startSimButton = null;

    public QuickSimTools(HolmesDockWindowsTable holmesDockWindowsTable) {
    }

    public void acquireData(boolean scanTransitions, boolean scanPlaces, boolean markArcs, boolean repetitions, JProgressBar quickProgressBar) {
        if (this.overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
            JOptionPane.showMessageDialog(null, "Net simulator working. Unable to retrieve transitions statistics..", "Simulator working", 0);
        } else {
            this.scanTransitions = scanTransitions;
            this.scanPlaces = scanPlaces;
            this.markArcs = markArcs;
            if (repetitions) {
                this.statsData(quickProgressBar);
            } else {
                this.vectorData(quickProgressBar);
            }
        }
    }

    public void acquireDataXTPN(boolean bySteps, int steps, double time, boolean repeate, int repetitions, boolean knockout, JProgressBar quickProgressBar, HolmesRoundedButton button) {
        if (this.overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
            JOptionPane.showMessageDialog(null, "Net simulator working. Unable to retrieve transitions statistics..", "Simulator working", 0);
            return;
        }
        this.startSimButton = button;
        boolean isKnockout = false;
        if (knockout) {
            if (repeate) {
                for (Transition trans : this.overlord.getWorkspace().getProject().getTransitions()) {
                    if (!trans.isKnockedOut()) continue;
                    isKnockout = true;
                    break;
                }
                if (!isKnockout) {
                    JOptionPane.showMessageDialog(null, "At least one transition must be disabled.", "qSim Knockout: no disabled transition", 1);
                    return;
                }
            } else {
                JOptionPane.showMessageDialog(null, "Knockout simulation must have repetitions turned on.", "qSim Knockout: repetitions", 1);
                return;
            }
        }
        if (GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
            this.stateSimulatorXTPN = new StateSimulatorXTPN();
            this.stateSimulatorXTPN.initiateSim(this.overlord.simSettings);
            this.overlord.simSettings.setNetType(SimulatorGlobals.SimNetType.XTPN, true);
            this.overlord.simSettings.setSimSteps_XTPN(steps);
            this.overlord.simSettings.setSimTime_XTPN(time);
            this.overlord.simSettings.setTimeSimulationStatus_XTPN(!bySteps);
            this.overlord.simSettings.setSimRepetitions_XTPN(repetitions);
            this.startSimButton.setEnabled(false);
            this.overlord.getWorkspace().getProject().setSimulationActive(true);
            if (repeate) {
                if (knockout) {
                    this.stateSimulatorXTPN.setThreadDetails(3, this, this.overlord.simSettings, quickProgressBar, button);
                } else {
                    this.stateSimulatorXTPN.setThreadDetails(2, this, this.overlord.simSettings, quickProgressBar, button);
                }
            } else {
                this.stateSimulatorXTPN.setThreadDetails(1, this, this.overlord.simSettings, quickProgressBar, button);
            }
            Thread myThread = new Thread(this.stateSimulatorXTPN);
            myThread.start();
        }
    }

    private void statsData(JProgressBar quickProgressBar) {
        this.stateSimulatorPN = new StateSimulator();
        this.stateSimulatorPN.initiateSim(true, null);
        this.stateSimulatorPN.setThreadDetails(5, quickProgressBar, this);
        Thread myThread = new Thread(this.stateSimulatorPN);
        myThread.start();
    }

    private void vectorData(JProgressBar quickProgressBar) {
        this.stateSimulatorPN = new StateSimulator();
        this.stateSimulatorPN.initiateSim(true, null);
        this.stateSimulatorPN.setThreadDetails(6, quickProgressBar, this);
        Thread myThread = new Thread(this.stateSimulatorPN);
        myThread.start();
    }

    public void finishedStatsData(ArrayList<ArrayList<Double>> quickSimAllStats, ArrayList<Transition> transitions, ArrayList<Place> places) {
        int p;
        int t;
        ArrayList<Double> avgFire = quickSimAllStats.get(0);
        ArrayList<Double> avgTokens = quickSimAllStats.get(2);
        this.overlord.simSettings.quickSimToken = true;
        int transSize = transitions.size();
        int placesSize = places.size();
        double max = 0.0;
        for (t = 0; t < transSize; ++t) {
            if (!(avgFire.get(t) > max)) continue;
            max = avgFire.get(t);
        }
        if (this.overlord.simSettings.isMaxMode()) {
            max = 1.0;
        }
        for (t = 0; t < transSize; ++t) {
            Transition trans = transitions.get(t);
            double firing = avgFire.get(t);
            String tmp = Tools.cutValueExt(firing, 6);
            trans.qSimBoxT.qSimFired = firing = Double.parseDouble(tmp);
            trans.drawGraphBoxT.setAddText(Tools.cutValueExt(firing, 8));
            double reliance = firing / max;
            trans.qSimBoxT.qSimFillValue = (int)(30.0 * reliance);
            if (firing < 0.05) {
                trans.qSimBoxT.qSimFillColor = Color.RED;
                trans.qSimBoxT.qSimFillValue = 5;
            } else {
                trans.qSimBoxT.qSimFillColor = firing < 0.15 ? Color.ORANGE : Color.GREEN;
            }
            if (this.scanTransitions) {
                for (ElementLocation el : trans.getElementLocations()) {
                    el.qSimDrawed = true;
                }
                trans.qSimBoxT.qSimDrawed = true;
                trans.qSimBoxT.qSimDrawStats = true;
                if (firing < 0.01) {
                    trans.qSimArcSign = true;
                    trans.qSimBoxT.qSimOvalColor = Color.RED;
                    continue;
                }
                trans.qSimArcSign = false;
                continue;
            }
            trans.qSimBoxT.qSimDrawed = false;
            trans.qSimBoxT.qSimDrawStats = false;
            trans.qSimArcSign = false;
        }
        double maxT = 0.0;
        for (p = 0; p < placesSize; ++p) {
            if (!(avgTokens.get(p) > maxT)) continue;
            maxT = avgTokens.get(p);
        }
        for (p = 0; p < placesSize; ++p) {
            double avgT;
            Place place = places.get(p);
            place.qSimBoxP.qSimTokens = avgT = avgTokens.get(p).doubleValue();
            if (avgT == 0.0) {
                place.qSimBoxP.qSimFillColor = Color.BLACK;
                place.qSimBoxP.qSimOvalColor = Color.RED;
            } else if (avgT < 1.0) {
                place.qSimBoxP.qSimFillColor = Color.RED;
                place.qSimBoxP.qSimFillValue = 4;
            } else if (avgT < 5.0) {
                place.qSimBoxP.qSimFillColor = Color.ORANGE;
                place.qSimBoxP.qSimFillValue = 8;
            } else {
                double reliance = avgT / maxT;
                int fill = (int)(30.0 * reliance);
                if (fill < 8) {
                    fill = 8;
                }
                place.qSimBoxP.qSimFillValue = fill;
                place.qSimBoxP.qSimFillColor = Color.GREEN;
            }
            if (this.scanPlaces) {
                place.qSimBoxP.qSimDrawed = true;
                place.qSimBoxP.qSimDrawStats = true;
                for (ElementLocation el : place.getElementLocations()) {
                    el.qSimDrawed = true;
                }
                place.qSimArcSign = avgT == 0.0;
                continue;
            }
            place.qSimBoxP.qSimDrawed = false;
            place.qSimBoxP.qSimDrawStats = false;
            place.qSimArcSign = false;
        }
        ArrayList<Arc> arcs = this.overlord.getWorkspace().getProject().getArcs();
        for (Arc arc : arcs) {
            if (arc.getStartNode().qSimArcSign && arc.getEndNode().qSimArcSign) {
                arc.arcQSimBox.qSimForcedArc = true;
                arc.arcQSimBox.qSimForcedColor = Color.RED;
            } else {
                arc.arcQSimBox.qSimForcedArc = false;
                arc.arcQSimBox.qSimForcedColor = Color.BLACK;
            }
            if (this.markArcs) continue;
            arc.arcQSimBox.qSimForcedArc = false;
            arc.arcQSimBox.qSimForcedColor = Color.BLACK;
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    public void finishedStatsDataXTPN(StateSimDataContainer result, ArrayList<TransitionXTPN> transitions, ArrayList<PlaceXTPN> places) {
        String s;
        long minutes;
        String m;
        HolmesNotepad note = new HolmesNotepad(800, 600);
        note.addTextLineNL("Simulation data", "text");
        note.addTextLineNL("Avg. steps:  " + Tools.cutValue(result.simSteps), "text");
        note.addTextLineNL("Avg. time:   " + Tools.cutValue(result.simTime), "text");
        note.addTextLineNL("Repetitions: " + (int)result.simReps, "text");
        long milisecond = result.compTime;
        long seconds = milisecond /= 1000L;
        long hours = seconds / 3600L;
        String h = "" + hours;
        if (h.length() == 1) {
            h = "0" + h;
        }
        if ((m = "" + (minutes = (seconds -= hours * 3600L) / 60L)).length() == 1) {
            m = "0" + m;
        }
        if ((s = "" + (seconds -= minutes * 60L)).length() == 1) {
            s = "0" + s;
        }
        note.addTextLine("Simulation time recorded (h:m:s) : ", "text");
        note.addTextLineNL(h + ":" + m + ":" + s, "text");
        int transIndex = 0;
        double simSteps = result.simSteps;
        double simTime = result.simTime;
        note.addTextLineNL("", "bold");
        note.addTextLineNL("Transitions data", "bold");
        for (TransitionXTPN trans : transitions) {
            double tmpSteps = result.transitionsStatistics.get(transIndex).get(0);
            double tmpTime = result.transitionsStatistics.get(transIndex).get(4);
            note.addTextLine("Transition ", "text");
            note.addTextLine("" + transIndex, "bold");
            note.addTextLine(" (" + trans.getName() + ")", "bold");
            note.addTextLine(" Type: ", "text");
            note.addTextLineNL(this.getTransType(trans), "bold");
            String text = "   Inactive (#):  " + (int)tmpSteps + " (" + Tools.cutValue(tmpSteps * 100.0 / simSteps) + "%) | \u03c4: " + Tools.cutValue(tmpTime) + " (" + Tools.cutValue(tmpTime * 100.0 / simTime) + "%)";
            note.addTextLineNL(text, "text");
            tmpSteps = result.transitionsStatistics.get(transIndex).get(1);
            tmpTime = result.transitionsStatistics.get(transIndex).get(5);
            text = "   Active (#):    " + (int)tmpSteps + " (" + Tools.cutValue(tmpSteps * 100.0 / simSteps) + "%) | \u03c4: " + Tools.cutValue(tmpTime) + " (" + Tools.cutValue(tmpTime * 100.0 / simTime) + "%)";
            note.addTextLineNL(text, "text");
            tmpSteps = result.transitionsStatistics.get(transIndex).get(2);
            tmpTime = result.transitionsStatistics.get(transIndex).get(6);
            text = "   Production (#): " + (int)tmpSteps + " (" + Tools.cutValue(tmpSteps * 100.0 / simSteps) + "%) | \u03c4: " + Tools.cutValue(tmpTime) + " (" + Tools.cutValue(tmpTime * 100.0 / simTime) + "%)";
            note.addTextLineNL(text, "text");
            tmpSteps = result.transitionsStatistics.get(transIndex).get(3);
            text = "   Fired (#): " + (int)tmpSteps;
            note.addTextLineNL(text, "text");
            note.addTextLineNL("", "text");
            ++transIndex;
        }
        note.addTextLineNL("", "bold");
        note.addTextLineNL("Places data", "bold");
        int placeIndex = 0;
        for (PlaceXTPN place : places) {
            note.addTextLine("Place ", "text");
            note.addTextLine("" + placeIndex, "bold");
            note.addTextLine(" (" + place.getName() + ")", "bold");
            note.addTextLine(" Type: ", "text");
            note.addTextLineNL(this.getPlaceType(place), "bold");
            double avgTokens = result.avgTokens.get(placeIndex);
            note.addTextLineNL("   Avg. tokens: " + Tools.cutValue(avgTokens), "text");
            ++placeIndex;
        }
        note.setCaretFirstLine();
        note.setVisible(true);
        this.startSimButton.setEnabled(true);
        this.overlord.getWorkspace().getProject().setSimulationActive(false);
    }

    public void finishedStatsDataXTPN_Knockout(ArrayList<StateSimDataContainer> result, ArrayList<TransitionXTPN> transitions, ArrayList<PlaceXTPN> places) {
        HolmesNotepad note = new HolmesNotepad(800, 600);
        note.addTextLineNL("Simulation data", "text");
        note.addTextLineNL("Repetitions: " + (int)result.get((int)0).simReps, "text");
        note.addTextLineNL(" * Reference set:", "bold");
        note.addTextLine("      Avg. steps:  ", "text");
        note.addTextLineNL(Tools.cutValue(result.get((int)0).simSteps), "bold");
        note.addTextLine("      Avg. time:   ", "text");
        note.addTextLineNL(Tools.cutValue(result.get((int)0).simTime), "bold");
        note.addTextLine("      Time:        ", "text");
        note.addTextLineNL(Tools.getTime(result.get((int)0).compTime), "text");
        note.addTextLineNL(" * Knockout set:", "bold");
        note.addTextLine("      Avg. steps:  ", "text");
        note.addTextLineNL(Tools.cutValue(result.get((int)1).simSteps), "bold");
        note.addTextLine("      Avg. time:   ", "text");
        note.addTextLineNL(Tools.cutValue(result.get((int)1).simTime), "bold");
        note.addTextLine("      Time:        ", "text");
        note.addTextLineNL(Tools.getTime(result.get((int)1).compTime), "text");
        int transIndex = 0;
        double simStepsRef = result.get((int)0).simSteps;
        double simTimeRef = result.get((int)0).simTime;
        double simStepsKnock = result.get((int)1).simSteps;
        double simTimeKnock = result.get((int)1).simTime;
        note.addTextLineNL("", "bold");
        note.addTextLineNL("Transitions data", "bold");
        for (TransitionXTPN trans : transitions) {
            double tmpStepsRef = result.get((int)0).transitionsStatistics.get(transIndex).get(0);
            double tmpTimeRef = result.get((int)0).transitionsStatistics.get(transIndex).get(4);
            double tmpStepsKnock = result.get((int)1).transitionsStatistics.get(transIndex).get(0);
            double tmpTimeKnock = result.get((int)1).transitionsStatistics.get(transIndex).get(4);
            double tmpStepsPercentRef = tmpStepsRef * 100.0 / simStepsRef;
            double tmpTimePercentRef = tmpTimeRef * 100.0 / simTimeRef;
            double tmpStepsPercentKnock = tmpStepsKnock * 100.0 / simStepsKnock;
            double tmpTimePercentKnock = tmpTimeKnock * 100.0 / simTimeKnock;
            note.addTextLine("Transition ", "text");
            note.addTextLine("" + transIndex, "bold");
            note.addTextLine(" (" + trans.getName() + ")", "bold");
            note.addTextLine(" Type: ", "text");
            note.addTextLineNL(this.getTransType(trans), "bold");
            String text = " R Inactive (#):  " + (int)tmpStepsRef + " (" + Tools.cutValue(tmpStepsPercentRef) + "%) | \u03c4: " + Tools.cutValue(tmpTimeRef) + " (" + Tools.cutValue(tmpTimePercentRef) + "%)";
            note.addTextLineNL(text, "text");
            text = " K Inactive (#):  " + (int)tmpStepsKnock + " (" + Tools.cutValue(tmpStepsPercentKnock) + "%) | \u03c4: " + Tools.cutValue(tmpTimeKnock) + " (" + Tools.cutValue(tmpTimePercentKnock) + "%)";
            note.addTextLineNL(text, "text");
            double diffSteps = tmpStepsRef - tmpStepsKnock;
            String signS = "+";
            if (diffSteps > 0.0) {
                signS = "-";
            }
            double diffTime = tmpTimeRef - tmpTimeKnock;
            String signT = "+";
            if (diffTime > 0.0) {
                signT = "-";
            }
            String textDeltaInactive = "   \u0394Inact.:  " + signS + (int)Math.abs(tmpStepsRef - tmpStepsKnock) + " (" + signS + Tools.cutValue(Math.abs(tmpStepsPercentRef - tmpStepsPercentKnock)) + "%) | \u0394\u03c4: " + signT + Tools.cutValue(Math.abs(tmpTimeRef - tmpTimeKnock)) + " (" + signT + Tools.cutValue(Math.abs(tmpTimePercentRef - tmpTimePercentKnock)) + "%)";
            tmpStepsRef = result.get((int)0).transitionsStatistics.get(transIndex).get(1);
            tmpTimeRef = result.get((int)0).transitionsStatistics.get(transIndex).get(5);
            tmpStepsKnock = result.get((int)1).transitionsStatistics.get(transIndex).get(1);
            tmpTimeKnock = result.get((int)1).transitionsStatistics.get(transIndex).get(5);
            tmpStepsPercentRef = tmpStepsRef * 100.0 / simStepsRef;
            tmpTimePercentRef = tmpTimeRef * 100.0 / simTimeRef;
            tmpStepsPercentKnock = tmpStepsKnock * 100.0 / simStepsKnock;
            tmpTimePercentKnock = tmpTimeKnock * 100.0 / simTimeKnock;
            text = " R Active (#):    " + (int)tmpStepsRef + " (" + Tools.cutValue(tmpStepsPercentRef) + "%) | \u03c4: " + Tools.cutValue(tmpTimeRef) + " (" + Tools.cutValue(tmpTimePercentRef) + "%)";
            note.addTextLineNL(text, "text");
            text = " K Active (#):    " + (int)tmpStepsKnock + " (" + Tools.cutValue(tmpStepsPercentKnock) + "%) | \u03c4: " + Tools.cutValue(tmpTimeKnock) + " (" + Tools.cutValue(tmpTimePercentKnock) + "%)";
            note.addTextLineNL(text, "text");
            diffSteps = tmpStepsRef - tmpStepsKnock;
            signS = "+";
            if (diffSteps > 0.0) {
                signS = "-";
            }
            diffTime = tmpTimeRef - tmpTimeKnock;
            signT = "+";
            if (diffTime > 0.0) {
                signT = "-";
            }
            String textDeltaActive = "   \u0394Act.  :  " + signS + (int)Math.abs(tmpStepsRef - tmpStepsKnock) + " (" + signS + Tools.cutValue(Math.abs(tmpStepsPercentRef - tmpStepsPercentKnock)) + "%) | \u0394\u03c4: " + signT + Tools.cutValue(Math.abs(tmpTimeRef - tmpTimeKnock)) + " (" + signT + Tools.cutValue(Math.abs(tmpTimePercentRef - tmpTimePercentKnock)) + "%)";
            tmpStepsRef = result.get((int)0).transitionsStatistics.get(transIndex).get(2);
            tmpTimeRef = result.get((int)0).transitionsStatistics.get(transIndex).get(6);
            tmpStepsKnock = result.get((int)1).transitionsStatistics.get(transIndex).get(2);
            tmpTimeKnock = result.get((int)1).transitionsStatistics.get(transIndex).get(6);
            tmpStepsPercentRef = tmpStepsRef * 100.0 / simStepsRef;
            tmpTimePercentRef = tmpTimeRef * 100.0 / simTimeRef;
            tmpStepsPercentKnock = tmpStepsKnock * 100.0 / simStepsKnock;
            tmpTimePercentKnock = tmpTimeKnock * 100.0 / simTimeKnock;
            text = " R Production (#): " + (int)tmpStepsRef + " (" + Tools.cutValue(tmpStepsPercentRef) + "%) | \u03c4: " + Tools.cutValue(tmpTimeRef) + " (" + Tools.cutValue(tmpTimePercentRef) + "%)";
            note.addTextLineNL(text, "text");
            text = " K Production (#): " + (int)tmpStepsKnock + " (" + Tools.cutValue(tmpStepsPercentKnock) + "%) | \u03c4: " + Tools.cutValue(tmpTimeKnock) + " (" + Tools.cutValue(tmpTimePercentKnock) + "%)";
            note.addTextLineNL(text, "text");
            diffSteps = tmpStepsRef - tmpStepsKnock;
            signS = "+";
            if (diffSteps > 0.0) {
                signS = "-";
            }
            diffTime = tmpTimeRef - tmpTimeKnock;
            signT = "+";
            if (diffTime > 0.0) {
                signT = "-";
            }
            String textDeltaProduction = "   \u0394Prod. :  " + signS + (int)Math.abs(tmpStepsRef - tmpStepsKnock) + " (" + signS + Tools.cutValue(Math.abs(tmpStepsPercentRef - tmpStepsPercentKnock)) + "%) | \u0394\u03c4: " + signT + Tools.cutValue(Math.abs(tmpTimeRef - tmpTimeKnock)) + " (" + signT + Tools.cutValue(Math.abs(tmpTimePercentRef - tmpTimePercentKnock)) + "%)";
            tmpStepsRef = result.get((int)0).transitionsStatistics.get(transIndex).get(3);
            tmpStepsKnock = result.get((int)1).transitionsStatistics.get(transIndex).get(3);
            text = " R Fired (#): " + (int)tmpStepsRef + "  |   K Fired (#): " + (int)tmpStepsKnock;
            note.addTextLineNL(text, "text");
            diffSteps = tmpStepsRef - tmpStepsKnock;
            signS = "+";
            if (diffSteps > 0.0) {
                signS = "-";
            }
            String textDeltaFire = "   \u0394Fired :  " + signS + (int)Math.abs(tmpStepsRef - tmpStepsKnock);
            note.addTextLineNL(textDeltaInactive, "text");
            note.addTextLineNL(textDeltaActive, "text");
            note.addTextLineNL(textDeltaProduction, "text");
            note.addTextLineNL(textDeltaFire, "text");
            note.addTextLineNL("", "text");
            ++transIndex;
        }
        note.addTextLineNL("", "bold");
        note.addTextLineNL("Places data", "bold");
        int placeIndex = 0;
        for (PlaceXTPN place : places) {
            note.addTextLine("Place ", "text");
            note.addTextLine("" + placeIndex, "bold");
            note.addTextLine(" (" + place.getName() + ")", "bold");
            note.addTextLine(" Type: ", "text");
            note.addTextLineNL(this.getPlaceType(place), "bold");
            double avgTokensRef = result.get((int)0).avgTokens.get(placeIndex);
            note.addTextLine("   (Ref)   Avg. tokens:", "bold");
            note.addTextLineNL(Tools.cutValue(avgTokensRef), "text");
            double avgTokensKnock = result.get((int)1).avgTokens.get(placeIndex);
            note.addTextLine("   (Knock) Avg. tokens:", "bold");
            note.addTextLineNL(Tools.cutValue(avgTokensKnock), "text");
            ++placeIndex;
        }
        note.setCaretFirstLine();
        note.setVisible(true);
        this.startSimButton.setEnabled(true);
        this.overlord.getWorkspace().getProject().setSimulationActive(false);
    }

    private String getTransType(TransitionXTPN transition) {
        if (transition.isAlphaModeActive() && transition.isBetaModeActive()) {
            return "XTPN";
        }
        if (transition.isAlphaModeActive()) {
            return "TPN";
        }
        if (transition.isBetaModeActive()) {
            return "DPN";
        }
        return "classical PN";
    }

    private String getPlaceType(PlaceXTPN place) {
        if (place.isGammaModeActive()) {
            return "time-place";
        }
        return "classical place";
    }
}

