/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.simulators;

import holmes.petrinet.simulators.IRandomGenerator;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class HighQualityRandom
implements IRandomGenerator {
    private Lock l = new ReentrantLock();
    private long u;
    private long v = 4101842887655102017L;
    private long w = 1L;
    private Random generator;

    public HighQualityRandom() {
        this(System.nanoTime());
        this.generator = new Random(System.nanoTime());
    }

    public HighQualityRandom(long seed) {
        this.l.lock();
        this.u = seed ^ this.v;
        this.nextLong();
        this.v = this.u;
        this.nextLong();
        this.w = this.v;
        this.nextLong();
        this.l.unlock();
        this.generator = new Random(System.nanoTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long nextLong() {
        this.l.lock();
        try {
            this.u = this.u * 2862933555777941757L + 7046029254386353087L;
            this.v ^= this.v >>> 17;
            this.v ^= this.v << 31;
            this.v ^= this.v >>> 8;
            this.w = 4294957665L * (this.w & 0xFFFFFFFFFFFFFFFFL) + (this.w >>> 32);
            long x = this.u ^ this.u << 21;
            x ^= x >>> 35;
            x ^= x << 4;
            long l = x + this.v ^ this.w;
            return l;
        }
        finally {
            this.l.unlock();
        }
    }

    @Override
    public long nextLong(long limit) {
        long ref;
        long v = this.nextLong();
        double tmp = (double)v / (double)(ref = Long.MAX_VALUE);
        long result = (long)(tmp * (double)limit);
        if (result == limit) {
            --result;
        }
        return result;
    }

    @Override
    public long nextLong(long min, long max) {
        long res = this.nextLong(max - min) + min;
        return res;
    }

    @Override
    public int nextInt(int bits) {
        int result = (int)this.nextLong(bits);
        result = result < 0 ? -result : result;
        return result;
    }

    @Override
    public double nextDouble() {
        return this.generator.nextDouble();
    }

    @Override
    public double nextDouble(double min, double max) {
        return ThreadLocalRandom.current().nextDouble(min, max);
    }
}

