/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.elements;

import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.containers.TransitionXTPNhistoryContainer;
import holmes.petrinet.elements.containers.TransitionXTPNqSimGraphics;
import holmes.petrinet.functions.FunctionsTools;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TransitionXTPN
extends Transition {
    private static final long serialVersionUID = 4766270474155264671L;
    private boolean alphaMode_xTPN = true;
    private boolean alphaRangeVisibility_XTPN = true;
    private double alphaMin_xTPN = 0.0;
    private double alphaMax_xTPN = 1.0;
    private boolean betaMode_xTPN = true;
    private double betaMin_xTPN = 0.0;
    private double betaMax_xTPN = 1.0;
    private boolean betaRangeVisibility_XTPN = true;
    private double tauAlpha_xTPN = -1.0;
    private double tauBeta_xTPN = -1.0;
    private double timer_Ualfa_XTPN = -1.0;
    private double timer_Vbeta_XTPN = -1.0;
    private boolean tauTimersVisibility_XTPN = false;
    private boolean massActionKinetics = false;
    private boolean isImmediateXTPN = false;
    private boolean isActivated_xTPN = false;
    private boolean isProducing_xTPN = false;
    private int fractionDigits = 2;
    public TransitionXTPNhistoryContainer simHistoryXTPN = new TransitionXTPNhistoryContainer();
    public TransitionXTPNqSimGraphics qSimXTPN = new TransitionXTPNqSimGraphics();
    public ArrayList<TokensBack> readArcReturnVector;

    public TransitionXTPN(int transitionId, ArrayList<ElementLocation> elementLocations, String name, String comment) {
        super(transitionId, elementLocations, name, comment);
        this.transType = Transition.TransitionType.XTPN;
        this.readArcReturnVector = new ArrayList();
    }

    public TransitionXTPN(int transitionId, ArrayList<ElementLocation> elementLocations) {
        super(transitionId, elementLocations);
        this.transType = Transition.TransitionType.XTPN;
        this.readArcReturnVector = new ArrayList();
    }

    public TransitionXTPN(int transitionId, int sheetId, Point transitionPosition) {
        super(transitionId, sheetId, transitionPosition);
        this.transType = Transition.TransitionType.XTPN;
        this.readArcReturnVector = new ArrayList();
    }

    public TransitionXTPN(String error) {
        super(error);
        this.transType = Transition.TransitionType.XTPN;
        this.readArcReturnVector = new ArrayList();
    }

    public void resetTimeVariables_xTPN() {
        this.tauAlpha_xTPN = -1.0;
        this.tauBeta_xTPN = -1.0;
        this.timer_Ualfa_XTPN = -1.0;
        this.timer_Vbeta_XTPN = -1.0;
        this.isActivated_xTPN = false;
        this.isProducing_xTPN = false;
        this.readArcReturnVector.clear();
    }

    public void setAlphaMinValue(double value, boolean force) {
        if (force) {
            this.alphaMin_xTPN = value;
            return;
        }
        if (value < 0.0) {
            this.alphaMin_xTPN = 0.0;
            return;
        }
        if (value > this.alphaMax_xTPN) {
            this.alphaMin_xTPN = this.alphaMax_xTPN;
            return;
        }
        this.alphaMin_xTPN = value;
    }

    public double getAlphaMinValue() {
        return this.alphaMin_xTPN;
    }

    public void setAlphaMaxValue(double value, boolean force) {
        if (force) {
            this.alphaMax_xTPN = value;
            return;
        }
        if (value < 0.0) {
            this.alphaMax_xTPN = -1.0;
            return;
        }
        if (value < this.alphaMin_xTPN) {
            this.alphaMax_xTPN = this.alphaMin_xTPN;
            return;
        }
        this.alphaMax_xTPN = value;
    }

    public double getAlphaMaxValue() {
        return this.alphaMax_xTPN;
    }

    public void setBetaMinValue(double value, boolean force) {
        if (force) {
            this.betaMin_xTPN = value;
            return;
        }
        if (value < 0.0) {
            this.betaMin_xTPN = 0.0;
            return;
        }
        if (value > this.betaMax_xTPN) {
            this.betaMin_xTPN = this.betaMax_xTPN;
            return;
        }
        this.betaMin_xTPN = value;
    }

    public double getBetaMinValue() {
        return this.betaMin_xTPN;
    }

    public void setBetaMaxValue(double value, boolean force) {
        if (force) {
            this.betaMax_xTPN = value;
            return;
        }
        if (value < 0.0) {
            this.betaMax_xTPN = 0.0;
            return;
        }
        if (value < this.betaMin_xTPN) {
            this.betaMax_xTPN = this.betaMin_xTPN;
            return;
        }
        this.betaMax_xTPN = value;
    }

    public double getBetaMaxValue() {
        return this.betaMax_xTPN;
    }

    public void setTauAlphaValue(double value) {
        this.tauAlpha_xTPN = value;
    }

    public double getTauAlphaValue() {
        return this.tauAlpha_xTPN;
    }

    public void setTauBetaValue(double value) {
        this.tauBeta_xTPN = value;
    }

    public double getTauBetaValue() {
        return this.tauBeta_xTPN;
    }

    public void setTauTimersVisibility(boolean status) {
        this.tauTimersVisibility_XTPN = status;
    }

    public boolean isTauTimerVisible() {
        return this.tauTimersVisibility_XTPN;
    }

    public void setAlphaRangeVisibility(boolean status) {
        this.alphaRangeVisibility_XTPN = status;
    }

    public boolean isAlphaRangeVisible() {
        return this.alphaRangeVisibility_XTPN;
    }

    public void setBetaRangeVisibility(boolean status) {
        this.betaRangeVisibility_XTPN = status;
    }

    public boolean isBetaRangeVisible() {
        return this.betaRangeVisibility_XTPN;
    }

    public void setFraction_xTPN(int value) {
        this.fractionDigits = value;
    }

    public int getFraction_xTPN() {
        return this.fractionDigits;
    }

    public void setTimerAlfaValue(double value) {
        this.timer_Ualfa_XTPN = value;
    }

    public void updateTimerAlfaValue(double delta) {
        this.timer_Ualfa_XTPN += delta;
    }

    public double getTimerAlfaValue() {
        return this.timer_Ualfa_XTPN;
    }

    public void setTimerBetaValue(double value) {
        this.timer_Vbeta_XTPN = value;
    }

    public void updateTimerBetaValue(double delta) {
        this.timer_Vbeta_XTPN += delta;
    }

    public double getTimerBetaValue() {
        return this.timer_Vbeta_XTPN;
    }

    public void setActivationStatusXTPN(boolean status) {
        this.isActivated_xTPN = status;
        if (status) {
            this.isProducing_xTPN = false;
        }
    }

    public boolean isActivated_xTPN() {
        return this.isActivated_xTPN;
    }

    public void setProductionStatus_xTPN(boolean status) {
        this.isProducing_xTPN = status;
        if (status) {
            this.isActivated_xTPN = false;
        }
    }

    public boolean isProducing_xTPN() {
        return this.isProducing_xTPN;
    }

    public void setAlphaModeStatus(boolean status) {
        this.alphaMode_xTPN = status;
    }

    public boolean isAlphaModeActive() {
        return this.alphaMode_xTPN;
    }

    public void setBetaModeStatus(boolean status) {
        this.betaMode_xTPN = status;
    }

    public boolean isBetaModeActive() {
        return this.betaMode_xTPN;
    }

    public void setMassActionKineticsXTPNstatus(boolean status) {
        this.massActionKinetics = status;
    }

    public boolean isImmediateXTPN() {
        return this.isImmediateXTPN;
    }

    public void setImmediateStatusXTPN(boolean immediateXTPN) {
        this.isImmediateXTPN = immediateXTPN;
    }

    public boolean isMassActionKineticsActiveXTPN() {
        return this.massActionKinetics;
    }

    public boolean isInputTransition() {
        return this.getInArcs().size() == 0;
    }

    public boolean isOutputTransition() {
        return this.getOutArcs().size() == 0;
    }

    public boolean isActiveTransitionXTPN(double accuracy) {
        if (this.knockoutStatus || this.isProducing_xTPN()) {
            return false;
        }
        for (Arc arc : this.getInArcs()) {
            if (!(arc.getStartNode() instanceof PlaceXTPN)) {
                GUIManager.getDefaultGUIManager().log("Error, non-XTPN place found! Place: " + arc.getStartNode().getName(), "error", true);
                break;
            }
            PlaceXTPN arcStartPlace = (PlaceXTPN)arc.getStartNode();
            Arc.TypeOfArc arcType = arc.getArcType();
            int arcWeight = arc.getWeight();
            if (arcStartPlace.isGammaModeActive()) {
                if (arcStartPlace.accessMultiset().size() < arcWeight) {
                    if (arcType == Arc.TypeOfArc.INHIBITOR) continue;
                    return false;
                }
                if (!(!this.isActivationMultiset(arcWeight, arcStartPlace.getGammaMinValue(), arcStartPlace.accessMultiset(), accuracy) ? arcType != Arc.TypeOfArc.INHIBITOR : arcType == Arc.TypeOfArc.INHIBITOR)) continue;
                return false;
            }
            int startPlaceTokens = arcStartPlace.getNonReservedTokensNumber();
            if (!(arcWeight > startPlaceTokens ? arcType != Arc.TypeOfArc.INHIBITOR : arcType == Arc.TypeOfArc.INHIBITOR)) continue;
            return false;
        }
        return true;
    }

    public void deactivateTransitionXTPN(boolean graphics) {
        this.setActivationStatusXTPN(false);
        this.setProductionStatus_xTPN(false);
        if (this.alphaMode_xTPN) {
            this.setTimerAlfaValue(-1.0);
            this.setTauAlphaValue(-1.0);
        }
        if (this.betaMode_xTPN) {
            this.setTimerBetaValue(-1.0);
            this.setTauBetaValue(-1.0);
        }
        if (graphics) {
            ArrayList<Arc> arcs = this.getInArcs();
            for (Arc arc : arcs) {
                arc.arcXTPNbox.setXTPNactStatus(false);
            }
        }
    }

    private boolean isActivationMultiset(int size, double gammaMin, ArrayList<Double> multiset, double accuracy) {
        int counter = 0;
        for (Double kappa : multiset) {
            if (!(kappa + accuracy > gammaMin) || ++counter != size) continue;
            return true;
        }
        return false;
    }

    private Map<PlaceXTPN, Integer> preparePrePlaces() {
        HashMap<PlaceXTPN, Integer> prePlaces = new HashMap<PlaceXTPN, Integer>();
        for (ElementLocation el : this.getElementLocations()) {
            for (Arc arc : el.getInArcs()) {
                Node n = arc.getStartNode();
                if (prePlaces.containsKey((PlaceXTPN)n)) continue;
                int weight = FunctionsTools.getFunctionalArcWeight(this, arc, (PlaceXTPN)n);
                prePlaces.put((PlaceXTPN)n, weight);
            }
        }
        return prePlaces;
    }

    public double maxFiresPossible() {
        long massActionKineticModifier = 1L;
        Map<PlaceXTPN, Integer> prePlaces = this.preparePrePlaces();
        if (prePlaces.size() != 0) {
            massActionKineticModifier = Long.MAX_VALUE;
            for (PlaceXTPN prePlace : prePlaces.keySet()) {
                int weigth = prePlaces.get(prePlace);
                long firingNumber = prePlace.getTokensNumber() / weigth;
                if (prePlace.isGammaModeActive()) {
                    firingNumber = 0L;
                    double gammaMin = prePlace.getGammaMinValue();
                    for (double token : prePlace.accessMultiset()) {
                        if (!(token >= gammaMin)) continue;
                        ++firingNumber;
                    }
                    firingNumber /= (long)weigth;
                }
                massActionKineticModifier = Math.min(massActionKineticModifier, firingNumber);
            }
        }
        return massActionKineticModifier;
    }

    public static final class TokensBack {
        public PlaceXTPN placeBack;
        public int tokensBack;
        public ArrayList<Double> multisetBack;

        public TokensBack(PlaceXTPN place, int tokens, ArrayList<Double> multiRem) {
            this.placeBack = place;
            this.tokensBack = tokens;
            this.multisetBack = multiRem;
        }

        public void Clear() {
            this.placeBack = null;
            this.tokensBack = 0;
            this.multisetBack.clear();
        }
    }
}

