/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.elements;

import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceColored;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.functions.FunctionsTools;
import java.awt.Point;
import java.util.ArrayList;

public class TransitionColored
extends Transition {
    protected int reqT0red = 1;
    protected int reqT1green = 0;
    protected int reqT2blue = 0;
    protected int reqT3yellow = 0;
    protected int reqT4gray = 0;
    protected int reqT5black = 0;

    public TransitionColored(int transitionId, ArrayList<ElementLocation> elementLocations, String name, String comment) {
        super(transitionId, elementLocations, name, comment);
        this.transType = Transition.TransitionType.CPN;
    }

    public TransitionColored(int transitionId, ArrayList<ElementLocation> elementLocations) {
        super(transitionId, elementLocations);
        this.transType = Transition.TransitionType.CPN;
    }

    public TransitionColored(int transitionId, int sheetId, Point transitionPosition) {
        super(transitionId, sheetId, transitionPosition);
        this.transType = Transition.TransitionType.CPN;
    }

    public TransitionColored(String error) {
        super(error);
        this.transType = Transition.TransitionType.CPN;
    }

    public boolean isColorActive() {
        if (this.knockoutStatus) {
            return false;
        }
        int req0red = 0;
        int req1green = 0;
        int req2blue = 0;
        int req3yellow = 0;
        int req4grey = 0;
        int req5black = 0;
        int tokens0red = 0;
        int tokens1green = 0;
        int tokens2blue = 0;
        int tokens3yellow = 0;
        int tokens4grey = 0;
        int tokens5black = 0;
        for (Arc arc : this.getInArcs()) {
            Place arcStartPlace = (Place)arc.getStartNode();
            Arc.TypeOfArc arcType = arc.getArcType();
            if (arcType != Arc.TypeOfArc.COLOR) {
                boolean status;
                int startPlaceTokens = arcStartPlace.getNonReservedTokensNumber();
                if (arcType == Arc.TypeOfArc.INHIBITOR) {
                    if (startPlaceTokens <= arc.getWeight()) continue;
                    return false;
                }
                if (arcType == Arc.TypeOfArc.EQUAL && startPlaceTokens != arc.getWeight()) {
                    return false;
                }
                if (this.fpnExtension.isFunctional() ? !(status = FunctionsTools.getFunctionDecision(startPlaceTokens, arc, arc.getWeight(), this)) : startPlaceTokens < arc.getWeight()) {
                    return false;
                }
            }
            req0red += arc.getColorWeight(0);
            req1green += arc.getColorWeight(1);
            req2blue += arc.getColorWeight(2);
            req3yellow += arc.getColorWeight(3);
            req4grey += arc.getColorWeight(4);
            req5black += arc.getColorWeight(5);
            try {
                tokens0red += ((PlaceColored)arcStartPlace).getNonReservedColorTokensNumber(0);
                tokens1green += ((PlaceColored)arcStartPlace).getNonReservedColorTokensNumber(1);
                tokens2blue += ((PlaceColored)arcStartPlace).getNonReservedColorTokensNumber(2);
                tokens3yellow += ((PlaceColored)arcStartPlace).getNonReservedColorTokensNumber(3);
                tokens4grey += ((PlaceColored)arcStartPlace).getNonReservedColorTokensNumber(4);
                tokens5black += ((PlaceColored)arcStartPlace).getNonReservedColorTokensNumber(5);
            }
            catch (Exception ex) {
                GUIManager.getDefaultGUIManager().log("Error in TransitionColored.isColorActive(). Probably non-colored place in arc.", "error", false);
            }
        }
        return req0red > tokens0red || req1green > tokens1green || req2blue > tokens2blue || req3yellow > tokens3yellow || req4grey > tokens4grey || req5black > tokens5black;
    }

    public int getRequiredColoredTokens(int i) {
        return switch (i) {
            case 1 -> this.reqT1green;
            case 2 -> this.reqT2blue;
            case 3 -> this.reqT3yellow;
            case 4 -> this.reqT4gray;
            case 5 -> this.reqT5black;
            default -> this.reqT0red;
        };
    }

    public void setRequiredColoredTokens(int tokens, int i) {
        switch (i) {
            case 1: {
                this.reqT1green = tokens;
                break;
            }
            case 2: {
                this.reqT2blue = tokens;
                break;
            }
            case 3: {
                this.reqT3yellow = tokens;
                break;
            }
            case 4: {
                this.reqT4gray = tokens;
                break;
            }
            case 5: {
                this.reqT5black = tokens;
                break;
            }
            default: {
                this.reqT0red = tokens;
            }
        }
    }
}

