/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.elements;

import holmes.darkgui.GUIManager;
import holmes.graphpanel.ElementDraw;
import holmes.graphpanel.ElementDrawSettings;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceColored;
import holmes.petrinet.elements.containers.TransitionGraphicsContainer;
import holmes.petrinet.elements.containers.TransitionQSimContainer;
import holmes.petrinet.elements.extensions.TransitionFPNExtension;
import holmes.petrinet.elements.extensions.TransitionSPNExtension;
import holmes.petrinet.elements.extensions.TransitionTimeExtention;
import holmes.petrinet.functions.FunctionContainer;
import holmes.petrinet.functions.FunctionsTools;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;

public class Transition
extends Node {
    private static final long serialVersionUID = -4981812911464514746L;
    protected TransitionType transType;
    protected static final int realRadius = 15;
    protected boolean isLaunching;
    protected boolean knockoutStatus = false;
    public boolean borderFrame = false;
    public TransitionGraphicsContainer drawGraphBoxT = new TransitionGraphicsContainer();
    public TransitionQSimContainer qSimBoxT = new TransitionQSimContainer();
    public TransitionTimeExtention timeExtension = new TransitionTimeExtention();
    public TransitionSPNExtension spnExtension = new TransitionSPNExtension();
    public TransitionFPNExtension fpnExtension = new TransitionFPNExtension(this);

    public Transition(int transitionId, ArrayList<ElementLocation> elementLocations, String name, String comment) {
        super(transitionId, elementLocations, 15);
        this.setName(name);
        this.setComment(comment);
        this.fpnExtension.createNewFunctionsVector();
        this.setType(PetriNetElement.PetriNetElementType.TRANSITION);
        this.transType = TransitionType.PN;
        this.spnExtension.stochasticType = TransitionSPNExtension.StochaticsType.NONE;
    }

    public Transition(int transitionId, ArrayList<ElementLocation> elementLocations) {
        super(transitionId, elementLocations, 15);
        this.setName("Transition" + IdGenerator.getNextTransitionId());
        this.fpnExtension.createNewFunctionsVector();
        this.setType(PetriNetElement.PetriNetElementType.TRANSITION);
        this.transType = TransitionType.PN;
        this.spnExtension.stochasticType = TransitionSPNExtension.StochaticsType.NONE;
    }

    public Transition(int transitionId, int sheetId, Point transitionPosition) {
        super(sheetId, transitionId, transitionPosition, 15);
        this.setName("Transition" + IdGenerator.getNextTransitionId());
        this.fpnExtension.createNewFunctionsVector();
        this.setType(PetriNetElement.PetriNetElementType.TRANSITION);
        this.transType = TransitionType.PN;
        this.spnExtension.stochasticType = TransitionSPNExtension.StochaticsType.NONE;
    }

    public Transition(String error) {
        super(99, IdGenerator.getNextTransitionId(), new Point(0, 0), 15);
        this.setName("Transition" + IdGenerator.getNextTransitionId());
        this.fpnExtension.createNewFunctionsVector();
        this.setType(PetriNetElement.PetriNetElementType.TRANSITION);
        this.transType = TransitionType.PN;
        this.spnExtension.stochasticType = TransitionSPNExtension.StochaticsType.NONE;
        this.setName(error);
    }

    @Override
    public void draw(Graphics2D g, int sheetId, ElementDrawSettings eds) {
        ElementDraw.drawElement(this, g, sheetId, eds);
    }

    public ArrayList<Place> getPrePlaces() {
        ArrayList<Place> prePlaces = new ArrayList<Place>();
        for (ElementLocation el : this.getElementLocations()) {
            for (Arc arc : el.getInArcs()) {
                Node n = arc.getStartNode();
                if (prePlaces.contains((Place)n)) continue;
                prePlaces.add((Place)n);
            }
        }
        return prePlaces;
    }

    public ArrayList<Place> getPostPlaces() {
        ArrayList<Place> postPlaces = new ArrayList<Place>();
        for (ElementLocation el : this.getElementLocations()) {
            for (Arc arc : el.getOutArcs()) {
                Node n = arc.getEndNode();
                if (postPlaces.contains((Place)n)) continue;
                postPlaces.add((Place)n);
            }
        }
        return postPlaces;
    }

    public int getAvailableTokens() {
        int availableTokens = 0;
        for (Arc arc : this.getInArcs()) {
            Place origin = (Place)arc.getStartNode();
            availableTokens += origin.getTokensNumber();
        }
        return availableTokens;
    }

    public int getRequiredTokens() {
        int requiredTokens = 0;
        for (Arc arc : this.getInArcs()) {
            requiredTokens += arc.getWeight();
        }
        return requiredTokens;
    }

    public void setFrame(boolean is) {
        this.borderFrame = is;
    }

    public void setLaunching(boolean isLaunching) {
        this.isLaunching = isLaunching;
    }

    public boolean isLaunching() {
        return this.isLaunching;
    }

    public void setKnockout(boolean status) {
        this.knockoutStatus = status;
    }

    public boolean isKnockedOut() {
        return this.knockoutStatus;
    }

    public boolean isActive() {
        if (this.knockoutStatus) {
            return false;
        }
        if (this.timeExtension.isDPN() && this.timeExtension.getDPNtimer() == this.timeExtension.getDPNduration()) {
            return true;
        }
        for (Arc arc : this.getInArcs()) {
            boolean status;
            Place arcStartPlace = (Place)arc.getStartNode();
            Arc.TypeOfArc arcType = arc.getArcType();
            int startPlaceTokens = arcStartPlace.getNonReservedTokensNumber();
            if (arcType == Arc.TypeOfArc.INHIBITOR) {
                if (startPlaceTokens < arc.getWeight()) continue;
                return false;
            }
            if (arcType == Arc.TypeOfArc.EQUAL && startPlaceTokens != arc.getWeight()) {
                return false;
            }
            if (!(this.fpnExtension.isFunctional() ? !(status = FunctionsTools.getFunctionDecision(startPlaceTokens, arc, arc.getWeight(), this)) : startPlaceTokens < arc.getWeight())) continue;
            return false;
        }
        return true;
    }

    public void bookRequiredTokens() {
        for (Arc arc : this.getInArcs()) {
            Place origin = (Place)arc.getStartNode();
            if (arc.getArcType() == Arc.TypeOfArc.INHIBITOR) {
                origin.reserveTokens(0);
                continue;
            }
            if (arc.getArcType() == Arc.TypeOfArc.EQUAL) {
                origin.reserveTokens(arc.getWeight());
                continue;
            }
            if (arc.getArcType() == Arc.TypeOfArc.RESET) {
                int freeToken = origin.getNonReservedTokensNumber();
                origin.reserveTokens(freeToken);
                continue;
            }
            if (arc.getArcType() == Arc.TypeOfArc.COLOR) {
                try {
                    ((PlaceColored)origin).reserveColorTokens(arc.getColorWeight(0), 0);
                    ((PlaceColored)origin).reserveColorTokens(arc.getColorWeight(1), 1);
                    ((PlaceColored)origin).reserveColorTokens(arc.getColorWeight(2), 2);
                    ((PlaceColored)origin).reserveColorTokens(arc.getColorWeight(3), 3);
                    ((PlaceColored)origin).reserveColorTokens(arc.getColorWeight(4), 4);
                    ((PlaceColored)origin).reserveColorTokens(arc.getColorWeight(5), 5);
                }
                catch (Exception ex) {
                    GUIManager.getDefaultGUIManager().log("Transition.bookRequiredTokens() error while booking colored tokens", "error", true);
                }
                continue;
            }
            if (arc.getArcType() == Arc.TypeOfArc.READARC) {
                if (GUIManager.getDefaultGUIManager().getSettingsManager().getValue("simTransReadArcTokenReserv").equals("0")) continue;
                origin.reserveTokens(arc.getWeight());
                continue;
            }
            if (this.fpnExtension.isFunctional()) {
                FunctionContainer fc = this.fpnExtension.getFunctionContainer(arc);
                if (fc != null) {
                    origin.reserveTokens((int)fc.currentValue);
                    continue;
                }
                origin.reserveTokens(arc.getWeight());
                continue;
            }
            origin.reserveTokens(arc.getWeight());
        }
    }

    public void returnBookedTokens() {
        for (Arc arc : this.getInArcs()) {
            ((Place)arc.getStartNode()).freeReservedTokens();
        }
    }

    @Override
    public PetriNetElement.PetriNetElementType getType() {
        return PetriNetElement.PetriNetElementType.TRANSITION;
    }

    public int getOutArcWeightTo(Place outPlace) {
        int weight = 0;
        for (Arc currentArc : this.getOutArcs()) {
            if (!currentArc.getEndNode().equals(outPlace)) continue;
            weight = currentArc.getWeight();
        }
        return weight;
    }

    public int getInArcWeightFrom(Place inPlace) {
        int weight = 0;
        for (Arc currentArc : this.getInArcs()) {
            if (!currentArc.getStartNode().equals(inPlace)) continue;
            weight = currentArc.getWeight();
        }
        return weight;
    }

    public TransitionType getTransType() {
        return this.transType;
    }

    public void setTransType(TransitionType value) {
        this.transType = value;
    }

    @Override
    public String toString() {
        String name = this.getName();
        if (name == null) {
            return "(T)null";
        }
        return "(T" + GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions().indexOf(this) + ")";
    }

    public boolean isColored() {
        return this.transType == TransitionType.CPN;
    }

    public static enum TransitionType {
        PN,
        TPN,
        SPN,
        XTPN,
        CPN;

    }
}

