/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.elements;

import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Place;
import holmes.petrinet.simulators.IRandomGenerator;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class PlaceXTPN
extends Place {
    private double gammaMin_xTPN = 0.0;
    private double gammaMax_xTPN = 99.0;
    private boolean gammaMode_xTPN = true;
    private boolean showTokenSet_xTPN = false;
    public boolean showQSimXTPN = false;
    private boolean gammaRangeVisibility_XTPN = true;
    private int franctionDigits = 2;
    private ArrayList<Double> multisetK = new ArrayList();

    public PlaceXTPN(int nodeId, int sheetId, Point placePosition) {
        super(nodeId, sheetId, placePosition);
        this.placeType = Place.PlaceType.XTPN;
    }

    public PlaceXTPN(int nodeId, ArrayList<ElementLocation> elementLocations, String name, String comment, int tokensNumber) {
        super(nodeId, elementLocations, name, comment, tokensNumber);
        this.placeType = Place.PlaceType.XTPN;
    }

    public PlaceXTPN(int nodeId, ArrayList<ElementLocation> elementLocations) {
        super(nodeId, elementLocations);
        this.placeType = Place.PlaceType.XTPN;
    }

    public void setGammaMinValue(double value, boolean force) {
        if (force) {
            this.gammaMin_xTPN = value;
            return;
        }
        if (value < 0.0) {
            this.gammaMin_xTPN = 0.0;
            return;
        }
        if (value > this.gammaMax_xTPN) {
            this.gammaMin_xTPN = this.gammaMax_xTPN;
            return;
        }
        this.gammaMin_xTPN = value;
    }

    public double getGammaMinValue() {
        return this.gammaMin_xTPN;
    }

    public void setGammaMaxValue(double value, boolean force) {
        if (value > 2.147483647E9) {
            value = 2.147483646E9;
        }
        if (force) {
            this.gammaMax_xTPN = value;
            return;
        }
        if (value < 0.0) {
            this.gammaMax_xTPN = -1.0;
            return;
        }
        if (value < this.gammaMin_xTPN) {
            this.gammaMax_xTPN = this.gammaMin_xTPN;
            return;
        }
        this.gammaMax_xTPN = value;
    }

    public double getGammaMaxValue() {
        return this.gammaMax_xTPN;
    }

    public void setGammaModeStatus(boolean status) {
        this.gammaMode_xTPN = status;
        if (!status) {
            this.setGammaRangeVisibility(status);
        }
    }

    public boolean isGammaModeActive() {
        return this.gammaMode_xTPN;
    }

    public void setGammaRangeVisibility(boolean status) {
        this.gammaRangeVisibility_XTPN = status;
    }

    public boolean isGammaRangeVisible() {
        return this.gammaRangeVisibility_XTPN;
    }

    public void setFractionForPlaceXTPN(int value) {
        this.franctionDigits = value;
    }

    public int getFractionForPlaceXTPN() {
        return this.franctionDigits;
    }

    public void addTokens_XTPN(int howMany, double initialTime) {
        if (this.isGammaModeActive()) {
            for (int i = 0; i < howMany; ++i) {
                this.multisetK.add(initialTime);
            }
            if (initialTime > 0.0) {
                Collections.sort(this.multisetK);
                Collections.reverse(this.multisetK);
            }
        }
        this.modifyTokensNumber(howMany);
    }

    public int removeOldTokens_XTPN() {
        int removed = 0;
        if (this.isGammaModeActive()) {
            Iterator<Double> iterator = this.multisetK.iterator();
            while (iterator.hasNext()) {
                Double kappa = iterator.next();
                if (kappa >= this.gammaMax_xTPN) {
                    iterator.remove();
                    ++removed;
                    continue;
                }
                if (!(Math.abs(this.gammaMax_xTPN - kappa) < GUIManager.getDefaultGUIManager().simSettings.getCalculationsAccuracy())) break;
                iterator.remove();
                ++removed;
            }
        }
        this.modifyTokensNumber(-removed);
        return removed;
    }

    public ArrayList<Double> removeTokensForProduction_XTPN(int howMany, int mode, IRandomGenerator generator) {
        ArrayList<Double> removedTokens = new ArrayList<Double>();
        if (!this.isGammaModeActive()) {
            this.modifyTokensNumber(-howMany);
            return removedTokens;
        }
        int counter = howMany;
        if (howMany > this.multisetK.size()) {
            GUIManager.getDefaultGUIManager().log("Error, trying to remove more tokens (" + howMany + ") than\nthe multiset size (" + this.multisetK.size() + ")", "error", true);
            removedTokens.addAll(this.multisetK);
            this.multisetK.clear();
            return removedTokens;
        }
        if (mode == 0) {
            double oldOne = Double.MAX_VALUE;
            Iterator<Double> iterator = this.multisetK.iterator();
            while (iterator.hasNext()) {
                Double kappa = iterator.next();
                removedTokens.add(kappa);
                iterator.remove();
                --counter;
                assert (oldOne >= kappa);
                oldOne = kappa;
                if (counter != 0) continue;
                break;
            }
        } else if (mode == 1) {
            Collections.reverse(this.multisetK);
            double oldOne = -1.0;
            Iterator<Double> iterator = this.multisetK.iterator();
            while (iterator.hasNext()) {
                Double kappa = iterator.next();
                removedTokens.add(kappa);
                iterator.remove();
                --counter;
                assert (oldOne <= kappa);
                oldOne = kappa;
                if (counter != 0) continue;
                break;
            }
            Collections.reverse(this.multisetK);
        } else {
            for (int i = 0; i < howMany; ++i) {
                int index = generator.nextInt(this.multisetK.size());
                removedTokens.add(this.multisetK.get(index));
                this.multisetK.remove(index);
            }
        }
        this.modifyTokensNumber(-howMany);
        return removedTokens;
    }

    public void incTokensTime_XTPN(double tau) {
        if (this.isGammaModeActive()) {
            this.multisetK.replaceAll(aDouble -> aDouble + tau);
        } else {
            JOptionPane.showMessageDialog(null, "Critical error - tokens time update when XTPN status OFF\nfor place" + this.getName(), "Error 587654", 0);
        }
    }

    public void updateToken_XTPN(int ID, Double value) {
        if (ID > -1 && ID < this.multisetK.size()) {
            this.multisetK.set(ID, value);
        }
        Collections.sort(this.multisetK);
        Collections.reverse(this.multisetK);
    }

    public void removeTokenByID_XTPN(int index) {
        if (index > -1 && index < this.multisetK.size()) {
            this.multisetK.remove(index);
        }
        this.modifyTokensNumber(-1);
    }

    public ArrayList<Double> accessMultiset() {
        return this.multisetK;
    }

    public void replaceMultiset(ArrayList<Double> newMultiset) {
        this.multisetK = newMultiset;
    }

    public void transformXTPNintoPNpace() {
        this.setGammaModeStatus(false);
        this.multisetK.clear();
    }

    public void transformIntoXTPNplace() {
        this.setGammaModeStatus(true);
        for (int i = 0; i < this.tokensNumber; ++i) {
            this.multisetK.add(0.0);
        }
    }
}

