/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.elements;

import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Place;
import java.awt.Point;
import java.util.ArrayList;

public class PlaceColored
extends Place {
    public int token1green = 0;
    public int token2blue = 0;
    public int token3yellow = 0;
    public int token4grey = 0;
    public int token5black = 0;
    public int reserved1green = 0;
    public int reserved2blue = 0;
    public int reserved3yellow = 0;
    public int reserved4grey = 0;
    public int reserved5black = 0;

    public PlaceColored(int nodeId, int sheetId, Point placePosition) {
        super(nodeId, sheetId, placePosition);
        this.isColored = true;
        this.setPlaceType(Place.PlaceType.CPN);
    }

    public PlaceColored(int nodeId, ArrayList<ElementLocation> elementLocations, String name, String comment, int tokensNumber) {
        super(nodeId, elementLocations, name, comment, tokensNumber);
        this.isColored = true;
        this.setPlaceType(Place.PlaceType.CPN);
    }

    public PlaceColored(int nodeId, ArrayList<ElementLocation> elementLocations) {
        super(nodeId, elementLocations);
        this.isColored = true;
        this.setPlaceType(Place.PlaceType.CPN);
    }

    public int getColorTokensNumber(int i) {
        return switch (i) {
            case 1 -> this.token1green;
            case 2 -> this.token2blue;
            case 3 -> this.token3yellow;
            case 4 -> this.token4grey;
            case 5 -> this.token5black;
            default -> this.tokensNumber;
        };
    }

    public void setColorTokensNumber(int tokensNumber, int i) {
        switch (i) {
            case 1: {
                this.token1green = Math.max(tokensNumber, 0);
                break;
            }
            case 2: {
                this.token2blue = Math.max(tokensNumber, 0);
                break;
            }
            case 3: {
                this.token3yellow = Math.max(tokensNumber, 0);
                break;
            }
            case 4: {
                this.token4grey = Math.max(tokensNumber, 0);
                break;
            }
            case 5: {
                this.token5black = Math.max(tokensNumber, 0);
                break;
            }
            default: {
                this.tokensNumber = Math.max(tokensNumber, 0);
            }
        }
    }

    public void modifyColorTokensNumber(int delta, int i) {
        switch (i) {
            case 1: {
                this.token1green += delta;
                if (this.tokensNumber >= 0) break;
                this.token1green = 0;
                break;
            }
            case 2: {
                this.token2blue += delta;
                if (this.tokensNumber >= 0) break;
                this.token2blue = 0;
                break;
            }
            case 3: {
                this.token3yellow += delta;
                if (this.tokensNumber >= 0) break;
                this.token3yellow = 0;
                break;
            }
            case 4: {
                this.token4grey += delta;
                if (this.tokensNumber >= 0) break;
                this.token4grey = 0;
                break;
            }
            case 5: {
                this.token5black += delta;
                if (this.tokensNumber >= 0) break;
                this.token5black = 0;
                break;
            }
            default: {
                this.tokensNumber += delta;
                if (this.tokensNumber >= 0) break;
                this.tokensNumber = 0;
            }
        }
    }

    public int getReservedColorTokens(int i) {
        return switch (i) {
            case 1 -> this.reserved1green;
            case 2 -> this.reserved2blue;
            case 3 -> this.reserved3yellow;
            case 4 -> this.reserved4grey;
            case 5 -> this.reserved5black;
            default -> this.reservedTokens;
        };
    }

    public void reserveColorTokens(int tokensTaken, int i) {
        switch (i) {
            case 1: {
                this.reserved1green += tokensTaken;
                break;
            }
            case 2: {
                this.reserved2blue += tokensTaken;
                break;
            }
            case 3: {
                this.reserved3yellow += tokensTaken;
                break;
            }
            case 4: {
                this.reserved4grey += tokensTaken;
                break;
            }
            case 5: {
                this.reserved5black += tokensTaken;
                break;
            }
            default: {
                this.reservedTokens += tokensTaken;
            }
        }
    }

    @Override
    public void freeReservedTokens() {
        this.reservedTokens = 0;
        this.reserved1green = 0;
        this.reserved2blue = 0;
        this.reserved3yellow = 0;
        this.reserved4grey = 0;
        this.reserved5black = 0;
    }

    public void freeReservedColorTokens(int i) {
        switch (i) {
            case 1: {
                this.reserved1green = 0;
                break;
            }
            case 2: {
                this.reserved2blue = 0;
                break;
            }
            case 3: {
                this.reserved3yellow = 0;
                break;
            }
            case 4: {
                this.reserved4grey = 0;
                break;
            }
            case 5: {
                this.reserved5black = 0;
                break;
            }
            default: {
                this.reservedTokens = 0;
            }
        }
    }

    public int getNonReservedColorTokensNumber(int i) {
        return switch (i) {
            case 0 -> this.tokensNumber - this.getReservedColorTokens(0);
            case 1 -> this.token1green - this.getReservedColorTokens(1);
            case 2 -> this.token2blue - this.getReservedColorTokens(2);
            case 3 -> this.token3yellow - this.getReservedColorTokens(3);
            case 4 -> this.token4grey - this.getReservedColorTokens(4);
            case 5 -> this.token5black - this.getReservedColorTokens(5);
            default -> this.tokensNumber - this.getReservedTokens();
        };
    }
}

