/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.elements;

import holmes.darkgui.GUIManager;
import holmes.graphpanel.ElementDraw;
import holmes.graphpanel.ElementDrawSettings;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;

public class MetaNode
extends Node {
    private static final long serialVersionUID = -1463839771476569949L;
    private MetaType metaType;
    private int metaSheetID;

    public MetaNode(int sheetId, int nodeId, Point nodePosition, MetaType mt) {
        super(sheetId, nodeId, nodePosition, 15);
        this.setType(PetriNetElement.PetriNetElementType.META);
        this.setMetaType(mt);
    }

    public void setMetaType(MetaType mt) {
        this.metaType = mt;
    }

    public MetaType getMetaType() {
        return this.metaType;
    }

    public void setRepresentedSheetID(int sheetID) {
        this.metaSheetID = sheetID;
    }

    public ElementLocation getFirstELoc() {
        return this.getElementLocations().get(0);
    }

    public int getRepresentedSheetID() {
        return this.metaSheetID;
    }

    public int getMySheetID() {
        return this.getElementLocations().get(0).getSheetID();
    }

    @Override
    public void draw(Graphics2D g, int sheetId, ElementDrawSettings eds) {
        ElementDraw.drawElement(this, g, sheetId, eds);
    }

    public void removeAllInConnectionsWith(Node node) {
        ArrayList<Arc> metaIns = this.getFirstELoc().accessMetaInArcs();
        int size = metaIns.size();
        for (int i = 0; i < size; ++i) {
            if (!metaIns.get(i).getStartNode().equals(node)) continue;
            Arc arc = metaIns.get(i);
            metaIns.remove(arc);
            arc.getStartLocation().accessMetaOutArcs().remove(arc);
            GUIManager.getDefaultGUIManager().getWorkspace().getProject().getArcs().remove(arc);
            --i;
            --size;
        }
    }

    public void removeAllOutConnectionsWith(Node node) {
        ArrayList<Arc> metaOuts = this.getFirstELoc().accessMetaOutArcs();
        int size = metaOuts.size();
        for (int i = 0; i < size; ++i) {
            if (!metaOuts.get(i).getEndNode().equals(node)) continue;
            Arc arc = metaOuts.get(i);
            metaOuts.remove(arc);
            arc.getEndLocation().accessMetaInArcs().remove(arc);
            GUIManager.getDefaultGUIManager().getWorkspace().getProject().getArcs().remove(arc);
            --i;
            --size;
        }
    }

    @Override
    public String toString() {
        String name = this.getName();
        Object text = "";
        String type = "";
        if (this.getMetaType() == MetaType.SUBNETPLACE) {
            type = "P-type";
        } else if (this.getMetaType() == MetaType.SUBNETTRANS) {
            type = "T-type";
        } else if (this.getMetaType() == MetaType.SUBNET) {
            type = "P/T-type";
        }
        text = (String)text + "MetaN [sub:" + this.getRepresentedSheetID() + ", ";
        text = (String)text + type + "]  ";
        if (name == null) {
            return "(Meta) -- ";
        }
        text = (String)text + "(M" + GUIManager.getDefaultGUIManager().getWorkspace().getProject().getMetaNodes().indexOf(this) + ")";
        return text;
    }

    public static enum MetaType {
        SUBNETTRANS,
        SUBNETPLACE,
        SUBNET,
        UNKNOWN;

    }
}

