/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.elements;

import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.workspace.Workspace;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;

public class ElementLocation
implements Serializable {
    private static final long serialVersionUID = 2775375770782696276L;
    private int sheetId;
    private Point position;
    private Point notSnappedPosition;
    private Node parentNode;
    private boolean isSelected = false;
    private boolean isPortalSelected = false;
    private ArrayList<Arc> inArcs = new ArrayList();
    private ArrayList<Arc> outArcs = new ArrayList();
    private ArrayList<Arc> metaInArcs = new ArrayList();
    private ArrayList<Arc> metaOutArcs = new ArrayList();
    public boolean qSimArcSign = false;
    public boolean qSimDrawed = false;

    public ElementLocation(int sheetId, Point position, Node parentNode) {
        this.position = position;
        this.notSnappedPosition = position;
        this.sheetId = sheetId;
        this.parentNode = parentNode;
    }

    public int getSheetID() {
        return this.sheetId;
    }

    public void setSheetID(int sheetId) {
        this.sheetId = sheetId;
    }

    public Point getPosition() {
        return this.position;
    }

    public void setPosition(Point position) {
        Workspace workspace = GUIManager.getDefaultGUIManager().getWorkspace();
        int sheetIndex = workspace.getIndexOfId(this.sheetId);
        if (workspace.getSheets().get(sheetIndex).getGraphPanel().isLegalLocation(position)) {
            this.position = position;
        }
    }

    public void forceSetPosition(Point position) {
        this.position = position;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(Node parentNode) {
        this.parentNode = parentNode;
    }

    public void updateLocation(Point delta) {
        Point tempPosition = new Point(this.position.x + delta.x, this.position.y + delta.y);
        Workspace workspace = GUIManager.getDefaultGUIManager().getWorkspace();
        int sheetIndex = workspace.getIndexOfId(this.sheetId);
        if (workspace.getSheets().get(sheetIndex).getGraphPanel().isLegalLocation(tempPosition)) {
            this.position = tempPosition;
        }
    }

    public void setNotSnappedPosition(Point p) {
        this.notSnappedPosition = p;
    }

    public void updateLocationWithMeshSnap(Point delta, int meshSize) {
        Point notSnPos = this.notSnappedPosition;
        this.notSnappedPosition.setLocation(notSnPos.x + delta.x, notSnPos.y + delta.y);
        Point tempPosition = new Point((this.notSnappedPosition.x + delta.x) / meshSize * meshSize, (this.notSnappedPosition.y + delta.y) / meshSize * meshSize);
        Workspace workspace = GUIManager.getDefaultGUIManager().getWorkspace();
        int sheetIndex = workspace.getIndexOfId(this.sheetId);
        if (workspace.getSheets().get(sheetIndex).getGraphPanel().isLegalLocation(tempPosition)) {
            this.position = tempPosition;
        }
    }

    public ArrayList<Arc> getOutArcs() {
        return this.outArcs;
    }

    public void setOutArcs(ArrayList<Arc> outArcs) {
        this.outArcs = outArcs;
    }

    public ArrayList<Arc> getInArcs() {
        return this.inArcs;
    }

    public void setInArcs(ArrayList<Arc> inArcs) {
        this.inArcs = inArcs;
    }

    public void addInArc(Arc a) {
        this.inArcs.add(a);
    }

    public void removeInArc(Arc a) {
        this.inArcs.remove(a);
    }

    public void addOutArc(Arc a) {
        this.outArcs.add(a);
    }

    public void removeOutArc(Arc a) {
        this.outArcs.remove(a);
    }

    public ArrayList<Arc> accessMetaInArcs() {
        return this.metaInArcs;
    }

    public ArrayList<Arc> accessMetaOutArcs() {
        return this.metaOutArcs;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
        this.setPortalSelected(false);
        if (this.getParentNode().checkAllPortalsSelection()) {
            this.getParentNode().selectAllPortals();
        } else {
            this.getParentNode().deselectAllPortals();
        }
    }

    public boolean isPortalSelected() {
        return this.isPortalSelected;
    }

    public void setPortalSelected(boolean isPortalSelected) {
        this.isPortalSelected = isPortalSelected;
    }

    public String toString() {
        String s;
        if (this.getParentNode() == null) {
            s = "ParentNode: nullSheetID:" + this.getSheetID() + "; Pos:" + this.pointPos(this.getPosition()) + "; inArcs: " + this.getInArcs().size() + "; outArcs: " + this.getOutArcs().size();
        } else {
            int index = this.getParentNode().getElementLocations().indexOf(this);
            s = "Node: " + this.getParentNode() + "(" + index + ") [gID:" + this.getParentNode().getID() + "];\n SheetID: " + this.getSheetID() + "; Pos:" + this.pointPos(this.getPosition()) + "; inArcs: " + this.getInArcs().size() + "; outArcs: " + this.getOutArcs().size() + "; mInArcs: " + this.accessMetaInArcs().size() + "; mOutArcs: " + this.accessMetaOutArcs().size();
        }
        return s;
    }

    private String pointPos(Point p) {
        if (p != null) {
            return "[" + p.x + "," + p.y + "]";
        }
        return "[null, null]";
    }
}

