/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.elements;

import holmes.darkgui.GUIManager;
import holmes.graphpanel.ElementDraw;
import holmes.graphpanel.ElementDrawSettings;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.containers.ArcColoredContainer;
import holmes.petrinet.elements.containers.ArcDecompContainer;
import holmes.petrinet.elements.containers.ArcQSimContainer;
import holmes.petrinet.elements.containers.ArcXTPNContainer;
import holmes.varia.NetworkTransformations;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Line2D;
import java.util.ArrayList;

public class Arc
extends PetriNetElement {
    private static final long serialVersionUID = 5365625190238686098L;
    private TypeOfArc arcType;
    private ElementLocation locationStart;
    private ElementLocation locationEnd = null;
    private Point tempEndPoint = null;
    private ArrayList<Point> breakPoints;
    private boolean selected = false;
    private boolean isCorrect = false;
    private int weight = 1;
    public boolean isTransportingTokens = false;
    private int graphicalSimulationSteps = 0;
    private boolean simulationForwardDirection = true;
    private Arc pairedArc;
    private boolean isMainArcOfPair = false;
    public ArcDecompContainer arcDecoBox = new ArcDecompContainer();
    public ArcXTPNContainer arcXTPNbox = new ArcXTPNContainer();
    private ArcColoredContainer arcColoredBox = new ArcColoredContainer();
    public ArcQSimContainer arcQSimBox = new ArcQSimContainer();

    public Arc(ElementLocation startPosition, ElementLocation endPosition, TypeOfArc type) {
        this(startPosition, type);
        this.setEndLocation(endPosition);
        this.setID(IdGenerator.getNextId());
        this.lookForArcPair();
    }

    public Arc(int arcId, ElementLocation startPosition, ElementLocation endPosition, TypeOfArc type) {
        this(startPosition, type);
        this.setEndLocation(endPosition);
        this.setID(arcId);
        this.lookForArcPair();
    }

    public Arc(ElementLocation startPosition, ElementLocation endPosition, String comment, int weight, TypeOfArc type) {
        this(startPosition, type);
        this.setID(IdGenerator.getNextId());
        this.setEndLocation(endPosition);
        this.checkIsCorect(endPosition);
        this.setComment(comment);
        this.setWeight(weight);
        this.lookForArcPair();
    }

    public Arc(ElementLocation startPosition, TypeOfArc type) {
        this.arcType = type;
        this.setStartLocation(startPosition);
        this.setEndPoint(startPosition.getPosition());
        this.setType(PetriNetElement.PetriNetElementType.ARC);
        this.breakPoints = new ArrayList();
    }

    private void lookForArcPair() {
        if (this.getArcType() == TypeOfArc.META_ARC) {
            return;
        }
        if (this.getArcType() != TypeOfArc.NORMAL) {
            if (this.getArcType() == TypeOfArc.READARC) {
                for (Arc a : this.getEndLocation().getOutArcs()) {
                    if (a.getEndLocation() != this.getStartLocation() || a.getArcType() != TypeOfArc.READARC) continue;
                    a.setMainArcOfPair(true);
                    a.setPairedArc(this);
                    this.setPairedArc(a);
                }
            }
            this.handleComplexArcGraphics(null);
            return;
        }
        ArrayList<Arc> candidates = this.getEndLocation().getOutArcs();
        for (Arc a : candidates) {
            if (a.getEndLocation() != this.getStartLocation()) continue;
            if (a.getArcType() != TypeOfArc.NORMAL) {
                this.handleComplexArcGraphics(a);
                continue;
            }
            a.setMainArcOfPair(true);
            a.setPairedArc(this);
            this.setPairedArc(a);
        }
    }

    private void handleComplexArcGraphics(Arc arc) {
        Point breakPoint;
        Point endP;
        Point startP;
        if (this.breakPoints.size() == 0) {
            startP = this.getStartLocation().getPosition();
            endP = this.getEndLocation().getPosition();
            breakPoint = new Point((startP.x + endP.x) / 2 + 15, (startP.y + endP.y) / 2 + 15);
            this.breakPoints.add(breakPoint);
        }
        if (arc == null) {
            return;
        }
        if (arc.breakPoints.size() == 0) {
            startP = arc.getStartLocation().getPosition();
            endP = arc.getEndLocation().getPosition();
            breakPoint = new Point((startP.x + endP.x) / 2 - 15, (startP.y + endP.y) / 2 - 15);
            arc.accessBreaks().add(breakPoint);
        }
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public int getColorWeight(int i) {
        return switch (i) {
            case 1 -> this.arcColoredBox.weight1green;
            case 2 -> this.arcColoredBox.weight2blue;
            case 3 -> this.arcColoredBox.weight3yellow;
            case 4 -> this.arcColoredBox.weight4grey;
            case 5 -> this.arcColoredBox.weight5black;
            default -> this.weight;
        };
    }

    public void setColorWeight(int w, int i) {
        switch (i) {
            case 1: {
                this.arcColoredBox.weight1green = w;
                break;
            }
            case 2: {
                this.arcColoredBox.weight2blue = w;
                break;
            }
            case 3: {
                this.arcColoredBox.weight3yellow = w;
                break;
            }
            case 4: {
                this.arcColoredBox.weight4grey = w;
                break;
            }
            case 5: {
                this.arcColoredBox.weight5black = w;
                break;
            }
            default: {
                this.weight = w;
            }
        }
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comm) {
        this.comment = comm;
        if (this.pairedArc != null && this.isMainArcOfPair) {
            this.pairedArc.setComment(comm);
        }
    }

    public Node getStartNode() {
        return this.locationStart.getParentNode();
    }

    public Node getEndNode() {
        if (this.locationEnd != null) {
            return this.locationEnd.getParentNode();
        }
        return null;
    }

    public int getLocationSheetId() {
        return this.locationStart.getSheetID();
    }

    public double getWidth() {
        Point A = this.getStartLocation().getPosition();
        Point B = this.getEndLocation().getPosition();
        return Math.hypot(A.x - B.x, A.y - B.y);
    }

    public void drawSimulationMovingToken(Graphics2D g, int sheetId) {
        ElementDraw.drawMovingToken(g, sheetId, this);
    }

    public void incrementSimulationStep() {
        if (!this.isTransportingTokens) {
            return;
        }
        int GRAPHICAL_STEPS_COUNTER = GUIManager.getDefaultGUIManager().simSettings.getArcGraphicDelay();
        ++this.graphicalSimulationSteps;
        if (this.getGraphicalSimulationSteps() > GRAPHICAL_STEPS_COUNTER) {
            this.setGraphicalSimulationSteps(0);
            this.setTransportingTokens(false);
        }
    }

    public void draw(Graphics2D g, int sheetId, int zoom, ElementDrawSettings eds) {
        ElementDraw.drawArc(this, g, sheetId, zoom, eds);
    }

    public boolean getIsCorect() {
        return this.isCorrect;
    }

    public boolean checkIsCorect(ElementLocation elementLocation) {
        this.isCorrect = elementLocation != null && elementLocation.getParentNode().getType() != this.getStartLocation().getParentNode().getType() && elementLocation != this.getStartLocation();
        return this.isCorrect;
    }

    public void setEndPoint(Point point) {
        this.tempEndPoint = point;
    }

    public Point getTempEndPoint() {
        return this.tempEndPoint;
    }

    public boolean getSelected() {
        return this.selected;
    }

    public boolean checkSelection() {
        if (this.locationEnd == null || this.locationStart == null) {
            return false;
        }
        this.setSelected(this.locationEnd.isSelected() && this.locationStart.isSelected());
        return this.getSelected();
    }

    public void setSelected(boolean select) {
        this.selected = select;
    }

    public boolean checkIntersection(Point P) {
        int breaks = this.breakPoints.size();
        if (breaks > 0) {
            Point start = this.getStartLocation().getPosition();
            Point b0 = this.breakPoints.get(0);
            if (Line2D.ptSegDist(start.x, start.y, b0.x, b0.y, P.x, P.y) <= 3.0) {
                return true;
            }
            for (int i = 1; i < breaks; ++i) {
                if (!(Line2D.ptSegDist(this.breakPoints.get((int)(i - 1)).x, this.breakPoints.get((int)(i - 1)).y, this.breakPoints.get((int)i).x, this.breakPoints.get((int)i).y, P.x, P.y) <= 3.0)) continue;
                return true;
            }
            Point bFinal = this.breakPoints.get(breaks - 1);
            Point end = this.getEndLocation().getPosition();
            return Line2D.ptSegDist(bFinal.x, bFinal.y, end.x, end.y, P.x, P.y) <= 3.0;
        }
        Point A = this.getStartLocation().getPosition();
        Point B = this.getEndLocation().getPosition();
        return Line2D.ptSegDist(A.x, A.y, B.x, B.y, P.x, P.y) <= 3.0;
    }

    public ElementLocation getStartLocation() {
        return this.locationStart;
    }

    private void setStartLocation(ElementLocation startLocation) {
        this.locationStart = startLocation;
        if (this.arcType == TypeOfArc.META_ARC) {
            this.locationStart.accessMetaOutArcs().add(this);
        } else {
            this.locationStart.addOutArc(this);
        }
    }

    public void modifyStartLocation(ElementLocation startLocation) {
        this.locationStart = startLocation;
    }

    private void setEndLocation(ElementLocation elementLocation) {
        if (elementLocation == null) {
            return;
        }
        this.locationEnd = elementLocation;
        if (this.arcType == TypeOfArc.META_ARC) {
            this.locationEnd.accessMetaInArcs().add(this);
        } else {
            this.locationEnd.addInArc(this);
        }
        this.tempEndPoint = null;
        this.isCorrect = true;
    }

    public void modifyEndLocation(ElementLocation elementLocation) {
        this.locationEnd = elementLocation;
    }

    public ElementLocation getEndLocation() {
        return this.locationEnd;
    }

    public void unlinkElementLocations() {
        if (this.arcType == TypeOfArc.META_ARC) {
            if (this.locationStart != null) {
                this.locationStart.accessMetaOutArcs().remove(this);
            }
            if (this.locationEnd != null) {
                this.locationEnd.accessMetaInArcs().remove(this);
            }
        } else {
            if (this.locationStart != null) {
                this.locationStart.removeOutArc(this);
            }
            if (this.locationEnd != null) {
                this.locationEnd.removeInArc(this);
            }
        }
    }

    public boolean isTransportingTokens() {
        return this.isTransportingTokens;
    }

    public void setTransportingTokens(boolean isTransportingTokens) {
        this.isTransportingTokens = isTransportingTokens;
        this.setGraphicalSimulationSteps(0);
        if (!isTransportingTokens) {
            if (this.isSimulationForwardDirection()) {
                if (this.getStartNode().getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                    ((Transition)this.getStartNode()).setLaunching(false);
                }
            } else if (this.getEndNode().getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                ((Transition)this.getEndNode()).setLaunching(false);
            }
        }
    }

    public int getGraphicalSimulationSteps() {
        return this.graphicalSimulationSteps;
    }

    private void setGraphicalSimulationSteps(int value) {
        this.graphicalSimulationSteps = value;
    }

    public boolean isSimulationForwardDirection() {
        return this.simulationForwardDirection;
    }

    public void setSimulationForwardDirection(boolean simulationForwardDirection) {
        this.simulationForwardDirection = simulationForwardDirection;
    }

    public Arc getPairedArc() {
        return this.pairedArc;
    }

    private void setPairedArc(Arc pairedArc) {
        if (this.getArcType() == TypeOfArc.META_ARC) {
            return;
        }
        this.pairedArc = pairedArc;
        this.arcType = TypeOfArc.READARC;
    }

    public boolean isMainArcOfPair() {
        return this.isMainArcOfPair;
    }

    private void setMainArcOfPair(boolean isMainArcOfPair) {
        this.isMainArcOfPair = isMainArcOfPair;
    }

    public TypeOfArc getArcType() {
        return this.arcType;
    }

    public void setArcType(TypeOfArc type) {
        this.arcType = type;
    }

    public ArrayList<Point> accessBreaks() {
        return this.breakPoints;
    }

    public void addBreakPoint(Point breakP) {
        this.breakPoints.add(breakP);
    }

    public void clearBreakPoints() {
        this.breakPoints.clear();
    }

    public void updateAllBreakPointsLocations(Point delta) {
        for (Point breakP : this.breakPoints) {
            breakP.setLocation(breakP.x + delta.x, breakP.y + delta.y);
        }
    }

    public void updateAllBreakPointsLocationsNetExtension(boolean magnify) {
        for (Point breakP : this.breakPoints) {
            double oldX = breakP.x;
            double oldY = breakP.y;
            if (magnify) {
                oldX *= 1.1;
                oldY *= 1.1;
            } else {
                oldX /= 1.1;
                oldY /= 1.1;
            }
            breakP.setLocation((int)oldX, (int)oldY);
        }
    }

    public void alignBreakPoints() {
        for (Point breakP : this.breakPoints) {
            breakP.setLocation(NetworkTransformations.alignToGrid(breakP));
        }
    }

    public Point checkBreakIntersection(Point mousePt) {
        for (Point breakP : this.breakPoints) {
            if (breakP.x - 5 >= mousePt.x || breakP.y - 5 >= mousePt.y || breakP.x + 5 <= mousePt.x || breakP.y + 5 <= mousePt.y) continue;
            return breakP;
        }
        return null;
    }

    public void createNewBreakPoint(Point breakP) {
        Point start = this.getStartLocation().getPosition();
        int breaks = this.breakPoints.size();
        if (breaks == 0) {
            this.addBreakPoint(breakP);
        } else {
            int whereToInsert = 0;
            Point b0 = this.breakPoints.get(0);
            if (Line2D.ptSegDist(start.x, start.y, b0.x, b0.y, breakP.x, breakP.y) <= 3.0) {
                this.breakPoints.add(whereToInsert, breakP);
                return;
            }
            for (int i = 1; i < breaks; ++i) {
                ++whereToInsert;
                if (!(Line2D.ptSegDist(this.breakPoints.get((int)(i - 1)).x, this.breakPoints.get((int)(i - 1)).y, this.breakPoints.get((int)i).x, this.breakPoints.get((int)i).y, breakP.x, breakP.y) <= 3.0)) continue;
                this.breakPoints.add(whereToInsert, breakP);
                return;
            }
            this.breakPoints.add(breakP);
        }
    }

    public void removeBreakPoint(Point breakP) {
        Point toRemove = this.checkBreakIntersection(breakP);
        if (toRemove != null) {
            this.breakPoints.remove(toRemove);
        }
    }

    public String toString() {
        Node node;
        Node node2;
        PetriNet pn = GUIManager.getDefaultGUIManager().getWorkspace().getProject();
        String startNode = "";
        int startNodeLoc = -1;
        int startELLoc = -1;
        int startNodeID = -1;
        if (this.getStartLocation() != null && (node2 = this.getStartLocation().getParentNode()) != null) {
            if (node2 instanceof Place) {
                startNode = "P";
                startNodeLoc = pn.getPlaces().indexOf(node2);
            } else if (node2 instanceof Transition) {
                startNode = "T";
                startNodeLoc = pn.getTransitions().indexOf(node2);
            } else if (node2 instanceof MetaNode) {
                startNode = "M";
                startNodeLoc = pn.getMetaNodes().indexOf(node2);
            }
            startELLoc = node2.getElementLocations().indexOf(this.getStartLocation());
            startNodeID = node2.getID();
        }
        String endNode = "";
        int endNodeLoc = -1;
        int endELLoc = -1;
        int endNodeID = -1;
        if (this.getEndLocation() != null && (node = this.getEndLocation().getParentNode()) != null) {
            if (node instanceof Place) {
                endNode = "P";
                endNodeLoc = pn.getPlaces().indexOf(node);
            } else if (node instanceof Transition) {
                endNode = "T";
                endNodeLoc = pn.getTransitions().indexOf(node);
            } else if (node instanceof MetaNode) {
                endNode = "M";
                endNodeLoc = pn.getMetaNodes().indexOf(node);
            }
            endELLoc = node.getElementLocations().indexOf(this.getEndLocation());
            endNodeID = node.getID();
        }
        return " ArcType: " + this.arcType.toString() + " " + startNode + startNodeLoc + "(" + startELLoc + ") [gID:" + startNodeID + "]  ==>   " + endNode + endNodeLoc + "(" + endELLoc + ") [gID:" + endNodeID + "]";
    }

    public static enum TypeOfArc {
        NORMAL,
        READARC,
        INHIBITOR,
        RESET,
        EQUAL,
        META_ARC,
        COLOR;

    }
}

