/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.data;

import holmes.darkgui.GUIManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.data.SPNdataVector;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.extensions.TransitionSPNExtension;
import java.util.ArrayList;

public class SPNdataVectorManager {
    private GUIManager overlord = GUIManager.getDefaultGUIManager();
    private PetriNet pn;
    private ArrayList<SPNdataVector> SPNdataMatrix;
    public int selectedVector = 0;

    public SPNdataVectorManager(PetriNet net) {
        this.pn = net;
        this.SPNdataMatrix = new ArrayList();
        this.SPNdataMatrix.add(new SPNdataVector());
    }

    public void addTrans() {
        for (SPNdataVector frVector : this.SPNdataMatrix) {
            frVector.addTrans("1.0", TransitionSPNExtension.StochaticsType.ST);
        }
    }

    public boolean removeTrans(int index) {
        if (index >= this.SPNdataMatrix.get(0).getSize()) {
            return false;
        }
        for (SPNdataVector frVector : this.SPNdataMatrix) {
            boolean status = frVector.removeTrans(index);
            if (status) continue;
            this.overlord.log("Critical error: invalid transition index in SPN data matrix.", "error", true);
            return false;
        }
        return true;
    }

    public SPNdataVector getSPNdataVector(int index) {
        if (index >= this.SPNdataMatrix.size()) {
            return null;
        }
        return this.SPNdataMatrix.get(index);
    }

    public SPNdataVector getCurrentSPNdataVector() {
        return this.SPNdataMatrix.get(this.selectedVector);
    }

    public void addCurrentFRasSPNdataVector() {
        SPNdataVector frVector = new SPNdataVector();
        for (Transition trans : this.pn.getTransitions()) {
            frVector.addTrans("" + trans.spnExtension.getFiringRate(), trans.spnExtension.getSPNtype());
        }
        this.SPNdataMatrix.add(frVector);
    }

    public void createCleanSPNdataVector() {
        this.reset(false);
        int transNo = this.pn.getTransitions().size();
        for (int t = 0; t < transNo; ++t) {
            this.SPNdataMatrix.get(0).addTrans("1.0", TransitionSPNExtension.StochaticsType.ST);
        }
    }

    public void setNetworkSPNdataVector(int vectorID) {
        ArrayList<Transition> transitions = this.pn.getTransitions();
        SPNdataVector frVector = this.SPNdataMatrix.get(vectorID);
        for (int t = 0; t < transitions.size(); ++t) {
            Transition trans = transitions.get(t);
            trans.spnExtension.setSPNtype(frVector.getStochasticType(t));
            trans.spnExtension.setFiringRate(frVector.getFiringRate(t));
        }
        this.selectedVector = vectorID;
    }

    public void restoreSelectedSPNvector() {
        this.setNetworkSPNdataVector(this.selectedVector);
    }

    public void removeSPNvector(int vectorID) {
        this.SPNdataMatrix.remove(vectorID);
        this.selectedVector = 0;
    }

    public void replaceSPNvectorWithNetFRates(int vectorID) {
        ArrayList<Transition> transitions = this.pn.getTransitions();
        SPNdataVector frVector = this.SPNdataMatrix.get(vectorID);
        for (int t = 0; t < transitions.size(); ++t) {
            frVector.accessVector().get((int)t).ST_function = "" + transitions.get((int)t).spnExtension.getFiringRate();
            frVector.accessVector().get((int)t).sType = transitions.get((int)t).spnExtension.getSPNtype();
        }
    }

    public String getSPNvectorDescription(int selected) {
        return this.SPNdataMatrix.get(selected).getDescription();
    }

    public void setSPNvectorDescription(int selected, String newText) {
        this.SPNdataMatrix.get(selected).setDescription(newText);
    }

    public SPNdataVector.SPNvectorSuperType getSPNvectorType(int selected) {
        return this.SPNdataMatrix.get(selected).getSuperType();
    }

    public void setSPNvectorDescription(int selected, SPNdataVector.SPNvectorSuperType type) {
        this.SPNdataMatrix.get(selected).setSyperType(type);
    }

    public ArrayList<SPNdataVector> accessSPNmatrix() {
        return this.SPNdataMatrix;
    }

    public void reset(boolean isLoading) {
        if (isLoading) {
            this.SPNdataMatrix = new ArrayList();
        } else {
            this.SPNdataMatrix = new ArrayList();
            this.SPNdataMatrix.add(new SPNdataVector());
        }
        this.selectedVector = 0;
    }
}

