/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.data;

import holmes.analyse.MCTCalculator;
import holmes.darkgui.GUIController;
import holmes.darkgui.GUIManager;
import holmes.files.io.AbyssReader;
import holmes.files.io.AbyssWriter;
import holmes.files.io.IOprotocols;
import holmes.files.io.snoopy.NetHandler;
import holmes.files.io.snoopy.NetHandler_Classic;
import holmes.files.io.snoopy.NetHandler_Colored;
import holmes.files.io.snoopy.NetHandler_Extended;
import holmes.files.io.snoopy.NetHandler_Time;
import holmes.files.io.snoopy.SnoopyReader;
import holmes.files.io.snoopy.SnoopyWriter;
import holmes.graphpanel.GraphPanel;
import holmes.graphpanel.SelectionActionListener;
import holmes.petrinet.data.MCSDataMatrix;
import holmes.petrinet.data.NetSimulationDataCore;
import holmes.petrinet.data.P_StateManager;
import holmes.petrinet.data.PetriNetData;
import holmes.petrinet.data.PetriNetMethods;
import holmes.petrinet.data.SPNdataVectorManager;
import holmes.petrinet.data.SSAplacesManager;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceColored;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.petrinet.elements.extensions.TransitionSPNExtension;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.xtpn.GraphicalSimulatorXTPN;
import holmes.workspace.Workspace;
import holmes.workspace.WorkspaceSheet;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.simpleframework.xml.Root;
import org.xml.sax.helpers.DefaultHandler;

@Root
public class PetriNet
implements SelectionActionListener,
Cloneable {
    private ArrayList<SelectionActionListener> actionListeners = new ArrayList();
    private ArrayList<ArrayList<Integer>> t_invariantsMatrix;
    private ArrayList<String> t_invariantsDescriptions;
    private boolean t_invComputed;
    private ArrayList<Integer> t_invariantsTypes;
    private ArrayList<ArrayList<Integer>> p_invariantsMatrix;
    private ArrayList<String> p_invariantsDescriptions;
    private ArrayList<ArrayList<Integer>> colorVector = null;
    private ArrayList<ArrayList<Transition>> mctData;
    private ArrayList<Integer> transitionMCTnumber;
    private ArrayList<String> mctNames;
    private NetSimulationDataCore simData;
    private MCSDataMatrix mcsData;
    private P_StateManager statesManager;
    private SPNdataVectorManager firingRatesManager;
    private SSAplacesManager ssaManager;
    private ArrayList<String> subNetNames;
    private String lastFileName = "";
    private PetriNetData dataCore = new PetriNetData(new ArrayList<Node>(), new ArrayList<Arc>(), "default");
    private ArrayList<GraphPanel> graphPanels;
    private IOprotocols communicationProtocol;
    private NetHandler handler;
    private Workspace workspace;
    private GraphPanel.DrawModes drawMode = GraphPanel.DrawModes.POINTER;
    private GraphicalSimulator simulator;
    private GraphicalSimulatorXTPN simulatorXTPN;
    private MCTCalculator analyzer;
    private PetriNetMethods methods;
    private boolean isSimulationActive = false;
    public boolean anythingChanged = false;
    public GUIManager overlord;
    private GlobalNetType projectType = GlobalNetType.PN;
    private GlobalNetSubType projectSubType = GlobalNetSubType.CLEAN_XTPN;

    public PetriNet(ArrayList<Node> nod, ArrayList<Arc> ar) {
        this.overlord = GUIManager.getDefaultGUIManager();
        this.setProjectType(GlobalNetType.PN);
        this.getDataCore().nodes = nod;
        this.getDataCore().arcs = ar;
        this.communicationProtocol = new IOprotocols();
        this.dataCore.netName = "default";
        this.mcsData = new MCSDataMatrix();
        this.methods = new PetriNetMethods(this);
        this.simData = new NetSimulationDataCore();
        this.statesManager = new P_StateManager(this);
        this.ssaManager = new SSAplacesManager(this);
        this.t_invComputed = false;
    }

    public PetriNet(Workspace workspace, String name) {
        this.overlord = GUIManager.getDefaultGUIManager();
        this.setGraphPanels(new ArrayList<GraphPanel>());
        this.workspace = workspace;
        this.setSimulator(new GraphicalSimulator(SimulatorGlobals.SimNetType.BASIC, this));
        this.setSimulatorXTPN(new GraphicalSimulatorXTPN(SimulatorGlobals.SimNetType.XTPN, this));
        this.setMCTanalyzer(new MCTCalculator(this));
        this.statesManager = new P_StateManager(this);
        this.ssaManager = new SSAplacesManager(this);
        this.firingRatesManager = new SPNdataVectorManager(this);
        this.resetComm();
        this.dataCore.netName = name;
        this.mcsData = new MCSDataMatrix();
        this.methods = new PetriNetMethods(this);
        this.simData = new NetSimulationDataCore();
        this.t_invComputed = false;
    }

    public void resetComm() {
        this.communicationProtocol = new IOprotocols();
    }

    public void resetData() {
        this.overlord.log("Removing all nodes (places and transition) and all arcs.", "text", true);
        this.getDataCore().nodes.clear();
        this.getDataCore().arcs.clear();
        this.getDataCore().netName = "default";
    }

    public ArrayList<Place> getPlaces() {
        ArrayList<Place> returnPlaces = new ArrayList<Place>();
        for (Node n : this.dataCore.nodes) {
            if (!(n instanceof Place)) continue;
            returnPlaces.add((Place)n);
        }
        return returnPlaces;
    }

    public int getPlacesNumber() {
        int counter = 0;
        for (Node n : this.dataCore.nodes) {
            if (!(n instanceof Place)) continue;
            ++counter;
        }
        return counter;
    }

    public ArrayList<Transition> getTransitions() {
        ArrayList<Transition> returnTransitions = new ArrayList<Transition>();
        for (Node n : this.dataCore.nodes) {
            if (!(n instanceof Transition)) continue;
            returnTransitions.add((Transition)n);
        }
        return returnTransitions;
    }

    public ArrayList<Transition> getTimeTransitions() {
        ArrayList<Transition> returnTransitions = new ArrayList<Transition>();
        for (Node n : this.dataCore.nodes) {
            if (!(n instanceof Transition) || ((Transition)n).getTransType() != Transition.TransitionType.TPN) continue;
            returnTransitions.add((Transition)n);
        }
        return returnTransitions;
    }

    public ArrayList<ArrayList<Node>> getPNelements() {
        ArrayList<ArrayList<Node>> result = new ArrayList<ArrayList<Node>>();
        ArrayList<Node> places = new ArrayList<Node>();
        ArrayList<Node> transitions = new ArrayList<Node>();
        ArrayList<Node> timeTransitions = new ArrayList<Node>();
        ArrayList<Node> metaNodes = new ArrayList<Node>();
        for (Node n : this.dataCore.nodes) {
            if (n instanceof Place) {
                places.add(n);
                continue;
            }
            if (n instanceof Transition) {
                if (((Transition)n).getTransType() == Transition.TransitionType.TPN) {
                    timeTransitions.add(n);
                    continue;
                }
                transitions.add(n);
                continue;
            }
            if (!(n instanceof MetaNode)) continue;
            metaNodes.add(n);
        }
        result.add(places);
        result.add(transitions);
        result.add(timeTransitions);
        result.add(metaNodes);
        return result;
    }

    public ArrayList<MetaNode> getMetaNodes() {
        ArrayList<MetaNode> returnNodes = new ArrayList<MetaNode>();
        for (Node n : this.dataCore.nodes) {
            if (!(n instanceof MetaNode)) continue;
            returnNodes.add((MetaNode)n);
        }
        return returnNodes;
    }

    public void setNodes(ArrayList<Node> nodes) {
        this.getDataCore().nodes = nodes;
        for (GraphPanel gp : this.getGraphPanels()) {
            gp.setNodes(nodes);
        }
    }

    public void setName(String name) {
        this.getDataCore().netName = name;
    }

    public String getFileName() {
        return this.lastFileName;
    }

    public void setFileName(String newName) {
        this.lastFileName = newName;
    }

    public String getName() {
        return this.getDataCore().netName;
    }

    public ArrayList<Arc> getArcs() {
        return this.getDataCore().arcs;
    }

    private void addArcsAndNodes(ArrayList<Arc> arcs, ArrayList<Node> nodes) {
        this.getArcs().addAll(arcs);
        this.getNodes().addAll(nodes);
    }

    public void addArc(Arc a) {
        this.getArcs().add(a);
    }

    public void setArcs(ArrayList<Arc> arcs) {
        this.getDataCore().arcs = arcs;
        for (GraphPanel gp : this.getGraphPanels()) {
            gp.setArcs(this.getDataCore().arcs);
        }
    }

    public ArrayList<Node> getNodes() {
        return this.getDataCore().nodes;
    }

    public void setDrawMode(GraphPanel.DrawModes mode) {
        this.drawMode = mode;
        for (GraphPanel gp : this.getGraphPanels()) {
            gp.setDrawMode(mode);
        }
    }

    public GraphPanel.DrawModes getDrawMode() {
        return this.drawMode;
    }

    public NetHandler getHandler() {
        return this.handler;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void addActionListener(SelectionActionListener a) {
        this.actionListeners.add(a);
    }

    private void invokeActionListeners(SelectionActionListener.SelectionActionEvent e) {
        for (SelectionActionListener a : this.actionListeners) {
            a.actionPerformed(e);
        }
    }

    @Override
    public void actionPerformed(SelectionActionListener.SelectionActionEvent arg0) {
        this.invokeActionListeners(arg0);
    }

    public GraphicalSimulator getSimulator() {
        return this.simulator;
    }

    public void setSimulator(GraphicalSimulator simulator) {
        this.simulator = simulator;
    }

    public GraphicalSimulatorXTPN getSimulatorXTPN() {
        return this.simulatorXTPN;
    }

    public void setSimulatorXTPN(GraphicalSimulatorXTPN simulator) {
        this.simulatorXTPN = simulator;
    }

    public MCTCalculator getMCTanalyzer() {
        return this.analyzer;
    }

    public void setMCTanalyzer(MCTCalculator analyzer) {
        this.analyzer = analyzer;
    }

    public ArrayList<GraphPanel> getGraphPanels() {
        return this.graphPanels;
    }

    private void setGraphPanels(ArrayList<GraphPanel> graphPanels) {
        this.graphPanels = graphPanels;
    }

    public PetriNetData getDataCore() {
        return this.dataCore;
    }

    public void setData(PetriNetData data) {
        this.dataCore = data;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setT_InvMatrix(ArrayList<ArrayList<Integer>> t_invariants, boolean generateMCT) {
        this.t_invariantsMatrix = t_invariants;
        this.t_invariantsDescriptions = null;
        this.t_invariantsTypes = null;
        this.t_invComputed = false;
        if (t_invariants == null) {
            return;
        }
        this.t_invariantsDescriptions = new ArrayList();
        this.t_invariantsTypes = new ArrayList();
        for (int i = 0; i < this.t_invariantsMatrix.size(); ++i) {
            this.t_invariantsDescriptions.add("Default description of t-invariant #" + (i + 1));
            this.t_invariantsTypes.add(99999);
        }
        if (generateMCT) {
            MCTCalculator analyzer = this.getWorkspace().getProject().getMCTanalyzer();
            ArrayList<ArrayList<Transition>> mct = analyzer.generateMCT();
            this.getWorkspace().getProject().setMCTMatrix(mct, true);
            this.overlord.getMctBox().showMCT(mct);
        }
    }

    public void setP_InvMatrix(ArrayList<ArrayList<Integer>> p_invariants) {
        this.p_invariantsMatrix = p_invariants;
        this.p_invariantsDescriptions = null;
        if (p_invariants == null) {
            return;
        }
        this.p_invariantsDescriptions = new ArrayList();
        for (int i = 0; i < this.p_invariantsMatrix.size(); ++i) {
            this.p_invariantsDescriptions.add("Default description of p-invariant #" + (i + 1));
        }
    }

    public void setT_InvDescriptions(ArrayList<String> namesVector) {
        if (this.t_invariantsMatrix == null) {
            return;
        }
        if (namesVector.size() == this.t_invariantsMatrix.size()) {
            this.t_invariantsDescriptions = namesVector;
        }
    }

    public void setT_InvTypes(ArrayList<Integer> typesVector) {
        if (this.t_invariantsMatrix == null) {
            return;
        }
        if (typesVector.size() == this.t_invariantsMatrix.size()) {
            this.t_invariantsTypes = typesVector;
        }
    }

    public void setP_InvDescriptions(ArrayList<String> namesVector) {
        if (this.p_invariantsMatrix == null) {
            return;
        }
        if (namesVector.size() == this.p_invariantsMatrix.size()) {
            this.p_invariantsDescriptions = namesVector;
        }
    }

    public String getT_InvDescription(int index) {
        if (this.t_invariantsMatrix == null) {
            return "";
        }
        if (index < this.t_invariantsDescriptions.size() && index >= 0) {
            return this.t_invariantsDescriptions.get(index);
        }
        return "";
    }

    public String getP_InvDescription(int index) {
        if (this.p_invariantsMatrix == null) {
            return "";
        }
        if (index < this.p_invariantsDescriptions.size() && index >= 0) {
            return this.p_invariantsDescriptions.get(index);
        }
        return "";
    }

    public ArrayList<ArrayList<Integer>> getT_InvMatrix() {
        return this.t_invariantsMatrix;
    }

    public ArrayList<ArrayList<Integer>> getP_InvMatrix() {
        return this.p_invariantsMatrix;
    }

    public ArrayList<String> accessT_InvDescriptions() {
        return this.t_invariantsDescriptions;
    }

    public ArrayList<Integer> accessT_InvTypesVector() {
        return this.t_invariantsTypes;
    }

    public ArrayList<String> accessP_InvDescriptions() {
        return this.p_invariantsDescriptions;
    }

    public void setT_invTypesComputed(boolean status) {
        this.t_invComputed = status;
    }

    public boolean getT_invTypesComputed() {
        return this.t_invComputed;
    }

    public void setMCTMatrix(ArrayList<ArrayList<Transition>> mct, boolean sort) {
        this.mctData = mct;
        this.mctNames = new ArrayList();
        if (mct == null) {
            return;
        }
        if (sort) {
            mct = MCTCalculator.getSortedMCT(mct, true);
        }
        for (int m = 0; m < mct.size(); ++m) {
            this.mctNames.add("default name for mct" + (m + 1));
        }
        this.transitionMCTnumber = this.methods.getTransMCTindicesVector();
    }

    public ArrayList<Integer> getMCTtransIndicesVector() {
        return this.transitionMCTnumber;
    }

    public ArrayList<ArrayList<Transition>> getMCTMatrix() {
        return this.mctData;
    }

    public ArrayList<String> accessMCTnames() {
        return this.mctNames;
    }

    public void setMCTNames(ArrayList<String> namesVector) {
        if (this.mctData == null) {
            return;
        }
        if (namesVector.size() == this.mctData.size()) {
            this.mctNames = namesVector;
        }
    }

    public ArrayList<String> accessSubNetNames() {
        return this.subNetNames;
    }

    public String getMCTname(int index) {
        if (this.mctData == null) {
            return "";
        }
        if (index < this.mctNames.size() && index >= 0) {
            return this.mctNames.get(index);
        }
        return "";
    }

    public boolean isSheetEmpty(int sheetID) {
        boolean result = true;
        block0: for (Node node : this.getNodes()) {
            for (ElementLocation location : node.getNodeLocations()) {
                if (location.getSheetID() != sheetID) continue;
                result = false;
                continue block0;
            }
        }
        return result;
    }

    public void addGraphPanel(GraphPanel graphPanel) {
        graphPanel.setNodesAndArcs(this.getDataCore().nodes, this.getDataCore().arcs);
        this.getGraphPanels().add(graphPanel);
    }

    public GraphPanel createAndAddGraphPanel(int sheetId) {
        GraphPanel gp = new GraphPanel(sheetId, this, this.getDataCore().nodes, this.getDataCore().arcs);
        gp.setDrawMode(this.drawMode);
        this.getGraphPanels().add(gp);
        return gp;
    }

    public GraphPanel getGraphPanel(int sheetID) {
        for (GraphPanel gp : this.getGraphPanels()) {
            if (gp.getSheetId() != sheetID) continue;
            return gp;
        }
        return null;
    }

    public IOprotocols getCommunicator() {
        return this.communicationProtocol;
    }

    public MCSDataMatrix getMCSdataCore() {
        return this.mcsData;
    }

    public void setMCSdataCore(MCSDataMatrix newMCS) {
        this.mcsData = newMCS;
    }

    public NetSimulationDataCore accessSimKnockoutData() {
        return this.simData;
    }

    public void setNewKnockoutData(NetSimulationDataCore data) {
        this.simData = data;
    }

    public void clearSimKnockoutData() {
        this.simData = null;
        this.simData = new NetSimulationDataCore();
    }

    public P_StateManager accessStatesManager() {
        return this.statesManager;
    }

    public SSAplacesManager accessSSAmanager() {
        return this.ssaManager;
    }

    public void replaceStatesManager(P_StateManager newStatesMngr) {
        this.statesManager = newStatesMngr;
    }

    public SPNdataVectorManager accessFiringRatesManager() {
        return this.firingRatesManager;
    }

    public void replaceStatesManager(SPNdataVectorManager newStatesMngr) {
        this.firingRatesManager = newStatesMngr;
    }

    public void selectProperSimulatorBox(boolean XTPN) {
        int simulatorType = this.overlord.getSimulatorBox().getCurrentDockWindow().simulatorType;
        if (XTPN) {
            if (simulatorType == 0) {
                this.overlord.getSimulatorBox().getCurrentDockWindow().simMode.setSelectedIndex(4);
            }
        } else if (simulatorType == 1) {
            this.overlord.getSimulatorBox().getCurrentDockWindow().simMode.setSelectedIndex(0);
        }
    }

    public void restoreMarkingZero() {
        try {
            if (GUIController.access().getCurrentNetType() == GlobalNetType.XTPN) {
                this.restoreMarkingZeroXTPN();
                return;
            }
            this.accessStatesManager().setNetworkStatePN(this.accessStatesManager().selectedStatePN);
            for (Transition trans : this.getTransitions()) {
                trans.setLaunching(false);
                if (trans.getTransType() != Transition.TransitionType.TPN) continue;
                trans.timeExtension.resetTimeVariables();
            }
            SimulatorGlobals.SimNetType nt = this.overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimNetType();
            this.getSimulator().resetSimulator();
            this.overlord.simSettings.currentStep = this.getSimulator().getSimulatorTimeStep();
            this.overlord.getSimulatorBox().getCurrentDockWindow().timeStepLabelValue.setText("" + this.getSimulator().getSimulatorTimeStep());
            this.repaintAllGraphPanels();
            this.getSimulator().getSimLogger().logSimReset();
        }
        catch (Exception e) {
            this.overlord.log("Unknown error: unable to restore state m0 on request.", "error", true);
        }
    }

    public void restoreMarkingZeroXTPN() {
        try {
            this.accessStatesManager().replaceNetStateWithSelectedMultiset_M(this.accessStatesManager().selectedStateXTPN);
            for (Transition trans : this.getTransitions()) {
                if (!(trans instanceof TransitionXTPN)) {
                    this.overlord.log("Critical error (834528336), wrong place object.", "error", true);
                    return;
                }
                trans.setLaunching(false);
                ((TransitionXTPN)trans).resetTimeVariables_xTPN();
            }
            SimulatorGlobals.SimNetType nt = this.overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimNetType();
            this.getSimulatorXTPN().resetSimulator();
            this.overlord.io.updateTimeStep(true, this.getSimulatorXTPN().getStepsCounterXTPN(), this.getSimulatorXTPN().getTimeCounterXTPN(), 0.0);
            this.overlord.simSettings.currentStep = this.getSimulatorXTPN().getStepsCounterXTPN();
            this.overlord.simSettings.currentTime = this.getSimulatorXTPN().getTimeCounterXTPN();
            this.repaintAllGraphPanels();
            this.getSimulator().getSimLogger().logSimReset();
        }
        catch (Exception e) {
            this.overlord.log("Unknown error: unable to restore XTOM p-state m0 on request.", "error", true);
        }
    }

    public void restoreMarkingZeroFast(ArrayList<Transition> transitions) {
        try {
            if (this.checkIfXTPNpresent()) {
                this.accessStatesManager().replaceNetStateWithSelectedMultiset_M(this.accessStatesManager().selectedStateXTPN);
            } else {
                this.accessStatesManager().setNetworkStatePN(this.accessStatesManager().selectedStatePN);
            }
            for (Transition trans : transitions) {
                trans.setLaunching(false);
                if (trans.getTransType() == Transition.TransitionType.TPN) {
                    trans.timeExtension.resetTimeVariables();
                }
                if (!(trans instanceof TransitionXTPN)) continue;
                ((TransitionXTPN)trans).resetTimeVariables_xTPN();
            }
            this.getSimulator().getSimLogger().logSimReset();
        }
        catch (Exception e) {
            this.overlord.log("Unknown error: unable to restore state m0 on request.", "error", true);
        }
    }

    public void storeColors() {
        this.colorVector = new ArrayList();
        for (Place place : this.getPlaces()) {
            ArrayList<Integer> tokensC = new ArrayList<Integer>();
            tokensC.add(((PlaceColored)place).getColorTokensNumber(0));
            tokensC.add(((PlaceColored)place).getColorTokensNumber(1));
            tokensC.add(((PlaceColored)place).getColorTokensNumber(2));
            tokensC.add(((PlaceColored)place).getColorTokensNumber(3));
            tokensC.add(((PlaceColored)place).getColorTokensNumber(4));
            tokensC.add(((PlaceColored)place).getColorTokensNumber(5));
            this.colorVector.add(tokensC);
        }
    }

    public void restoreColors() {
        if (this.checkIfXTPNpresent()) {
            return;
        }
        try {
            ArrayList<Place> places = this.getPlaces();
            for (Place place : places) {
                place.setTokensNumber(0);
            }
            if (this.colorVector == null) {
                return;
            }
            places = this.getPlaces();
            for (int p = 0; p < places.size(); ++p) {
                PlaceColored placeColored = (PlaceColored)places.get(p);
                placeColored.setColorTokensNumber(this.colorVector.get(p).get(0), 0);
                placeColored.setColorTokensNumber(this.colorVector.get(p).get(1), 1);
                placeColored.setColorTokensNumber(this.colorVector.get(p).get(2), 2);
                placeColored.setColorTokensNumber(this.colorVector.get(p).get(3), 3);
                placeColored.setColorTokensNumber(this.colorVector.get(p).get(4), 4);
                placeColored.setColorTokensNumber(this.colorVector.get(p).get(5), 5);
                placeColored.setTokensNumber(0);
            }
            ArrayList<Transition> transitions = this.getTransitions();
            for (Transition trans : transitions) {
                trans.setLaunching(false);
                if (trans.getTransType() != Transition.TransitionType.TPN) continue;
                trans.timeExtension.resetTimeVariables();
            }
            SimulatorGlobals.SimNetType simNetType = this.overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimNetType();
            this.getSimulator().resetSimulator();
            this.getSimulatorXTPN().resetSimulator();
            this.overlord.getSimulatorBox().getCurrentDockWindow().setSimulator(this.getSimulator(), this.getSimulatorXTPN());
            this.overlord.io.updateTimeStep(false, this.getSimulator().getSimulatorTimeStep(), 0.0, 0.0);
            this.overlord.simSettings.currentStep = this.getSimulator().getSimulatorTimeStep();
            this.repaintAllGraphPanels();
            this.getSimulator().getSimLogger().logSimReset();
        }
        catch (Exception e) {
            this.overlord.log("Unknown error: unable to restore colored state m0 on request.", "error", true);
        }
    }

    private void turnTransitionGlowingOff() {
        for (GraphPanel gp : this.getGraphPanels()) {
            gp.getSelectionManager().removeTransitionsGlowing();
            gp.repaint();
        }
    }

    public boolean removeGraphPanel(int sheetID) {
        System.out.println("Before deletion:");
        for (GraphPanel graphPanel : this.getGraphPanels()) {
            System.out.println(graphPanel);
        }
        for (Node node : this.getNodes()) {
            System.out.println(node);
        }
        for (Arc arc : this.getArcs()) {
            System.out.println(arc);
        }
        Iterator<GraphPanel> gpIterator = this.getGraphPanels().iterator();
        while (gpIterator.hasNext()) {
            if (gpIterator.next().getSheetId() != sheetID) continue;
            gpIterator.remove();
            Iterator<Node> iterator = this.getNodes().iterator();
            while (iterator.hasNext()) {
                Node node = iterator.next();
                for (ElementLocation el : node.getNodeLocations(sheetID)) {
                    if (!node.removeElementLocation(el)) {
                        iterator.remove();
                    }
                    Iterator<Arc> j = el.getInArcs().iterator();
                    while (j.hasNext()) {
                        this.getArcs().remove(j.next());
                        j.remove();
                    }
                    j = el.getOutArcs().iterator();
                    while (j.hasNext()) {
                        this.getArcs().remove(j.next());
                        j.remove();
                    }
                }
            }
            System.out.println("After deletion:");
            for (GraphPanel graphPanel : this.getGraphPanels()) {
                System.out.println(graphPanel);
            }
            for (Node node : this.getNodes()) {
                System.out.println(node);
            }
            for (Arc arc : this.getArcs()) {
                System.out.println(arc);
            }
            return true;
        }
        return false;
    }

    public boolean checkNameConflict(String name) {
        for (Node n : this.getNodes()) {
            if (!n.getName().equals(name)) continue;
            return true;
        }
        for (Arc a : this.getArcs()) {
            if (!a.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<BufferedImage> getImagesFromGraphPanels() {
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        for (GraphPanel g : this.getGraphPanels()) {
            images.add(g.createImageFromSheet());
        }
        return images;
    }

    public boolean saveAsPNT(String filePath) {
        return this.communicationProtocol.writePNT(filePath, this.getPlaces(), this.getTransitions(), this.getArcs());
    }

    public boolean saveAsAbyss(String filePath) {
        AbyssWriter ABYSSSwriter = new AbyssWriter();
        return ABYSSSwriter.write(filePath);
    }

    public boolean saveAsSPPED(String filePath) {
        SnoopyWriter sWr = new SnoopyWriter();
        return sWr.writeSPPED(filePath);
    }

    public boolean saveAsSPEPT(String filePath) {
        SnoopyWriter sWr = new SnoopyWriter();
        return sWr.writeSPEPT(filePath);
    }

    public boolean saveAsSPTPT(String filePath) {
        SnoopyWriter sWr = new SnoopyWriter();
        return sWr.writeSPTPT(filePath);
    }

    public boolean loadFromFile(String path) {
        boolean status = this.overlord.reset.newProjectInitiated();
        if (!status) {
            return false;
        }
        SAXParserFactory readerSNOOPY = SAXParserFactory.newInstance();
        try {
            if (path.endsWith(".abyss")) {
                AbyssReader ABYSSReader = new AbyssReader();
                ABYSSReader.read(path);
                this.addArcsAndNodes(ABYSSReader.getArcArray(), ABYSSReader.getNodeArray());
                this.setName(ABYSSReader.getPNname());
                String name = path;
                int ind = name.lastIndexOf("\\");
                if (ind > 1) {
                    name = name.substring(ind + 1);
                }
                this.setFileName(name);
            }
            if (path.endsWith(".spped") || path.endsWith(".spept") || path.endsWith(".colpn") || path.endsWith(".sptpt") || path.endsWith(".pn") || path.endsWith(".xpn")) {
                if (this.overlord.getSettingsManager().getValue("programUseOldSnoopyLoaders").equals("1")) {
                    this.overlord.log("Activating old Snoopy loader. Will fail for hierarchical networks.", "text", true);
                    FileInputStream xmlInput = new FileInputStream(path);
                    SAXParser saxParser = readerSNOOPY.newSAXParser();
                    if (path.endsWith(".spped") || path.endsWith(".pn")) {
                        this.handler = new NetHandler_Classic();
                    }
                    if (path.endsWith(".spept") || path.endsWith(".xpn")) {
                        this.handler = new NetHandler_Extended();
                    }
                    if (path.endsWith(".colpn")) {
                        this.handler = new NetHandler_Colored();
                    }
                    if (path.endsWith(".sptpt")) {
                        this.handler = new NetHandler_Time();
                    }
                    saxParser.parse((InputStream)xmlInput, (DefaultHandler)this.handler);
                    this.addArcsAndNodes(this.handler.getArcList(), this.handler.getNodesList());
                    this.accessStatesManager().createCleanStatePN();
                    this.accessSSAmanager().createCleanSSAvector();
                    this.accessFiringRatesManager().createCleanSPNdataVector();
                    String name = path;
                    int ind = name.lastIndexOf("\\");
                    if (ind > 1) {
                        name = name.substring(ind + 1);
                    }
                    this.setFileName(name);
                    name = name.replace(".spped", "");
                    name = name.replace(".spept", "");
                    name = name.replace(".colpn", "");
                    name = name.replace(".sptpt", "");
                    name = name.replace(".pn", "");
                    name = name.replace(".xpn", "");
                    this.setName(name);
                } else {
                    SnoopyReader reader = new SnoopyReader(0, path);
                    this.addArcsAndNodes(reader.getArcList(), reader.getNodesList());
                    this.accessStatesManager().createCleanStatePN();
                    this.accessFiringRatesManager().createCleanSPNdataVector();
                    this.accessSSAmanager().createCleanSSAvector();
                    this.overlord.subnetsGraphics.addRequiredSheets();
                    this.overlord.subnetsGraphics.resizePanels();
                    this.overlord.getWorkspace().setSelectedDock(0);
                }
                int nodeSID = this.overlord.getWorkspace().getSheets().size() - 1;
                int SIN = this.overlord.IDtoIndex(nodeSID);
                GraphPanel graphPanel = this.overlord.getWorkspace().getSheets().get(SIN).getGraphPanel();
                graphPanel.setOriginSize(graphPanel.getSize());
                graphPanel.repaint();
            }
            if (path.endsWith(".pnt")) {
                this.communicationProtocol.readPNT(path);
                this.addArcsAndNodes(this.communicationProtocol.getArcArray(), this.communicationProtocol.getNodeArray());
                this.accessStatesManager().createCleanStatePN();
                this.accessFiringRatesManager().createCleanSPNdataVector();
            }
            this.overlord.log("Petri net successfully imported from file " + path, "text", true);
            ArrayList<Place> places = this.getPlaces();
            ArrayList<Arc> arcs = this.getArcs();
            ArrayList<Transition> transitions = this.getTransitions();
            for (Transition transition : transitions) {
                transition.fpnExtension.checkFunctions(arcs, places);
            }
            return true;
        }
        catch (Exception e) {
            this.overlord.log("Critical error while loading network: " + e.getMessage(), "error", true);
            return false;
        }
    }

    public int saveInvariantsToCSV(String path, boolean silence, boolean t_inv) {
        int result = -1;
        try {
            if (t_inv) {
                if (this.getT_InvMatrix() != null) {
                    this.communicationProtocol.writeT_invCSV(path, this.getT_InvMatrix(), this.getTransitions());
                    if (!silence) {
                        JOptionPane.showMessageDialog(null, "T-invariants saved to file:\n" + path, "Success", 1);
                    }
                    result = 0;
                } else {
                    if (!silence) {
                        JOptionPane.showMessageDialog(null, "There are no t-invariants to export.", "Warning", 2);
                    }
                    this.overlord.log("No t-invariants, saving into CSV file failed.", "error", true);
                }
            } else if (this.getP_InvMatrix() != null) {
                this.communicationProtocol.writeP_invCSV(path, this.getP_InvMatrix(), this.getPlaces());
                if (!silence) {
                    JOptionPane.showMessageDialog(null, "P-invariants saved to file:\n" + path, "Success", 1);
                }
                result = 0;
            } else {
                if (!silence) {
                    JOptionPane.showMessageDialog(null, "There are no p-invariants to export.", "Warning", 2);
                }
                this.overlord.log("No p-invariants, saving into CSV file failed.", "error", true);
            }
        }
        catch (Exception e) {
            this.overlord.log("Error: " + e.getMessage(), "error", true);
        }
        return result;
    }

    public int saveInvariantsToInaFormat(String path, boolean t_inv) {
        int result = -1;
        try {
            if (t_inv) {
                if (this.getT_InvMatrix() != null) {
                    this.communicationProtocol.writeT_invINA(path, this.getT_InvMatrix(), this.getTransitions());
                    JOptionPane.showMessageDialog(null, "T-invariants saved to file:\n" + path, "Success", 1);
                    this.overlord.log("T-invariants saved into .inv INA file.", "text", true);
                    result = 0;
                } else {
                    JOptionPane.showMessageDialog(null, "There are no t-invariants to export", "Warning", 2);
                    this.overlord.log("No t-invariants, saving into CSV file failed.", "error", true);
                }
            } else if (this.getP_InvMatrix() != null) {
                this.communicationProtocol.writeP_invINA(path, this.getP_InvMatrix(), this.getPlaces());
                JOptionPane.showMessageDialog(null, "P-invariants saved to file:\n" + path, "Success", 1);
                this.overlord.log("P-invariants saved into .inv INA file.", "text", true);
                result = 0;
            } else {
                JOptionPane.showMessageDialog(null, "There are no p-invariants to export", "Warning", 2);
                this.overlord.log("No p-invariants, saving into CSV file failed.", "error", true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.overlord.log("Error: " + e.getMessage(), "error", true);
        }
        return result;
    }

    public int saveInvariantsToCharlie(String path, boolean t_inv) {
        int result = -1;
        try {
            if (t_inv) {
                if (this.getT_InvMatrix() != null) {
                    this.communicationProtocol.writeT_invCharlie(path, this.getT_InvMatrix(), this.getTransitions());
                    JOptionPane.showMessageDialog(null, "T-invariants saved to file:\n" + path, "Success", 1);
                    this.overlord.log("T-invariants saved in Charlie file format.", "text", true);
                    result = 0;
                } else {
                    JOptionPane.showMessageDialog(null, "There are no t-invariants to export.", "Warning", 2);
                    this.overlord.log("No t-invariants, saving into CSV file failed.", "error", true);
                }
            } else if (this.getP_InvMatrix() != null) {
                this.communicationProtocol.writeP_invCharlie(path, this.getP_InvMatrix(), this.getPlaces());
                JOptionPane.showMessageDialog(null, "P-invariants saved to file:\n" + path, "Success", 1);
                this.overlord.log("P-invariants saved in Charlie file format.", "text", true);
                result = 0;
            } else {
                JOptionPane.showMessageDialog(null, "There are no p-invariants to export.", "Warning", 2);
                this.overlord.log("No p-invariants, saving into CSV file failed.", "error", true);
            }
        }
        catch (Exception e) {
            this.overlord.log("Error: " + e.getMessage(), "error", true);
        }
        return result;
    }

    public boolean loadTPinvariantsFromFile(String path, boolean t_inv) {
        try {
            if (t_inv) {
                boolean status = this.communicationProtocol.readT_invariants(path);
                if (!status) {
                    return false;
                }
                this.setT_InvMatrix(this.communicationProtocol.getInvariantsList(), true);
                this.overlord.reset.setT_invariantsStatus(true);
            } else {
                boolean status = this.communicationProtocol.readP_invariants(path);
                if (!status) {
                    return false;
                }
                this.setP_InvMatrix(this.communicationProtocol.getInvariantsList());
                this.overlord.reset.setP_invariantsStatus(true);
            }
            return true;
        }
        catch (Exception e) {
            this.overlord.log("Invariants reading and/or adding to program failed.", "error", true);
            return false;
        }
    }

    public void repaintAllGraphPanels() {
        for (GraphPanel g : this.getGraphPanels()) {
            g.invalidate();
            g.repaint();
        }
    }

    public void incrementGraphicalSimulationStep() {
        for (Arc a : this.getArcs()) {
            a.incrementSimulationStep();
        }
        for (GraphPanel g : this.getGraphPanels()) {
            g.invalidate();
            g.repaint();
        }
    }

    public boolean isSimulationActive() {
        return this.isSimulationActive;
    }

    public void setSimulationActive(boolean isSimulationActive) {
        this.isSimulationActive = isSimulationActive;
        for (GraphPanel g : this.getGraphPanels()) {
            g.setSimulationActive(isSimulationActive);
        }
    }

    public int returnCleanSheetID() {
        int SID = 0;
        if (!this.getDataCore().nodes.isEmpty()) {
            ArrayList<Integer> sheetList = new ArrayList<Integer>();
            for (WorkspaceSheet ws : this.overlord.getWorkspace().getSheets()) {
                sheetList.add(ws.getId());
            }
            int[] tabSID = new int[this.overlord.getWorkspace().getSheets().get(this.overlord.getWorkspace().getSheets().size() - 1).getId() + 1];
            for (int j = 0; j < this.getDataCore().nodes.size(); ++j) {
                for (int i = 0; i < this.getDataCore().nodes.get(j).getNodeLocations().size(); ++i) {
                    int tSID;
                    int n = tSID = this.getDataCore().nodes.get(j).getNodeLocations().get(i).getSheetID();
                    tabSID[n] = tabSID[n] + 1;
                }
            }
            boolean emptySheet = false;
            int emptySheetIndex = 999999999;
            for (Integer integer : sheetList) {
                if (tabSID[integer] != 0) continue;
                emptySheet = true;
                if (emptySheetIndex <= integer) continue;
                emptySheetIndex = integer;
            }
            SID = emptySheet ? emptySheetIndex : this.overlord.getWorkspace().newTab(false, new Point(0, 0), 1, MetaNode.MetaType.SUBNET);
        }
        return SID;
    }

    private void setTransitionGlowedMTC(boolean isGlowedMTC) {
        for (Node n : this.getNodes()) {
            if (n.getType() != PetriNetElement.PetriNetElementType.TRANSITION) continue;
            ((Transition)n).drawGraphBoxT.setGlowed_MTC(isGlowedMTC);
        }
    }

    private void setGlowedSubnet(boolean isGlowedSubnet) {
        for (Node n : this.getNodes()) {
            n.setGlowedSub(isGlowedSubnet);
        }
        for (Arc a : this.getArcs()) {
            a.setGlowedSub(isGlowedSubnet);
        }
    }

    public void resetNetColors() {
        this.turnTransitionGlowingOff();
        this.setTransitionGlowedMTC(false);
        this.setGlowedSubnet(false);
        this.resetSimulationGraphics_Transitions();
        this.resetSimulationGraphics_Places();
        this.resetArcGraphics();
        this.resetNodes();
    }

    private void resetNodes() {
        for (Node n : this.getNodes()) {
            n.qSimArcSign = false;
            for (ElementLocation el : n.getElementLocations()) {
                el.qSimArcSign = false;
                el.qSimDrawed = false;
            }
        }
    }

    private void resetArcGraphics() {
        for (Arc a : this.getArcs()) {
            a.arcQSimBox.qSimForcedArc = false;
            if (a.getType() == PetriNetElement.PetriNetElementType.ARC) {
                a.arcDecoBox.setColor(false, Color.BLACK);
            }
            a.arcXTPNbox.showQSimXTPN = false;
        }
    }

    private void resetSimulationGraphics_Transitions() {
        for (Node n : this.getNodes()) {
            if (n.getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                Transition trans = (Transition)n;
                trans.drawGraphBoxT.setColorWithNumber(false, Color.white, false, -1.0, false, "");
                trans.drawGraphBoxT.resetOffs();
                trans.qSimBoxT.qSimDrawed = false;
                trans.qSimBoxT.qSimDrawStats = false;
                trans.qSimBoxT.qSimOvalSize = 10;
                n.qSimArcSign = false;
            }
            if (!(n instanceof TransitionXTPN)) continue;
            ((TransitionXTPN)n).qSimXTPN.clean();
            ((TransitionXTPN)n).qSimXTPN.showQSimXTPN = false;
        }
    }

    private void resetSimulationGraphics_Places() {
        for (Node n : this.getNodes()) {
            if (n.getType() == PetriNetElement.PetriNetElementType.PLACE) {
                Place place = (Place)n;
                place.drawGraphBoxP.setColorWithNumber(false, Color.white, false, -1.0, false, "");
                place.drawGraphBoxP.resetOffs();
                place.qSimBoxP.qSimDrawed = false;
                place.qSimBoxP.qSimDrawStats = false;
                place.qSimBoxP.qSimOvalSize = 10;
                n.qSimArcSign = false;
            }
            if (!(n instanceof PlaceXTPN)) continue;
            ((PlaceXTPN)n).showQSimXTPN = false;
        }
    }

    private boolean checkIfEmpty() {
        if (this.getNodes().size() == 0) {
            return true;
        }
        Object[] options = new Object[]{"Load and replace project", "Cancel operation"};
        int n = JOptionPane.showOptionDialog(null, "New net will replace an old one already drawn. If the latter has not been saved,\nplease do it before continuing or it will be lost.", "Continue loading new net?", 0, 3, null, options, options[1]);
        return n == 0;
    }

    public void startInvSim(int type, int value) {
    }

    public void deleteProjectData() {
        this.overlord.log("Net data deletion initiated.", "text", true);
        for (GraphPanel gp : this.getGraphPanels()) {
            gp.getSelectionManager().forceDeselectAllElements();
        }
        this.setNodes(new ArrayList<Node>());
        this.setArcs(new ArrayList<Arc>());
        this.repaintAllGraphPanels();
        ArrayList<GraphPanel> newGraphPanels = new ArrayList<GraphPanel>();
        for (GraphPanel gp : this.getGraphPanels()) {
            int sheetID = gp.getSheetId();
            WorkspaceSheet.SheetPanel sheetPanel = (WorkspaceSheet.SheetPanel)gp.getParent();
            sheetPanel.remove(gp);
            GraphPanel newGraphPanel = new GraphPanel(sheetID, this, this.getNodes(), this.getArcs());
            sheetPanel.add(newGraphPanel);
            newGraphPanels.add(newGraphPanel);
        }
        this.setGraphPanels(newGraphPanels);
        this.repaintAllGraphPanels();
    }

    public GlobalNetType getNetTypeByName(String name) {
        return switch (name) {
            case "TPN" -> GlobalNetType.TPN;
            case "PN_extArcs" -> GlobalNetType.PN_extArcs;
            case "FPN" -> GlobalNetType.FPN;
            case "timeFPN" -> GlobalNetType.timeFPN;
            case "TPN_extArcs" -> GlobalNetType.TPN_extArcs;
            case "FPN_extArcs" -> GlobalNetType.FPN_extArcs;
            case "timeFPN_extArcs" -> GlobalNetType.timeFPN_extArcs;
            case "SPN" -> GlobalNetType.SPN;
            case "functionalSPN" -> GlobalNetType.functionalSPN;
            case "XTPN" -> GlobalNetType.XTPN;
            default -> GlobalNetType.PN;
        };
    }

    public void setProjectType(GlobalNetType projectType) {
        this.projectType = projectType;
        GUIController.access().setCurrentNetType(projectType);
    }

    public GlobalNetType getProjectType() {
        return this.projectType;
    }

    public GlobalNetSubType getProjectSubType() {
        return this.projectSubType;
    }

    public void setProjectSubType(GlobalNetSubType projectSubType) {
        this.projectSubType = projectSubType;
    }

    public boolean hasNonXTPNnodes() {
        boolean result = false;
        for (Node n : this.dataCore.nodes) {
            if (n instanceof Place && !(n instanceof PlaceXTPN)) {
                return true;
            }
            if (!(n instanceof Transition) || n instanceof TransitionXTPN) continue;
            return true;
        }
        return result;
    }

    public boolean checkIfXTPNpresent() {
        boolean result = false;
        for (Node n : this.dataCore.nodes) {
            if (n instanceof PlaceXTPN) {
                return true;
            }
            if (!(n instanceof TransitionXTPN)) continue;
            return true;
        }
        return result;
    }

    public void transformAllIntoXTPNnodes_TODO() {
        for (Node n : this.dataCore.nodes) {
            if (n instanceof Place) {
                Place place = (Place)n;
                continue;
            }
            if (!(n instanceof Transition)) continue;
            Transition transition = (Transition)n;
            transition.setTransType(Transition.TransitionType.XTPN);
            transition.timeExtension.setTPNstatus(false);
            transition.timeExtension.setDPNstatus(false);
            transition.spnExtension.setSPNtype(TransitionSPNExtension.StochaticsType.NONE);
        }
    }

    public static enum GlobalNetType {
        PN,
        TPN,
        PN_extArcs,
        FPN,
        timeFPN,
        TPN_extArcs,
        FPN_extArcs,
        timeFPN_extArcs,
        SPN,
        functionalSPN,
        XTPN;

    }

    public static enum GlobalNetSubType {
        CLEAN_XTPN,
        FUNCTIONAL,
        EXT_ARCS,
        FUNCTIONAL_EXT_ARCS;

    }

    public static enum GlobalFileNetType {
        SPPED,
        SPEPT,
        SPTPT,
        HOLMESPROJECT;

    }
}

