/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.data;

import holmes.darkgui.GUIController;
import holmes.darkgui.GUIManager;
import holmes.petrinet.data.MultisetM;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.data.StatePlacesVector;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceXTPN;
import java.util.ArrayList;

public class P_StateManager {
    private final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private final PetriNet pn;
    private ArrayList<StatePlacesVector> statesMatrix;
    private ArrayList<MultisetM> statesMatrixXTPN;
    public int selectedStatePN = 0;
    public int selectedStateXTPN = 0;

    public P_StateManager(PetriNet net) {
        this.pn = net;
        this.statesMatrix = new ArrayList();
        this.statesMatrix.add(new StatePlacesVector());
        this.statesMatrix.get(0).setDescription("Default first (0) working state for current net.");
        this.statesMatrixXTPN = new ArrayList();
        this.statesMatrixXTPN.add(new MultisetM());
        this.statesMatrixXTPN.get(0).setDescription("Default first (0) multiset M for the current XTPN net.");
    }

    public void addPlace(Place place) {
        for (StatePlacesVector pVector : this.statesMatrix) {
            pVector.addPlace(0.0);
        }
        if (place instanceof PlaceXTPN) {
            for (MultisetM multisetM : this.statesMatrixXTPN) {
                if (((PlaceXTPN)place).isGammaModeActive()) {
                    multisetM.addMultiset_K_toMultiset_M(new ArrayList<Double>(((PlaceXTPN)place).accessMultiset()), 1);
                    continue;
                }
                multisetM.addMultiset_K_toMultiset_M(new ArrayList<Double>(((PlaceXTPN)place).accessMultiset()), 0);
            }
        }
    }

    public void removePlace(int index) {
        boolean status;
        for (StatePlacesVector pVector : this.statesMatrix) {
            status = pVector.removePlace(index);
            if (status) continue;
            this.overlord.log("Critical error: invalid place index (" + index + ") in states matrix.", "error", true);
        }
        if (GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
            for (MultisetM multisetM : this.statesMatrixXTPN) {
                status = multisetM.removePlaceFromMultiset_M(index);
                if (status) continue;
                this.overlord.log("Critical error: invalid XTPN place index (" + index + ") in XTPN states matrix.", "error", true);
            }
        }
    }

    public StatePlacesVector getStatePN(int index) {
        if (index >= this.statesMatrix.size()) {
            return null;
        }
        return this.statesMatrix.get(index);
    }

    public StatePlacesVector getCurrentStatePN() {
        return this.statesMatrix.get(this.selectedStatePN);
    }

    public void addCurrentStatePN() {
        StatePlacesVector pVector = new StatePlacesVector();
        for (Place place : this.pn.getPlaces()) {
            pVector.addPlace(place.getTokensNumber());
        }
        this.statesMatrix.add(pVector);
    }

    public void addNewCleanStatePN() {
        StatePlacesVector pVector = new StatePlacesVector();
        int placesNumber = this.pn.getPlacesNumber();
        for (int p = 0; p < placesNumber; ++p) {
            pVector.addPlace(0.0);
        }
        this.statesMatrix.add(pVector);
    }

    public void createCleanStatePN() {
        this.resetPN(true);
        ArrayList<Place> places = this.pn.getPlaces();
        for (Place place : places) {
            this.statesMatrix.get(0).addPlace(place.getTokensNumber());
        }
    }

    public void setNetworkStatePN(int stateID) {
        ArrayList<Place> places = this.pn.getPlaces();
        StatePlacesVector psVector = this.statesMatrix.get(stateID);
        for (int placeIndex = 0; placeIndex < places.size(); ++placeIndex) {
            Place place = places.get(placeIndex);
            place.setTokensNumber((int)psVector.getTokens(placeIndex));
            place.freeReservedTokens();
        }
        this.selectedStatePN = stateID;
    }

    public void removeStatePN(int stateID) {
        this.statesMatrix.remove(stateID);
        this.selectedStatePN = 0;
    }

    public void replaceStoredStateWithNetStatePN(int stateID) {
        ArrayList<Place> places = this.pn.getPlaces();
        StatePlacesVector psVector = this.statesMatrix.get(stateID);
        for (int p = 0; p < places.size(); ++p) {
            psVector.accessVector().set(p, Double.valueOf(places.get(p).getTokensNumber()));
        }
    }

    public String getStateDescriptionPN(int selected) {
        return this.statesMatrix.get(selected).getDescription();
    }

    public void setStateDescriptionPN(int selected, String newText) {
        this.statesMatrix.get(selected).setDescription(newText);
    }

    public ArrayList<StatePlacesVector> accessStateMatrix() {
        return this.statesMatrix;
    }

    public void resetPN(boolean createFirstVector) {
        this.statesMatrix = new ArrayList();
        if (createFirstVector) {
            this.statesMatrix.add(new StatePlacesVector());
            this.statesMatrix.get(0).setDescription("Default first (0) working state for current net.");
        }
        this.selectedStatePN = 0;
    }

    public MultisetM getMultiset_M(int index) {
        if (index >= this.statesMatrixXTPN.size()) {
            return null;
        }
        return this.statesMatrixXTPN.get(index);
    }

    public void createNewMultiset_M_basedOnNet() {
        MultisetM multisetM = new MultisetM();
        for (Place place : this.pn.getPlaces()) {
            if (!(place instanceof PlaceXTPN)) {
                this.overlord.log("Critical error, wrong place object. ID: 548932123.", "error", true);
                return;
            }
            if (((PlaceXTPN)place).isGammaModeActive()) {
                multisetM.addMultiset_K_toMultiset_M(new ArrayList<Double>(((PlaceXTPN)place).accessMultiset()), 1);
                continue;
            }
            int tokens = place.getTokensNumber();
            ArrayList<Double> fakeMultiset = new ArrayList<Double>();
            fakeMultiset.add(Double.valueOf(tokens));
            multisetM.addMultiset_K_toMultiset_M(fakeMultiset, 0);
        }
        this.statesMatrixXTPN.add(multisetM);
    }

    public void addNewCleanMultiset_M() {
        MultisetM multisetM = new MultisetM();
        for (int placeID = 0; placeID < this.pn.getPlacesNumber(); ++placeID) {
            multisetM.addMultiset_K_toMultiset_M(new ArrayList<Double>(), 1);
        }
        this.statesMatrixXTPN.add(multisetM);
    }

    public void createFirstMultiset_M() {
        this.removeAllMultisets_M(true);
        ArrayList<Place> places = this.pn.getPlaces();
        for (Place place : places) {
            if (!(place instanceof PlaceXTPN)) {
                this.overlord.log("Error code: 54284123. Non-XTPN nodes detected.", "error", true);
                return;
            }
            if (((PlaceXTPN)place).isGammaModeActive()) {
                this.statesMatrixXTPN.get(0).addMultiset_K_toMultiset_M(new ArrayList<Double>(((PlaceXTPN)place).accessMultiset()), 1);
                continue;
            }
            this.statesMatrixXTPN.get(0).addMultiset_K_toMultiset_M(new ArrayList<Double>(((PlaceXTPN)place).accessMultiset()), 0);
        }
    }

    public boolean replaceNetStateWithSelectedMultiset_M(int stateID) {
        ArrayList<Place> places = this.pn.getPlaces();
        MultisetM multisetM = this.statesMatrixXTPN.get(stateID);
        if (multisetM.getMultiset_M_Size() == places.size()) {
            for (int placeIndex = 0; placeIndex < places.size(); ++placeIndex) {
                Place place = places.get(placeIndex);
                if (!(place instanceof PlaceXTPN)) {
                    this.overlord.log("Critical error, wrong place object. ID: 19284133.", "error", true);
                    return false;
                }
                if (multisetM.isPlaceStoredAsGammaActive(placeIndex)) {
                    ((PlaceXTPN)place).setGammaModeStatus(true);
                    ((PlaceXTPN)place).replaceMultiset(new ArrayList<Double>(multisetM.accessMultiset_K(placeIndex)));
                    place.setTokensNumber(multisetM.accessMultiset_K(placeIndex).size());
                    continue;
                }
                ((PlaceXTPN)place).setGammaModeStatus(false);
                ((PlaceXTPN)place).accessMultiset().clear();
                double tokensNo = multisetM.accessMultiset_K(placeIndex).get(0);
                place.setTokensNumber((int)tokensNo);
            }
            this.selectedStateXTPN = stateID;
            return true;
        }
        return false;
    }

    public void removeMultiset_M(int stateID) {
        this.statesMatrixXTPN.remove(stateID);
        this.selectedStateXTPN = 0;
    }

    public void replaceStoredMultiset_M_withCurrentNetState(int stateID) {
        ArrayList<Place> places = this.pn.getPlaces();
        MultisetM multisetM = this.statesMatrixXTPN.get(stateID);
        multisetM.accessArrayListSOfMultiset_M().clear();
        multisetM.accessPlacesGammaVector().clear();
        for (Place place : places) {
            if (!(place instanceof PlaceXTPN)) {
                this.overlord.log("Critical error, wrong place object. ID: 93214125.", "error", true);
                return;
            }
            ArrayList<Double> currentPlaceMultiset = new ArrayList<Double>(((PlaceXTPN)place).accessMultiset());
            int placeTag = 1;
            if (!((PlaceXTPN)place).isGammaModeActive()) {
                currentPlaceMultiset.clear();
                currentPlaceMultiset.add(Double.valueOf(place.getTokensNumber()));
                placeTag = 0;
            }
            multisetM.addMultiset_K_toMultiset_M(currentPlaceMultiset, placeTag);
        }
    }

    public String getMultiset_M_Description(int selected) {
        return this.statesMatrixXTPN.get(selected).getDescription();
    }

    public void setMultiset_M_Description(int selected, String newText) {
        this.statesMatrixXTPN.get(selected).setDescription(newText);
    }

    public ArrayList<MultisetM> accessStateMatrixXTPN() {
        return this.statesMatrixXTPN;
    }

    public void removeAllMultisets_M(boolean createFirstVector) {
        this.statesMatrixXTPN = new ArrayList();
        if (createFirstVector) {
            this.statesMatrixXTPN.add(new MultisetM());
            this.statesMatrixXTPN.get(0).setDescription("Default first (0) working XTPN state for current net.");
        }
        this.selectedStateXTPN = 0;
    }
}

