/*
 * Decompiled with CFR 0.152.
 */
package holmes.petrinet.data;

import holmes.darkgui.GUIManager;
import holmes.petrinet.data.NetSimulationData;
import holmes.utilities.Tools;
import holmes.workspace.ExtensionFileFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;

public class NetSimulationDataCore
implements Serializable {
    private static final long serialVersionUID = -2180386709205258057L;
    private ArrayList<NetSimulationData> referenceSets = new ArrayList();
    private ArrayList<NetSimulationData> knockoutSets = new ArrayList();
    private ArrayList<Long> seriesData = new ArrayList();
    public boolean saved = false;

    public boolean addNewReferenceSet(NetSimulationData refSet) {
        this.referenceSets.add(refSet);
        this.saved = false;
        return true;
    }

    public ArrayList<NetSimulationData> accessReferenceSets() {
        return this.referenceSets;
    }

    public NetSimulationData getReferenceSet(int index) {
        if (index < this.referenceSets.size()) {
            return this.referenceSets.get(index);
        }
        return null;
    }

    public boolean addNewDataSet(NetSimulationData refSet) {
        this.knockoutSets.add(refSet);
        this.saved = false;
        return true;
    }

    public ArrayList<NetSimulationData> accessKnockoutDataSets() {
        return this.knockoutSets;
    }

    public NetSimulationData getKnockoutSet(int index) {
        if (index < this.knockoutSets.size()) {
            return this.knockoutSets.get(index);
        }
        return null;
    }

    public void addNewSeries(long value) {
        if (!this.seriesData.contains(value)) {
            this.seriesData.add(value);
        }
    }

    public ArrayList<Long> accessSeries() {
        return this.seriesData;
    }

    public void removeSeries(long IDseries) {
        int knockSize = this.knockoutSets.size();
        for (int s = 0; s < knockSize; ++s) {
            if (this.knockoutSets.get(s).getIDseries() != IDseries) continue;
            this.knockoutSets.remove(s);
            --s;
            --knockSize;
        }
        this.seriesData.remove(IDseries);
    }

    public NetSimulationData returnSeriesFirst(long IDseries) {
        for (NetSimulationData nsd : this.knockoutSets) {
            if (nsd.getIDseries() != IDseries) continue;
            return nsd;
        }
        return null;
    }

    public ArrayList<NetSimulationData> getSeriesDatasets(long IDseries) {
        ArrayList<NetSimulationData> result = new ArrayList<NetSimulationData>();
        NetSimulationData tmp = this.returnSeriesFirst(IDseries);
        int transSize = tmp.transNumber;
        for (NetSimulationData data : this.knockoutSets) {
            if (data.getIDseries() != IDseries) continue;
            result.add(data);
        }
        if (result.size() != transSize) {
            GUIManager.getDefaultGUIManager().log("Error: data package incomplete!", "error", true);
            return null;
        }
        return result;
    }

    public boolean loadDataSets() {
        NetSimulationDataCore core = new NetSimulationDataCore();
        String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
        String newLocation = "";
        try {
            FileFilter[] filter = new FileFilter[]{new ExtensionFileFilter("Simulation Data (.sim)", new String[]{"sim"})};
            newLocation = Tools.selectFileDialog(lastPath, filter, "Load data", "", "");
            if (newLocation.equals("")) {
                return false;
            }
            File test = new File(newLocation);
            if (!test.exists()) {
                return false;
            }
            FileInputStream fis = new FileInputStream(newLocation);
            ObjectInputStream ois = new ObjectInputStream(fis);
            core = (NetSimulationDataCore)ois.readObject();
            ois.close();
            fis.close();
            GUIManager.getDefaultGUIManager().getWorkspace().getProject().setNewKnockoutData(core);
            return true;
        }
        catch (Exception ioe) {
            String msg = "Simulation data loading failed for file " + newLocation;
            GUIManager.getDefaultGUIManager().log(msg, "error", true);
            GUIManager.getDefaultGUIManager().log(ioe.getMessage(), "error", true);
            return false;
        }
    }

    public boolean saveDataSets() {
        try {
            String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
            FileFilter[] filter = new FileFilter[]{new ExtensionFileFilter("Simulation Data (.sim)", new String[]{"sim"})};
            Object newLocation = Tools.selectFileDialog(lastPath, filter, "Save data", "", "");
            if (((String)newLocation).equals("")) {
                return false;
            }
            if (!((String)newLocation).contains(".sim")) {
                newLocation = (String)newLocation + ".sim";
            }
            FileOutputStream fos = new FileOutputStream((String)newLocation);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            NetSimulationDataCore core = GUIManager.getDefaultGUIManager().getWorkspace().getProject().accessSimKnockoutData();
            oos.writeObject(core);
            oos.close();
            fos.close();
            return true;
        }
        catch (IOException ioe) {
            GUIManager.getDefaultGUIManager().log("Saving simulation data failed.", "error", true);
            return false;
        }
    }
}

