/*
 * Decompiled with CFR 0.152.
 */
package holmes.graphpanel.popupmenu;

import holmes.darkgui.GUIManager;
import holmes.files.io.IOprotocols;
import holmes.graphpanel.GraphPanel;
import holmes.graphpanel.popupmenu.GraphPanelPopupMenu;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.HolmesFileView;
import holmes.workspace.ExtensionFileFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class SheetPopupMenu
extends GraphPanelPopupMenu {
    private static final long serialVersionUID = 3206422633820189233L;
    public int x;
    public int y;

    public SheetPopupMenu(GraphPanel graphPanel, PetriNetElement.PetriNetElementType pne) {
        super(graphPanel, pne);
        this.x = GUIManager.getDefaultGUIManager().getWorkspace().getSelectedSheet().getMousePosition().x;
        this.y = GUIManager.getDefaultGUIManager().getWorkspace().getSelectedSheet().getMousePosition().y;
        this.addMenuItem("Select All", "", e -> this.getGraphPanel().getSelectionManager().selectAllElementLocations());
        this.addSeparator();
        this.add(this.pasteMenuItem);
        this.addSeparator();
        this.addMenuItem("Refresh", "refresh.png", e -> {
            this.getGraphPanel().invalidate();
            this.getGraphPanel().repaint();
        });
        this.addMenuItem("Clear colors", "clearColors.png", e -> GUIManager.getDefaultGUIManager().reset.clearGraphColors());
        this.addMenuItem("Save to image file", "picture_save.png", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.exportToPicture();
            }

            private void exportToPicture() {
                String lastPath = GUIManager.getDefaultGUIManager().getLastPath();
                JFileChooser fc = lastPath == null ? new JFileChooser() : new JFileChooser(lastPath);
                fc.setFileView(new HolmesFileView());
                ExtensionFileFilter pngFilter = new ExtensionFileFilter(".png - Portable Network Graphics", new String[]{"png"});
                ExtensionFileFilter bmpFilter = new ExtensionFileFilter(".bmp -  Bitmap Image File", new String[]{"bmp"});
                ExtensionFileFilter jpegFilter = new ExtensionFileFilter(".jpeg - JPEG Image File", new String[]{"jpeg"});
                ExtensionFileFilter jpgFilter = new ExtensionFileFilter(".jpg - JPEG Image File", new String[]{"jpg"});
                fc.setFileFilter(pngFilter);
                fc.addChoosableFileFilter(pngFilter);
                fc.addChoosableFileFilter(bmpFilter);
                fc.addChoosableFileFilter(jpegFilter);
                fc.addChoosableFileFilter(jpgFilter);
                fc.setAcceptAllFileFilterUsed(false);
                if (fc.showSaveDialog(null) == 0) {
                    File file = fc.getSelectedFile();
                    String ext = "";
                    String extension = fc.getFileFilter().getDescription();
                    if (extension.contains(".png")) {
                        ext = ".png";
                    }
                    if (extension.contains(".bmp")) {
                        ext = ".bmp";
                    }
                    if (extension.contains(".jpeg") || extension.contains(".jpg")) {
                        ext = ".jpeg";
                    }
                    BufferedImage image = SheetPopupMenu.this.getGraphPanel().createImageFromSheet();
                    try {
                        String ext2 = "";
                        String path = file.getPath();
                        if (ext.equals(".png") && !path.contains(".png")) {
                            ext2 = ".png";
                        }
                        if (ext.equals(".bmp") && !file.getPath().contains(".bmp")) {
                            ext2 = ".bmp";
                        }
                        if (ext.equals(".jpeg") && !file.getPath().contains(".jpeg")) {
                            ext2 = ".jpeg";
                        }
                        if (ext.equals(".jpeg") && !file.getPath().contains(".jpg")) {
                            ext2 = ".jpg";
                        }
                        ImageIO.write((RenderedImage)image, ext.substring(1), new File(file.getPath() + ext2));
                        GUIManager.getDefaultGUIManager().setLastPath(file.getParentFile().getPath());
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Saving net sheet into picture failed.", "Export Picture Error", 0);
                    }
                }
            }
        });
        this.addSeparator();
        this.addMenuItem("Fast zoom reset", "undo.png", e -> this.getGraphPanel().setZoom(100, this.getGraphPanel().getZoom()));
        JMenu zoomMenu = new JMenu("Zoom");
        this.add(zoomMenu);
        zoomMenu.add(this.createMenuItem("200%", "", null, arg0 -> this.getGraphPanel().setZoom(200, this.getGraphPanel().getZoom())));
        zoomMenu.add(this.createMenuItem("100%", "", null, arg0 -> this.getGraphPanel().setZoom(100, this.getGraphPanel().getZoom())));
        zoomMenu.add(this.createMenuItem("80%", "", null, arg0 -> this.getGraphPanel().setZoom(80, this.getGraphPanel().getZoom())));
        zoomMenu.add(this.createMenuItem("50%", "", null, arg0 -> this.getGraphPanel().setZoom(50, this.getGraphPanel().getZoom())));
        zoomMenu.add(this.createMenuItem("30%", "", null, arg0 -> this.getGraphPanel().setZoom(30, this.getGraphPanel().getZoom())));
        this.addSeparator();
        this.addMenuItem("All Invisibility: OFF", "smallInvisibility.png", e -> {
            if (this.getGraphPanel().getSelectionManager().getSelectedElementLocations().size() == 0) {
                return;
            }
            for (Transition trans : GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions()) {
                trans.setInvisibility(false);
            }
            for (Place place : GUIManager.getDefaultGUIManager().getWorkspace().getProject().getPlaces()) {
                place.setInvisibility(false);
            }
            GUIManager.getDefaultGUIManager().getWorkspace().repaintAllGraphPanels();
        });
        this.addMenuItem("All knockout: OFF", "offlineSmall.png", e -> {
            if (this.getGraphPanel().getSelectionManager().getSelectedElementLocations().size() == 0) {
                return;
            }
            for (Transition trans : GUIManager.getDefaultGUIManager().getWorkspace().getProject().getTransitions()) {
                trans.setKnockout(false);
            }
            GUIManager.getDefaultGUIManager().getWorkspace().repaintAllGraphPanels();
        });
        this.addSeparator();
        JMenu analMenu = new JMenu("Network Analysis");
        this.add(analMenu);
        analMenu.add(this.createMenuItem("Import t-invariants from file", "invImportPopup.png", null, arg0 -> GUIManager.getDefaultGUIManager().io.loadExternalAnalysis(true)));
        analMenu.add(this.createMenuItem("Generate t-invariants", "generateINA.png", null, arg0 -> GUIManager.getDefaultGUIManager().io.fastGenerateTinvariants()));
        analMenu.add(this.createMenuItem("Generate MCT sets", "generateMCT.png", null, arg0 -> GUIManager.getDefaultGUIManager().generateMCT()));
        JMenu mctSubMenu = new JMenu("MCT Options");
        analMenu.add(mctSubMenu);
        JMenuItem mct1 = this.createMenuItem("Simple MCT file", "", null, arg0 -> GUIManager.getDefaultGUIManager().io.generateSimpleMCTFile());
        mctSubMenu.add(mct1);
        JMenuItem mct2 = this.createMenuItem("Tex output file", "", null, arg0 -> {});
        mct2.setEnabled(false);
        mctSubMenu.add(mct2);
        JMenuItem mct3 = this.createMenuItem("Other files", "", null, arg0 -> {});
        mct3.setEnabled(false);
        mctSubMenu.add(mct3);
        JMenu netMenu = new JMenu("Network Tools");
        this.add(netMenu);
        netMenu.add(this.createMenuItem("Show TPN transitions", "", null, arg0 -> GUIManager.getDefaultGUIManager().io.markTransitions(0)));
        netMenu.add(this.createMenuItem("Show DPN transitions", "", null, arg0 -> GUIManager.getDefaultGUIManager().io.markTransitions(1)));
        netMenu.add(this.createMenuItem("Show TPN/DPN transitions", "", null, arg0 -> GUIManager.getDefaultGUIManager().io.markTransitions(2)));
        netMenu.add(this.createMenuItem("Fix Snoopy compatibility", "", null, arg0 -> GUIManager.getDefaultGUIManager().subnetsHQ.checkSnoopyCompatibility()));
        this.addSeparator();
        JMenu subImpMenu = new JMenu("Subnet import");
        this.add(subImpMenu);
        subImpMenu.add(this.createMenuItem("Import Subnet with original location ", "", null, arg0 -> {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                IOprotocols io = new IOprotocols();
                io.importSubnetFromFile(file.getAbsolutePath(), 0, 0);
            }
        }));
        subImpMenu.add(this.createMenuItem("Import Subnet with point click location ", "", null, arg0 -> {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                IOprotocols io = new IOprotocols();
                io.importSubnetFromFile(file.getAbsolutePath(), this.x, this.y);
                for (ElementLocation el : this.getGraphPanel().getSelectionManager().getSelectedElementLocations()) {
                    el.setSelected(false);
                }
            }
        }));
    }

    private void exportToFile() {
        JFileChooser fc = new JFileChooser();
        ExtensionFileFilter pngFilter = new ExtensionFileFilter(".png - Portable Network Graphics", new String[]{"png"});
        ExtensionFileFilter bmpFilter = new ExtensionFileFilter(".bmp -  Bitmap Image File", new String[]{"bmp"});
        ExtensionFileFilter jpegFilter = new ExtensionFileFilter(".jpeg - JPEG Image File", new String[]{"jpeg"});
        fc.setFileFilter(pngFilter);
        fc.addChoosableFileFilter(pngFilter);
        fc.addChoosableFileFilter(bmpFilter);
        fc.addChoosableFileFilter(jpegFilter);
        fc.setAcceptAllFileFilterUsed(false);
        if (fc.showSaveDialog(null) == 0) {
            File file = fc.getSelectedFile();
            String ext = "";
            String extension = fc.getFileFilter().getDescription();
            if (extension.contains(".png")) {
                ext = ".png";
            }
            if (extension.contains(".bmp")) {
                ext = ".bmp";
            }
            if (extension.contains(".jpeg")) {
                ext = ".jpeg";
            }
            BufferedImage image = this.getGraphPanel().createImageFromSheet();
            try {
                ImageIO.write((RenderedImage)image, ext.substring(1), new File(file.getPath() + ext));
                GUIManager.getDefaultGUIManager().log("Network image save to file " + file.getPath() + ext, "text", true);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                GUIManager.getDefaultGUIManager().log("Error: " + ex.getMessage(), "error", true);
            }
        }
    }
}

