/*
 * Decompiled with CFR 0.152.
 */
package holmes.graphpanel.popupmenu;

import holmes.graphpanel.GraphPanel;
import holmes.petrinet.elements.PetriNetElement;
import holmes.utilities.Tools;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.XMLEncoder;
import java.io.FileOutputStream;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class GraphPanelPopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = 2192129184059718857L;
    private GraphPanel graphPanel;
    protected JMenuItem cutMenuItem;
    protected JMenuItem copyMenuItem;
    protected JMenuItem pasteMenuItem;

    public GraphPanelPopupMenu(GraphPanel graphPanel, PetriNetElement.PetriNetElementType pne) {
        this.setGraphPanel(graphPanel);
        if (pne != PetriNetElement.PetriNetElementType.META) {
            this.createPredefineMenuItems();
        }
    }

    public void createPredefineMenuItems() {
        this.cutMenuItem = this.createMenuItem("Cut", "cut.png", KeyStroke.getKeyStroke(88, 128), e -> {});
        this.copyMenuItem = this.createMenuItem("Copy", "copying_and_distribution.png", KeyStroke.getKeyStroke(67, 128), e -> {
            boolean x = true;
        });
        this.pasteMenuItem = this.createMenuItem("Paste", "paste_plain.png", KeyStroke.getKeyStroke(86, 128), e -> {});
        this.cutMenuItem.setEnabled(false);
        this.copyMenuItem.setEnabled(false);
        this.pasteMenuItem.setEnabled(false);
    }

    public void serializeObjectToXML(String xmlFileLocation, Object objectToSerialize) throws Exception {
        FileOutputStream os = new FileOutputStream(xmlFileLocation);
        XMLEncoder encoder = new XMLEncoder(os);
        encoder.writeObject(objectToSerialize);
        encoder.close();
    }

    public void show(MouseEvent e) {
        super.show(this.getGraphPanel(), e.getX(), e.getY());
    }

    public GraphPanel getGraphPanel() {
        return this.graphPanel;
    }

    public void setGraphPanel(GraphPanel graphPanel) {
        this.graphPanel = graphPanel;
    }

    protected void addMenuItem(String text, String iconName, ActionListener actionListener) {
        try {
            JMenuItem menuItem = !iconName.equals("") ? new JMenuItem(text, Tools.getResIcon16("/icons/" + iconName)) : new JMenuItem(text);
            menuItem.addActionListener(actionListener);
            this.add(menuItem);
        }
        catch (Exception e) {
            JMenuItem menuItem = new JMenuItem(text);
            menuItem.addActionListener(actionListener);
            this.add(menuItem);
        }
    }

    protected JMenuItem createMenuItem(String text, String iconName, KeyStroke accelerator, ActionListener actionListener) {
        try {
            JMenuItem menuItem = !iconName.equals("") ? new JMenuItem(text, Tools.getResIcon16("/icons/" + iconName)) : new JMenuItem(text);
            menuItem.addActionListener(actionListener);
            menuItem.setAccelerator(accelerator);
            return menuItem;
        }
        catch (Exception e) {
            JMenuItem menuItem = new JMenuItem(text);
            menuItem.addActionListener(actionListener);
            menuItem.setAccelerator(accelerator);
            return menuItem;
        }
    }
}

