/*
 * Decompiled with CFR 0.152.
 */
package holmes.graphpanel;

import holmes.darkgui.GUIManager;
import holmes.files.io.IOprotocols;
import holmes.graphpanel.GraphPanel;
import holmes.graphpanel.SelectionActionListener;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.elements.TransitionXTPN;
import holmes.petrinet.functions.FunctionsTools;
import holmes.windows.xtpn.HolmesNodeInfoXTPN;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;

public class SelectionManager {
    private final GUIManager overlord;
    private GraphPanel graphPanel;
    private ArrayList<Node> graphPanelNodes;
    private ArrayList<Arc> graphPanelArcs;
    private ArrayList<ElementLocation> selectedElementLocations = new ArrayList();
    private ArrayList<Arc> selectedArcs = new ArrayList();
    private SelectionActionListener actionListener;

    public SelectionManager(GraphPanel parentGraphPanel) {
        this.setGraphPanel(parentGraphPanel);
        this.graphPanelNodes = parentGraphPanel.getNodes();
        this.graphPanelArcs = parentGraphPanel.getArcs();
        this.overlord = GUIManager.getDefaultGUIManager();
    }

    private GraphPanel getGraphPanel() {
        return this.graphPanel;
    }

    private void setGraphPanel(GraphPanel parentGraphPanel) {
        this.graphPanel = parentGraphPanel;
    }

    private ArrayList<Node> getGraphPanelNodes() {
        return this.graphPanelNodes;
    }

    private void setGraphPanelNodes(ArrayList<Node> graphPanelNodes) {
        this.graphPanelNodes = graphPanelNodes;
    }

    public ArrayList<Arc> getGraphPanelArcs() {
        return this.graphPanelArcs;
    }

    private void setGraphPanelArcs(ArrayList<Arc> graphPanelArcs) {
        this.graphPanelArcs = graphPanelArcs;
    }

    public ArrayList<ElementLocation> getSelectedElementLocations() {
        return this.selectedElementLocations;
    }

    public void setSelectedElementLocations(ArrayList<ElementLocation> selectedElementLocations) {
        this.selectedElementLocations = selectedElementLocations;
    }

    public ArrayList<Arc> getSelectedArcs() {
        return this.selectedArcs;
    }

    public void setSelectedArcs(ArrayList<Arc> selectedArcs) {
        this.selectedArcs = selectedArcs;
    }

    public void setActionListener(SelectionActionListener e) {
        this.actionListener = e;
    }

    public SelectionActionListener getActionListener() {
        return this.actionListener;
    }

    private void invokeActionListener() {
        SelectionActionListener.SelectionActionEvent actionEvent = new SelectionActionListener.SelectionActionEvent();
        actionEvent.setElementLocationGroup(this.getSelectedElementLocations());
        actionEvent.setArcGroup(this.getSelectedArcs());
        if (this.getSelectedArcs().size() + this.getSelectedElementLocations().size() == 1) {
            actionEvent.setActionType(SelectionActionListener.SelectionActionEvent.SelectionActionType.SELECTED_ONE);
        } else {
            actionEvent.setActionType(SelectionActionListener.SelectionActionEvent.SelectionActionType.SELECTED_GROUP);
        }
        this.getActionListener().actionPerformed(actionEvent);
    }

    public void selectElementLocation(ElementLocation el) {
        if (!this.getSelectedElementLocations().contains(el)) {
            this.getSelectedElementLocations().add(el);
            el.setSelected(true);
            this.getGraphPanel().repaint();
            this.invokeActionListener();
        }
    }

    public void selectOneElementLocation(ElementLocation el) {
        this.deselectAllElementLocations();
        this.deselectAllArcs();
        this.selectElementLocation(el);
        this.invokeActionListener();
    }

    public void toggleElementLocationSelection(ElementLocation el) {
        if (!this.isElementLocationSelected(el)) {
            this.selectElementLocation(el);
        } else {
            this.deselectElementLocation(el);
        }
    }

    public ElementLocation getPossiblySelectedElementLocation(Point p, int additionalRange) {
        for (Node n : this.getGraphPanelNodes()) {
            int sheetID;
            ElementLocation el = n.getLocationWhichContains(p, sheetID = this.getGraphPanel().getSheetId(), additionalRange);
            if (el == null) continue;
            return el;
        }
        return null;
    }

    public void deselectElementLocation(ElementLocation el) {
        this.getSelectedElementLocations().remove(el);
        el.setSelected(false);
        if (this.getSelectedElementLocations().size() > 1) {
            this.checkArcsForSelection();
        }
        this.getGraphPanel().repaint();
        this.invokeActionListener();
    }

    public boolean isElementLocationSelected(ElementLocation el) {
        return this.selectedElementLocations.contains(el);
    }

    public void deleteElementLocation(ElementLocation el) {
        PetriNet pn = this.overlord.getWorkspace().getProject();
        ArrayList<Place> places = pn.getPlaces();
        ArrayList<Transition> transitions = pn.getTransitions();
        boolean functionWarning = false;
        boolean canDo = this.overlord.subnetsHQ.checkIfExpendable(el);
        if (!canDo) {
            JOptionPane.showMessageDialog(null, "This element is the only one that leads to subnet\nwith other portals of same node. Please remove all\nportals in correct subnets before removing THIS portal.", "Cannot be removed now", 2);
            this.invokeActionListener();
        } else {
            Arc a;
            ArrayList<Integer> sheetModified = new ArrayList<Integer>();
            sheetModified.add(el.getSheetID());
            this.deselectElementLocation(el);
            Node n = el.getParentNode();
            if (!n.removeElementLocation(el)) {
                int index;
                if (n instanceof Place) {
                    index = places.indexOf((Place)n);
                    pn.accessStatesManager().removePlace(index);
                    pn.accessSSAmanager().removePlace(index);
                    if (FunctionsTools.revalidateFunctions((Place)n, index)) {
                        functionWarning = true;
                    }
                }
                if (n instanceof Transition) {
                    index = transitions.indexOf((Transition)n);
                    pn.accessFiringRatesManager().removeTrans(index);
                }
                this.getGraphPanelNodes().remove(n);
            }
            for (Arc arc : el.getInArcs()) {
                this.getGraphPanelArcs().remove(arc);
                arc.getStartLocation().removeOutArc(arc);
            }
            for (Arc arc : el.getOutArcs()) {
                this.getGraphPanelArcs().remove(arc);
                arc.getEndLocation().removeInArc(arc);
            }
            Iterator<Arc> i = el.accessMetaInArcs().iterator();
            while (i.hasNext()) {
                a = i.next();
                this.getGraphPanelArcs().remove(a);
                a.getStartLocation().accessMetaOutArcs().remove(a);
                i.remove();
            }
            i = el.accessMetaOutArcs().iterator();
            while (i.hasNext()) {
                a = i.next();
                this.getGraphPanelArcs().remove(a);
                a.getEndLocation().accessMetaInArcs().remove(a);
                i.remove();
            }
            this.overlord.subnetsHQ.validateMetaArcs(sheetModified, false, false);
            this.getGraphPanel().repaint();
            this.invokeActionListener();
            if (functionWarning) {
                this.overlord.log("Some functions have been affected by the removal operation. Please read reports above this message.", "error", true);
            }
        }
    }

    public void deleteAllSelectedElements() {
        PetriNet pn = this.overlord.getWorkspace().getProject();
        ArrayList<Place> places = pn.getPlaces();
        ArrayList<Transition> transitions = pn.getTransitions();
        ArrayList<Integer> sheetsModified = new ArrayList<Integer>();
        ArrayList<ElementLocation> protectedList = new ArrayList<ElementLocation>();
        boolean functionWarning = false;
        Iterator<ElementLocation> i = this.getSelectedElementLocations().iterator();
        while (i.hasNext()) {
            Arc a;
            Arc begone;
            Node n;
            ElementLocation el = i.next();
            boolean canDo = this.overlord.subnetsHQ.checkIfExpendable(el);
            if (!canDo) {
                protectedList.add(el);
                continue;
            }
            int sheetID = el.getSheetID();
            if (!sheetsModified.contains(sheetID)) {
                sheetsModified.add(sheetID);
            }
            if (!(n = el.getParentNode()).removeElementLocation(el)) {
                int index;
                if (n instanceof Place) {
                    index = places.indexOf((Place)n);
                    pn.accessStatesManager().removePlace(index);
                    pn.accessSSAmanager().removePlace(index);
                    if (FunctionsTools.revalidateFunctions((Place)n, index)) {
                        functionWarning = true;
                    }
                }
                if (n instanceof Transition) {
                    index = transitions.indexOf((Transition)n);
                    pn.accessFiringRatesManager().removeTrans(index);
                }
                this.getGraphPanelNodes().remove(n);
            }
            Iterator<Arc> j = el.getInArcs().iterator();
            while (j.hasNext()) {
                begone = j.next();
                this.getGraphPanelArcs().remove(begone);
                begone.getStartLocation().removeOutArc(begone);
                j.remove();
            }
            j = el.getOutArcs().iterator();
            while (j.hasNext()) {
                begone = j.next();
                this.getGraphPanelArcs().remove(begone);
                begone.getEndLocation().removeInArc(begone);
                j.remove();
            }
            j = el.accessMetaInArcs().iterator();
            while (j.hasNext()) {
                a = j.next();
                this.getGraphPanelArcs().remove(a);
                a.getStartLocation().accessMetaOutArcs().remove(a);
                j.remove();
            }
            j = el.accessMetaOutArcs().iterator();
            while (j.hasNext()) {
                a = j.next();
                this.getGraphPanelArcs().remove(a);
                a.getEndLocation().accessMetaInArcs().remove(a);
                j.remove();
            }
            i.remove();
        }
        boolean securedDelete = protectedList.size() > 0;
        Iterator<Arc> i2 = this.getSelectedArcs().iterator();
        while (i2.hasNext()) {
            Arc a = i2.next();
            if (securedDelete && (protectedList.contains(a.getStartLocation()) || protectedList.contains(a.getEndLocation()))) continue;
            this.getGraphPanelArcs().remove(a);
            a.unlinkElementLocations();
            if (a.getPairedArc() != null) {
                Arc arc = a.getPairedArc();
                arc.unlinkElementLocations();
                this.getGraphPanelArcs().remove(arc);
            }
            i2.remove();
        }
        this.overlord.subnetsHQ.validateMetaArcs(sheetsModified, false, false);
        this.getSelectedArcs().clear();
        this.getSelectedElementLocations().clear();
        this.getGraphPanel().repaint();
        this.invokeActionListener();
        if (securedDelete) {
            JOptionPane.showMessageDialog(null, "Some element connected with subnets could not be deleted. Their corresponding\nportal within these subnets must be deleted first.", "Cannot be removed", 2);
        }
        if (functionWarning) {
            this.overlord.log("Some functions have been affected by the removal operation. Please read reports above this message.", "error", true);
        }
    }

    public void selectElementLocationGroup(ArrayList<ElementLocation> elementLocationGroup) {
        if (elementLocationGroup == null) {
            return;
        }
        for (ElementLocation el : elementLocationGroup) {
            if (this.getSelectedElementLocations().contains(el)) continue;
            this.getSelectedElementLocations().add(el);
            el.setSelected(true);
        }
        if (this.getSelectedElementLocations().size() > 1) {
            this.checkArcsForSelection();
        }
        this.getGraphPanel().repaint();
        this.invokeActionListener();
    }

    public void selectAllElementLocations() {
        this.getSelectedElementLocations().clear();
        this.getSelectedArcs().clear();
        for (Node n : this.getGraphPanelNodes()) {
            for (ElementLocation el : n.getNodeLocations(this.getGraphPanel().getSheetId())) {
                this.getSelectedElementLocations().add(el);
                el.setSelected(true);
            }
        }
        for (Arc a : this.getGraphPanelArcs()) {
            if (a.getLocationSheetId() != this.getGraphPanel().getSheetId()) continue;
            a.setSelected(true);
            this.getSelectedArcs().add(a);
        }
        this.getGraphPanel().repaint();
        this.invokeActionListener();
    }

    public void deselectAllElementLocations() {
        for (ElementLocation el : this.getSelectedElementLocations()) {
            el.setSelected(false);
        }
        this.getSelectedElementLocations().clear();
        this.deselectAllArcs();
        this.getGraphPanel().repaint();
        this.invokeActionListener();
    }

    public void transformSelectedIntoPortal() {
        String oldComment;
        String oldName;
        for (int i = 1; i < this.getSelectedElementLocations().size(); ++i) {
            if (this.getSelectedElementLocations().get(i - 1).getParentNode().getType() == this.getSelectedElementLocations().get(i).getParentNode().getType()) continue;
            JOptionPane.showMessageDialog(null, "Please select only one type of element: either transitions or places!", "Multiple types selection warning", 2);
            return;
        }
        int selectedNodeIndex = this.getGraphPanelNodes().indexOf(this.getSelectedElementLocations().get(0).getParentNode());
        for (ElementLocation el : this.getSelectedElementLocations()) {
            if (selectedNodeIndex > this.getGraphPanelNodes().indexOf(el.getParentNode())) {
                selectedNodeIndex = this.getGraphPanelNodes().indexOf(el.getParentNode());
            }
            if (el.getParentNode().isPortal()) {
                for (ElementLocation e : el.getParentNode().getNodeLocations()) {
                    e.setPortalSelected(false);
                }
            }
            if (el.getParentNode().removeElementLocation(el)) continue;
            this.getGraphPanelNodes().remove(el.getParentNode());
        }
        if (this.getSelectedElementLocations().get(0).getParentNode().getType() == PetriNetElement.PetriNetElementType.PLACE) {
            oldName = this.getSelectedElementLocations().get(0).getParentNode().getName();
            oldComment = this.getSelectedElementLocations().get(0).getParentNode().getComment();
            int oldTokensNumber = ((Place)this.getSelectedElementLocations().get(0).getParentNode()).getTokensNumber();
            int oldTokensTaken = ((Place)this.getSelectedElementLocations().get(0).getParentNode()).getReservedTokens();
            Place portal = new Place(IdGenerator.getNextId(), (ArrayList)this.getSelectedElementLocations().clone());
            ArrayList<ElementLocation> namesLocations = new ArrayList<ElementLocation>();
            ArrayList<ElementLocation> alphaLocations = new ArrayList<ElementLocation>();
            ArrayList<ElementLocation> betaLocations = new ArrayList<ElementLocation>();
            ArrayList<ElementLocation> gammaLocations = new ArrayList<ElementLocation>();
            ArrayList<ElementLocation> tauLocations = new ArrayList<ElementLocation>();
            int sid = this.getSelectedElementLocations().get(0).getParentNode().getElementLocations().get(0).getSheetID();
            for (int i = 0; i < this.getSelectedElementLocations().size(); ++i) {
                namesLocations.add(new ElementLocation(sid, new Point(0, 0), null));
                alphaLocations.add(new ElementLocation(sid, new Point(0, 0), null));
                betaLocations.add(new ElementLocation(sid, new Point(0, 0), null));
                gammaLocations.add(new ElementLocation(sid, new Point(0, 0), null));
                tauLocations.add(new ElementLocation(sid, new Point(0, 0), null));
            }
            portal.setTextsLocations(namesLocations, GUIManager.locationMoveType.NAME);
            portal.setTextsLocations(alphaLocations, GUIManager.locationMoveType.ALPHA);
            portal.setTextsLocations(betaLocations, GUIManager.locationMoveType.BETA);
            portal.setTextsLocations(gammaLocations, GUIManager.locationMoveType.GAMMA);
            portal.setTextsLocations(tauLocations, GUIManager.locationMoveType.TAU);
            portal.setName(oldName);
            portal.setComment(oldComment);
            portal.setTokensNumber(oldTokensNumber);
            portal.reserveTokens(oldTokensTaken);
            this.getGraphPanelNodes().add(selectedNodeIndex, portal);
        } else if (this.getSelectedElementLocations().get(0).getParentNode().getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
            oldName = this.getSelectedElementLocations().get(0).getParentNode().getName();
            oldComment = this.getSelectedElementLocations().get(0).getParentNode().getComment();
            Transition selTransition = (Transition)this.getSelectedElementLocations().get(0).getParentNode();
            double oldEFT = selTransition.timeExtension.getEFT();
            double oldLFT = selTransition.timeExtension.getLFT();
            double oldDuration = selTransition.timeExtension.getDPNduration();
            boolean oldTPNstatus = selTransition.timeExtension.isTPN();
            boolean oldDPNstatus = selTransition.timeExtension.isDPN();
            Transition.TransitionType tt = selTransition.getTransType();
            Transition portal = new Transition(IdGenerator.getNextId(), (ArrayList)this.getSelectedElementLocations().clone());
            portal.setTransType(tt);
            ArrayList<ElementLocation> namesLocations = new ArrayList<ElementLocation>();
            ArrayList<ElementLocation> alphaLocations = new ArrayList<ElementLocation>();
            ArrayList<ElementLocation> betaLocations = new ArrayList<ElementLocation>();
            ArrayList<ElementLocation> gammaLocations = new ArrayList<ElementLocation>();
            ArrayList<ElementLocation> tauLocations = new ArrayList<ElementLocation>();
            int sid = this.getSelectedElementLocations().get(0).getParentNode().getElementLocations().get(0).getSheetID();
            for (int i = 0; i < this.getSelectedElementLocations().size(); ++i) {
                namesLocations.add(new ElementLocation(sid, new Point(0, 0), null));
                alphaLocations.add(new ElementLocation(sid, new Point(0, 0), null));
                betaLocations.add(new ElementLocation(sid, new Point(0, 0), null));
                gammaLocations.add(new ElementLocation(sid, new Point(0, 0), null));
                tauLocations.add(new ElementLocation(sid, new Point(0, 0), null));
            }
            portal.setTextsLocations(namesLocations, GUIManager.locationMoveType.NAME);
            portal.setTextsLocations(alphaLocations, GUIManager.locationMoveType.ALPHA);
            portal.setTextsLocations(betaLocations, GUIManager.locationMoveType.BETA);
            portal.setTextsLocations(gammaLocations, GUIManager.locationMoveType.GAMMA);
            portal.setTextsLocations(tauLocations, GUIManager.locationMoveType.TAU);
            portal.setName(oldName);
            portal.setComment(oldComment);
            portal.timeExtension.setEFT(oldEFT);
            portal.timeExtension.setLFT(oldLFT);
            portal.timeExtension.setDPNduration(oldDuration);
            portal.timeExtension.setTPNstatus(oldTPNstatus);
            portal.timeExtension.setDPNstatus(oldDPNstatus);
            this.getGraphPanelNodes().add(selectedNodeIndex, portal);
        }
        this.getGraphPanel().repaint();
    }

    public void cloneNodeIntoPortalV2() {
        if (this.getSelectedElementLocations().size() > 1) {
            JOptionPane.showMessageDialog(null, "Cloning into Portals possible only for one selected node!", "Multiple selection warning", 2);
            return;
        }
        ElementLocation selectedEL = this.getSelectedElementLocations().get(0);
        Node parent = selectedEL.getParentNode();
        int selectedX = selectedEL.getPosition().x + 30;
        int selectedY = selectedEL.getPosition().y + 30;
        int selectedSheedID = selectedEL.getSheetID();
        ElementLocation newGraphicsEL = new ElementLocation(selectedSheedID, new Point(selectedX, selectedY), parent);
        ElementLocation newNameEL = new ElementLocation(selectedSheedID, new Point(0, 0), parent);
        parent.getElementLocations().add(newGraphicsEL);
        parent.getTextsLocations(GUIManager.locationMoveType.NAME).add(newNameEL);
        parent.getTextsLocations(GUIManager.locationMoveType.ALPHA).add(newNameEL);
        parent.getTextsLocations(GUIManager.locationMoveType.BETA).add(newNameEL);
        parent.getTextsLocations(GUIManager.locationMoveType.GAMMA).add(newNameEL);
        parent.getTextsLocations(GUIManager.locationMoveType.TAU).add(newNameEL);
        parent.setPortal(true);
        this.getGraphPanel().repaint();
    }

    public void cloneNodeIntoPortal() {
        String oldComment;
        String oldName;
        if (this.getSelectedElementLocations().size() > 1) {
            JOptionPane.showMessageDialog(null, "Cloning into Portals possible only for one selected node!", "Multiple selection warning", 2);
            return;
        }
        ElementLocation nodeSelectedEL = this.getSelectedElementLocations().get(0);
        Node nodeSelected = nodeSelectedEL.getParentNode();
        ArrayList<ElementLocation> namesLocations = new ArrayList<ElementLocation>();
        ArrayList<ElementLocation> alphaLocations = new ArrayList<ElementLocation>();
        ArrayList<ElementLocation> betaLocations = new ArrayList<ElementLocation>();
        ArrayList<ElementLocation> gammaLocations = new ArrayList<ElementLocation>();
        ArrayList<ElementLocation> tauLocations = new ArrayList<ElementLocation>();
        int selectedNodeIndex = this.getGraphPanelNodes().indexOf(nodeSelected);
        ArrayList<ElementLocation> otherNodes = nodeSelected.getElementLocations();
        int indClicked = nodeSelected.getElementLocations().indexOf(nodeSelectedEL);
        namesLocations.add(nodeSelected.getTextsLocations(GUIManager.locationMoveType.NAME).get(indClicked));
        alphaLocations.add(nodeSelected.getTextsLocations(GUIManager.locationMoveType.ALPHA).get(indClicked));
        betaLocations.add(nodeSelected.getTextsLocations(GUIManager.locationMoveType.BETA).get(indClicked));
        gammaLocations.add(nodeSelected.getTextsLocations(GUIManager.locationMoveType.GAMMA).get(indClicked));
        tauLocations.add(nodeSelected.getTextsLocations(GUIManager.locationMoveType.TAU).get(indClicked));
        for (ElementLocation el : otherNodes) {
            if (el.equals(nodeSelectedEL)) continue;
            this.selectedElementLocations.add(el);
            indClicked = nodeSelected.getElementLocations().indexOf(el);
            namesLocations.add(nodeSelected.getTextsLocations(GUIManager.locationMoveType.NAME).get(indClicked));
            alphaLocations.add(nodeSelected.getTextsLocations(GUIManager.locationMoveType.ALPHA).get(indClicked));
            betaLocations.add(nodeSelected.getTextsLocations(GUIManager.locationMoveType.BETA).get(indClicked));
            gammaLocations.add(nodeSelected.getTextsLocations(GUIManager.locationMoveType.GAMMA).get(indClicked));
            tauLocations.add(nodeSelected.getTextsLocations(GUIManager.locationMoveType.TAU).get(indClicked));
        }
        for (ElementLocation el : this.getSelectedElementLocations()) {
            if (el.getParentNode().isPortal()) {
                for (ElementLocation e : el.getParentNode().getNodeLocations()) {
                    e.setPortalSelected(false);
                }
            }
            if (el.getParentNode().removeElementLocation(el)) continue;
            this.getGraphPanelNodes().remove(el.getParentNode());
        }
        if (this.getSelectedElementLocations().get(0).getParentNode().getType() == PetriNetElement.PetriNetElementType.PLACE) {
            oldName = this.getSelectedElementLocations().get(0).getParentNode().getName();
            oldComment = this.getSelectedElementLocations().get(0).getParentNode().getComment();
            int oldTokensNumber = ((Place)this.getSelectedElementLocations().get(0).getParentNode()).getTokensNumber();
            int oldTokensTaken = ((Place)this.getSelectedElementLocations().get(0).getParentNode()).getReservedTokens();
            ElementLocation clonedNode = this.getSelectedElementLocations().get(0);
            Point newPosition = new Point();
            newPosition.setLocation(clonedNode.getPosition().getX() + 30.0, clonedNode.getPosition().getY() + 30.0);
            ElementLocation clone = new ElementLocation(clonedNode.getSheetID(), newPosition, clonedNode.getParentNode());
            clone.setSelected(clonedNode.isSelected());
            clone.setPortalSelected(clonedNode.isPortalSelected());
            this.selectedElementLocations.add(clone);
            Place portal = new Place(IdGenerator.getNextId(), (ArrayList)this.getSelectedElementLocations().clone());
            int sid = ((ElementLocation)namesLocations.get(0)).getSheetID();
            namesLocations.add(new ElementLocation(sid, new Point(0, 0), null));
            portal.setTextsLocations(namesLocations, GUIManager.locationMoveType.NAME);
            int sidA = ((ElementLocation)alphaLocations.get(0)).getSheetID();
            alphaLocations.add(new ElementLocation(sidA, new Point(0, 0), null));
            portal.setTextsLocations(alphaLocations, GUIManager.locationMoveType.ALPHA);
            int sidB = ((ElementLocation)betaLocations.get(0)).getSheetID();
            betaLocations.add(new ElementLocation(sidB, new Point(0, 0), null));
            portal.setTextsLocations(betaLocations, GUIManager.locationMoveType.BETA);
            int sidG = ((ElementLocation)gammaLocations.get(0)).getSheetID();
            gammaLocations.add(new ElementLocation(sidG, new Point(0, 0), null));
            portal.setTextsLocations(gammaLocations, GUIManager.locationMoveType.GAMMA);
            int sidT = ((ElementLocation)tauLocations.get(0)).getSheetID();
            tauLocations.add(new ElementLocation(sidT, new Point(0, 0), null));
            portal.setTextsLocations(tauLocations, GUIManager.locationMoveType.TAU);
            portal.setName(oldName);
            portal.setComment(oldComment);
            portal.setTokensNumber(oldTokensNumber);
            portal.reserveTokens(oldTokensTaken);
            this.getGraphPanelNodes().add(selectedNodeIndex, portal);
        } else if (this.getSelectedElementLocations().get(0).getParentNode().getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
            oldName = this.getSelectedElementLocations().get(0).getParentNode().getName();
            oldComment = this.getSelectedElementLocations().get(0).getParentNode().getComment();
            Transition selTransition = (Transition)this.getSelectedElementLocations().get(0).getParentNode();
            double oldEFT = selTransition.timeExtension.getEFT();
            double oldLFT = selTransition.timeExtension.getLFT();
            double oldDuration = selTransition.timeExtension.getDPNduration();
            boolean oldTPNstatus = selTransition.timeExtension.isTPN();
            boolean oldDPNstatus = selTransition.timeExtension.isDPN();
            Transition.TransitionType tt = selTransition.getTransType();
            ElementLocation clonedNode = this.getSelectedElementLocations().get(0);
            Point newPosition = new Point();
            newPosition.setLocation(clonedNode.getPosition().getX() + 30.0, clonedNode.getPosition().getY() + 30.0);
            ElementLocation clone = new ElementLocation(clonedNode.getSheetID(), newPosition, clonedNode.getParentNode());
            clone.setSelected(clonedNode.isSelected());
            clone.setPortalSelected(clonedNode.isPortalSelected());
            this.selectedElementLocations.add(clone);
            Transition portal = new Transition(IdGenerator.getNextId(), (ArrayList)this.getSelectedElementLocations().clone());
            portal.setTransType(tt);
            int sid = namesLocations.get(0).getSheetID();
            namesLocations.add(new ElementLocation(sid, new Point(0, 0), null));
            portal.setTextsLocations(namesLocations, GUIManager.locationMoveType.NAME);
            int sidA = alphaLocations.get(0).getSheetID();
            alphaLocations.add(new ElementLocation(sidA, new Point(0, 0), null));
            portal.setTextsLocations(alphaLocations, GUIManager.locationMoveType.ALPHA);
            int sidB = betaLocations.get(0).getSheetID();
            betaLocations.add(new ElementLocation(sidB, new Point(0, 0), null));
            portal.setTextsLocations(betaLocations, GUIManager.locationMoveType.BETA);
            int sidG = gammaLocations.get(0).getSheetID();
            gammaLocations.add(new ElementLocation(sidG, new Point(0, 0), null));
            portal.setTextsLocations(gammaLocations, GUIManager.locationMoveType.GAMMA);
            int sidT = tauLocations.get(0).getSheetID();
            tauLocations.add(new ElementLocation(sidT, new Point(0, 0), null));
            portal.setTextsLocations(tauLocations, GUIManager.locationMoveType.TAU);
            portal.setName(oldName);
            portal.setComment(oldComment);
            portal.timeExtension.setEFT(oldEFT);
            portal.timeExtension.setLFT(oldLFT);
            portal.timeExtension.setDPNduration(oldDuration);
            portal.timeExtension.setTPNstatus(oldTPNstatus);
            portal.timeExtension.setDPNstatus(oldDPNstatus);
            this.getGraphPanelNodes().add(selectedNodeIndex, portal);
        }
        this.getGraphPanel().repaint();
    }

    public void doubleClickReactionHandler() {
        ArrayList<Node> safetyNodesList = new ArrayList<Node>();
        for (ElementLocation el : this.getSelectedElementLocations()) {
            if (el.getParentNode().getType() == PetriNetElement.PetriNetElementType.PLACE && !safetyNodesList.contains(el.getParentNode())) {
                safetyNodesList.add(el.getParentNode());
                Place place = (Place)el.getParentNode();
                if (place instanceof PlaceXTPN) {
                    HolmesNodeInfoXTPN ani = new HolmesNodeInfoXTPN((PlaceXTPN)place, el, GUIManager.getDefaultGUIManager().getFrame());
                    ani.setVisible(true);
                    return;
                }
                place.modifyTokensNumber(1);
                if (this.overlord.getWorkspace().getProject().accessStatesManager().selectedStatePN != 0) continue;
                int tokens = place.getTokensNumber();
                ArrayList<Place> places = this.overlord.getWorkspace().getProject().getPlaces();
                this.overlord.getWorkspace().getProject().accessStatesManager().getStatePN(0).setTokens(places.indexOf(place), tokens);
                continue;
            }
            if (el.getParentNode().getType() == PetriNetElement.PetriNetElementType.TRANSITION && !safetyNodesList.contains(el.getParentNode())) {
                safetyNodesList.add(el.getParentNode());
                Transition trans = (Transition)el.getParentNode();
                if (!(trans instanceof TransitionXTPN)) continue;
                HolmesNodeInfoXTPN ani = new HolmesNodeInfoXTPN((TransitionXTPN)trans, el, GUIManager.getDefaultGUIManager().getFrame());
                ani.setVisible(true);
                return;
            }
            if (el.getParentNode().getType() == PetriNetElement.PetriNetElementType.META && !safetyNodesList.contains(el.getParentNode())) {
                try {
                    MetaNode node = (MetaNode)el.getParentNode();
                    safetyNodesList.add(node);
                    int sheetID = node.getRepresentedSheetID();
                    int sheetIndex = this.overlord.getWorkspace().getIndexOfId(sheetID);
                    this.overlord.getWorkspace().setSelectedDock(sheetIndex);
                    this.invokeActionListener();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Wrong sheet number linked to this meta-node.", "Serious problem", 2);
                    this.invokeActionListener();
                }
                break;
            }
            this.invokeActionListener();
        }
    }

    public void decreaseTokensNumber() {
        ArrayList<Node> safetyNodesList = new ArrayList<Node>();
        for (ElementLocation el : this.getSelectedElementLocations()) {
            if (el.getParentNode().getType() != PetriNetElement.PetriNetElementType.PLACE || safetyNodesList.contains(el.getParentNode()) || el.getParentNode() instanceof PlaceXTPN) continue;
            safetyNodesList.add(el.getParentNode());
            int tokens = ((Place)el.getParentNode()).getTokensNumber();
            if (tokens < 1) continue;
            ((Place)el.getParentNode()).modifyTokensNumber(-1);
            if (this.overlord.getWorkspace().getProject().accessStatesManager().selectedStatePN != 0) continue;
            int value = ((Place)el.getParentNode()).getTokensNumber();
            ArrayList<Place> places = this.overlord.getWorkspace().getProject().getPlaces();
            this.overlord.getWorkspace().getProject().accessStatesManager().getStatePN(0).setTokens(places.indexOf((Place)el.getParentNode()), value);
        }
    }

    public void selectArc(Arc arc) {
        if (!this.getSelectedArcs().contains(arc)) {
            this.getSelectedArcs().add(arc);
            arc.setSelected(true);
            this.getGraphPanel().repaint();
            this.invokeActionListener();
        }
    }

    public void selectOneArc(Arc arc) {
        for (Arc a : this.getGraphPanelArcs()) {
            if (a.getLocationSheetId() != this.getGraphPanel().getSheetId()) continue;
            a.setSelected(false);
        }
        this.getSelectedArcs().clear();
        this.selectArc(arc);
    }

    public Arc getPossiblySelectedArc(Point p) {
        for (Arc a : this.getGraphPanelArcs()) {
            if (a.getLocationSheetId() != this.getGraphPanel().getSheetId() || !a.checkIntersection(p)) continue;
            return a;
        }
        return null;
    }

    public boolean isArcSelected(Arc arc) {
        return this.getSelectedArcs().contains(arc);
    }

    public void deselectArc(Arc arc) {
        this.getSelectedArcs().remove(arc);
        arc.setSelected(false);
        this.getGraphPanel().repaint();
        this.invokeActionListener();
    }

    public void toggleArcSelection(Arc arc) {
        if (arc.getSelected()) {
            this.deselectArc(arc);
        } else {
            this.selectArc(arc);
        }
    }

    public void deleteArc(Arc arc) {
        this.overlord.markNetChange();
        arc.unlinkElementLocations();
        this.deselectArc(arc);
        this.getGraphPanelArcs().remove(arc);
        this.getGraphPanel().repaint();
        if (arc.getPairedArc() != null) {
            Arc a = arc.getPairedArc();
            a.unlinkElementLocations();
            this.getGraphPanelArcs().remove(a);
        }
        this.invokeActionListener();
    }

    public void checkArcsForSelection() {
        for (Arc a : this.getGraphPanelArcs()) {
            if (!a.checkSelection()) continue;
            this.getSelectedArcs().add(a);
        }
        this.getGraphPanel().repaint();
        this.invokeActionListener();
    }

    public void deselectAllArcs() {
        for (Arc a : this.getSelectedArcs()) {
            a.setSelected(false);
        }
        this.getSelectedArcs().clear();
        this.getGraphPanel().repaint();
        this.invokeActionListener();
    }

    public void deselectAllElements() {
        for (Arc a : this.getSelectedArcs()) {
            a.setSelected(false);
        }
        for (ElementLocation el : this.getSelectedElementLocations()) {
            el.setSelected(false);
        }
        this.getSelectedArcs().clear();
        this.getSelectedElementLocations().clear();
        this.invokeActionListener();
    }

    public void forceDeselectAllElements() {
        for (Arc a : this.getGraphPanelArcs()) {
            if (a.getLocationSheetId() != this.getGraphPanel().getSheetId()) continue;
            a.setSelected(false);
        }
        for (ElementLocation el : this.getSelectedElementLocations()) {
            if (el.getSheetID() != this.getGraphPanel().getSheetId()) continue;
            el.setSelected(false);
        }
        this.getSelectedArcs().clear();
        this.getSelectedElementLocations().clear();
        this.invokeActionListener();
    }

    public void selectInRect(Rectangle rectangle) {
        for (ElementLocation el : this.getSelectedElementLocations()) {
            el.setSelected(false);
        }
        for (Arc a : this.getSelectedArcs()) {
            a.setSelected(false);
        }
        this.getSelectedArcs().clear();
        this.getSelectedElementLocations().clear();
        for (Node n : this.getGraphPanel().getNodes()) {
            for (ElementLocation el : n.getLocationsWhichAreContained(rectangle, this.getGraphPanel().getSheetId())) {
                if (this.getSelectedElementLocations().contains(el)) continue;
                this.getSelectedElementLocations().add(el);
                el.setSelected(true);
            }
        }
        if (this.getSelectedElementLocations().size() > 1) {
            this.checkArcsForSelection();
        }
        this.getGraphPanel().repaint();
        this.invokeActionListener();
    }

    public void selectSheet() {
        SelectionActionListener.SelectionActionEvent actionEvent = new SelectionActionListener.SelectionActionEvent(this.getGraphPanel().getSheetId());
        this.getActionListener().actionPerformed(actionEvent);
    }

    public void dragSelected() {
        SelectionActionListener.SelectionActionEvent actionEvent = new SelectionActionListener.SelectionActionEvent();
        actionEvent.setElementLocationGroup(this.getSelectedElementLocations());
        actionEvent.setArcGroup(this.getSelectedArcs());
        if (this.getSelectedArcs().size() + this.getSelectedElementLocations().size() == 1) {
            actionEvent.setActionType(SelectionActionListener.SelectionActionEvent.SelectionActionType.SELECTED_ONE);
        } else {
            actionEvent.setActionType(SelectionActionListener.SelectionActionEvent.SelectionActionType.SELECTED_GROUP);
        }
        this.getActionListener().actionPerformed(actionEvent);
    }

    public void removeTransitionsGlowing() {
        for (Node n : this.getGraphPanelNodes()) {
            if (n.getType() != PetriNetElement.PetriNetElementType.TRANSITION) continue;
            ((Transition)n).drawGraphBoxT.setGlowedINV(false, 0);
        }
    }

    public void saveSubnet() {
        ArrayList<ElementLocation> listOfElements = new ArrayList<ElementLocation>();
        for (ElementLocation el : this.getSelectedElementLocations()) {
            if (!el.isSelected()) continue;
            listOfElements.add(el);
        }
        IOprotocols io = new IOprotocols();
        io.exportSubnet(listOfElements);
    }
}

