/*
 * Decompiled with CFR 0.152.
 */
package holmes.graphpanel;

import holmes.darkgui.GUIManager;
import holmes.petrinet.data.MauritiusMap;
import holmes.windows.HolmesKnockout;
import holmes.windows.HolmesKnockoutViewer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;

public class MauritiusMapPanel
extends JPanel {
    private static final long serialVersionUID = 1028800481995974984L;
    private MauritiusMap mmbt;
    private Map<Point, MapElement> mapLocations = new HashMap<Point, MapElement>();
    private int currentVerticalLevel = 0;
    private int verticalMulti = 0;
    private int offsetVertical = 100;
    private int maxUsedWidth = 0;
    private boolean fullName = true;
    private int baseThickness = 0;
    private int zoom = 100;
    private int panelWidth = 800;
    private int panelHeigth = 600;
    private Dimension originSize;
    public boolean originalSizeKnown = false;
    private boolean contractedMode = false;

    public MauritiusMapPanel(HolmesKnockout holmesKnockout) {
        this.setPreferredSize(new Dimension(this.panelWidth, this.panelHeigth));
        this.addMouseWheelListener(new MouseMapWheelHandler());
        this.addMouseListener(new MouseMapHandler());
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mmbt != null) {
            this.baseThickness = this.mmbt.getRoot().transFrequency;
            this.mapLocations = new HashMap<Point, MapElement>();
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.scale((float)this.getZoom() / 100.0f, (float)this.getZoom() / 100.0f);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.readAndPaintTree(this.mmbt.getRoot(), g2d, 100, 200, this.fullName, null);
            this.normalizeSize();
            this.verticalMulti = 0;
            if (!this.originalSizeKnown) {
                this.setOriginSize(new Dimension(this.panelWidth, this.panelHeigth));
                this.originalSizeKnown = true;
            }
        }
    }

    public void registerNewMap(MauritiusMap mmbt, boolean contractedMode) {
        this.mmbt = mmbt;
        this.originalSizeKnown = false;
        this.contractedMode = contractedMode;
    }

    private void readAndPaintTree(MauritiusMap.BTNode node, Graphics2D g2d, int x, int y, boolean fullName, ArrayList<Integer> disabledHistory) {
        ArrayList<Object> disabledPath = disabledHistory == null ? new ArrayList() : new ArrayList<Integer>(disabledHistory);
        if (node.transLocation == 64) {
            boolean bl = true;
        }
        this.updateWidth(x);
        Object name = node.transName;
        if (name == null) {
            name = "N/A";
        }
        int freq = node.transFrequency;
        int currentMulti = this.verticalMulti;
        if (!fullName) {
            int loc = node.transLocation;
            name = "t_" + loc;
        }
        boolean mctDetected = false;
        if (((String)name).contains("_MCT")) {
            int ind = ((String)name).indexOf("_MCT");
            String mctName = ((String)name).substring(ind + 1);
            this.drawRotatedText(g2d, x + 8, y + 35, 0, "(" + mctName + ")", false);
            name = ((String)name).substring(0, ind);
            mctDetected = true;
        }
        if (mctDetected && this.contractedMode) {
            this.drawCenteredSquare(g2d, x, y, 40, Color.lightGray);
            disabledPath.add(node.transLocation);
            this.mapLocations.put(new Point(x, y), new MapElement(node, disabledPath));
        } else {
            this.drawCenteredCircle(g2d, x, y, 40, Color.darkGray);
            this.drawRotatedText(g2d, x + 15, y - 15, -8, (String)name, false);
            disabledPath.add(node.transLocation);
            this.mapLocations.put(new Point(x, y), new MapElement(node, disabledPath));
        }
        String t_id = "t" + node.transLocation;
        this.drawRotatedText(g2d, x - 27, y + 35, 0, t_id, true);
        if (freq < 10) {
            this.drawText(g2d, x - 4, y + 5, "" + freq, Color.red);
        } else if (freq < 100) {
            this.drawText(g2d, x - 8, y + 5, "" + freq, Color.red);
        } else {
            this.drawText(g2d, x - 14, y + 5, "" + freq, Color.red);
        }
        if (node.rightChild != null) {
            if (this.contractedMode) {
                int currentVal = node.transFrequency;
                while (node.rightChild != null && currentVal == node.rightChild.transFrequency) {
                    node.rightChild = node.rightChild.rightChild;
                }
            }
            if (node.rightChild != null) {
                this.drawArrow(g2d, x + 20, y, x + 100, y, 3, Color.gray);
                this.readAndPaintTree(node.rightChild, g2d, x + 126, y, fullName, disabledPath);
            }
        }
        if (node.leftChild != null) {
            int additionalDown = 0;
            if (this.currentVerticalLevel == 0) {
                additionalDown = this.offsetVertical * this.verticalMulti;
            } else if (currentMulti < this.verticalMulti) {
                additionalDown += this.offsetVertical * (this.verticalMulti - currentMulti);
                ++currentMulti;
            }
            ++this.currentVerticalLevel;
            int lowerAltitude = y + this.offsetVertical + additionalDown;
            this.drawL_shapeArrow(g2d, x - 45, y, x - 45, lowerAltitude, 3, Color.gray);
            this.readAndPaintTree(node.leftChild, g2d, x, lowerAltitude, fullName, disabledHistory);
            ++this.verticalMulti;
            --this.currentVerticalLevel;
        }
    }

    private void normalizeSize() {
        if (this.panelHeigth < 200 + (this.offsetVertical + 10) * this.verticalMulti) {
            this.panelHeigth = 200 + (this.offsetVertical + 10) * this.verticalMulti;
        }
        if (this.panelWidth < 200 + this.maxUsedWidth) {
            this.panelWidth = 700 + this.maxUsedWidth;
        }
        double zoomMod = (double)this.zoom / 100.0;
        this.setPreferredSize(new Dimension((int)((double)this.panelWidth * zoomMod), (int)((double)this.panelHeigth * zoomMod)));
        this.setSize(new Dimension((int)((double)this.panelWidth * zoomMod), (int)((double)this.panelHeigth * zoomMod)));
    }

    private int normalizeThickness(int transFrequency) {
        double base = this.baseThickness;
        double result = (double)transFrequency / base * 10.0;
        return (int)result;
    }

    public void setFullName(boolean full) {
        this.fullName = full;
    }

    private void drawLine(Graphics2D g2d, int x1, int y1, int x2, int y2, int width, Color color) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angle = Math.atan2(dy, dx);
        int len = (int)Math.sqrt(dx * dx + dy * dy);
        AffineTransform atOld = g2d.getTransform();
        AffineTransform at = AffineTransform.getTranslateInstance(x1, y1);
        at.concatenate(AffineTransform.getRotateInstance(angle));
        g2d.transform(at);
        Color old = g2d.getColor();
        g2d.setPaint(color);
        g2d.setStroke(new BasicStroke(width));
        g2d.drawLine(0, 0, len, 0);
        g2d.setPaint(old);
        g2d.setTransform(atOld);
    }

    private void drawArrow(Graphics2D g2d, int x1, int y1, int x2, int y2, int width, Color color) {
        int ARR_SIZE = 6 + width;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angle = Math.atan2(dy, dx);
        int len = (int)Math.sqrt(dx * dx + dy * dy);
        AffineTransform atOld = g2d.getTransform();
        AffineTransform at = AffineTransform.getTranslateInstance(x1, y1);
        at.concatenate(AffineTransform.getRotateInstance(angle));
        g2d.transform(at);
        Color old = g2d.getColor();
        g2d.setPaint(color);
        g2d.setStroke(new BasicStroke(width));
        g2d.drawLine(0, 0, len, 0);
        int offX = 6;
        int offY = 0;
        g2d.fillPolygon(new int[]{len + offX, len - ARR_SIZE + offX, len - ARR_SIZE + offX, len + offX}, new int[]{offY, -ARR_SIZE + offY, ARR_SIZE + offY, offY}, 4);
        g2d.setPaint(old);
        g2d.setTransform(atOld);
    }

    private void drawL_shapeArrow(Graphics2D g2d, int x1, int y1, int x2, int y2, int width, Color color) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angle = Math.atan2(dy, dx);
        int len = (int)Math.sqrt(dx * dx + dy * dy);
        AffineTransform atOld = g2d.getTransform();
        AffineTransform at = AffineTransform.getTranslateInstance(x1, y1);
        at.concatenate(AffineTransform.getRotateInstance(angle));
        g2d.transform(at);
        Color old = g2d.getColor();
        g2d.setPaint(color);
        g2d.setStroke(new BasicStroke(width));
        g2d.drawLine(0, 0, len, 0);
        g2d.setPaint(old);
        g2d.setTransform(atOld);
        this.drawArrow(g2d, x2, y2, x2 + 20, y2, width, color);
    }

    public void drawRotatedText(Graphics2D g2d, double x, double y, int angle, String text, boolean bold) {
        int baseSize = 14;
        float zoom = this.getZoom();
        if (zoom < 50.0f) {
            baseSize = 10;
            baseSize = (int)((float)baseSize * (100.0f / zoom));
        }
        Font oldFont = g2d.getFont();
        Color oldColor = g2d.getColor();
        if (bold) {
            g2d.setFont(new Font("Tahoma", 1, baseSize));
        } else {
            g2d.setFont(new Font("Tahoma", 0, baseSize));
        }
        g2d.setColor(Color.black);
        g2d.translate((float)x, (float)y);
        g2d.rotate(Math.toRadians(angle));
        g2d.drawString(text, 0, 0);
        g2d.rotate(-Math.toRadians(angle));
        g2d.translate(-((float)x), -((float)y));
        g2d.setFont(oldFont);
        g2d.setColor(oldColor);
    }

    private void drawText(Graphics2D g2d, int x, int y, String text, Color color) {
        Color oldColor = g2d.getColor();
        g2d.setColor(color);
        g2d.setFont(new Font("Tahoma", 1, 14));
        g2d.drawString(text, x, y);
        g2d.setColor(oldColor);
    }

    private void drawCenteredCircle(Graphics2D g2d, int x, int y, int r, Color color) {
        int xPos = x - r / 2;
        int yPos = y - r / 2;
        Color old = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(color);
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.drawOval(xPos, yPos, r, r);
        xPos = x - r / 2 + 5;
        yPos = y - r / 2 + 5;
        g2d.drawOval(xPos, yPos, r - 10, r - 10);
        g2d.setStroke(oldStroke);
        g2d.setPaint(old);
    }

    private void drawCenteredSquare(Graphics2D g2d, int x, int y, int r, Color color) {
        int xPos = x - r / 2;
        int yPos = y - r / 2;
        Color old = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(color);
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.drawRect(xPos, yPos, r, r);
        xPos = x - r / 2 + 5;
        yPos = y - r / 2 + 5;
        g2d.drawOval(xPos - 2, yPos - 2, r - 6, r - 6);
        g2d.setStroke(oldStroke);
        g2d.setPaint(old);
    }

    public Dimension getOriginSize() {
        return this.originSize;
    }

    public void setOriginSize(Dimension originSize) {
        this.originSize = originSize;
    }

    private void updateWidth(int x) {
        if (x > this.maxUsedWidth) {
            this.maxUsedWidth = x;
        }
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int zoom) {
        if (this.getOriginSize().width * zoom / 100 < 10) {
            return;
        }
        this.zoom = zoom;
        this.invalidate();
        this.repaint();
    }

    private Point getClickedKey(Point mousePt) {
        double rangeLength = 20.0;
        rangeLength *= (double)this.zoom / 100.0;
        for (Point point : this.mapLocations.keySet()) {
            if (!((double)Math.abs(point.x - mousePt.x) < rangeLength) || !((double)Math.abs(point.y - mousePt.y) < rangeLength)) continue;
            return point;
        }
        return null;
    }

    public class MouseMapWheelHandler
    implements MouseWheelListener {
        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.isControlDown()) {
                MauritiusMapPanel.this.setZoom(MauritiusMapPanel.this.getZoom() - 10 * e.getWheelRotation());
            }
        }
    }

    private class MouseMapHandler
    extends MouseAdapter {
        private MouseMapHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            e.getComponent().repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (e.getButton() != 1 || !e.isShiftDown()) {
                    // empty if block
                }
                if (e.getButton() != 1 || e.isShiftDown()) {
                    // empty if block
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            GUIManager.getDefaultGUIManager().setNameLocationChangeMode(null, null, GUIManager.locationMoveType.NONE);
            Point mousePt = e.getPoint();
            mousePt.setLocation(e.getPoint().getX() * 100.0 / (double)MauritiusMapPanel.this.zoom, e.getPoint().getY() * 100.0 / (double)MauritiusMapPanel.this.zoom);
            Point key = MauritiusMapPanel.this.getClickedKey(mousePt);
            MapElement data = MauritiusMapPanel.this.mapLocations.get(key);
            if (data != null) {
                new HolmesKnockoutViewer(data);
            }
            e.getComponent().repaint();
        }
    }

    public class MapElement {
        public MauritiusMap.BTNode node;
        public ArrayList<Integer> disabledHistory;

        public MapElement(MauritiusMap.BTNode node, ArrayList<Integer> history) {
            this.node = node;
            this.disabledHistory = new ArrayList<Integer>(history);
        }
    }
}

